/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.project;

import com.gentics.mesh.context.BulkActionContext;
import com.gentics.mesh.context.InternalActionContext;
import com.gentics.mesh.context.impl.InternalRoutingActionContextImpl;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.HibCoreElement;
import com.gentics.mesh.core.data.dao.DaoGlobal;
import com.gentics.mesh.core.data.dao.RoleDao;
import com.gentics.mesh.core.data.dao.SchemaDao;
import com.gentics.mesh.core.data.dao.UserDao;
import com.gentics.mesh.core.data.page.Page;
import com.gentics.mesh.core.data.perm.InternalPermission;
import com.gentics.mesh.core.data.project.HibProject;
import com.gentics.mesh.core.data.service.BasicObjectTestcases;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.branch.BranchCreateRequest;
import com.gentics.mesh.core.rest.branch.BranchReference;
import com.gentics.mesh.core.rest.branch.BranchResponse;
import com.gentics.mesh.core.rest.job.JobStatus;
import com.gentics.mesh.core.rest.project.ProjectReference;
import com.gentics.mesh.core.rest.project.ProjectResponse;
import com.gentics.mesh.core.rest.tag.TagFamilyResponse;
import com.gentics.mesh.core.rest.tag.TagResponse;
import com.gentics.mesh.error.InvalidArgumentException;
import com.gentics.mesh.parameter.PagingParameters;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.PagingParametersImpl;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.test.util.MeshAssert;
import com.google.common.collect.Iterators;
import io.vertx.ext.web.RoutingContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.PROJECT, startServer=true)
public class ProjectTest
extends AbstractMeshTest
implements BasicObjectTestcases {
    @Override
    @Test
    public void testTransformToReference() throws Exception {
        try (Tx tx = this.tx();){
            ProjectReference reference = this.project().transformToReference();
            Assert.assertNotNull((Object)reference);
            Assert.assertEquals((Object)this.project().getUuid(), (Object)reference.getUuid());
            Assert.assertEquals((Object)this.project().getName(), (Object)reference.getName());
        }
    }

    @Override
    @Test
    public void testCreate() {
        try (Tx tx = this.tx();){
            HibProject project = this.createProject("test", "folder");
            HibProject project2 = (HibProject)tx.projectDao().findByName(project.getName());
            Assert.assertNotNull((Object)project2);
            Assert.assertEquals((Object)"test", (Object)project2.getName());
            Assert.assertEquals((Object)project.getUuid(), (Object)project2.getUuid());
        }
    }

    @Override
    @Test
    public void testDelete() throws Exception {
        BulkActionContext bac = this.createBulkContext();
        try (Tx tx = this.tx();){
            HibProject project = (HibProject)Tx.get().projectDao().findByUuid(this.project().getUuid());
            tx.projectDao().delete((HibBaseElement)project, bac);
            MeshAssert.assertElement((DaoGlobal)tx.projectDao(), (String)this.projectUuid(), (boolean)false);
        }
    }

    @Override
    @Test
    public void testRootNode() {
        try (Tx tx = this.tx();){
            long nProjectsBefore = tx.projectDao().findAll().count();
            Assert.assertNotNull((Object)this.createProject("test1234556", "folder"));
            long nProjectsAfter = tx.projectDao().findAll().count();
            Assert.assertEquals((long)(nProjectsBefore + 1L), (long)nProjectsAfter);
        }
    }

    @Override
    @Test
    public void testFindAllVisible() throws InvalidArgumentException {
        try (Tx tx = this.tx();){
            Page page = tx.projectDao().findAll(this.mockActionContext(), (PagingParameters)new PagingParametersImpl(1, Long.valueOf(25L)));
            Assert.assertNotNull((Object)page);
        }
    }

    @Override
    @Test
    public void testFindAll() {
        try (Tx tx = this.tx();){
            long size = Iterators.size((Iterator)tx.projectDao().findAll().iterator());
            Assert.assertEquals((long)1L, (long)size);
        }
    }

    @Override
    @Test
    public void testFindByName() {
        try (Tx tx = this.tx();){
            Assert.assertNull((Object)tx.projectDao().findByName("bogus"));
            Assert.assertNotNull((Object)tx.projectDao().findByName("dummy"));
        }
    }

    @Override
    @Test
    public void testFindByUUID() throws Exception {
        try (Tx tx = this.tx();){
            HibProject project = (HibProject)tx.projectDao().findByUuid(this.projectUuid());
            Assert.assertNotNull((Object)project);
            project = (HibProject)tx.projectDao().findByUuid("bogus");
            Assert.assertNull((Object)project);
        }
    }

    @Override
    @Test
    public void testTransformation() throws Exception {
        try (Tx tx = this.tx();){
            HibProject project = this.project();
            RoutingContext rc = this.mockRoutingContext();
            InternalRoutingActionContextImpl ac = new InternalRoutingActionContextImpl(rc);
            ProjectResponse response = (ProjectResponse)tx.projectDao().transformToRestSync((Object)project, (InternalActionContext)ac, 0, new String[0]);
            Assert.assertEquals((Object)project.getName(), (Object)response.getName());
            Assert.assertEquals((Object)project.getUuid(), (Object)response.getUuid());
        }
    }

    @Override
    @Test
    public void testCreateDelete() throws Exception {
        try (Tx tx = this.tx();){
            HibProject project = this.createProject("newProject", "folder");
            Assert.assertNotNull((Object)project);
            String uuid = project.getUuid();
            BulkActionContext bac = this.createBulkContext();
            HibProject foundProject = (HibProject)tx.projectDao().findByUuid(uuid);
            Assert.assertNotNull((Object)foundProject);
            tx.projectDao().delete((HibBaseElement)project, bac);
            foundProject = (HibProject)tx.projectDao().findByUuid(uuid);
            Assert.assertNull((Object)foundProject);
        }
    }

    @Override
    @Test
    public void testCRUDPermissions() {
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            UserDao userDao = tx.userDao();
            InternalActionContext ac = this.mockActionContext();
            roleDao.grantPermissions(this.role(), tx.data().permissionRoots().project(), new InternalPermission[]{InternalPermission.CREATE_PERM});
            HibProject project = this.createProject("TestProject", "folder");
            Assert.assertFalse((String)"The user should not have create permissions on the project.", (boolean)userDao.hasPermission(this.user(), (HibBaseElement)project, InternalPermission.CREATE_PERM));
            userDao.inheritRolePermissions(this.user(), tx.data().permissionRoots().project(), (HibBaseElement)project);
            ac.data().clear();
            Assert.assertTrue((String)"The users role should have inherited the initial permission on the project root.", (boolean)userDao.hasPermission(this.user(), (HibBaseElement)project, InternalPermission.CREATE_PERM));
        }
    }

    @Override
    @Test
    public void testRead() {
        try (Tx tx = this.tx();){
            SchemaDao schemaDao = tx.schemaDao();
            HibProject project = this.project();
            Assert.assertNotNull((Object)project.getName());
            Assert.assertEquals((Object)"dummy", (Object)project.getName());
            Assert.assertNotNull((Object)project.getBaseNode());
            Assert.assertEquals((long)3L, (long)schemaDao.findAll((HibCoreElement)project).count());
        }
    }

    @Override
    @Test
    public void testUpdate() {
        try (Tx tx = this.tx();){
            HibProject project = this.project();
            project.setName("new Name");
            Assert.assertEquals((Object)"new Name", (Object)project.getName());
        }
    }

    @Override
    @Test
    public void testReadPermission() {
        try (Tx tx = this.tx();){
            HibProject newProject = this.createProject("newProject", "folder");
            this.testPermission(InternalPermission.READ_PERM, (HibBaseElement)newProject);
        }
    }

    @Override
    @Test
    public void testDeletePermission() {
        try (Tx tx = this.tx();){
            HibProject newProject = this.createProject("newProject", "folder");
            this.testPermission(InternalPermission.DELETE_PERM, (HibBaseElement)newProject);
        }
    }

    @Override
    @Test
    public void testUpdatePermission() {
        try (Tx tx = this.tx();){
            HibProject newProject = this.createProject("newProject", "folder");
            this.testPermission(InternalPermission.UPDATE_PERM, (HibBaseElement)newProject);
        }
    }

    @Override
    @Test
    public void testCreatePermission() {
        try (Tx tx = this.tx();){
            HibProject newProject = this.createProject("newProject", "folder");
            this.testPermission(InternalPermission.CREATE_PERM, (HibBaseElement)newProject);
        }
    }

    @Test
    public void testDeleteWithTaggedBranches() {
        int numBranches = 5;
        BulkActionContext bac = this.createBulkContext();
        String projectUuid = (String)this.tx(() -> this.project().getUuid());
        String initialBranchUuid = (String)this.tx(() -> this.project().getInitialBranch().getUuid());
        TagFamilyResponse tagFamily = this.createTagFamily("dummy", "Colours");
        TagResponse red = this.createTag("dummy", tagFamily.getUuid(), "Red");
        TagResponse green = this.createTag("dummy", tagFamily.getUuid(), "Green");
        TagResponse blue = this.createTag("dummy", tagFamily.getUuid(), "Blue");
        ArrayList<String> branchUuids = new ArrayList<String>();
        for (int i = 0; i < numBranches; ++i) {
            BranchCreateRequest request = new BranchCreateRequest().setName(String.format("Branch %d", i)).setBaseBranch((BranchReference)new BranchReference().setUuid(initialBranchUuid)).setLatest(true);
            AtomicReference branchUuid = new AtomicReference();
            this.waitForJobs(() -> branchUuid.set(((BranchResponse)ClientHelper.call(() -> this.client().createBranch("dummy", request, new ParameterProvider[0]))).getUuid()), JobStatus.COMPLETED, 1);
            branchUuids.add((String)branchUuid.get());
            BranchCreateRequest subrequest = new BranchCreateRequest().setName(String.format("Subbranch %d", i)).setBaseBranch((BranchReference)new BranchReference().setUuid((String)branchUuid.get())).setLatest(false);
            this.waitForJobs(() -> branchUuids.add(((BranchResponse)ClientHelper.call(() -> this.client().createBranch("dummy", subrequest, new ParameterProvider[0]))).getUuid()), JobStatus.COMPLETED, 1);
        }
        for (String branchUuid : branchUuids) {
            for (TagResponse tag : Arrays.asList(red, green, blue)) {
                ClientHelper.call(() -> this.client().addTagToBranch("dummy", branchUuid, tag.getUuid()));
            }
        }
        this.tx(tx -> {
            HibProject project = (HibProject)tx.projectDao().findByUuid(this.project().getUuid());
            tx.projectDao().delete((HibBaseElement)project, bac);
        });
        this.tx(tx -> ((AbstractObjectAssert)Assertions.assertThat((Object)((HibProject)tx.projectDao().findByUuid(projectUuid))).as("Deleted project", new Object[0])).isNull());
    }
}

