/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.project;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.core.rest.branch.BranchCreateRequest;
import com.gentics.mesh.core.rest.branch.BranchReference;
import com.gentics.mesh.core.rest.branch.BranchResponse;
import com.gentics.mesh.core.rest.job.JobStatus;
import com.gentics.mesh.core.rest.node.NodeUpdateRequest;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.ProjectPurgeParameters;
import com.gentics.mesh.parameter.impl.ProjectPurgeParametersImpl;
import com.gentics.mesh.rest.client.MeshRequest;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.test.util.TestUtils;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.NONE, testSize=TestSize.FULL, startServer=true)
public class ProjectVersionPurgeEndpointTest
extends AbstractMeshTest {
    @Test
    public void testPurgeWithNoPerm() {
        ClientHelper.call(() -> this.client().purgeProject(this.projectUuid(), new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_admin_permission_required", (String[])new String[0]);
    }

    @Test
    public void testBogusProject() {
        this.adminCall(() -> this.client().purgeProject(this.userUuid(), new ParameterProvider[0]), HttpResponseStatus.NOT_FOUND, "object_not_found_for_uuid", this.userUuid());
    }

    @Test
    public void testPurge() {
        this.disableAutoPurge();
        String nodeUuid = this.contentUuid();
        this.waitForJob(() -> this.adminCall(() -> this.client().purgeProject(this.projectUuid(), new ParameterProvider[0])));
        this.assertVersions(nodeUuid, "en", "PD(1.0)=>I(0.1)");
        for (int i = 0; i < 5; ++i) {
            NodeUpdateRequest request = new NodeUpdateRequest();
            request.setVersion("draft");
            request.setLanguage("en");
            request.getFields().put("slug", (Field)FieldUtil.createStringField((String)("blub" + i)));
            ClientHelper.call(() -> this.client().updateNode(this.projectName(), nodeUuid, request, new ParameterProvider[0]));
        }
        this.assertVersions(nodeUuid, "en", "D(1.5)=>(1.4)=>(1.3)=>(1.2)=>(1.1)=>P(1.0)=>I(0.1)");
        this.waitForJob(() -> this.runAsAdmin(() -> ClientHelper.call(() -> this.client().purgeProject(this.projectUuid(), new ParameterProvider[0]))));
        this.assertVersions(nodeUuid, "en", "D(1.5)=>P(1.0)=>I(0.1)");
    }

    @Test
    public void testPurgeWithBefore() throws InterruptedException, ExecutionException {
        this.disableAutoPurge();
        String nodeUuid = this.contentUuid();
        String middle = null;
        for (int i = 0; i < 12; ++i) {
            if (i == 6) {
                middle = Instant.now().atZone(ZoneOffset.UTC).format(DateTimeFormatter.ISO_INSTANT);
                this.setupBranch(this.initialBranchUuid(), "demo2", false);
            }
            NodeUpdateRequest request = new NodeUpdateRequest();
            request.setVersion("draft");
            request.setLanguage("en");
            request.getFields().put("slug", (Field)FieldUtil.createStringField((String)("blub" + i)));
            ClientHelper.call(() -> this.client().updateNode(this.projectName(), nodeUuid, request, new ParameterProvider[0]));
            NodeUpdateRequest request2 = new NodeUpdateRequest();
            request2.setVersion("draft");
            request2.setLanguage("de");
            request2.getFields().put("slug", (Field)FieldUtil.createStringField((String)("blub_de" + i)));
            ClientHelper.call(() -> this.client().updateNode(this.projectName(), nodeUuid, request2, new ParameterProvider[0]));
            TestUtils.sleep((long)500L);
        }
        String middleDate = middle;
        this.waitForJob(() -> {
            ProjectPurgeParametersImpl purgeParams = new ProjectPurgeParametersImpl();
            purgeParams.setBefore(middleDate);
            this.adminCall(() -> this.lambda$testPurgeWithBefore$10((ProjectPurgeParameters)purgeParams));
        });
        this.assertVersions(nodeUuid, "en", "D(1.12)=>(1.11)=>(1.10)=>(1.9)=>(1.8)=>(1.7)=>(1.6)=>PI(1.0)=>I(0.1)");
        this.assertVersions(nodeUuid, "de", "D(1.12)=>(1.11)=>(1.10)=>(1.9)=>(1.8)=>(1.7)=>(1.6)=>PI(1.0)=>I(0.1)");
        this.assertVersions(nodeUuid, "en", "D(1.6)=>PI(1.0)=>I(0.1)", "demo2");
        this.assertVersions(nodeUuid, "de", "D(1.6)=>PI(1.0)=>I(0.1)", "demo2");
    }

    private String setupBranch(String initialBranchUuid, String branchName, boolean latest) throws InterruptedException, ExecutionException {
        CompletableFuture fut = new CompletableFuture();
        this.waitForJobs(() -> {
            BranchCreateRequest branchCreateRequest = new BranchCreateRequest();
            branchCreateRequest.setBaseBranch((BranchReference)new BranchReference().setUuid(this.initialBranchUuid()));
            branchCreateRequest.setName(branchName);
            branchCreateRequest.setLatest(latest);
            BranchResponse resp = (BranchResponse)ClientHelper.call(() -> this.client().createBranch(this.projectName(), branchCreateRequest, new ParameterProvider[0]));
            fut.complete(resp.getUuid());
        }, JobStatus.COMPLETED, 1);
        return (String)fut.get();
    }

    private /* synthetic */ MeshRequest lambda$testPurgeWithBefore$10(ProjectPurgeParameters purgeParams) throws Exception {
        return this.client().purgeProject(this.projectUuid(), new ParameterProvider[]{purgeParams});
    }
}

