/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.role;

import com.gentics.mesh.core.data.HibTransformableElement;
import com.gentics.mesh.core.data.dao.RoleDao;
import com.gentics.mesh.core.data.role.HibRole;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.GenericParametersImpl;
import com.gentics.mesh.parameter.impl.NodeParametersImpl;
import com.gentics.mesh.parameter.impl.PagingParametersImpl;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class RoleEndpointETagTest
extends AbstractMeshTest {
    @Test
    public void testReadMultiple() {
        try (Tx tx = this.tx();){
            String actualEtag = ClientHelper.callETag(() -> this.client().findRoles(new ParameterProvider[0]));
            Assert.assertNotNull((Object)actualEtag);
            ClientHelper.callETag(() -> this.client().findRoles(new ParameterProvider[0]), (String)actualEtag, (boolean)true, (int)304);
            ClientHelper.callETag(() -> this.client().findRoles(new ParameterProvider[]{new PagingParametersImpl().setPage(2L)}), (String)actualEtag, (boolean)true, (int)200);
        }
    }

    @Test
    public void testReadWithoutETag() {
        String etag = ClientHelper.callETagRaw(() -> this.client().findRoles(new ParameterProvider[]{new GenericParametersImpl().setETag(false)}));
        Assert.assertNull((String)"The etag should not have been generated.", (Object)etag);
        etag = ClientHelper.callETagRaw(() -> this.client().findRoleByUuid(this.roleUuid(), new ParameterProvider[]{new GenericParametersImpl().setETag(false)}));
        Assert.assertNull((String)"The etag should not have been generated.", (Object)etag);
    }

    @Test
    public void testReadOne() {
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            HibRole role = this.role();
            String responseEtag = ClientHelper.callETag(() -> this.client().findRoleByUuid(role.getUuid(), new ParameterProvider[0]));
            String etag = roleDao.getETag((HibTransformableElement)role, this.mockActionContext());
            Assert.assertEquals((Object)etag, (Object)responseEtag);
            Assert.assertEquals((Object)etag, (Object)ClientHelper.callETag(() -> this.client().findRoleByUuid(role.getUuid(), new ParameterProvider[0]), (String)etag, (boolean)true, (int)304));
            Assert.assertEquals((Object)etag, (Object)ClientHelper.callETag(() -> this.client().findRoleByUuid(role.getUuid(), new ParameterProvider[]{new NodeParametersImpl().setExpandAll(true)}), (String)etag, (boolean)true, (int)304));
            Assert.assertEquals((Object)etag, (Object)ClientHelper.callETag(() -> this.client().findRoleByUuid(role.getUuid(), new ParameterProvider[]{new NodeParametersImpl().setExpandAll(false)}), (String)etag, (boolean)true, (int)304));
            Assert.assertEquals((Object)etag, (Object)ClientHelper.callETag(() -> this.client().findRoleByUuid(role.getUuid(), new ParameterProvider[]{new NodeParametersImpl().setExpandAll(true)}), (String)etag, (boolean)true, (int)304));
        }
    }
}

