/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.role;

import com.gentics.mesh.ElementType;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.assertj.impl.PermissionInfoAssert;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.dao.GroupDao;
import com.gentics.mesh.core.data.dao.RoleDao;
import com.gentics.mesh.core.data.dao.UserDao;
import com.gentics.mesh.core.data.group.HibGroup;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.perm.InternalPermission;
import com.gentics.mesh.core.data.role.HibRole;
import com.gentics.mesh.core.data.schema.HibMicroschema;
import com.gentics.mesh.core.data.user.HibUser;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.MeshEvent;
import com.gentics.mesh.core.rest.common.GenericMessageResponse;
import com.gentics.mesh.core.rest.common.Permission;
import com.gentics.mesh.core.rest.common.PermissionInfo;
import com.gentics.mesh.core.rest.event.role.PermissionChangedEventModelImpl;
import com.gentics.mesh.core.rest.node.NodeListResponse;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.project.ProjectResponse;
import com.gentics.mesh.core.rest.role.RolePermissionRequest;
import com.gentics.mesh.core.rest.role.RolePermissionResponse;
import com.gentics.mesh.core.rest.role.RoleReference;
import com.gentics.mesh.core.rest.tag.TagFamilyResponse;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.search.TrackingSearchProvider;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.netty.handler.codec.http.HttpResponseStatus;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.TRACKING, testSize=TestSize.FULL, startServer=true)
public class RoleEndpointPermissionsTest
extends AbstractMeshTest {
    @Test
    public void testRevokeAllPermissionFromProject() {
        String roleName = (String)this.tx(() -> this.role().getName());
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            roleDao.grantPermissions(this.role(), (HibBaseElement)this.role(), new InternalPermission[]{InternalPermission.UPDATE_PERM});
            Assert.assertTrue((boolean)roleDao.hasPermission(this.role(), InternalPermission.DELETE_PERM, (HibBaseElement)this.tagFamily("colors")));
            tx.success();
        }
        int totalEvents = this.getNodeCount() + this.tagFamilies().size() + this.tags().size() + 2;
        this.expect(MeshEvent.ROLE_PERMISSIONS_CHANGED).match(totalEvents, PermissionChangedEventModelImpl.class, event -> {
            RoleReference roleRef = event.getRole();
            Assert.assertEquals((String)"The uuid of the role did not match for the event.", (Object)this.roleUuid(), (Object)roleRef.getUuid());
            Assert.assertEquals((String)"The name of the role did not match for the event.", (Object)roleName, (Object)roleRef.getName());
        }).total(totalEvents);
        RolePermissionRequest request = new RolePermissionRequest();
        request.setRecursive(Boolean.valueOf(true));
        request.getPermissions().setOthers(false);
        GenericMessageResponse message = (GenericMessageResponse)ClientHelper.call(() -> this.client().updateRolePermissions(this.roleUuid(), "projects/" + this.projectUuid(), request));
        this.awaitEvents();
        this.waitForSearchIdleEvent();
        long nodecontainerCount = (Long)this.tx(() -> this.getAllContents().count());
        long updateEvents = nodecontainerCount + (long)this.tagFamilies().size() + (long)this.tags().size() + 1L;
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasEvents(0L, updateEvents, 0L, 0L, 0L);
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            MeshAssertions.assertThat((GenericMessageResponse)message).matches("role_updated_permission", new String[]{this.role().getName()});
            Assert.assertFalse((boolean)roleDao.hasPermission(this.role(), InternalPermission.READ_PERM, (HibBaseElement)this.tagFamily("colors")));
        }
    }

    @Test
    public void testRevokeAllPermissionFromProjectByName() {
        RoleDao roleDao;
        try (Tx tx = this.tx();){
            roleDao = tx.roleDao();
            roleDao.grantPermissions(this.role(), (HibBaseElement)this.role(), new InternalPermission[]{InternalPermission.UPDATE_PERM});
            Assert.assertTrue((boolean)roleDao.hasPermission(this.role(), InternalPermission.DELETE_PERM, (HibBaseElement)this.tagFamily("colors")));
            tx.success();
        }
        tx = this.tx();
        try {
            roleDao = tx.roleDao();
            RolePermissionRequest request = new RolePermissionRequest();
            request.setRecursive(Boolean.valueOf(true));
            request.getPermissions().setOthers(false);
            GenericMessageResponse message = (GenericMessageResponse)ClientHelper.call(() -> this.client().updateRolePermissions(this.role().getUuid(), "projects/dummy", request));
            MeshAssertions.assertThat((GenericMessageResponse)message).matches("role_updated_permission", new String[]{this.role().getName()});
            Assert.assertFalse((boolean)roleDao.hasPermission(this.role(), InternalPermission.READ_PERM, (HibBaseElement)this.tagFamily("colors")));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testAddPermissionToProjectTagFamily() {
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            roleDao.grantPermissions(this.role(), (HibBaseElement)this.role(), new InternalPermission[]{InternalPermission.UPDATE_PERM});
            Assert.assertTrue((boolean)roleDao.hasPermission(this.role(), InternalPermission.DELETE_PERM, (HibBaseElement)this.tagFamily("colors")));
            tx.success();
        }
        RolePermissionRequest request = new RolePermissionRequest();
        request.setRecursive(Boolean.valueOf(false));
        request.getPermissions().add(Permission.READ);
        request.getPermissions().add(Permission.UPDATE);
        request.getPermissions().add(Permission.CREATE);
        request.getPermissions().setOthers(false);
        String tagFamilyUuid = (String)this.tx(() -> this.tagFamily("colors").getUuid());
        String roleName = (String)this.tx(() -> this.role().getName());
        GenericMessageResponse message = (GenericMessageResponse)ClientHelper.call(() -> this.client().updateRolePermissions(this.roleUuid(), "projects/" + this.projectUuid() + "/tagFamilies/" + tagFamilyUuid, request));
        MeshAssertions.assertThat((GenericMessageResponse)message).matches("role_updated_permission", new String[]{roleName});
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            Assert.assertFalse((boolean)roleDao.hasPermission(this.role(), InternalPermission.DELETE_PERM, (HibBaseElement)this.tagFamily("colors")));
        }
    }

    @Test
    public void testAddPermissionToMicroschema() {
        HibMicroschema vcard;
        RoleDao roleDao;
        try (Tx tx = this.tx();){
            RoleDao roleDao2 = tx.roleDao();
            roleDao2.grantPermissions(this.role(), (HibBaseElement)this.role(), new InternalPermission[]{InternalPermission.UPDATE_PERM});
            HibMicroschema vcard2 = this.microschemaContainer("vcard");
            roleDao2.revokePermissions(this.role(), (HibBaseElement)vcard2, InternalPermission.values());
            roleDao2.grantPermissions(this.role(), (HibBaseElement)vcard2, new InternalPermission[]{InternalPermission.READ_PERM});
            tx.success();
        }
        try (Tx tx = this.tx();){
            roleDao = tx.roleDao();
            vcard = this.microschemaContainer("vcard");
            Assert.assertFalse((boolean)roleDao.hasPermission(this.role(), InternalPermission.DELETE_PERM, (HibBaseElement)vcard));
            RolePermissionRequest request = new RolePermissionRequest();
            request.setRecursive(Boolean.valueOf(false));
            request.getPermissions().add(Permission.UPDATE);
            request.getPermissions().add(Permission.CREATE);
            GenericMessageResponse message = (GenericMessageResponse)ClientHelper.call(() -> this.client().updateRolePermissions(this.role().getUuid(), "microschemas/" + vcard.getUuid(), request));
            MeshAssertions.assertThat((GenericMessageResponse)message).matches("role_updated_permission", new String[]{this.role().getName()});
        }
        tx = this.tx();
        try {
            roleDao = tx.roleDao();
            Assert.assertFalse((boolean)roleDao.hasPermission(this.role(), InternalPermission.DELETE_PERM, (HibBaseElement)vcard));
            Assert.assertTrue((boolean)roleDao.hasPermission(this.role(), InternalPermission.UPDATE_PERM, (HibBaseElement)vcard));
            Assert.assertTrue((boolean)roleDao.hasPermission(this.role(), InternalPermission.CREATE_PERM, (HibBaseElement)vcard));
            Assert.assertTrue((boolean)roleDao.hasPermission(this.role(), InternalPermission.READ_PERM, (HibBaseElement)vcard));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testSetOnlyCreatePerm() {
        String pathToElement = "groups";
        RolePermissionRequest request = new RolePermissionRequest();
        request.setRecursive(Boolean.valueOf(true));
        request.getPermissions().add(Permission.CREATE);
        request.getPermissions().setOthers(false);
        this.tx(tx -> {
            RoleDao roleDao = tx.roleDao();
            Assert.assertTrue((String)"The role should have read permission on the group.", (boolean)roleDao.hasPermission(this.role(), InternalPermission.READ_PERM, (HibBaseElement)this.group()));
        });
        GenericMessageResponse message = (GenericMessageResponse)ClientHelper.call(() -> this.client().updateRolePermissions(this.roleUuid(), pathToElement, request));
        MeshAssertions.assertThat((GenericMessageResponse)message).matches("role_updated_permission", new String[]{(String)this.tx(() -> this.role().getName())});
        this.tx(tx -> {
            RoleDao roleDao = tx.roleDao();
            Assert.assertFalse((String)"The role should no longer have read permission on the group.", (boolean)roleDao.hasPermission(this.role(), InternalPermission.READ_PERM, (HibBaseElement)this.group()));
        });
    }

    @Test
    public void testAddPermissionsOnGroup() {
        String pathToElement = "groups";
        String roleName = (String)this.tx(() -> this.role().getName());
        RolePermissionRequest request = new RolePermissionRequest();
        request.setRecursive(Boolean.valueOf(true));
        request.getPermissions().add(Permission.READ);
        request.getPermissions().add(Permission.UPDATE);
        request.getPermissions().add(Permission.CREATE);
        request.getPermissions().setOthers(false);
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            Assert.assertTrue((String)"The role should have delete permission on the group.", (boolean)roleDao.hasPermission(this.role(), InternalPermission.DELETE_PERM, (HibBaseElement)this.group()));
        }
        this.expect(MeshEvent.ROLE_PERMISSIONS_CHANGED).match(9, PermissionChangedEventModelImpl.class, event -> {
            RoleReference roleRef = event.getRole();
            Assert.assertEquals((String)"The role name in the event did not match.", (Object)roleName, (Object)roleRef.getName());
            Assert.assertEquals((String)"The role uuid in the event did not match.", (Object)this.roleUuid(), (Object)roleRef.getUuid());
            ElementType type = event.getType();
            switch (type) {
                case ROLE: {
                    ((AbstractCharSequenceAssert)MeshAssertions.assertThat((String)event.getName()).as("The listed roles should have been affected.", new Object[0])).containsPattern((CharSequence)"anonymous|joe1_role");
                    break;
                }
                case USER: {
                    ((AbstractCharSequenceAssert)MeshAssertions.assertThat((String)event.getName()).as("All users in the groups should be affected due to recursive true.", new Object[0])).containsPattern((CharSequence)"joe1|anonymous|guest|admin");
                    break;
                }
                case GROUP: {
                    ((AbstractCharSequenceAssert)MeshAssertions.assertThat((String)event.getName()).as("All groups should be affected.", new Object[0])).containsPattern((CharSequence)"anonymous|joe1_group|extra_group|guests|admin");
                    break;
                }
                default: {
                    Assert.fail((String)("Unexpected event for type {" + type + "}"));
                }
            }
        }).total(9L);
        this.expect(MeshEvent.ROLE_UPDATED).none();
        this.expect(MeshEvent.USER_UPDATED).none();
        this.expect(MeshEvent.GROUP_UPDATED).none();
        GenericMessageResponse message = (GenericMessageResponse)ClientHelper.call(() -> this.client().updateRolePermissions(this.roleUuid(), pathToElement, request));
        MeshAssertions.assertThat((GenericMessageResponse)message).matches("role_updated_permission", new String[]{roleName});
        this.awaitEvents();
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            Assert.assertFalse((String)"The role should no longer have delete permission on the group.", (boolean)roleDao.hasPermission(this.role(), InternalPermission.DELETE_PERM, (HibBaseElement)this.group()));
        }
    }

    @Test
    public void testGrantPermToProjectByName() {
        try (Tx tx2 = this.tx();){
            RoleDao roleDao = tx2.roleDao();
            roleDao.grantPermissions(this.role(), (HibBaseElement)this.role(), new InternalPermission[]{InternalPermission.UPDATE_PERM});
            Assert.assertTrue((boolean)roleDao.hasPermission(this.role(), InternalPermission.DELETE_PERM, (HibBaseElement)this.tagFamily("colors")));
        }
        String pathToElement = "dummy/tagFamilies/" + (String)this.tx(() -> this.tagFamily("colors").getUuid());
        RolePermissionResponse response = (RolePermissionResponse)ClientHelper.call(() -> this.client().readRolePermissions(this.roleUuid(), pathToElement));
        MeshAssertions.assertThat((PermissionInfo)response).hasPerm(Permission.basicPermissions());
        response = (RolePermissionResponse)ClientHelper.call(() -> this.client().readRolePermissions(this.roleUuid(), "/dummy"));
        MeshAssertions.assertThat((PermissionInfo)response).hasPerm(Permission.basicPermissions());
        this.tx(tx -> {
            RoleDao roleDao = tx.roleDao();
            roleDao.revokePermissions(this.role(), (HibBaseElement)this.project(), new InternalPermission[]{InternalPermission.DELETE_PERM});
        });
        response = (RolePermissionResponse)ClientHelper.call(() -> this.client().readRolePermissions(this.roleUuid(), "/dummy"));
        MeshAssertions.assertThat((PermissionInfo)response).hasNoPerm(new Permission[]{Permission.DELETE});
        ProjectResponse projectResponse = (ProjectResponse)ClientHelper.call(() -> this.client().findProjectByUuid(this.projectUuid(), new ParameterProvider[0]));
        Assert.assertFalse((boolean)projectResponse.getPermissions().hasPerm(Permission.DELETE));
    }

    @Test
    public void testReadPermissionsOnProjectTagFamily() {
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            roleDao.grantPermissions(this.role(), (HibBaseElement)this.role(), new InternalPermission[]{InternalPermission.UPDATE_PERM});
            Assert.assertTrue((boolean)roleDao.hasPermission(this.role(), InternalPermission.DELETE_PERM, (HibBaseElement)this.tagFamily("colors")));
            tx.success();
        }
        String pathToElement = (String)this.tx(() -> "projects/" + this.project().getUuid() + "/tagFamilies/" + this.tagFamily("colors").getUuid());
        RolePermissionResponse response = (RolePermissionResponse)ClientHelper.call(() -> this.client().readRolePermissions(this.roleUuid(), pathToElement));
        Assert.assertNotNull((Object)response);
        MeshAssertions.assertThat((PermissionInfo)response).hasPerm(Permission.basicPermissions());
    }

    @Test
    public void testApplyPermissionsOnTag() {
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            roleDao.grantPermissions(this.role(), (HibBaseElement)this.role(), new InternalPermission[]{InternalPermission.UPDATE_PERM});
            Assert.assertTrue((boolean)roleDao.hasPermission(this.role(), InternalPermission.DELETE_PERM, (HibBaseElement)this.tagFamily("colors")));
            roleDao.revokePermissions(this.role(), (HibBaseElement)this.tag("red"), new InternalPermission[]{InternalPermission.DELETE_PERM});
            tx.success();
        }
        String pathToElement = (String)this.tx(() -> "projects/" + this.project().getUuid() + "/tagFamilies/" + this.tagFamily("colors").getUuid() + "/tags/" + this.tag("red").getUuid());
        RolePermissionRequest request = new RolePermissionRequest();
        request.setRecursive(Boolean.valueOf(false));
        request.getPermissions().setDelete(Boolean.valueOf(true));
        ClientHelper.call(() -> this.client().updateRolePermissions(this.roleUuid(), pathToElement, request));
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            Assert.assertTrue((boolean)roleDao.hasPermission(this.role(), InternalPermission.DELETE_PERM, (HibBaseElement)this.tag("red")));
        }
    }

    @Test
    public void testApplyPermissionsOnTags() {
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            roleDao.grantPermissions(this.role(), (HibBaseElement)this.role(), new InternalPermission[]{InternalPermission.UPDATE_PERM});
            Assert.assertTrue((boolean)roleDao.hasPermission(this.role(), InternalPermission.DELETE_PERM, (HibBaseElement)this.tagFamily("colors")));
            roleDao.revokePermissions(this.role(), (HibBaseElement)this.tag("red"), new InternalPermission[]{InternalPermission.DELETE_PERM});
            tx.success();
        }
        String pathToElement = (String)this.tx(() -> "projects/" + this.project().getUuid() + "/tagFamilies/" + this.tagFamily("colors").getUuid() + "/tags");
        RolePermissionRequest request = new RolePermissionRequest();
        request.setRecursive(Boolean.valueOf(false));
        request.getPermissions().setDelete(Boolean.valueOf(true));
        ClientHelper.call(() -> this.client().updateRolePermissions(this.roleUuid(), pathToElement, request));
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            Assert.assertFalse((String)"The perm of the tag should not change since the action currently only affects the tag family itself", (boolean)roleDao.hasPermission(this.role(), InternalPermission.DELETE_PERM, (HibBaseElement)this.tag("red")));
            Assert.assertTrue((String)"The tag family perm did not change", (boolean)roleDao.hasPermission(this.role(), InternalPermission.DELETE_PERM, (HibBaseElement)this.tagFamily("colors")));
        }
    }

    @Test
    public void testApplyCreatePermissionsOnTagFamily() {
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            roleDao.grantPermissions(this.role(), (HibBaseElement)this.role(), new InternalPermission[]{InternalPermission.UPDATE_PERM});
            roleDao.revokePermissions(this.role(), (HibBaseElement)this.tagFamily("colors"), new InternalPermission[]{InternalPermission.CREATE_PERM});
            roleDao.revokePermissions(this.role(), (HibBaseElement)this.tag("red"), new InternalPermission[]{InternalPermission.CREATE_PERM});
            Assert.assertFalse((boolean)roleDao.hasPermission(this.role(), InternalPermission.CREATE_PERM, (HibBaseElement)this.tagFamily("colors")));
            tx.success();
        }
        String tagFamilyUuid = (String)this.tx(() -> this.tagFamily("colors").getUuid());
        TagFamilyResponse tagFamilyResponse = (TagFamilyResponse)ClientHelper.call(() -> this.client().findTagFamilyByUuid("dummy", tagFamilyUuid, new ParameterProvider[0]));
        Assert.assertFalse((boolean)tagFamilyResponse.getPermissions().hasPerm(Permission.CREATE));
        String pathToElement = (String)this.tx(() -> "projects/" + this.project().getUuid() + "/tagFamilies/" + tagFamilyUuid);
        RolePermissionRequest request = new RolePermissionRequest();
        request.setRecursive(Boolean.valueOf(false));
        request.getPermissions().setOthers(true);
        ClientHelper.call(() -> this.client().updateRolePermissions(this.roleUuid(), pathToElement, request));
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            Assert.assertFalse((String)"The perm of the tag should not change since the action currently only affects the tag family itself", (boolean)roleDao.hasPermission(this.role(), InternalPermission.CREATE_PERM, (HibBaseElement)this.tag("red")));
            Assert.assertTrue((String)"The tag family perm did not change", (boolean)roleDao.hasPermission(this.role(), InternalPermission.CREATE_PERM, (HibBaseElement)this.tagFamily("colors")));
        }
        tagFamilyResponse = (TagFamilyResponse)ClientHelper.call(() -> this.client().findTagFamilyByUuid("dummy", tagFamilyUuid, new ParameterProvider[0]));
        Assert.assertTrue((boolean)tagFamilyResponse.getPermissions().hasPerm(Permission.CREATE));
    }

    @Test
    public void testAddRecursivePermissionsToNodes() {
        String roleUuid;
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            GroupDao groupDao = tx.groupDao();
            HibGroup testGroup = groupDao.create("testGroup", this.user());
            HibRole testRole = tx.roleDao().create("testRole", this.user());
            HibUser testUser = tx.userDao().create("test", this.user());
            tx.userDao().setPassword(testUser, "dummy");
            groupDao.addRole(testGroup, testRole);
            groupDao.addUser(testGroup, testUser);
            roleUuid = testRole.getUuid();
            roleDao.grantPermissions(this.role(), (HibBaseElement)testRole, InternalPermission.values());
            tx.success();
        }
        RolePermissionRequest request = new RolePermissionRequest();
        request.setRecursive(Boolean.valueOf(true));
        request.getPermissions().setRead(Boolean.valueOf(true));
        request.getPermissions().setOthers(false);
        GenericMessageResponse message = (GenericMessageResponse)this.adminCall(() -> this.client().updateRolePermissions(roleUuid, "projects/" + this.projectUuid() + "/nodes", request));
        MeshAssertions.assertThat((GenericMessageResponse)message).matches("role_updated_permission", new String[]{"testRole"});
        request.getPermissions().setUpdate(Boolean.valueOf(true));
        message = (GenericMessageResponse)this.adminCall(() -> this.client().updateRolePermissions(roleUuid, "projects/" + this.projectUuid() + "/nodes", request));
        MeshAssertions.assertThat((GenericMessageResponse)message).matches("role_updated_permission", new String[]{"testRole"});
        this.client().logout().blockingGet();
        this.client().setLogin("test", "dummy");
        this.client().login().blockingGet();
        NodeListResponse nodeList = (NodeListResponse)ClientHelper.call(() -> this.client().findNodes("dummy", new ParameterProvider[0]));
        System.out.println(nodeList.toJson());
        for (NodeResponse node : nodeList.getData()) {
            ((PermissionInfoAssert)MeshAssertions.assertThat((PermissionInfo)node.getPermissions()).as("Node uuid: " + node.getUuid(), new Object[0])).hasPerm(new Permission[]{Permission.READ, Permission.UPDATE}).hasNoPerm(new Permission[]{Permission.CREATE, Permission.DELETE}).hasPerm(new Permission[]{Permission.READ_PUBLISHED});
        }
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", this.contentUuid(), new ParameterProvider[0]));
        MeshAssertions.assertThat((PermissionInfo)response.getPermissions()).hasPerm(new Permission[]{Permission.READ, Permission.UPDATE}).hasNoPerm(new Permission[]{Permission.CREATE, Permission.DELETE}).hasPerm(new Permission[]{Permission.READ_PUBLISHED});
    }

    @Test
    public void testAddPermissionToNode() {
        GenericMessageResponse message;
        RolePermissionRequest request;
        HibNode node;
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            UserDao userDao = tx.userDao();
            HibNode node2 = this.folder("2015");
            roleDao.revokePermissions(this.role(), (HibBaseElement)node2, new InternalPermission[]{InternalPermission.UPDATE_PERM});
            Assert.assertFalse((boolean)roleDao.hasPermission(this.role(), InternalPermission.UPDATE_PERM, (HibBaseElement)node2));
            Assert.assertTrue((boolean)userDao.hasPermission(this.user(), (HibBaseElement)this.role(), InternalPermission.UPDATE_PERM));
            tx.success();
        }
        this.expect(MeshEvent.ROLE_PERMISSIONS_CHANGED).total(1L);
        try (Tx tx = this.tx();){
            node = this.folder("2015");
            request = new RolePermissionRequest();
            request.setRecursive(Boolean.valueOf(false));
            request.getPermissions().add(Permission.READ);
            request.getPermissions().add(Permission.UPDATE);
            request.getPermissions().add(Permission.CREATE);
            message = (GenericMessageResponse)ClientHelper.call(() -> this.client().updateRolePermissions(this.role().getUuid(), "projects/" + this.project().getUuid() + "/nodes/" + node.getUuid(), request));
            MeshAssertions.assertThat((GenericMessageResponse)message).matches("role_updated_permission", new String[]{this.role().getName()});
        }
        tx = this.tx();
        try {
            RoleDao roleDao = tx.roleDao();
            Assert.assertTrue((boolean)roleDao.hasPermission(this.role(), InternalPermission.UPDATE_PERM, (HibBaseElement)node));
            Assert.assertTrue((boolean)roleDao.hasPermission(this.role(), InternalPermission.CREATE_PERM, (HibBaseElement)node));
            Assert.assertTrue((boolean)roleDao.hasPermission(this.role(), InternalPermission.READ_PERM, (HibBaseElement)node));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.awaitEvents();
        this.eventAsserter().clear();
        this.expect(MeshEvent.ROLE_PERMISSIONS_CHANGED).none();
        tx = this.tx();
        try {
            request = new RolePermissionRequest();
            request.setRecursive(Boolean.valueOf(false));
            request.getPermissions().add(Permission.READ);
            request.getPermissions().add(Permission.UPDATE);
            request.getPermissions().add(Permission.CREATE);
            message = (GenericMessageResponse)ClientHelper.call(() -> this.client().updateRolePermissions(this.role().getUuid(), "projects/" + this.project().getUuid() + "/nodes/" + node.getUuid(), request));
            MeshAssertions.assertThat((GenericMessageResponse)message).matches("role_updated_permission", new String[]{this.role().getName()});
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.awaitEvents();
    }

    @Test
    public void testAddPermissionToNonExistingProject() {
        try (Tx tx = this.tx();){
            RolePermissionRequest request = new RolePermissionRequest();
            request.getPermissions().add(Permission.READ);
            String path = "projects/bogus1234/nodes";
            ClientHelper.call(() -> this.client().updateRolePermissions(this.role().getUuid(), path, request), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"error_element_for_path_not_found", (String[])new String[]{path});
        }
    }
}

