/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.role;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.assertj.impl.MeshElementEventModelAssert;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.dao.DaoGlobal;
import com.gentics.mesh.core.data.dao.GroupDao;
import com.gentics.mesh.core.data.dao.RoleDao;
import com.gentics.mesh.core.data.dao.UserDao;
import com.gentics.mesh.core.data.perm.InternalPermission;
import com.gentics.mesh.core.data.role.HibRole;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.MeshEvent;
import com.gentics.mesh.core.rest.common.ListResponse;
import com.gentics.mesh.core.rest.common.Permission;
import com.gentics.mesh.core.rest.common.PermissionInfo;
import com.gentics.mesh.core.rest.error.GenericRestException;
import com.gentics.mesh.core.rest.event.MeshElementEventModel;
import com.gentics.mesh.core.rest.event.impl.MeshElementEventModelImpl;
import com.gentics.mesh.core.rest.role.RoleCreateRequest;
import com.gentics.mesh.core.rest.role.RoleListResponse;
import com.gentics.mesh.core.rest.role.RoleResponse;
import com.gentics.mesh.core.rest.role.RoleUpdateRequest;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.PagingParametersImpl;
import com.gentics.mesh.parameter.impl.RolePermissionParametersImpl;
import com.gentics.mesh.search.TrackingSearchProvider;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.test.context.MeshTestHelper;
import com.gentics.mesh.test.definition.BasicRestTestcases;
import com.gentics.mesh.test.util.MeshAssert;
import com.gentics.mesh.util.UUIDUtil;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.reactivex.Single;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.TRACKING, testSize=TestSize.PROJECT, startServer=true)
public class RoleEndpointTest
extends AbstractMeshTest
implements BasicRestTestcases {
    @Override
    @Test
    public void testCreate() throws Exception {
        RoleCreateRequest request = new RoleCreateRequest();
        request.setName("new_role");
        this.expect(MeshEvent.ROLE_CREATED).match(1, MeshElementEventModelImpl.class, event -> ((MeshElementEventModelAssert)MeshAssertions.assertThat((MeshElementEventModel)event).hasName("new_role")).uuidNotNull()).total(1L);
        this.expect(MeshEvent.ROLE_UPDATED).total(0L);
        RoleResponse restRole = (RoleResponse)ClientHelper.call(() -> this.client().createRole(request));
        this.awaitEvents();
        this.waitForSearchIdleEvent();
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasStore(HibRole.composeIndexName(), restRole.getUuid());
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasEvents(1L, 0L, 0L, 0L, 0L);
        try (Tx tx = this.tx();){
            UserDao userDao = tx.userDao();
            HibRole createdRole = (HibRole)tx.roleDao().findByUuid(restRole.getUuid());
            Assert.assertTrue((boolean)userDao.hasPermission(this.user(), (HibBaseElement)createdRole, InternalPermission.UPDATE_PERM));
            Assert.assertTrue((boolean)userDao.hasPermission(this.user(), (HibBaseElement)createdRole, InternalPermission.READ_PERM));
            Assert.assertTrue((boolean)userDao.hasPermission(this.user(), (HibBaseElement)createdRole, InternalPermission.DELETE_PERM));
            Assert.assertTrue((boolean)userDao.hasPermission(this.user(), (HibBaseElement)createdRole, InternalPermission.CREATE_PERM));
            String roleUuid = restRole.getUuid();
            restRole = (RoleResponse)ClientHelper.call(() -> this.client().findRoleByUuid(roleUuid, new ParameterProvider[0]));
            MeshAssertions.assertThat((RoleResponse)restRole).matches(request);
            Assert.assertNotNull((Object)tx.roleDao().findByUuid(restRole.getUuid()));
        }
    }

    @Override
    @Test
    public void testCreateWithNoPerm() throws Exception {
        try (Tx tx2 = this.tx();){
            RoleDao roleDao = tx2.roleDao();
            roleDao.revokePermissions(this.role(), tx2.data().permissionRoots().role(), new InternalPermission[]{InternalPermission.CREATE_PERM});
            tx2.success();
        }
        String roleRootUuid = (String)this.tx(tx -> tx.data().permissionRoots().role().getUuid());
        RoleCreateRequest request = new RoleCreateRequest();
        request.setName("new_role");
        ClientHelper.call(() -> this.client().createRole(request), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{roleRootUuid, InternalPermission.CREATE_PERM.getRestPerm().getName()});
    }

    @Override
    @Test
    public void testCreateWithUuid() throws Exception {
        String uuid = UUIDUtil.randomUUID();
        RoleCreateRequest request = new RoleCreateRequest();
        request.setName("new_role");
        RoleResponse restRole = (RoleResponse)ClientHelper.call(() -> this.client().createRole(uuid, request));
        MeshAssertions.assertThat((RoleResponse)restRole).hasName("new_role").hasUuid(uuid);
    }

    @Override
    @Test
    @Ignore(value="Not valid over dup UUIDs being allowed globally")
    public void testCreateWithDuplicateUuid() throws Exception {
        String uuid = this.userUuid();
        RoleCreateRequest request = new RoleCreateRequest();
        request.setName("new_role");
        ClientHelper.call(() -> this.client().createRole(uuid, request), (HttpResponseStatus)HttpResponseStatus.INTERNAL_SERVER_ERROR, (String)"error_internal", (String[])new String[0]);
    }

    @Test
    public void testCreateRoleWithConflictingName() throws Exception {
        String name = "new_role";
        RoleCreateRequest request = new RoleCreateRequest();
        request.setName(name);
        ClientHelper.call(() -> this.client().createRole(request));
        ClientHelper.call(() -> this.client().createRole(request), (HttpResponseStatus)HttpResponseStatus.CONFLICT, (String)"role_conflicting_name", (String[])new String[0]);
    }

    @Override
    @Test
    public void testCreateReadDelete() throws Exception {
        RoleCreateRequest request = new RoleCreateRequest();
        request.setName("new_role");
        RoleResponse restRole = (RoleResponse)ClientHelper.call(() -> this.client().createRole(request));
        MeshAssertions.assertThat((RoleResponse)restRole).matches(request);
        ClientHelper.call(() -> this.client().deleteRole(restRole.getUuid()));
    }

    @Test
    public void testCreateWithNoPermissionRoleRoot() throws Exception {
        RoleCreateRequest request = new RoleCreateRequest();
        request.setName("new_role");
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            roleDao.revokePermissions(this.role(), tx.data().permissionRoots().role(), new InternalPermission[]{InternalPermission.CREATE_PERM});
            tx.success();
        }
        tx = this.tx();
        try {
            ClientHelper.call(() -> this.client().createRole(request), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{tx.data().permissionRoots().role().getUuid(), InternalPermission.CREATE_PERM.getRestPerm().getName()});
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    @Ignore(value="We can't test this using the rest client")
    public void testCreateRoleWithBogusJson() throws Exception {
    }

    @Test
    public void testCreateRoleWithNoName() throws Exception {
        RoleCreateRequest request = new RoleCreateRequest();
        ClientHelper.call(() -> this.client().createRole(request), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"error_name_must_be_set", (String[])new String[0]);
    }

    @Test
    public void testReadOwnRoleByUUID() throws Exception {
        try (Tx tx = this.tx();){
            RoleResponse restRole = (RoleResponse)ClientHelper.call(() -> this.client().findRoleByUuid(this.roleUuid(), new ParameterProvider[0]));
            MeshAssertions.assertThat((RoleResponse)restRole).matches(this.role());
        }
    }

    @Override
    @Test
    public void testReadByUUID() throws Exception {
        HibRole extraRole;
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            GroupDao groupDao = tx.groupDao();
            extraRole = roleDao.create("extra role", this.user());
            groupDao.addRole(this.group(), extraRole);
            Assert.assertNotNull((String)"The UUID of the role must not be null.", (Object)extraRole.getUuid());
            roleDao.grantPermissions(this.role(), (HibBaseElement)extraRole, new InternalPermission[]{InternalPermission.READ_PERM});
            tx.success();
        }
        tx = this.tx();
        try {
            RoleResponse restRole = (RoleResponse)ClientHelper.call(() -> this.client().findRoleByUuid(extraRole.getUuid(), new ParameterProvider[0]));
            MeshAssertions.assertThat((RoleResponse)restRole).matches(extraRole);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Override
    @Test
    public void testReadByUuidWithRolePerms() {
        RoleResponse restRole = (RoleResponse)ClientHelper.call(() -> this.client().findRoleByUuid(this.roleUuid(), new ParameterProvider[]{new RolePermissionParametersImpl().setRoleUuid(this.roleUuid())}));
        Assert.assertNotNull((Object)restRole.getRolePerms());
        MeshAssertions.assertThat((PermissionInfo)restRole.getRolePerms()).hasPerm(Permission.basicPermissions());
    }

    @Override
    @Test
    public void testReadByUUIDWithMissingPermission() throws Exception {
        String extraRoleUuid;
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            GroupDao groupRoot = tx.groupDao();
            HibRole extraRole = roleDao.create("extra role", this.user());
            extraRoleUuid = extraRole.getUuid();
            groupRoot.addRole(this.group(), extraRole);
            roleDao.revokePermissions(this.role(), (HibBaseElement)extraRole, new InternalPermission[]{InternalPermission.READ_PERM});
            tx.success();
        }
        ClientHelper.call(() -> this.client().findRoleByUuid(extraRoleUuid, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{extraRoleUuid, InternalPermission.READ_PERM.getRestPerm().getName()});
    }

    @Test
    public void testReadOwnRoleByUUIDWithMissingPermission() throws Exception {
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            roleDao.revokePermissions(this.role(), (HibBaseElement)this.role(), new InternalPermission[]{InternalPermission.READ_PERM});
            tx.success();
        }
        ClientHelper.call(() -> this.client().findRoleByUuid(this.roleUuid(), new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{this.roleUuid(), InternalPermission.READ_PERM.getRestPerm().getName()});
    }

    @Override
    @Test
    public void testReadMultiple() throws Exception {
        int nRoles = 21;
        String noPermRoleName = "no_perm_role";
        int initialRolesCount = this.roles().size();
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            GroupDao groupRoot = tx.groupDao();
            HibRole noPermRole = roleDao.create("no_perm_role", this.user());
            roleDao.grantPermissions(this.role(), (HibBaseElement)this.group(), new InternalPermission[]{InternalPermission.READ_PERM});
            for (int i = 0; i < 21; ++i) {
                HibRole extraRole = roleDao.create("extra role " + i, this.user());
                groupRoot.addRole(this.group(), extraRole);
                roleDao.grantPermissions(this.role(), (HibBaseElement)extraRole, new InternalPermission[]{InternalPermission.READ_PERM});
            }
            groupRoot.addRole(this.group(), noPermRole);
            tx.success();
        }
        RoleListResponse restResponse = (RoleListResponse)ClientHelper.call(() -> this.client().findRoles(new ParameterProvider[0]));
        Assert.assertNull((Object)restResponse.getMetainfo().getPerPage());
        Assert.assertEquals((long)1L, (long)restResponse.getMetainfo().getCurrentPage());
        Assert.assertEquals((long)(21 + initialRolesCount), (long)restResponse.getData().size());
        long perPage = 11L;
        boolean currentPage = true;
        restResponse = (RoleListResponse)ClientHelper.call(() -> this.client().findRoles(new ParameterProvider[]{new PagingParametersImpl(1, Long.valueOf(perPage))}));
        Assert.assertEquals((String)"The amount of items for page {1} does not match the expected amount.", (long)11L, (long)restResponse.getData().size());
        int totalRoles = 21 + this.data().getRoles().size();
        int totalPages = (int)Math.ceil((double)totalRoles / (double)perPage);
        Assert.assertEquals((String)"The response did not contain the correct amount of items", (long)perPage, (long)restResponse.getData().size());
        Assert.assertEquals((long)1L, (long)restResponse.getMetainfo().getCurrentPage());
        Assert.assertEquals((String)("The total pages could does not match. We expect {" + totalRoles + "} total roles and {" + perPage + "} roles per page. Thus we expect {" + totalPages + "} pages"), (long)totalPages, (long)restResponse.getMetainfo().getPageCount());
        Assert.assertEquals((long)perPage, (long)restResponse.getMetainfo().getPerPage());
        for (RoleResponse role : restResponse.getData()) {
            System.out.println(role.getName());
        }
        Assert.assertEquals((long)totalRoles, (long)restResponse.getMetainfo().getTotalCount());
        ArrayList allRoles = new ArrayList();
        int page = 1;
        while (page <= totalPages) {
            int cPage = page++;
            restResponse = (RoleListResponse)ClientHelper.call(() -> this.client().findRoles(new ParameterProvider[]{new PagingParametersImpl(cPage, Long.valueOf(perPage))}));
            allRoles.addAll(restResponse.getData());
        }
        Assert.assertEquals((String)"Somehow not all roles were loaded when loading all pages.", (long)totalRoles, (long)allRoles.size());
        List filteredUserList = allRoles.parallelStream().filter(restRole -> restRole.getName().equals("no_perm_role")).collect(Collectors.toList());
        Assert.assertTrue((String)"Extra role should not be part of the list since no permissions were added.", (filteredUserList.size() == 0 ? 1 : 0) != 0);
        ClientHelper.call(() -> this.client().findRoles(new ParameterProvider[]{new PagingParametersImpl(-1, Long.valueOf(perPage))}), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"error_page_parameter_must_be_positive", (String[])new String[]{"-1"});
        ClientHelper.call(() -> this.client().findRoles(new ParameterProvider[]{new PagingParametersImpl(1, Long.valueOf(-1L))}), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"error_pagesize_parameter", (String[])new String[]{"-1"});
        RoleListResponse response = (RoleListResponse)ClientHelper.call(() -> this.client().findRoles(new ParameterProvider[]{new PagingParametersImpl(4242, Long.valueOf(25L))}));
        Assert.assertEquals((long)0L, (long)response.getData().size());
        Assert.assertEquals((long)4242L, (long)response.getMetainfo().getCurrentPage());
        Assert.assertEquals((long)1L, (long)response.getMetainfo().getPageCount());
        Assert.assertEquals((long)(21 + initialRolesCount), (long)response.getMetainfo().getTotalCount());
        Assert.assertEquals((long)25L, (long)response.getMetainfo().getPerPage());
        this.verifySorting(param -> (ListResponse)ClientHelper.call(() -> this.client().findRoles(new ParameterProvider[]{param})), RoleResponse::getName, "name", "List of role names");
    }

    @Test
    public void testReadMetaCountOnly() {
        RoleListResponse response = (RoleListResponse)this.client().findRoles(new ParameterProvider[]{new PagingParametersImpl(1, Long.valueOf(0L))}).blockingGet();
        Assert.assertEquals((long)0L, (long)response.getData().size());
    }

    @Override
    @Test
    public void testUpdate() throws JsonGenerationException, JsonMappingException, IOException, Exception {
        String extraRoleUuid = (String)this.tx(tx -> {
            RoleDao roleDao = tx.roleDao();
            GroupDao groupDao = tx.groupDao();
            HibRole extraRole = roleDao.create("extra role", this.user());
            groupDao.addRole(this.group(), extraRole);
            roleDao.grantPermissions(this.role(), (HibBaseElement)extraRole, new InternalPermission[]{InternalPermission.UPDATE_PERM});
            return extraRole.getUuid();
        });
        this.expect(MeshEvent.ROLE_UPDATED).match(1, MeshElementEventModelImpl.class, event -> ((MeshElementEventModelAssert)MeshAssertions.assertThat((MeshElementEventModel)event).hasName("renamed role")).hasUuid(extraRoleUuid)).total(1L);
        this.expect(MeshEvent.ROLE_CREATED).total(0L);
        RoleUpdateRequest request = new RoleUpdateRequest();
        request.setName("renamed role");
        RoleResponse restRole = (RoleResponse)ClientHelper.call(() -> this.client().updateRole(extraRoleUuid, request));
        Assert.assertEquals((Object)request.getName(), (Object)restRole.getName());
        Assert.assertEquals((Object)extraRoleUuid, (Object)restRole.getUuid());
        this.awaitEvents();
        try (Tx tx2 = this.tx();){
            HibRole reloadedRole = (HibRole)tx2.roleDao().findByUuid(extraRoleUuid);
            Assert.assertEquals((String)"The role should have been renamed", (Object)request.getName(), (Object)reloadedRole.getName());
        }
    }

    @Override
    @Test
    public void testUpdateByUUIDWithoutPerm() throws Exception {
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            roleDao.revokePermissions(this.role(), (HibBaseElement)this.role(), new InternalPermission[]{InternalPermission.UPDATE_PERM});
            tx.success();
        }
        RoleUpdateRequest request = new RoleUpdateRequest();
        request.setName("New Name");
        ClientHelper.call(() -> this.client().updateRole(this.roleUuid(), request), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{this.roleUuid(), InternalPermission.UPDATE_PERM.getRestPerm().getName()});
    }

    @Test
    public void testUpdateConflictCheck() {
        try (Tx tx = this.tx();){
            tx.roleDao().create("test123", this.user());
            tx.success();
        }
        RoleUpdateRequest request = new RoleUpdateRequest();
        request.setName("test123");
        ClientHelper.call(() -> this.client().updateRole(this.roleUuid(), request), (HttpResponseStatus)HttpResponseStatus.CONFLICT, (String)"role_conflicting_name", (String[])new String[0]);
    }

    @Override
    @Test
    public void testUpdateWithBogusUuid() throws GenericRestException, Exception {
        RoleUpdateRequest request = new RoleUpdateRequest();
        request.setName("renamed role");
        ClientHelper.call(() -> this.client().updateRole("bogus", request), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"error_illegal_uuid", (String[])new String[]{"bogus"});
    }

    @Test
    public void testUpdateOwnRole() throws JsonGenerationException, JsonMappingException, IOException, Exception {
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            roleDao.revokePermissions(this.role(), (HibBaseElement)this.role(), new InternalPermission[]{InternalPermission.UPDATE_PERM});
            tx.success();
        }
        RoleUpdateRequest restRole = new RoleUpdateRequest();
        restRole.setName("renamed role");
        ClientHelper.call(() -> this.client().updateRole(this.roleUuid(), restRole), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{this.roleUuid(), InternalPermission.UPDATE_PERM.getRestPerm().getName()});
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            roleDao.grantPermissions(this.role(), (HibBaseElement)this.role(), new InternalPermission[]{InternalPermission.UPDATE_PERM});
            tx.success();
        }
        ClientHelper.call(() -> this.client().updateRole(this.roleUuid(), restRole));
        tx = this.tx();
        try {
            HibRole reloadedRole = (HibRole)tx.roleDao().findByUuid(this.roleUuid());
            Assert.assertEquals((Object)restRole.getName(), (Object)reloadedRole.getName());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Override
    @Test
    public void testDeleteByUUID() throws Exception {
        String extraRoleUuid = (String)this.tx(tx -> {
            RoleDao roleDao = tx.roleDao();
            GroupDao groupDao = tx.groupDao();
            HibRole extraRole = roleDao.create("extra role", this.user());
            groupDao.addRole(this.group(), extraRole);
            roleDao.grantPermissions(this.role(), (HibBaseElement)extraRole, new InternalPermission[]{InternalPermission.DELETE_PERM});
            return extraRole.getUuid();
        });
        this.expect(MeshEvent.ROLE_DELETED).match(1, MeshElementEventModelImpl.class, event -> ((MeshElementEventModelAssert)MeshAssertions.assertThat((MeshElementEventModel)event).hasName("extra role")).hasUuid(extraRoleUuid));
        this.waitAndClearSearchIdleEvents();
        ClientHelper.call(() -> this.client().deleteRole(extraRoleUuid));
        this.awaitEvents();
        this.waitForSearchIdleEvent();
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasDelete(HibRole.composeIndexName(), extraRoleUuid);
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasEvents(0L, 0L, 1L, 0L, 0L);
        try (Tx tx2 = this.tx();){
            MeshAssert.assertElement((DaoGlobal)tx2.roleDao(), (String)extraRoleUuid, (boolean)false);
        }
    }

    @Override
    @Test
    public void testDeleteByUUIDWithNoPermission() throws Exception {
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            roleDao.revokePermissions(this.role(), (HibBaseElement)this.role(), new InternalPermission[]{InternalPermission.DELETE_PERM});
            tx.success();
        }
        tx = this.tx();
        try {
            String uuid = this.role().getUuid();
            ClientHelper.call(() -> this.client().deleteRole(uuid), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{uuid, InternalPermission.DELETE_PERM.getRestPerm().getName()});
            MeshAssert.assertElement((DaoGlobal)tx.roleDao(), (String)uuid, (boolean)true);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Override
    @Test
    @Ignore(value="not yet enabled")
    public void testUpdateMultithreaded() throws InterruptedException {
        RoleUpdateRequest request = new RoleUpdateRequest();
        request.setName("renamed role");
        int nJobs = 5;
        MeshTestHelper.awaitConcurrentRequests(nJobs, i -> this.client().updateRole(this.role().getUuid(), request));
    }

    @Override
    @Test
    @Ignore(value="not yet enabled")
    public void testReadByUuidMultithreaded() throws Exception {
        Single future = this.client().login();
        future.blockingGet();
        int nJobs = 10;
        String uuid = this.role().getUuid();
        MeshTestHelper.awaitConcurrentRequests(nJobs, i -> this.client().findRoleByUuid(uuid, new ParameterProvider[0]));
    }

    @Override
    @Test
    @Ignore(value="not yet enabled")
    public void testDeleteByUUIDMultithreaded() throws Exception {
        int nJobs = 3;
        String uuid = this.role().getUuid();
        ClientHelper.validateDeletion(i -> this.client().deleteRole(uuid), (int)nJobs);
    }

    @Override
    @Test
    public void testCreateMultithreaded() throws Exception {
        Single future = this.client().login();
        future.blockingGet();
        int nJobs = 20;
        MeshTestHelper.awaitConcurrentRequests(nJobs, i -> {
            RoleCreateRequest request = new RoleCreateRequest();
            request.setName("new_role_" + i);
            return this.client().createRole(request);
        });
    }

    @Override
    @Test
    public void testReadByUuidMultithreadedNonBlocking() throws Exception {
        String uuid;
        try (Tx tx = this.tx();){
            uuid = this.role().getUuid();
        }
        Single observable = this.client().login();
        observable.blockingGet();
        int nJobs = 400;
        MeshTestHelper.awaitConcurrentRequests(nJobs, i -> this.client().findRoleByUuid(uuid, new ParameterProvider[0]));
    }

    @Override
    @Test
    public void testPermissionResponse() {
        RoleResponse role = (RoleResponse)((RoleListResponse)this.client().findRoles(new ParameterProvider[0]).blockingGet()).getData().get(0);
        MeshAssertions.assertThat((PermissionInfo)role.getPermissions()).hasNoPublishPermsSet();
    }
}

