/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.role;

import com.gentics.mesh.context.BulkActionContext;
import com.gentics.mesh.context.InternalActionContext;
import com.gentics.mesh.context.impl.InternalRoutingActionContextImpl;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.dao.NodeDao;
import com.gentics.mesh.core.data.dao.PersistingGroupDao;
import com.gentics.mesh.core.data.dao.RoleDao;
import com.gentics.mesh.core.data.dao.UserDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.page.Page;
import com.gentics.mesh.core.data.perm.InternalPermission;
import com.gentics.mesh.core.data.role.HibRole;
import com.gentics.mesh.core.data.schema.HibSchemaVersion;
import com.gentics.mesh.core.data.service.BasicObjectTestcases;
import com.gentics.mesh.core.data.user.HibUser;
import com.gentics.mesh.core.db.CommonTx;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.role.RoleReference;
import com.gentics.mesh.core.rest.role.RoleResponse;
import com.gentics.mesh.error.InvalidArgumentException;
import com.gentics.mesh.parameter.PagingParameters;
import com.gentics.mesh.parameter.impl.PagingParametersImpl;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.google.common.collect.Iterators;
import io.vertx.ext.web.RoutingContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.PROJECT, startServer=false)
public class RoleTest
extends AbstractMeshTest
implements BasicObjectTestcases {
    @Override
    @Test
    public void testTransformToReference() throws Exception {
        try (Tx tx = this.tx();){
            RoleReference reference = (RoleReference)this.role().transformToReference();
            Assert.assertNotNull((Object)reference);
            Assert.assertEquals((Object)this.role().getUuid(), (Object)reference.getUuid());
            Assert.assertEquals((Object)this.role().getName(), (Object)reference.getName());
        }
    }

    @Override
    @Test
    public void testCreate() throws Exception {
        try (Tx tx = this.tx();){
            String roleName = "test";
            RoleDao roleDao = tx.roleDao();
            HibRole createdRole = roleDao.create(roleName, this.user());
            Assert.assertNotNull((Object)createdRole);
            String uuid = createdRole.getUuid();
            HibRole role = (HibRole)tx.roleDao().findByUuid(uuid);
            Assert.assertNotNull((Object)role);
            Assert.assertEquals((Object)roleName, (Object)role.getName());
        }
    }

    @Test
    public void testGrantPermission() {
        try (Tx tx = this.tx();){
            NodeDao nodeDao = tx.nodeDao();
            RoleDao roleDao = tx.roleDao();
            HibRole role = this.role();
            HibNode node = this.folder("news");
            roleDao.grantPermissions(role, (HibBaseElement)node, new InternalPermission[]{InternalPermission.CREATE_PERM, InternalPermission.READ_PERM, InternalPermission.UPDATE_PERM, InternalPermission.DELETE_PERM});
            HibNode parentNode = this.folder("2015");
            HibNode node2 = nodeDao.create(parentNode, this.user(), (HibSchemaVersion)this.getSchemaContainer().getLatestVersion(), this.project());
            roleDao.grantPermissions(role, (HibBaseElement)node2, new InternalPermission[]{InternalPermission.READ_PERM, InternalPermission.DELETE_PERM});
            roleDao.grantPermissions(role, (HibBaseElement)node2, new InternalPermission[]{InternalPermission.CREATE_PERM});
            Set permissions = roleDao.getPermissions(role, (HibBaseElement)node2);
            Assert.assertNotNull((Object)permissions);
            Assert.assertTrue((boolean)permissions.contains(InternalPermission.CREATE_PERM));
            Assert.assertTrue((boolean)permissions.contains(InternalPermission.READ_PERM));
            Assert.assertTrue((boolean)permissions.contains(InternalPermission.DELETE_PERM));
            Assert.assertFalse((boolean)permissions.contains(InternalPermission.UPDATE_PERM));
            roleDao.grantPermissions(role, (HibBaseElement)role, new InternalPermission[]{InternalPermission.CREATE_PERM});
        }
    }

    @Test
    public void testIsPermitted() throws Exception {
        try (Tx tx = this.tx();){
            UserDao userDao = tx.userDao();
            HibUser user = this.user();
            int nRuns = 2000;
            for (int i = 0; i < nRuns; ++i) {
                userDao.hasPermission(user, (HibBaseElement)this.folder("news"), InternalPermission.READ_PERM);
            }
        }
    }

    @Test
    public void testGrantPermissionTwice() {
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            HibRole role = this.role();
            HibNode node = this.folder("news");
            roleDao.grantPermissions(role, (HibBaseElement)node, new InternalPermission[]{InternalPermission.CREATE_PERM});
            roleDao.grantPermissions(role, (HibBaseElement)node, new InternalPermission[]{InternalPermission.CREATE_PERM});
            Set permissions = roleDao.getPermissions(role, (HibBaseElement)node);
            Assert.assertNotNull((Object)permissions);
            Assert.assertTrue((boolean)permissions.contains(InternalPermission.CREATE_PERM));
            Assert.assertTrue((boolean)permissions.contains(InternalPermission.READ_PERM));
            Assert.assertTrue((boolean)permissions.contains(InternalPermission.DELETE_PERM));
            Assert.assertTrue((boolean)permissions.contains(InternalPermission.UPDATE_PERM));
        }
    }

    @Test
    public void testGrantMultiplePermission() {
        HibNode node;
        HibRole testRole;
        HibRole anonymous;
        HibRole admin;
        RoleDao roleDao;
        try (Tx tx = this.tx();){
            roleDao = tx.roleDao();
            admin = (HibRole)roleDao.findByName("admin");
            ((AbstractObjectAssert)Assertions.assertThat((Object)admin).as("Admin role", new Object[0])).isNotNull();
            anonymous = (HibRole)roleDao.findByName("anonymous");
            ((AbstractObjectAssert)Assertions.assertThat((Object)anonymous).as("Anonymous role", new Object[0])).isNotNull();
            testRole = this.role();
            ((AbstractObjectAssert)Assertions.assertThat((Object)testRole).as("Test role", new Object[0])).isNotNull();
            node = this.folder("news");
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)roleDao.grantPermissions(new HashSet<HibRole>(Arrays.asList(admin, anonymous)), (HibBaseElement)node, false, new InternalPermission[]{InternalPermission.CREATE_PERM, InternalPermission.READ_PERM})).as("Changed permissions", new Object[0])).isTrue();
            Assertions.assertThat((Iterable)roleDao.getPermissions(admin, (HibBaseElement)node)).as("Permissions for admin", new Object[0]).containsOnly((Object[])new InternalPermission[]{InternalPermission.CREATE_PERM, InternalPermission.READ_PERM});
            Assertions.assertThat((Iterable)roleDao.getPermissions(anonymous, (HibBaseElement)node)).as("Permissions for anonymous", new Object[0]).containsOnly((Object[])new InternalPermission[]{InternalPermission.CREATE_PERM, InternalPermission.READ_PERM});
            Assertions.assertThat((Iterable)roleDao.getPermissions(testRole, (HibBaseElement)node)).as("Permissions for test role", new Object[0]).containsOnly((Object[])new InternalPermission[]{InternalPermission.CREATE_PERM, InternalPermission.PUBLISH_PERM, InternalPermission.UPDATE_PERM, InternalPermission.READ_PERM, InternalPermission.DELETE_PERM, InternalPermission.READ_PUBLISHED_PERM});
            tx.success();
        }
        tx = this.tx();
        try {
            roleDao = tx.roleDao();
            admin = (HibRole)roleDao.findByName("admin");
            ((AbstractObjectAssert)Assertions.assertThat((Object)admin).as("Admin role", new Object[0])).isNotNull();
            anonymous = (HibRole)roleDao.findByName("anonymous");
            ((AbstractObjectAssert)Assertions.assertThat((Object)anonymous).as("Anonymous role", new Object[0])).isNotNull();
            testRole = this.role();
            ((AbstractObjectAssert)Assertions.assertThat((Object)testRole).as("Test role", new Object[0])).isNotNull();
            node = this.folder("news");
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)roleDao.grantPermissions(new HashSet<HibRole>(Arrays.asList(admin, testRole)), (HibBaseElement)node, false, new InternalPermission[]{InternalPermission.UPDATE_PERM})).as("Changed permissions", new Object[0])).isTrue();
            Assertions.assertThat((Iterable)roleDao.getPermissions(admin, (HibBaseElement)node)).as("Permissions for admin", new Object[0]).containsOnly((Object[])new InternalPermission[]{InternalPermission.CREATE_PERM, InternalPermission.READ_PERM, InternalPermission.UPDATE_PERM});
            Assertions.assertThat((Iterable)roleDao.getPermissions(anonymous, (HibBaseElement)node)).as("Permissions for anonymous", new Object[0]).containsOnly((Object[])new InternalPermission[]{InternalPermission.CREATE_PERM, InternalPermission.READ_PERM});
            Assertions.assertThat((Iterable)roleDao.getPermissions(testRole, (HibBaseElement)node)).as("Permissions for test role", new Object[0]).containsOnly((Object[])new InternalPermission[]{InternalPermission.CREATE_PERM, InternalPermission.PUBLISH_PERM, InternalPermission.UPDATE_PERM, InternalPermission.READ_PERM, InternalPermission.DELETE_PERM, InternalPermission.READ_PUBLISHED_PERM});
            tx.success();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.tx();
        try {
            roleDao = tx.roleDao();
            admin = (HibRole)roleDao.findByName("admin");
            ((AbstractObjectAssert)Assertions.assertThat((Object)admin).as("Admin role", new Object[0])).isNotNull();
            anonymous = (HibRole)roleDao.findByName("anonymous");
            ((AbstractObjectAssert)Assertions.assertThat((Object)anonymous).as("Anonymous role", new Object[0])).isNotNull();
            testRole = this.role();
            ((AbstractObjectAssert)Assertions.assertThat((Object)testRole).as("Test role", new Object[0])).isNotNull();
            node = this.folder("news");
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)roleDao.grantPermissions(new HashSet<HibRole>(Arrays.asList(admin, anonymous, testRole)), (HibBaseElement)node, false, new InternalPermission[]{InternalPermission.CREATE_PERM, InternalPermission.READ_PERM})).as("Changed permissions", new Object[0])).isFalse();
            tx.success();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testGrantMultiplePermissionExclusive() {
        HibNode node;
        HibRole testRole;
        HibRole anonymous;
        HibRole admin;
        RoleDao roleDao;
        try (Tx tx = this.tx();){
            roleDao = tx.roleDao();
            admin = (HibRole)roleDao.findByName("admin");
            ((AbstractObjectAssert)Assertions.assertThat((Object)admin).as("Admin role", new Object[0])).isNotNull();
            anonymous = (HibRole)roleDao.findByName("anonymous");
            ((AbstractObjectAssert)Assertions.assertThat((Object)anonymous).as("Anonymous role", new Object[0])).isNotNull();
            testRole = this.role();
            ((AbstractObjectAssert)Assertions.assertThat((Object)testRole).as("Test role", new Object[0])).isNotNull();
            node = this.folder("news");
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)roleDao.grantPermissions(new HashSet<HibRole>(Arrays.asList(admin, anonymous)), (HibBaseElement)node, true, new InternalPermission[]{InternalPermission.CREATE_PERM, InternalPermission.READ_PERM})).as("Changed permissions", new Object[0])).isTrue();
            Assertions.assertThat((Iterable)roleDao.getPermissions(admin, (HibBaseElement)node)).as("Permissions for admin", new Object[0]).containsOnly((Object[])new InternalPermission[]{InternalPermission.CREATE_PERM, InternalPermission.READ_PERM});
            Assertions.assertThat((Iterable)roleDao.getPermissions(anonymous, (HibBaseElement)node)).as("Permissions for anonymous", new Object[0]).containsOnly((Object[])new InternalPermission[]{InternalPermission.CREATE_PERM, InternalPermission.READ_PERM});
            Assertions.assertThat((Iterable)roleDao.getPermissions(testRole, (HibBaseElement)node)).as("Permissions for test role", new Object[0]).containsOnly((Object[])new InternalPermission[]{InternalPermission.PUBLISH_PERM, InternalPermission.UPDATE_PERM, InternalPermission.DELETE_PERM, InternalPermission.READ_PUBLISHED_PERM});
            tx.success();
        }
        tx = this.tx();
        try {
            roleDao = tx.roleDao();
            admin = (HibRole)roleDao.findByName("admin");
            ((AbstractObjectAssert)Assertions.assertThat((Object)admin).as("Admin role", new Object[0])).isNotNull();
            anonymous = (HibRole)roleDao.findByName("anonymous");
            ((AbstractObjectAssert)Assertions.assertThat((Object)anonymous).as("Anonymous role", new Object[0])).isNotNull();
            testRole = this.role();
            ((AbstractObjectAssert)Assertions.assertThat((Object)testRole).as("Test role", new Object[0])).isNotNull();
            node = this.folder("news");
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)roleDao.grantPermissions(new HashSet<HibRole>(Arrays.asList(admin, anonymous)), (HibBaseElement)node, true, new InternalPermission[]{InternalPermission.READ_PERM})).as("Changed permissions", new Object[0])).isFalse();
            tx.success();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.tx();
        try {
            roleDao = tx.roleDao();
            admin = (HibRole)roleDao.findByName("admin");
            ((AbstractObjectAssert)Assertions.assertThat((Object)admin).as("Admin role", new Object[0])).isNotNull();
            anonymous = (HibRole)roleDao.findByName("anonymous");
            ((AbstractObjectAssert)Assertions.assertThat((Object)anonymous).as("Anonymous role", new Object[0])).isNotNull();
            testRole = this.role();
            ((AbstractObjectAssert)Assertions.assertThat((Object)testRole).as("Test role", new Object[0])).isNotNull();
            node = this.folder("news");
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)roleDao.grantPermissions(new HashSet<HibRole>(Arrays.asList(admin)), (HibBaseElement)node, true, new InternalPermission[]{InternalPermission.READ_PERM})).as("Changed permissions", new Object[0])).isTrue();
            Assertions.assertThat((Iterable)roleDao.getPermissions(admin, (HibBaseElement)node)).as("Permissions for admin", new Object[0]).containsOnly((Object[])new InternalPermission[]{InternalPermission.CREATE_PERM, InternalPermission.READ_PERM});
            Assertions.assertThat((Iterable)roleDao.getPermissions(anonymous, (HibBaseElement)node)).as("Permissions for anonymous", new Object[0]).containsOnly((Object[])new InternalPermission[]{InternalPermission.CREATE_PERM});
            Assertions.assertThat((Iterable)roleDao.getPermissions(testRole, (HibBaseElement)node)).as("Permissions for test role", new Object[0]).containsOnly((Object[])new InternalPermission[]{InternalPermission.PUBLISH_PERM, InternalPermission.UPDATE_PERM, InternalPermission.DELETE_PERM, InternalPermission.READ_PUBLISHED_PERM});
            tx.success();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testGetPermissions() {
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            HibRole role = this.role();
            HibNode node = this.folder("news");
            Assert.assertEquals((long)6L, (long)roleDao.getPermissions(role, (HibBaseElement)node).size());
        }
    }

    @Test
    public void testGetMultiplePermissions() {
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            HibRole admin = (HibRole)roleDao.findByName("admin");
            ((AbstractObjectAssert)Assertions.assertThat((Object)admin).as("Admin role", new Object[0])).isNotNull();
            HibRole anonymous = (HibRole)roleDao.findByName("anonymous");
            ((AbstractObjectAssert)Assertions.assertThat((Object)anonymous).as("Anonymous role", new Object[0])).isNotNull();
            HibRole testRole = this.role();
            ((AbstractObjectAssert)Assertions.assertThat((Object)testRole).as("Test role", new Object[0])).isNotNull();
            HibNode node = this.folder("news");
            Map result = roleDao.getPermissions(new HashSet<HibRole>(Arrays.asList(admin, anonymous, testRole)), (HibBaseElement)node);
            ((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)result).as("Permissions result", new Object[0])).containsOnlyKeys((Object[])new HibRole[]{admin, anonymous, testRole}).containsEntry((Object)testRole, new HashSet<InternalPermission>(Arrays.asList(InternalPermission.CREATE_PERM, InternalPermission.PUBLISH_PERM, InternalPermission.UPDATE_PERM, InternalPermission.READ_PERM, InternalPermission.DELETE_PERM, InternalPermission.READ_PUBLISHED_PERM)))).containsEntry((Object)admin, Collections.emptySet())).containsEntry((Object)anonymous, Collections.emptySet());
        }
    }

    @Test
    public void testGetMultiplePermissionsForNoRoles() {
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            HibNode node = this.folder("news");
            Map result = roleDao.getPermissions(Collections.emptySet(), (HibBaseElement)node);
            ((MapAssert)Assertions.assertThat((Map)result).as("Permissions result", new Object[0])).isEmpty();
        }
    }

    @Test
    public void testRevokePermission() {
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            HibRole role = this.role();
            HibNode node = this.folder("news");
            roleDao.revokePermissions(role, (HibBaseElement)node, new InternalPermission[]{InternalPermission.CREATE_PERM});
            Set permissions = roleDao.getPermissions(role, (HibBaseElement)node);
            Assert.assertNotNull((Object)permissions);
            Assert.assertFalse((boolean)permissions.contains(InternalPermission.CREATE_PERM));
            Assert.assertTrue((boolean)permissions.contains(InternalPermission.DELETE_PERM));
            Assert.assertTrue((boolean)permissions.contains(InternalPermission.UPDATE_PERM));
            Assert.assertTrue((boolean)permissions.contains(InternalPermission.READ_PERM));
        }
    }

    @Test
    public void testRevokeMultiplePermissions() {
        HibNode node;
        HibRole testRole;
        HibRole anonymous;
        HibRole admin;
        RoleDao roleDao;
        try (Tx tx = this.tx();){
            roleDao = tx.roleDao();
            admin = (HibRole)roleDao.findByName("admin");
            ((AbstractObjectAssert)Assertions.assertThat((Object)admin).as("Admin role", new Object[0])).isNotNull();
            anonymous = (HibRole)roleDao.findByName("anonymous");
            ((AbstractObjectAssert)Assertions.assertThat((Object)anonymous).as("Anonymous role", new Object[0])).isNotNull();
            testRole = this.role();
            ((AbstractObjectAssert)Assertions.assertThat((Object)testRole).as("Test role", new Object[0])).isNotNull();
            node = this.folder("news");
            roleDao.grantPermissions(admin, (HibBaseElement)node, new InternalPermission[]{InternalPermission.CREATE_PERM, InternalPermission.UPDATE_PERM});
            roleDao.grantPermissions(anonymous, (HibBaseElement)node, new InternalPermission[]{InternalPermission.CREATE_PERM});
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)roleDao.revokePermissions(new HashSet<HibRole>(Arrays.asList(admin, testRole)), (HibBaseElement)node, new InternalPermission[]{InternalPermission.CREATE_PERM, InternalPermission.READ_PERM})).as("Permissions were changed", new Object[0])).isTrue();
            Assertions.assertThat((Iterable)roleDao.getPermissions(admin, (HibBaseElement)node)).as("Permissions for admin", new Object[0]).containsOnly((Object[])new InternalPermission[]{InternalPermission.UPDATE_PERM});
            Assertions.assertThat((Iterable)roleDao.getPermissions(anonymous, (HibBaseElement)node)).as("Permissions for anonymous", new Object[0]).containsOnly((Object[])new InternalPermission[]{InternalPermission.CREATE_PERM});
            Assertions.assertThat((Iterable)roleDao.getPermissions(testRole, (HibBaseElement)node)).as("Permissions for test role", new Object[0]).containsOnly((Object[])new InternalPermission[]{InternalPermission.PUBLISH_PERM, InternalPermission.UPDATE_PERM, InternalPermission.DELETE_PERM, InternalPermission.READ_PUBLISHED_PERM});
            tx.success();
        }
        tx = this.tx();
        try {
            roleDao = tx.roleDao();
            admin = (HibRole)roleDao.findByName("admin");
            ((AbstractObjectAssert)Assertions.assertThat((Object)admin).as("Admin role", new Object[0])).isNotNull();
            anonymous = (HibRole)roleDao.findByName("anonymous");
            ((AbstractObjectAssert)Assertions.assertThat((Object)anonymous).as("Anonymous role", new Object[0])).isNotNull();
            testRole = this.role();
            ((AbstractObjectAssert)Assertions.assertThat((Object)testRole).as("Test role", new Object[0])).isNotNull();
            node = this.folder("news");
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)roleDao.revokePermissions(new HashSet<HibRole>(Arrays.asList(admin, testRole)), (HibBaseElement)node, new InternalPermission[]{InternalPermission.CREATE_PERM, InternalPermission.READ_PERM})).as("Permissions were changed", new Object[0])).isFalse();
            tx.success();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testRevokePermissionOnGroupRoot() throws Exception {
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            UserDao userDao = tx.userDao();
            roleDao.revokePermissions(this.role(), tx.data().permissionRoots().group(), new InternalPermission[]{InternalPermission.CREATE_PERM});
            HibUser user = this.user();
            Assert.assertFalse((String)"The create permission to the groups root node should have been revoked.", (boolean)userDao.hasPermission(user, tx.data().permissionRoots().group(), InternalPermission.CREATE_PERM));
        }
    }

    @Override
    @Test
    public void testRootNode() {
        try (Tx tx = this.tx();){
            String roleName = "test2";
            RoleDao roleDao = tx.roleDao();
            long nRolesBefore = roleDao.count();
            HibRole role = roleDao.create("test2", this.user());
            Assert.assertNotNull((Object)role);
            long nRolesAfter = roleDao.count();
            Assert.assertEquals((long)(nRolesBefore + 1L), (long)nRolesAfter);
        }
    }

    @Test
    public void testRoleAddCrudPermissions() {
        try (Tx tx = this.tx();){
            NodeDao nodeDao = tx.nodeDao();
            RoleDao roleDao = tx.roleDao();
            UserDao userDao = tx.userDao();
            HibUser requestUser = this.user();
            HibNode parentNode = this.folder("news");
            Assert.assertNotNull((Object)parentNode);
            for (HibRole role : this.roles().values()) {
                for (InternalPermission perm : InternalPermission.values()) {
                    roleDao.grantPermissions(role, (HibBaseElement)parentNode, new InternalPermission[]{perm});
                }
            }
            RoutingContext rc = this.mockRoutingContext();
            InternalRoutingActionContextImpl ac = new InternalRoutingActionContextImpl(rc);
            HibNode node = nodeDao.create(parentNode, this.user(), (HibSchemaVersion)this.getSchemaContainer().getLatestVersion(), this.project());
            Assert.assertEquals((long)0L, (long)userDao.getPermissions(requestUser, (HibBaseElement)node).size());
            userDao.inheritRolePermissions(requestUser, (HibBaseElement)parentNode, (HibBaseElement)node);
            ac.data().clear();
            Assert.assertEquals((long)6L, (long)userDao.getPermissions(requestUser, (HibBaseElement)node).size());
            try (Tx tx2 = this.tx();){
                for (HibRole role : this.roles().values()) {
                    for (InternalPermission permission : InternalPermission.values()) {
                        Assert.assertTrue((String)("The role {" + role.getName() + "} does not grant perm {" + permission.getRestPerm().getName() + "} to the node {" + node.getUuid() + "} but it should since the parent object got this role permission."), (boolean)roleDao.hasPermission(role, permission, (HibBaseElement)node));
                    }
                }
            }
        }
    }

    @Test
    public void testRolesOfGroup() throws InvalidArgumentException {
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            PersistingGroupDao groupDao = ((CommonTx)tx.unwrap()).groupDao();
            HibRole extraRole = roleDao.create("extraRole", this.user());
            groupDao.addRole(this.group(), extraRole);
            groupDao.addRole(this.group(), extraRole);
            groupDao.addRole(this.group(), extraRole);
            groupDao.addRole(this.group(), extraRole);
            groupDao.addRole(this.group(), extraRole);
            groupDao.mergeIntoPersisted((HibBaseElement)this.group());
            roleDao.grantPermissions(this.role(), (HibBaseElement)extraRole, new InternalPermission[]{InternalPermission.READ_PERM});
            RoutingContext rc = this.mockRoutingContext();
            InternalRoutingActionContextImpl ac = new InternalRoutingActionContextImpl(rc);
            HibUser requestUser = ac.getUser();
            Page roles = groupDao.getRoles(this.group(), requestUser, (PagingParameters)new PagingParametersImpl(1, Long.valueOf(10L)));
            Assert.assertEquals((long)2L, (long)roles.getSize());
            Assert.assertEquals((long)1L, (long)roleDao.getGroups(extraRole).count());
        }
    }

    @Override
    @Test
    public void testFindAllVisible() throws InvalidArgumentException {
        int roleCount = this.roles().size();
        try (Tx tx = this.tx();){
            RoutingContext rc = this.mockRoutingContext();
            InternalRoutingActionContextImpl ac = new InternalRoutingActionContextImpl(rc);
            Page page = tx.roleDao().findAll((InternalActionContext)ac, (PagingParameters)new PagingParametersImpl(1, Long.valueOf(5L)));
            Assert.assertEquals((long)roleCount, (long)page.getTotalElements());
            Assert.assertEquals((long)roleCount, (long)page.getSize());
            page = tx.roleDao().findAll((InternalActionContext)ac, (PagingParameters)new PagingParametersImpl(1, Long.valueOf(15L)));
            Assert.assertEquals((long)roleCount, (long)page.getTotalElements());
            Assert.assertEquals((long)roleCount, (long)page.getSize());
        }
    }

    @Override
    @Test
    public void testFindByName() {
        try (Tx tx = this.tx();){
            Assert.assertNotNull((Object)tx.roleDao().findByName(this.role().getName()));
            Assert.assertNull((Object)tx.roleDao().findByName("bogus"));
        }
    }

    @Override
    @Test
    public void testFindByUUID() {
        try (Tx tx = this.tx();){
            HibRole role = (HibRole)tx.roleDao().findByUuid(this.role().getUuid());
            Assert.assertNotNull((Object)role);
            role = (HibRole)tx.roleDao().findByUuid("bogus");
            Assert.assertNull((Object)role);
        }
    }

    @Override
    @Test
    public void testTransformation() throws Exception {
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            HibRole role = this.role();
            RoutingContext rc = this.mockRoutingContext();
            InternalRoutingActionContextImpl ac = new InternalRoutingActionContextImpl(rc);
            RoleResponse restModel = (RoleResponse)roleDao.transformToRestSync((Object)role, (InternalActionContext)ac, 0, new String[0]);
            Assert.assertNotNull((Object)restModel);
            Assert.assertEquals((Object)role.getName(), (Object)restModel.getName());
            Assert.assertEquals((Object)role.getUuid(), (Object)restModel.getUuid());
        }
    }

    @Override
    @Test
    public void testCreateDelete() throws Exception {
        String roleName = "test";
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            HibRole role = roleDao.create(roleName, this.user());
            String uuid = role.getUuid();
            role = (HibRole)roleDao.findByUuid(uuid);
            Assert.assertNotNull((Object)role);
            BulkActionContext context = this.createBulkContext();
            roleDao.delete((HibBaseElement)role, context);
            HibRole foundRole = (HibRole)roleDao.findByUuid(uuid);
            Assert.assertNull((Object)foundRole);
        }
    }

    @Override
    @Test
    public void testCRUDPermissions() {
        try (Tx tx = this.tx();){
            UserDao userDao = tx.userDao();
            RoleDao roleDao = tx.roleDao();
            InternalActionContext ac = this.mockActionContext();
            HibRole role = roleDao.create("SuperUser", this.user());
            Assert.assertFalse((boolean)userDao.hasPermission(this.user(), (HibBaseElement)role, InternalPermission.CREATE_PERM));
            userDao.inheritRolePermissions(this.user(), tx.data().permissionRoots().user(), (HibBaseElement)role);
            ac.data().clear();
            Assert.assertTrue((boolean)userDao.hasPermission(this.user(), (HibBaseElement)role, InternalPermission.CREATE_PERM));
        }
    }

    @Override
    @Test
    public void testFindAll() throws InvalidArgumentException {
        try (Tx tx = this.tx();){
            long size = Iterators.size((Iterator)tx.roleDao().findAll().iterator());
            Assert.assertEquals((long)this.roles().size(), (long)size);
        }
    }

    @Override
    @Test
    public void testRead() {
        try (Tx tx = this.tx();){
            HibRole role = this.role();
            Assert.assertEquals((Object)"joe1_role", (Object)role.getName());
            Assert.assertNotNull((Object)role.getUuid());
            Assert.assertNotNull((Object)role.getCreationTimestamp());
            Assert.assertNotNull((Object)role.getCreator());
            Assert.assertNotNull((Object)role.getEditor());
            Assert.assertNotNull((Object)role.getLastEditedTimestamp());
        }
    }

    @Override
    @Test
    public void testDelete() throws Exception {
        try (Tx tx = this.tx();){
            String uuid;
            BulkActionContext context = this.createBulkContext();
            try (Tx tx2 = this.tx();){
                RoleDao roleDao = tx2.roleDao();
                HibRole role = (HibRole)tx.roleDao().findByUuid(this.role().getUuid());
                uuid = role.getUuid();
                roleDao.delete((HibBaseElement)role, context);
                tx2.success();
            }
            Assert.assertNull((Object)tx.roleDao().findByUuid(uuid));
            Assert.assertEquals((String)"The role event was not included in the batch", (long)1L, (long)context.batch().getEntries().size());
        }
    }

    @Override
    @Test
    public void testUpdate() {
        try (Tx tx = this.tx();){
            HibRole role = this.role();
            role.setName("newName");
            Assert.assertEquals((Object)"newName", (Object)role.getName());
        }
    }

    @Override
    @Test
    public void testReadPermission() {
        try (Tx tx = this.tx();){
            this.testPermission(InternalPermission.READ_PERM, (HibBaseElement)this.role());
        }
    }

    @Override
    @Test
    public void testDeletePermission() {
        try (Tx tx = this.tx();){
            this.testPermission(InternalPermission.DELETE_PERM, (HibBaseElement)this.role());
        }
    }

    @Override
    @Test
    public void testUpdatePermission() {
        try (Tx tx = this.tx();){
            this.testPermission(InternalPermission.UPDATE_PERM, (HibBaseElement)this.role());
        }
    }

    @Override
    @Test
    public void testCreatePermission() {
        try (Tx tx = this.tx();){
            this.testPermission(InternalPermission.CREATE_PERM, (HibBaseElement)this.role());
        }
    }
}

