/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.s3binary;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.PublishStatusResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.s3binary.S3BinaryUploadRequest;
import com.gentics.mesh.core.rest.project.ProjectCreateRequest;
import com.gentics.mesh.core.rest.project.ProjectListResponse;
import com.gentics.mesh.core.rest.project.ProjectResponse;
import com.gentics.mesh.core.rest.schema.SchemaListResponse;
import com.gentics.mesh.core.rest.schema.impl.SchemaResponse;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.rest.client.MeshRestClient;
import com.gentics.mesh.rest.client.MeshRestClientConfig;
import java.io.IOException;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore(value="This is not a read CI-ready UT, but rather an impl testing helper.")
public class S3FileUploadClientTest {
    public static final String PROJECT_NAME = "test";

    @Test
    public void testUpload() throws IOException {
        MeshRestClientConfig config = MeshRestClientConfig.newConfig().setHost("localhost").setPort(8080).setSsl(false).build();
        MeshRestClient client = MeshRestClient.create((MeshRestClientConfig)config);
        client.setLogin("admin", "admin");
        client.login().blockingGet();
        Optional<ProjectResponse> op = ((ProjectListResponse)client.findProjects(new ParameterProvider[0]).blockingGet()).getData().stream().filter(p -> p.getName().equalsIgnoreCase(PROJECT_NAME)).findFirst();
        if (op.isPresent()) {
            client.deleteProject(op.get().getUuid()).blockingAwait();
        }
        ProjectCreateRequest projectRequest = new ProjectCreateRequest();
        projectRequest.setName(PROJECT_NAME);
        projectRequest.setSchemaRef("folder");
        ProjectResponse project = (ProjectResponse)client.createProject(projectRequest).blockingGet();
        SchemaResponse schemaResponse = ((SchemaListResponse)client.findSchemas(new ParameterProvider[0]).blockingGet()).getData().stream().filter(schema -> schema.getName().equalsIgnoreCase("content")).findFirst().get();
        String binaryContentSchemaUuid = schemaResponse.getUuid();
        client.assignSchemaToProject(PROJECT_NAME, binaryContentSchemaUuid).blockingGet();
        String filename = "test.jpg";
        try {
            NodeCreateRequest nodeCreateRequest = new NodeCreateRequest();
            nodeCreateRequest.setLanguage("en");
            nodeCreateRequest.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime again!"));
            nodeCreateRequest.setSchemaName("content");
            nodeCreateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)"folder1"));
            nodeCreateRequest.getFields().put("title", (Field)FieldUtil.createStringField((String)"folder2"));
            nodeCreateRequest.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"folder2"));
            nodeCreateRequest.setParentNodeUuid(project.getRootNode().getUuid());
            NodeResponse binaryNode = (NodeResponse)client.createNode(PROJECT_NAME, nodeCreateRequest, new ParameterProvider[0]).blockingGet();
            PublishStatusResponse publishStatusResponse = (PublishStatusResponse)client.publishNode(PROJECT_NAME, binaryNode.getUuid(), new ParameterProvider[0]).blockingGet();
            Assert.assertTrue((publishStatusResponse.getAvailableLanguages().size() > 0 ? 1 : 0) != 0);
            String nodeUuid = binaryNode.getUuid();
            S3BinaryUploadRequest request = new S3BinaryUploadRequest().setFilename(filename).setLanguage("en").setVersion("1.0");
            client.updateNodeS3BinaryField(PROJECT_NAME, nodeUuid, "en", request, new ParameterProvider[0]).blockingGet();
        }
        catch (Throwable t) {
            System.out.println("Failure creating node for " + filename);
            t.printStackTrace();
        }
    }
}

