/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.schema;

import com.gentics.mesh.core.rest.micronode.MicronodeResponse;
import com.gentics.mesh.core.rest.node.FieldMap;
import com.gentics.mesh.core.rest.node.FieldMapImpl;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.impl.NodeFieldImpl;
import com.gentics.mesh.core.rest.node.field.impl.StringFieldImpl;
import com.gentics.mesh.core.rest.node.field.list.impl.MicronodeFieldListImpl;
import com.gentics.mesh.core.rest.node.field.list.impl.NodeFieldListImpl;
import com.gentics.mesh.core.rest.node.field.list.impl.NodeFieldListItemImpl;
import com.gentics.mesh.core.rest.node.field.list.impl.StringFieldListImpl;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.MicroschemaReference;
import com.gentics.mesh.core.rest.schema.impl.ListFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.MicronodeFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.MicroschemaReferenceImpl;
import com.gentics.mesh.core.rest.schema.impl.NodeFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.SchemaCreateRequest;
import com.gentics.mesh.core.rest.schema.impl.SchemaResponse;
import com.gentics.mesh.core.rest.schema.impl.StringFieldSchemaImpl;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import java.util.Collections;
import org.junit.Before;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.TRACKING, testSize=TestSize.FULL, startServer=true)
public class EmptyAllowTest
extends AbstractMeshTest {
    private String nodeUuid;

    @Before
    public void setUp() throws Exception {
        this.nodeUuid = (String)this.tx(() -> this.folder("2015").getUuid());
    }

    private void createSchema(FieldSchema field) {
        field.setName("testField");
        SchemaCreateRequest req = new SchemaCreateRequest();
        req.setName("test");
        req.setFields(Collections.singletonList(field));
        SchemaResponse response = (SchemaResponse)this.client().createSchema(req, new ParameterProvider[0]).blockingGet();
        this.client().assignSchemaToProject("dummy", response.getUuid()).blockingAwait();
    }

    private void createNode(Field field) {
        NodeCreateRequest req = new NodeCreateRequest();
        req.setLanguage("en");
        req.setSchemaName("test");
        req.setParentNodeUuid(this.nodeUuid);
        FieldMapImpl fieldMap = new FieldMapImpl();
        fieldMap.put("testField", field);
        req.setFields((FieldMap)fieldMap);
        this.client().createNode("dummy", req, new ParameterProvider[0]).blockingAwait();
    }

    private void runTest(FieldSchema schemaField, Field nodeField) {
        this.createSchema(schemaField);
        this.createNode(nodeField);
    }

    private MicronodeResponse createMicronode() {
        MicronodeResponse vcard = new MicronodeResponse().setMicroschema((MicroschemaReference)new MicroschemaReferenceImpl().setName("vcard"));
        FieldMap fields = vcard.getFields();
        fields.put("firstName", (Field)new StringFieldImpl().setString("John"));
        fields.put("lastName", (Field)new StringFieldImpl().setString("Doe"));
        return vcard;
    }

    @Test
    public void string() {
        this.runTest((FieldSchema)new StringFieldSchemaImpl().setAllowedValues(new String[0]), (Field)new StringFieldImpl().setString("test"));
    }

    @Test
    public void stringList() {
        this.runTest((FieldSchema)new ListFieldSchemaImpl().setListType("string").setAllowedSchemas(new String[0]), (Field)new StringFieldListImpl().setItems(Collections.singletonList("test")));
    }

    @Test
    public void node() {
        this.runTest((FieldSchema)new NodeFieldSchemaImpl().setAllowedSchemas(new String[0]), (Field)new NodeFieldImpl().setUuid(this.nodeUuid));
    }

    @Test
    public void nodeList() {
        this.runTest((FieldSchema)new ListFieldSchemaImpl().setListType("node").setAllowedSchemas(new String[0]), (Field)new NodeFieldListImpl().setItems(Collections.singletonList(new NodeFieldListItemImpl().setUuid(this.nodeUuid))));
    }

    @Test
    public void micronode() {
        this.runTest((FieldSchema)new MicronodeFieldSchemaImpl().setAllowedMicroSchemas(new String[0]), (Field)this.createMicronode());
    }

    @Test
    public void micronodeList() {
        this.runTest((FieldSchema)new ListFieldSchemaImpl().setListType("micronode").setAllowedSchemas(new String[0]), (Field)new MicronodeFieldListImpl().setItems(Collections.singletonList(this.createMicronode())));
    }
}

