/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.schema;

import com.gentics.mesh.core.rest.micronode.MicronodeResponse;
import com.gentics.mesh.core.rest.microschema.impl.MicroschemaResponse;
import com.gentics.mesh.core.rest.node.FieldMap;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.impl.BooleanFieldImpl;
import com.gentics.mesh.core.rest.node.field.impl.DateFieldImpl;
import com.gentics.mesh.core.rest.node.field.impl.HtmlFieldImpl;
import com.gentics.mesh.core.rest.node.field.impl.NodeFieldImpl;
import com.gentics.mesh.core.rest.node.field.impl.NumberFieldImpl;
import com.gentics.mesh.core.rest.node.field.impl.StringFieldImpl;
import com.gentics.mesh.core.rest.node.field.list.impl.BooleanFieldListImpl;
import com.gentics.mesh.core.rest.node.field.list.impl.DateFieldListImpl;
import com.gentics.mesh.core.rest.node.field.list.impl.HtmlFieldListImpl;
import com.gentics.mesh.core.rest.node.field.list.impl.MicronodeFieldListImpl;
import com.gentics.mesh.core.rest.node.field.list.impl.NodeFieldListImpl;
import com.gentics.mesh.core.rest.node.field.list.impl.NodeFieldListItemImpl;
import com.gentics.mesh.core.rest.node.field.list.impl.NumberFieldListImpl;
import com.gentics.mesh.core.rest.node.field.list.impl.StringFieldListImpl;
import com.gentics.mesh.core.rest.schema.MicroschemaListResponse;
import com.gentics.mesh.core.rest.schema.MicroschemaReference;
import com.gentics.mesh.core.rest.schema.impl.BinaryFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.BooleanFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.DateFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.HtmlFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.ListFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.MicronodeFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.MicroschemaReferenceImpl;
import com.gentics.mesh.core.rest.schema.impl.NodeFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.NumberFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.SchemaCreateRequest;
import com.gentics.mesh.core.rest.schema.impl.SchemaResponse;
import com.gentics.mesh.core.rest.schema.impl.StringFieldSchemaImpl;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import java.util.Arrays;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true, clusterMode=false)
public class MicronodeMigrationAllFieldsTest
extends AbstractMeshTest {
    public static final String SCHEMA_NAME = "AllFields";

    @Test
    public void testMigration() {
        this.grantAdmin();
        this.createSchema();
        this.createAllFieldsNode();
        this.updateMicroschema();
    }

    private SchemaResponse createSchema() {
        SchemaCreateRequest request = new SchemaCreateRequest().setName(SCHEMA_NAME).setFields(Arrays.asList(new StringFieldSchemaImpl().setName("string"), new NumberFieldSchemaImpl().setName("number"), new BooleanFieldSchemaImpl().setName("boolean"), new DateFieldSchemaImpl().setName("date"), new HtmlFieldSchemaImpl().setName("html"), new NodeFieldSchemaImpl().setName("node"), new BinaryFieldSchemaImpl().setName("binary"), new MicronodeFieldSchemaImpl().setName("micronode"), new ListFieldSchemaImpl().setListType("string").setName("liststring"), new ListFieldSchemaImpl().setListType("number").setName("listnumber"), new ListFieldSchemaImpl().setListType("date").setName("listdate"), new ListFieldSchemaImpl().setListType("boolean").setName("listboolean"), new ListFieldSchemaImpl().setListType("html").setName("listhtml"), new ListFieldSchemaImpl().setListType("node").setName("listnode"), new ListFieldSchemaImpl().setListType("micronode").setName("listmicronode")));
        SchemaResponse schemaResponse = (SchemaResponse)this.client().createSchema(request, new ParameterProvider[0]).blockingGet();
        this.client().assignSchemaToProject("dummy", schemaResponse.getUuid()).blockingAwait();
        return schemaResponse;
    }

    private NodeResponse createAllFieldsNode() {
        NodeCreateRequest request = new NodeCreateRequest();
        request.setLanguage("en");
        request.setSchemaName(SCHEMA_NAME);
        request.setParentNodeUuid(this.folderUuid());
        FieldMap fields = request.getFields();
        MicronodeResponse micronode = new MicronodeResponse();
        micronode.setMicroschema((MicroschemaReference)new MicroschemaReferenceImpl().setName("vcard"));
        FieldMap micronodeFields = micronode.getFields();
        micronodeFields.putString("firstName", "John");
        micronodeFields.putString("lastName", "Doe");
        fields.put("micronode", (Field)micronode);
        fields.put("listmicronode", (Field)new MicronodeFieldListImpl().setItems(Arrays.asList(micronode, micronode)));
        fields.put("string", (Field)new StringFieldImpl().setString("example"));
        fields.put("number", (Field)new NumberFieldImpl().setNumber((Number)1234));
        fields.put("boolean", (Field)new BooleanFieldImpl().setValue(Boolean.valueOf(false)));
        fields.put("date", (Field)new DateFieldImpl().setDate("2020-02-21T12:40:00Z"));
        fields.put("html", (Field)new HtmlFieldImpl().setHTML("<p>example</p>"));
        fields.put("node", (Field)new NodeFieldImpl().setUuid(this.folderUuid()));
        fields.put("liststring", (Field)new StringFieldListImpl().setItems(Arrays.asList("example1", "example2")));
        fields.put("listnumber", (Field)new NumberFieldListImpl().setItems(Arrays.asList(123, 456)));
        fields.put("listdate", (Field)new DateFieldListImpl().setItems(Arrays.asList("2020-02-21T12:40:00Z", "2020-02-22T12:40:00Z")));
        fields.put("listboolean", (Field)new BooleanFieldListImpl().setItems(Arrays.asList(false, true)));
        fields.put("listhtml", (Field)new HtmlFieldListImpl().setItems(Arrays.asList("<p>example1</p>", "<p>example2</p>")));
        fields.put("listnode", (Field)new NodeFieldListImpl().setItems(Arrays.asList(new NodeFieldListItemImpl().setUuid(this.folderUuid()), new NodeFieldListItemImpl().setUuid(this.folderUuid()))));
        return (NodeResponse)this.client().createNode("dummy", request, new ParameterProvider[0]).blockingGet();
    }

    private void updateMicroschema() {
        MicroschemaResponse microschema = (MicroschemaResponse)((MicroschemaListResponse)this.client().findMicroschemas(new ParameterProvider[0]).blockingGet()).getData().get(0);
        microschema.getFields().add(new StringFieldSchemaImpl().setName("additionalStringField"));
        this.waitForJob(() -> this.client().updateMicroschema(microschema.getUuid(), microschema.toRequest(), new ParameterProvider[0]).blockingAwait());
    }
}

