/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.schema;

import com.gentics.mesh.core.rest.MeshEvent;
import com.gentics.mesh.core.rest.event.impl.MeshElementEventModelImpl;
import com.gentics.mesh.core.rest.job.JobStatus;
import com.gentics.mesh.core.rest.microschema.impl.MicroschemaResponse;
import com.gentics.mesh.core.rest.microschema.impl.MicroschemaUpdateRequest;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true, clusterMode=false)
public class MicronodeMigrationEndpointTest
extends AbstractMeshTest {
    @Test
    public void testUpdate() {
        this.grantAdmin();
        String uuid = (String)this.tx(() -> this.microschemaContainer("vcard").getUuid());
        MicroschemaResponse microschema = (MicroschemaResponse)ClientHelper.call(() -> this.client().findMicroschemaByUuid(uuid, new ParameterProvider[0]));
        this.expect(MeshEvent.MICROSCHEMA_UPDATED).one().match(1, MeshElementEventModelImpl.class, event -> {
            Assert.assertEquals((Object)"changed", (Object)event.getName());
            Assert.assertEquals((Object)uuid, (Object)event.getUuid());
        });
        this.expect(MeshEvent.MICROSCHEMA_BRANCH_ASSIGN).one();
        this.expect(MeshEvent.MICROSCHEMA_MIGRATION_START).one();
        this.expect(MeshEvent.MICROSCHEMA_MIGRATION_FINISHED).one();
        MicroschemaUpdateRequest request = microschema.toRequest();
        this.waitForJobs(() -> {
            request.setName("changed");
            ClientHelper.call(() -> this.client().updateMicroschema(uuid, request, new ParameterProvider[0]));
        }, JobStatus.COMPLETED, 1);
        this.awaitEvents();
    }
}

