/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.schema;

import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.assertj.impl.MeshElementEventModelAssert;
import com.gentics.mesh.core.data.HibCoreElement;
import com.gentics.mesh.core.data.HibNodeFieldContainer;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.schema.HibMicroschema;
import com.gentics.mesh.core.data.schema.HibMicroschemaVersion;
import com.gentics.mesh.core.data.schema.HibSchemaVersion;
import com.gentics.mesh.core.db.CommonTx;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.MeshEvent;
import com.gentics.mesh.core.rest.event.MeshElementEventModel;
import com.gentics.mesh.core.rest.event.impl.MeshElementEventModelImpl;
import com.gentics.mesh.core.rest.job.JobStatus;
import com.gentics.mesh.core.rest.micronode.MicronodeResponse;
import com.gentics.mesh.core.rest.microschema.impl.MicroschemaResponse;
import com.gentics.mesh.core.rest.microschema.impl.MicroschemaUpdateRequest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.impl.StringFieldImpl;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.MicroschemaReference;
import com.gentics.mesh.core.rest.schema.SchemaVersionModel;
import com.gentics.mesh.core.rest.schema.change.impl.SchemaChangeModel;
import com.gentics.mesh.core.rest.schema.change.impl.SchemaChangesListModel;
import com.gentics.mesh.core.rest.schema.impl.MicronodeFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.MicroschemaReferenceImpl;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.client.SchemaUpdateParametersImpl;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.json.JsonObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class MicroschemaChangesEndpointTest
extends AbstractMeshTest {
    @Before
    public void addAdminPerms() {
        this.grantAdmin();
    }

    @Test
    public void testRemoveField() throws Exception {
        HibMicroschema microschemaContainer = this.microschemaContainer("vcard");
        HibNode node = this.createMicronodeNode();
        HibMicroschemaVersion beforeVersion = (HibMicroschemaVersion)this.tx(() -> microschemaContainer.getLatestVersion());
        Assert.assertNull((String)"The microschema should not yet have any changes", this.tx(() -> microschemaContainer.getLatestVersion().getNextChange()));
        String microschemaUuid = (String)this.tx(() -> microschemaContainer.getUuid());
        SchemaChangesListModel listOfChanges = new SchemaChangesListModel();
        SchemaChangeModel change = SchemaChangeModel.createRemoveFieldChange((String)"firstName");
        listOfChanges.getChanges().add(change);
        try (Tx tx = this.tx();){
            Assert.assertNull((String)"The schema should not yet have any changes", (Object)microschemaContainer.getLatestVersion().getNextChange());
        }
        ClientHelper.call(() -> this.client().applyChangesToMicroschema(microschemaUuid, listOfChanges));
        MicroschemaResponse microschema = (MicroschemaResponse)ClientHelper.call(() -> this.client().findMicroschemaByUuid(microschemaUuid, new ParameterProvider[0]));
        this.waitForJobs(() -> ClientHelper.call(() -> this.client().assignBranchMicroschemaVersions("dummy", this.initialBranchUuid(), new MicroschemaReference[]{((MicroschemaReference)new MicroschemaReferenceImpl().setName(microschema.getName())).setVersion(microschema.getVersion())})), JobStatus.COMPLETED, 1);
        try (Tx tx = this.tx();){
            HibMicroschemaVersion reloaded = (HibMicroschemaVersion)CommonTx.get().load(beforeVersion.getId(), ((CommonTx)this.tx().unwrap()).microschemaDao().getVersionPersistenceClass());
            Assert.assertNotNull((String)"The change should have been added to the schema.", (Object)reloaded.getNextChange());
            HibNodeFieldContainer fieldContainer = tx.contentDao().getFieldContainer(node, "en");
            Assert.assertNotNull((String)"The node should have a micronode graph field", (Object)fieldContainer.getMicronode("micronodeField"));
        }
    }

    @Test
    public void testAddField() throws Exception {
        HibMicroschemaVersion beforeVersion;
        HibMicroschema microschemaContainer = this.microschemaContainer("vcard");
        try (Tx tx = this.tx();){
            beforeVersion = microschemaContainer.getLatestVersion();
            Assert.assertNull((String)"The microschema should not yet have any changes", (Object)beforeVersion.getNextChange());
        }
        String microschemaUuid = (String)this.tx(() -> microschemaContainer.getUuid());
        SchemaChangesListModel listOfChanges = new SchemaChangesListModel();
        SchemaChangeModel change = SchemaChangeModel.createAddFieldChange((String)"newField", (String)"html", (String)"fieldLabel", (JsonObject)new JsonObject().put("test", (Object)"test"));
        listOfChanges.getChanges().add(change);
        this.waitForLatestJob(() -> {
            ClientHelper.call(() -> this.client().applyChangesToMicroschema(microschemaUuid, listOfChanges));
            MicroschemaResponse microschema = (MicroschemaResponse)ClientHelper.call(() -> this.client().findMicroschemaByUuid(microschemaUuid, new ParameterProvider[0]));
            ClientHelper.call(() -> this.client().assignBranchMicroschemaVersions("dummy", this.initialBranchUuid(), new MicroschemaReference[]{((MicroschemaReference)new MicroschemaReferenceImpl().setName(microschema.getName())).setVersion(microschema.getVersion())}));
        });
        try (Tx tx = this.tx();){
            HibMicroschemaVersion reloaded = (HibMicroschemaVersion)CommonTx.get().load(beforeVersion.getId(), ((CommonTx)this.tx().unwrap()).microschemaDao().getVersionPersistenceClass());
            Assert.assertNotNull((String)"The change should have been added to the schema.", (Object)reloaded.getNextChange());
            Assert.assertNotNull((String)"The container should now have a new version", (Object)reloaded.getNextVersion());
        }
    }

    @Test
    public void testUpdateName() throws Exception {
        String newName = "new_name";
        String vcardUuid = (String)this.tx(() -> this.microschemaContainers().get("vcard").getUuid());
        HibMicroschemaVersion beforeVersion = (HibMicroschemaVersion)this.tx(() -> this.data().getMicroschemaContainer("vcard").getLatestVersion());
        this.expect(MeshEvent.MICROSCHEMA_UPDATED).match(1, MeshElementEventModelImpl.class, event -> ((MeshElementEventModelAssert)MeshAssertions.assertThat((MeshElementEventModel)event).hasName("new_name")).hasUuid(vcardUuid)).one();
        this.expect(MeshEvent.MICROSCHEMA_MIGRATION_START).none();
        MicroschemaUpdateRequest request = new MicroschemaUpdateRequest();
        request.setName("new_name");
        ClientHelper.call(() -> this.client().updateMicroschema(vcardUuid, request, new ParameterProvider[]{new SchemaUpdateParametersImpl().setUpdateAssignedBranches(false)}));
        MicroschemaResponse microschema = (MicroschemaResponse)ClientHelper.call(() -> this.client().findMicroschemaByUuid(vcardUuid, new ParameterProvider[0]));
        this.awaitEvents();
        this.waitForJobs(() -> ClientHelper.call(() -> this.client().assignBranchMicroschemaVersions("dummy", this.initialBranchUuid(), new MicroschemaReference[]{((MicroschemaReference)new MicroschemaReferenceImpl().setName(microschema.getName())).setVersion(microschema.getVersion())})), JobStatus.COMPLETED, 1);
        try (Tx tx = this.tx();){
            HibMicroschemaVersion reloaded = (HibMicroschemaVersion)CommonTx.get().load(beforeVersion.getId(), ((CommonTx)this.tx().unwrap()).microschemaDao().getVersionPersistenceClass());
            Assert.assertEquals((String)"The name of the microschema was not updated", (Object)"new_name", (Object)reloaded.getNextVersion().getName());
        }
    }

    @Test
    public void testUpdateWithConflictingName() {
        try (Tx tx = this.tx();){
            String name = "captionedImage";
            String originalSchemaName = "vcard";
            HibMicroschema microschema = this.microschemaContainers().get(originalSchemaName);
            Assert.assertNotNull((Object)microschema);
            MicroschemaUpdateRequest request = new MicroschemaUpdateRequest();
            request.setName(name);
            ClientHelper.call(() -> this.client().updateMicroschema(microschema.getUuid(), request, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.CONFLICT, (String)"schema_conflicting_name", (String[])new String[]{name});
            Assert.assertEquals((String)"The name of the microschema was updated but it should not.", (Object)originalSchemaName, (Object)microschema.getName());
        }
    }

    private HibNode createMicronodeNode() {
        this.tx(() -> {
            SchemaVersionModel schema = (SchemaVersionModel)this.tx(() -> ((HibSchemaVersion)this.schemaContainer("folder").getLatestVersion()).getSchema());
            MicronodeFieldSchemaImpl microschemaFieldSchema = new MicronodeFieldSchemaImpl();
            microschemaFieldSchema.setName("micronodeField");
            microschemaFieldSchema.setLabel("Some label");
            microschemaFieldSchema.setAllowedMicroSchemas(new String[]{"vcard"});
            schema.addField((FieldSchema)microschemaFieldSchema);
            ((HibSchemaVersion)this.schemaContainer("folder").getLatestVersion()).setSchema(schema);
        });
        MicronodeResponse micronode = new MicronodeResponse();
        MicroschemaReferenceImpl ref = new MicroschemaReferenceImpl();
        ref.setName("vcard");
        micronode.setMicroschema((MicroschemaReference)ref);
        micronode.getFields().put("firstName", (Field)new StringFieldImpl().setString("Max"));
        micronode.getFields().put("lastName", (Field)new StringFieldImpl().setString("Mustermann"));
        NodeResponse response = this.createNode("micronodeField", (Field)micronode);
        return (HibNode)this.tx(tx -> {
            HibNode node = (HibNode)tx.nodeDao().findByUuid((HibCoreElement)this.project(), response.getUuid());
            Assert.assertNotNull((String)"The node should have been created.", (Object)node);
            Assert.assertNotNull((String)"The node should have a micronode graph field", (Object)tx.contentDao().getFieldContainer(node, "en").getMicronode("micronodeField"));
            return node;
        });
    }
}

