/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.schema;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.schema.HibMicroschema;
import com.gentics.mesh.core.data.schema.HibMicroschemaVersion;
import com.gentics.mesh.core.db.CommonTx;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.microschema.MicroschemaVersionModel;
import com.gentics.mesh.core.rest.microschema.impl.MicroschemaModelImpl;
import com.gentics.mesh.core.rest.schema.BinaryFieldSchema;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.MicroschemaModel;
import com.gentics.mesh.core.rest.schema.StringFieldSchema;
import com.gentics.mesh.core.rest.schema.change.impl.SchemaChangeModel;
import com.gentics.mesh.core.rest.schema.change.impl.SchemaChangeOperation;
import com.gentics.mesh.core.rest.schema.change.impl.SchemaChangesListModel;
import com.gentics.mesh.core.rest.schema.impl.StringFieldSchemaImpl;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.category.FailingTests;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class MicroschemaDiffEndpointTest
extends AbstractMeshTest {
    private MicroschemaModel getMicroschema() {
        MicroschemaModelImpl vcardMicroschemaModel = new MicroschemaModelImpl();
        vcardMicroschemaModel.setName("vcard");
        vcardMicroschemaModel.setDescription("Microschema for a vcard");
        StringFieldSchemaImpl firstNameFieldSchema = new StringFieldSchemaImpl();
        firstNameFieldSchema.setName("firstName");
        firstNameFieldSchema.setLabel("First Name");
        firstNameFieldSchema.setRequired(true);
        vcardMicroschemaModel.addField((FieldSchema)firstNameFieldSchema);
        StringFieldSchemaImpl lastNameFieldSchema = new StringFieldSchemaImpl();
        lastNameFieldSchema.setName("lastName");
        lastNameFieldSchema.setLabel("Last Name");
        lastNameFieldSchema.setRequired(true);
        vcardMicroschemaModel.addField((FieldSchema)lastNameFieldSchema);
        StringFieldSchemaImpl addressFieldSchema = new StringFieldSchemaImpl();
        addressFieldSchema.setName("address");
        addressFieldSchema.setLabel("Address");
        vcardMicroschemaModel.addField((FieldSchema)addressFieldSchema);
        StringFieldSchemaImpl postcodeFieldSchema = new StringFieldSchemaImpl();
        postcodeFieldSchema.setName("postcode");
        postcodeFieldSchema.setLabel("Post Code");
        vcardMicroschemaModel.addField((FieldSchema)postcodeFieldSchema);
        return vcardMicroschemaModel;
    }

    @Test
    @Category(value={FailingTests.class})
    public void testDiffEmptyDescription() {
        String microschemaUuid = (String)this.tx(() -> this.microschemaContainer("vcard").getUuid());
        this.tx(() -> {
            HibMicroschema microschema = (HibMicroschema)this.tx(() -> this.microschemaContainer("vcard"));
            HibMicroschemaVersion microschemaVersion = microschema.getLatestVersion();
            MicroschemaVersionModel schemaModel = microschemaVersion.getSchema();
            schemaModel.setDescription("");
            microschemaVersion.setJson(schemaModel.toJson());
            CommonTx.get().microschemaDao().mergeIntoPersisted((HibBaseElement)microschema);
        });
        MicroschemaModel request = this.getMicroschema();
        request.setDescription(null);
        SchemaChangesListModel changes = (SchemaChangesListModel)ClientHelper.call(() -> this.client().diffMicroschema(microschemaUuid, request));
        MeshAssertions.assertThat((List)changes.getChanges()).isEmpty();
    }

    @Test
    public void testNoDiff() {
        try (Tx tx = this.tx();){
            HibMicroschema microschema = this.microschemaContainer("vcard");
            MicroschemaModel request = this.getMicroschema();
            SchemaChangesListModel changes = (SchemaChangesListModel)ClientHelper.call(() -> this.client().diffMicroschema(microschema.getUuid(), request));
            MeshAssertions.assertThat((List)changes.getChanges()).isEmpty();
        }
    }

    @Test
    public void testAddField() {
        String uuid = (String)this.tx(() -> this.microschemaContainer("vcard").getUuid());
        MicroschemaModel request = this.getMicroschema();
        StringFieldSchema stringField = FieldUtil.createStringFieldSchema((String)"someField");
        stringField.setAllowedValues(new String[]{"one", "two"});
        request.addField((FieldSchema)stringField);
        SchemaChangesListModel changes = (SchemaChangesListModel)ClientHelper.call(() -> this.client().diffMicroschema(uuid, request));
        Assert.assertNotNull((Object)changes);
        MeshAssertions.assertThat((List)changes.getChanges()).hasSize(2);
        MeshAssertions.assertThat((SchemaChangeModel)((SchemaChangeModel)changes.getChanges().get(0))).is(SchemaChangeOperation.ADDFIELD).forField("someField");
        MeshAssertions.assertThat((SchemaChangeModel)((SchemaChangeModel)changes.getChanges().get(1))).is(SchemaChangeOperation.UPDATEMICROSCHEMA).hasProperty("order", (Object)new String[]{"firstName", "lastName", "address", "postcode", "someField"});
        ClientHelper.call(() -> this.client().applyChangesToMicroschema(uuid, changes));
    }

    @Test
    public void testApplyChanges() {
        String uuid = (String)this.tx(() -> this.microschemaContainer("vcard").getUuid());
        MicroschemaModel request = this.getMicroschema();
        StringFieldSchema stringField = FieldUtil.createStringFieldSchema((String)"someField");
        stringField.setAllowedValues(new String[]{"one", "two"});
        request.addField((FieldSchema)stringField);
        SchemaChangesListModel changes = (SchemaChangesListModel)ClientHelper.call(() -> this.client().diffMicroschema(uuid, request));
        ClientHelper.call(() -> this.client().applyChangesToMicroschema(uuid, changes));
    }

    @Test
    public void testAddUnsupportedField() {
        try (Tx tx = this.tx();){
            HibMicroschema microschema = this.microschemaContainer("vcard");
            MicroschemaModel request = this.getMicroschema();
            BinaryFieldSchema binaryField = FieldUtil.createBinaryFieldSchema((String)"binaryField");
            request.addField((FieldSchema)binaryField);
            ClientHelper.call(() -> this.client().diffMicroschema(microschema.getUuid(), request), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"microschema_error_field_type_not_allowed", (String[])new String[]{"binaryField", "binary"});
        }
    }

    @Test
    public void testRemoveField() {
        try (Tx tx = this.tx();){
            HibMicroschema microschema = this.microschemaContainer("vcard");
            MicroschemaModel request = this.getMicroschema();
            request.removeField("postcode");
            SchemaChangesListModel changes = (SchemaChangesListModel)ClientHelper.call(() -> this.client().diffMicroschema(microschema.getUuid(), request));
            Assert.assertNotNull((Object)changes);
            MeshAssertions.assertThat((List)changes.getChanges()).hasSize(2);
            MeshAssertions.assertThat((SchemaChangeModel)((SchemaChangeModel)changes.getChanges().get(0))).is(SchemaChangeOperation.REMOVEFIELD).forField("postcode");
            MeshAssertions.assertThat((SchemaChangeModel)((SchemaChangeModel)changes.getChanges().get(1))).is(SchemaChangeOperation.UPDATEMICROSCHEMA).hasProperty("order", (Object)new String[]{"firstName", "lastName", "address"});
        }
    }
}

