/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.schema;

import com.gentics.mesh.core.data.HibTransformableElement;
import com.gentics.mesh.core.data.dao.MicroschemaDao;
import com.gentics.mesh.core.data.schema.HibMicroschema;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.NodeParametersImpl;
import com.gentics.mesh.parameter.impl.PagingParametersImpl;
import com.gentics.mesh.rest.client.MeshRequest;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class MicroschemaEndpointETagTest
extends AbstractMeshTest {
    @Test
    public void testReadMultiple() {
        try (Tx tx = this.tx();){
            String etag = ClientHelper.callETag(() -> this.client().findMicroschemas(new ParameterProvider[0]));
            ClientHelper.callETag(() -> this.client().findMicroschemas(new ParameterProvider[0]), (String)etag, (boolean)true, (int)304);
            ClientHelper.callETag(() -> this.client().findMicroschemas(new ParameterProvider[]{new PagingParametersImpl().setPage(2L)}), (String)etag, (boolean)true, (int)200);
        }
    }

    @Test
    public void testReadOne() {
        try (Tx tx = this.tx();){
            MicroschemaDao microschemaDao = tx.microschemaDao();
            HibMicroschema schema = this.microschemaContainers().get("vcard");
            String actualEtag = ClientHelper.callETag(() -> this.client().findMicroschemaByUuid(schema.getUuid(), new ParameterProvider[0]));
            String etag = microschemaDao.getETag((HibTransformableElement)schema, this.mockActionContext());
            Assert.assertEquals((Object)etag, (Object)actualEtag);
            MeshRequest request = this.client().findMicroschemaByUuid(schema.getUuid(), new ParameterProvider[0]);
            Assertions.assertThat((String)ClientHelper.callETag(() -> request, (String)etag, (boolean)true, (int)304)).contains(new CharSequence[]{etag});
            Assertions.assertThat((String)ClientHelper.callETag(() -> this.client().findMicroschemaByUuid(schema.getUuid(), new ParameterProvider[]{new NodeParametersImpl().setExpandAll(true)}), (String)etag, (boolean)true, (int)304)).contains(new CharSequence[]{etag});
            ClientHelper.callETag(() -> this.client().findMicroschemaByUuid(schema.getUuid(), new ParameterProvider[]{new NodeParametersImpl().setExpandAll(false)}), (String)etag, (boolean)true, (int)304);
            ClientHelper.callETag(() -> this.client().findMicroschemaByUuid(schema.getUuid(), new ParameterProvider[]{new NodeParametersImpl().setExpandAll(true)}), (String)etag, (boolean)true, (int)304);
        }
    }
}

