/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.schema;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.assertj.impl.MeshElementEventModelAssert;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.dao.DaoGlobal;
import com.gentics.mesh.core.data.dao.RoleDao;
import com.gentics.mesh.core.data.perm.InternalPermission;
import com.gentics.mesh.core.data.schema.HibMicroschema;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.MeshEvent;
import com.gentics.mesh.core.rest.common.Permission;
import com.gentics.mesh.core.rest.common.PermissionInfo;
import com.gentics.mesh.core.rest.error.GenericRestException;
import com.gentics.mesh.core.rest.event.MeshElementEventModel;
import com.gentics.mesh.core.rest.event.impl.MeshElementEventModelImpl;
import com.gentics.mesh.core.rest.micronode.MicronodeResponse;
import com.gentics.mesh.core.rest.microschema.impl.MicroschemaCreateRequest;
import com.gentics.mesh.core.rest.microschema.impl.MicroschemaResponse;
import com.gentics.mesh.core.rest.microschema.impl.MicroschemaUpdateRequest;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.list.impl.MicronodeFieldListImpl;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.FieldSchemaContainer;
import com.gentics.mesh.core.rest.schema.ListFieldSchema;
import com.gentics.mesh.core.rest.schema.MicroschemaListResponse;
import com.gentics.mesh.core.rest.schema.MicroschemaReference;
import com.gentics.mesh.core.rest.schema.SchemaReference;
import com.gentics.mesh.core.rest.schema.impl.MicroschemaReferenceImpl;
import com.gentics.mesh.core.rest.schema.impl.SchemaCreateRequest;
import com.gentics.mesh.core.rest.schema.impl.SchemaReferenceImpl;
import com.gentics.mesh.core.rest.schema.impl.SchemaResponse;
import com.gentics.mesh.json.JsonUtil;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.RolePermissionParametersImpl;
import com.gentics.mesh.parameter.impl.VersioningParametersImpl;
import com.gentics.mesh.search.TrackingSearchProvider;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.test.definition.BasicRestTestcases;
import com.gentics.mesh.test.util.MeshAssert;
import com.gentics.mesh.util.UUIDUtil;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.reactivex.Observable;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.TRACKING, testSize=TestSize.FULL, startServer=true)
public class MicroschemaEndpointTest
extends AbstractMeshTest
implements BasicRestTestcases {
    @Override
    @Ignore(value="Not yet implemented")
    @Test
    public void testUpdateMultithreaded() throws Exception {
        Assert.fail((String)"Not yet implemented");
    }

    @Override
    @Test
    public void testReadByUuidMultithreaded() throws Exception {
        int nJobs = 10;
        try (Tx tx = this.tx();){
            HibMicroschema vcardContainer = this.microschemaContainers().get("vcard");
            Assert.assertNotNull((Object)vcardContainer);
            String uuid = vcardContainer.getUuid();
            Observable.range((int)0, (int)nJobs).flatMapCompletable(i -> this.client().findMicroschemaByUuid(uuid, new ParameterProvider[0]).toCompletable()).blockingAwait();
        }
    }

    @Override
    @Ignore(value="Not yet implemented")
    @Test
    public void testDeleteByUUIDMultithreaded() throws Exception {
        Assert.fail((String)"Not yet implemented");
    }

    @Override
    @Test
    public void testCreateMultithreaded() throws Exception {
        int nJobs = 5;
        Observable.range((int)0, (int)nJobs).flatMapCompletable(i -> {
            MicroschemaCreateRequest request = new MicroschemaCreateRequest();
            request.setName("new_microschema_name" + i);
            return this.client().createMicroschema(request).toCompletable();
        }).blockingAwait();
    }

    @Override
    @Test
    public void testReadByUuidMultithreadedNonBlocking() throws Exception {
        int nJobs = 200;
        try (Tx tx = this.tx();){
            HibMicroschema vcardContainer = this.microschemaContainers().get("vcard");
            Assert.assertNotNull((Object)vcardContainer);
            String uuid = vcardContainer.getUuid();
            Observable.range((int)0, (int)nJobs).flatMapCompletable(i -> this.client().findMicroschemaByUuid(uuid, new ParameterProvider[0]).toCompletable()).blockingAwait();
        }
    }

    @Override
    @Test
    public void testCreate() throws Exception {
        MicroschemaCreateRequest request = new MicroschemaCreateRequest();
        request.setName("new_microschema_name");
        request.setDescription("microschema description");
        this.expect(MeshEvent.MICROSCHEMA_CREATED).match(1, MeshElementEventModelImpl.class, event -> ((MeshElementEventModelAssert)MeshAssertions.assertThat((MeshElementEventModel)event).hasName("new_microschema_name")).uuidNotNull()).one();
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).recordedStoreEvents(0);
        MicroschemaResponse microschemaResponse = (MicroschemaResponse)ClientHelper.call(() -> this.client().createMicroschema(request));
        this.awaitEvents();
        this.waitForSearchIdleEvent();
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).recordedStoreEvents(1);
        MeshAssertions.assertThat((PermissionInfo)microschemaResponse.getPermissions()).hasPerm(new Permission[]{Permission.READ, Permission.CREATE, Permission.DELETE, Permission.UPDATE});
        MeshAssertions.assertThat((FieldSchemaContainer)microschemaResponse).isEqualToComparingOnlyGivenFields((Object)request, new String[]{"name", "description"});
    }

    @Test
    public void testCreateWithConflictingName() {
        String name = "new_microschema_name";
        MicroschemaCreateRequest request = new MicroschemaCreateRequest();
        request.getFields().add(FieldUtil.createStringFieldSchema((String)"name").setRequired(true));
        request.setName(name);
        MicroschemaResponse microschemaResponse = (MicroschemaResponse)ClientHelper.call(() -> this.client().createMicroschema(request));
        Assert.assertEquals((String)"The microschema with the given name should haven been created.", (Object)microschemaResponse.getName(), (Object)name);
        ClientHelper.call(() -> this.client().createMicroschema(request), (HttpResponseStatus)HttpResponseStatus.CONFLICT, (String)"microschema_conflicting_name", (String[])new String[]{name});
    }

    @Override
    @Test
    public void testCreateWithNoPerm() throws Exception {
        MicroschemaCreateRequest request = new MicroschemaCreateRequest();
        request.setName("new_microschema_name");
        request.setDescription("microschema description");
        String microschemaRootUuid = (String)this.tx(() -> Tx.get().data().permissionRoots().microschema().getUuid());
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            roleDao.revokePermissions(this.role(), tx.data().permissionRoots().microschema(), new InternalPermission[]{InternalPermission.CREATE_PERM});
            tx.success();
        }
        ClientHelper.call(() -> this.client().createMicroschema(request), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{microschemaRootUuid, InternalPermission.CREATE_PERM.getRestPerm().getName()});
    }

    @Override
    @Test
    public void testCreateWithUuid() throws Exception {
        MicroschemaCreateRequest microschema = FieldUtil.createMinimalValidMicroschemaCreateRequest();
        String uuid = UUIDUtil.randomUUID();
        MicroschemaResponse resp = (MicroschemaResponse)ClientHelper.call(() -> this.client().createMicroschema(uuid, microschema));
        Assert.assertEquals((String)"The created microschema did not contain the expected uuid.", (Object)uuid, (Object)resp.getUuid());
    }

    @Override
    @Test
    @Ignore(value="Not valid over dup UUIDs being allowed globally")
    public void testCreateWithDuplicateUuid() throws Exception {
    }

    @Override
    @Test
    @Ignore(value="Not yet implemented")
    public void testCreateReadDelete() throws Exception {
        Assert.fail((String)"Not yet implemented");
    }

    @Override
    @Test
    public void testReadByUUID() throws Exception {
        try (Tx tx = this.tx();){
            HibMicroschema vcardContainer = this.microschemaContainer("vcard");
            Assert.assertNotNull((Object)vcardContainer);
            MicroschemaResponse microschemaResponse = (MicroschemaResponse)ClientHelper.call(() -> this.client().findMicroschemaByUuid(vcardContainer.getUuid(), new ParameterProvider[0]));
            MeshAssertions.assertThat((FieldSchemaContainer)microschemaResponse).isEqualToComparingOnlyGivenFields((Object)vcardContainer.getLatestVersion().getSchema(), new String[]{"name", "description"});
        }
    }

    @Test
    public void testReadVersion() {
        String uuid = (String)this.tx(() -> this.microschemaContainer("vcard").getUuid());
        String latestVersion = (String)this.tx(() -> this.microschemaContainer("vcard").getLatestVersion().getVersion());
        String json = (String)this.tx(() -> this.microschemaContainer("vcard").getLatestVersion().getJson());
        MicroschemaResponse restSchema = (MicroschemaResponse)ClientHelper.call(() -> this.client().findMicroschemaByUuid(uuid, new ParameterProvider[]{new VersioningParametersImpl().setVersion(latestVersion)}));
        Assert.assertEquals((String)"The loaded version did not match up with the requested version.", (Object)latestVersion, (Object)restSchema.getVersion());
        MicroschemaUpdateRequest request = (MicroschemaUpdateRequest)JsonUtil.readValue((String)json, MicroschemaUpdateRequest.class);
        request.setDescription("New description");
        request.addField((FieldSchema)FieldUtil.createHtmlFieldSchema((String)"someHtml"));
        ClientHelper.call(() -> this.client().updateMicroschema(uuid, request, new ParameterProvider[0]));
        restSchema = (MicroschemaResponse)ClientHelper.call(() -> this.client().findMicroschemaByUuid(uuid, new ParameterProvider[]{new VersioningParametersImpl().setVersion(latestVersion)}));
        Assert.assertEquals((String)"The loaded version did not match up with the requested version.", (Object)latestVersion, (Object)restSchema.getVersion());
        restSchema = (MicroschemaResponse)ClientHelper.call(() -> this.client().findMicroschemaByUuid(uuid, new ParameterProvider[0]));
        Assert.assertEquals((String)"The loaded version did not match up with the requested version.", (Object)"2.0", (Object)restSchema.getVersion());
        restSchema = (MicroschemaResponse)ClientHelper.call(() -> this.client().findMicroschemaByUuid(uuid, new ParameterProvider[]{new VersioningParametersImpl().setVersion("2.0")}));
        Assert.assertEquals((String)"The loaded version did not match up with the requested version.", (Object)"2.0", (Object)restSchema.getVersion());
    }

    @Test
    public void testReadBogusVersion() {
        String uuid = (String)this.tx(() -> this.microschemaContainer("vcard").getUuid());
        ClientHelper.call(() -> this.client().findMicroschemaByUuid(uuid, new ParameterProvider[]{new VersioningParametersImpl().setVersion("5.0")}), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"object_not_found_for_uuid_version", (String[])new String[]{uuid, "5.0"});
        ClientHelper.call(() -> this.client().findMicroschemaByUuid(uuid, new ParameterProvider[]{new VersioningParametersImpl().setVersion("sadgsdgasgd")}), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"error_illegal_version", (String[])new String[]{"sadgsdgasgd"});
    }

    @Override
    @Test
    public void testReadByUuidWithRolePerms() {
        try (Tx tx = this.tx();){
            HibMicroschema vcardContainer = this.microschemaContainers().get("vcard");
            Assert.assertNotNull((Object)vcardContainer);
            String uuid = vcardContainer.getUuid();
            MicroschemaResponse microschema = (MicroschemaResponse)ClientHelper.call(() -> this.client().findMicroschemaByUuid(uuid, new ParameterProvider[]{new RolePermissionParametersImpl().setRoleUuid(this.role().getUuid())}));
            Assert.assertNotNull((Object)microschema.getRolePerms());
            MeshAssertions.assertThat((PermissionInfo)microschema.getRolePerms()).hasPerm(Permission.basicPermissions());
        }
    }

    @Override
    @Test
    public void testReadByUUIDWithMissingPermission() throws Exception {
        String uuid;
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            HibMicroschema vcardContainer = this.microschemaContainers().get("vcard");
            uuid = vcardContainer.getUuid();
            roleDao.grantPermissions(this.role(), (HibBaseElement)vcardContainer, new InternalPermission[]{InternalPermission.DELETE_PERM});
            roleDao.grantPermissions(this.role(), (HibBaseElement)vcardContainer, new InternalPermission[]{InternalPermission.UPDATE_PERM});
            roleDao.grantPermissions(this.role(), (HibBaseElement)vcardContainer, new InternalPermission[]{InternalPermission.CREATE_PERM});
            roleDao.revokePermissions(this.role(), (HibBaseElement)vcardContainer, new InternalPermission[]{InternalPermission.READ_PERM});
            tx.success();
        }
        ClientHelper.call(() -> this.client().findMicroschemaByUuid(uuid, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{uuid, InternalPermission.READ_PERM.getRestPerm().getName()});
    }

    @Override
    @Test
    @Ignore(value="Not yet implemented")
    public void testReadMultiple() throws Exception {
        Assert.fail((String)"Not yet implemented");
    }

    @Override
    @Test
    @Ignore(value="Handled via microschema changes verticle test")
    public void testUpdate() throws Exception {
    }

    @Override
    @Test
    public void testUpdateByUUIDWithoutPerm() throws Exception {
        String uuid;
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            HibMicroschema microschema = this.microschemaContainers().get("vcard");
            uuid = microschema.getUuid();
            roleDao.revokePermissions(this.role(), (HibBaseElement)microschema, new InternalPermission[]{InternalPermission.UPDATE_PERM});
            tx.success();
        }
        MicroschemaUpdateRequest request = new MicroschemaUpdateRequest();
        request.setName("new-name");
        ClientHelper.call(() -> this.client().updateMicroschema(uuid, request, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{uuid, InternalPermission.UPDATE_PERM.getRestPerm().getName()});
    }

    @Override
    @Test
    public void testUpdateWithBogusUuid() throws GenericRestException, Exception {
        try (Tx tx = this.tx();){
            HibMicroschema microschema = this.microschemaContainers().get("vcard");
            String oldName = microschema.getName();
            MicroschemaUpdateRequest request = new MicroschemaUpdateRequest();
            request.setName("new-name");
            ClientHelper.call(() -> this.client().updateMicroschema("bogus", request, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"object_not_found_for_uuid", (String[])new String[]{"bogus"});
            HibMicroschema reloaded = (HibMicroschema)tx.microschemaDao().findByUuid(microschema.getUuid());
            Assert.assertEquals((String)"The name should not have been changed.", (Object)oldName, (Object)reloaded.getName());
        }
    }

    @Override
    @Test
    public void testDeleteByUUID() throws Exception {
        String uuid = (String)this.tx(() -> this.microschemaContainer("vcard").getUuid());
        this.expect(MeshEvent.MICROSCHEMA_DELETED).match(1, MeshElementEventModelImpl.class, event -> ((MeshElementEventModelAssert)MeshAssertions.assertThat((MeshElementEventModel)event).hasName("vcard")).hasUuid(uuid)).one();
        ClientHelper.call(() -> this.client().deleteMicroschema(uuid));
        this.awaitEvents();
        try (Tx tx = this.tx();){
            HibMicroschema reloaded = (HibMicroschema)tx.microschemaDao().findByUuid(uuid);
            Assert.assertNull((String)"The microschema should have been deleted.", (Object)reloaded);
        }
    }

    @Test
    public void testDeleteWithChanges() {
        String json = (String)this.tx(() -> this.microschemaContainers().get("vcard").getLatestVersion().getJson());
        String uuid = (String)this.tx(() -> this.microschemaContainers().get("vcard").getUuid());
        MicroschemaUpdateRequest request = (MicroschemaUpdateRequest)JsonUtil.readValue((String)json, MicroschemaUpdateRequest.class);
        request.setDescription("Updated microschema for a vcard");
        ClientHelper.call(() -> this.client().updateMicroschema(uuid, request, new ParameterProvider[0]));
        ClientHelper.call(() -> this.client().deleteMicroschema(uuid));
    }

    @Test
    public void testDeleteByUUIDWhileInUse1() throws Exception {
        String baseUuid = (String)this.tx(() -> this.project().getBaseNode().getUuid());
        SchemaCreateRequest schema = FieldUtil.createMinimalValidSchemaCreateRequest();
        schema.addField((FieldSchema)FieldUtil.createMicronodeFieldSchema((String)"vcardtest").setAllowedMicroSchemas(new String[]{"vcard"}));
        SchemaResponse response = (SchemaResponse)ClientHelper.call(() -> this.client().createSchema(schema, new ParameterProvider[0]));
        ClientHelper.call(() -> this.client().assignSchemaToProject("dummy", response.getUuid()));
        NodeResponse nodeResponse1 = this.createNodeWithMicronode(baseUuid);
        NodeResponse nodeResponse2 = this.createNodeWithMicronode(baseUuid);
        this.assertDelete(nodeResponse1.getUuid(), nodeResponse2.getUuid());
    }

    private NodeResponse createNodeWithMicronode(String baseUuid) {
        NodeCreateRequest nodeCreateRequest = new NodeCreateRequest();
        nodeCreateRequest.setLanguage("en");
        MicronodeResponse micronodeField = new MicronodeResponse();
        micronodeField.getFields().put("firstName", (Field)FieldUtil.createStringField((String)"firstnameValue"));
        micronodeField.getFields().put("lastName", (Field)FieldUtil.createStringField((String)"lastnameValue"));
        micronodeField.setMicroschema((MicroschemaReference)new MicroschemaReferenceImpl().setName("vcard"));
        nodeCreateRequest.getFields().put("vcardtest", (Field)micronodeField);
        nodeCreateRequest.setSchema((SchemaReference)new SchemaReferenceImpl().setName("test"));
        nodeCreateRequest.setParentNodeUuid(baseUuid);
        return (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", nodeCreateRequest, new ParameterProvider[0]));
    }

    @Test
    public void testDeleteByUUIDWhileInUse2() throws Exception {
        String baseUuid = (String)this.tx(() -> this.project().getBaseNode().getUuid());
        SchemaCreateRequest schema = FieldUtil.createMinimalValidSchemaCreateRequest();
        ListFieldSchema fieldSchema = FieldUtil.createListFieldSchema((String)"vcardslist", (String)"micronode").setAllowedSchemas(new String[]{"vcard"});
        schema.addField((FieldSchema)fieldSchema);
        SchemaResponse response = (SchemaResponse)ClientHelper.call(() -> this.client().createSchema(schema, new ParameterProvider[0]));
        ClientHelper.call(() -> this.client().assignSchemaToProject("dummy", response.getUuid()));
        NodeResponse nodeResponse1 = this.createNodeWithMicronodeList(baseUuid);
        NodeResponse nodeResponse2 = this.createNodeWithMicronodeList(baseUuid);
        this.assertDelete(nodeResponse1.getUuid(), nodeResponse2.getUuid());
    }

    private NodeResponse createNodeWithMicronodeList(String baseUuid) {
        NodeCreateRequest nodeCreateRequest = new NodeCreateRequest();
        nodeCreateRequest.setLanguage("en");
        MicronodeFieldListImpl micronodeListField = new MicronodeFieldListImpl();
        for (int i = 0; i < 3; ++i) {
            MicronodeResponse micronodeField = new MicronodeResponse();
            micronodeField.getFields().put("firstName", (Field)FieldUtil.createStringField((String)("firstnameValue" + i)));
            micronodeField.getFields().put("lastName", (Field)FieldUtil.createStringField((String)("lastnameValue" + i)));
            micronodeField.setMicroschema((MicroschemaReference)new MicroschemaReferenceImpl().setName("vcard"));
            micronodeListField.add((Object)micronodeField);
        }
        nodeCreateRequest.getFields().put("vcardslist", (Field)micronodeListField);
        nodeCreateRequest.setSchema((SchemaReference)new SchemaReferenceImpl().setName("test"));
        nodeCreateRequest.setParentNodeUuid(baseUuid);
        return (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", nodeCreateRequest, new ParameterProvider[0]));
    }

    private void assertDelete(String node1Uuid, String node2Uuid) {
        String microschemaContainerUuid = (String)this.tx(() -> this.microschemaContainers().get("vcard").getUuid());
        ClientHelper.call(() -> this.client().deleteMicroschema(microschemaContainerUuid), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"microschema_delete_still_in_use", (String[])new String[]{microschemaContainerUuid});
        try (Tx tx = this.tx();){
            HibMicroschema reloaded = (HibMicroschema)tx.microschemaDao().findByUuid(microschemaContainerUuid);
            Assert.assertNotNull((String)"The microschema should not have been deleted.", (Object)reloaded);
        }
        ClientHelper.call(() -> this.client().deleteNode("dummy", node1Uuid, new ParameterProvider[0]));
        ClientHelper.call(() -> this.client().deleteMicroschema(microschemaContainerUuid), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"microschema_delete_still_in_use", (String[])new String[]{microschemaContainerUuid});
        ClientHelper.call(() -> this.client().deleteNode("dummy", node2Uuid, new ParameterProvider[0]));
        ClientHelper.call(() -> this.client().deleteMicroschema(microschemaContainerUuid));
        tx = this.tx();
        try {
            HibMicroschema searched = (HibMicroschema)tx.microschemaDao().findByUuid(microschemaContainerUuid);
            Assert.assertNull((String)"The microschema should have been deleted.", (Object)searched);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Override
    @Test
    public void testDeleteByUUIDWithNoPermission() throws Exception {
        HibMicroschema microschema;
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            microschema = this.microschemaContainers().get("vcard");
            Assert.assertNotNull((Object)microschema);
            roleDao.revokePermissions(this.role(), (HibBaseElement)microschema, new InternalPermission[]{InternalPermission.DELETE_PERM});
            tx.success();
        }
        tx = this.tx();
        try {
            ClientHelper.call(() -> this.client().deleteMicroschema(microschema.getUuid()), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{microschema.getUuid(), InternalPermission.DELETE_PERM.getRestPerm().getName()});
            MeshAssert.assertElement((DaoGlobal)tx.microschemaDao(), (String)microschema.getUuid(), (boolean)true);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Override
    @Test
    public void testPermissionResponse() {
        MicroschemaResponse microschema = (MicroschemaResponse)((MicroschemaListResponse)this.client().findMicroschemas(new ParameterProvider[0]).blockingGet()).getData().get(0);
        MeshAssertions.assertThat((PermissionInfo)microschema.getPermissions()).hasNoPublishPermsSet();
    }

    @Test
    public void testConflictingNameWithSchema() throws InterruptedException {
        MicroschemaCreateRequest microSchemaRequest = new MicroschemaCreateRequest().setName("test");
        SchemaCreateRequest schemaRequest = new SchemaCreateRequest().setName("test");
        this.client().createSchema(schemaRequest, new ParameterProvider[0]).blockingAwait();
        ClientHelper.call(() -> this.client().createMicroschema(microSchemaRequest), (HttpResponseStatus)HttpResponseStatus.CONFLICT, (String)"schema_conflicting_name", (String[])new String[]{"test"});
    }
}

