/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.schema;

import com.gentics.mesh.core.rest.micronode.MicronodeResponse;
import com.gentics.mesh.core.rest.microschema.impl.MicroschemaCreateRequest;
import com.gentics.mesh.core.rest.microschema.impl.MicroschemaResponse;
import com.gentics.mesh.core.rest.microschema.impl.MicroschemaUpdateRequest;
import com.gentics.mesh.core.rest.node.FieldMap;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.NodeUpdateRequest;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.MicronodeField;
import com.gentics.mesh.core.rest.node.field.StringField;
import com.gentics.mesh.core.rest.node.field.impl.StringFieldImpl;
import com.gentics.mesh.core.rest.node.field.list.MicronodeFieldList;
import com.gentics.mesh.core.rest.node.field.list.impl.MicronodeFieldListImpl;
import com.gentics.mesh.core.rest.schema.MicroschemaReference;
import com.gentics.mesh.core.rest.schema.impl.ListFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.MicronodeFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.MicroschemaReferenceImpl;
import com.gentics.mesh.core.rest.schema.impl.SchemaCreateRequest;
import com.gentics.mesh.core.rest.schema.impl.SchemaResponse;
import com.gentics.mesh.core.rest.schema.impl.StringFieldSchemaImpl;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.client.VersioningParametersImpl;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.TRACKING, testSize=TestSize.FULL, startServer=true)
public class MicroschemaMigrationTest
extends AbstractMeshTest {
    private MicroschemaResponse phoneMicroschema;

    @Before
    public void setUp() throws Exception {
    }

    @Test
    public void migrateNewNode() {
        this.grantAdmin();
        this.createTestSchema();
        this.createMicroschemas();
        NodeResponse testNode = this.createTestNode();
        this.publishNode(testNode);
        this.assertVersions(testNode, "PD(1.0)=>I(0.1)");
        this.updateMicroschema();
        this.assertVersions(testNode, "PD(2.0)=>I(0.1)");
    }

    @Test
    public void migrateUpdatedNode() {
        this.grantAdmin();
        this.createTestSchema();
        this.createMicroschemas();
        NodeResponse testNode = this.createTestNode();
        this.publishNode(testNode);
        this.assertVersions(testNode, "PD(1.0)=>I(0.1)");
        testNode = this.addLocation(testNode, this.location("aut", "salzburg"));
        this.assertVersions(testNode, "PD(2.0)=>I(0.1)");
        testNode = this.addLocation(testNode, this.location("aut", "innsbruck"));
        this.assertVersions(testNode, "PD(3.0)=>I(0.1)");
        testNode = this.addLocation(testNode, this.location("aut", "klagenfurt"));
        this.assertVersions(testNode, "PD(4.0)=>I(0.1)");
        this.updateMicroschema();
        this.assertVersions(testNode, "PD(5.0)=>I(0.1)");
    }

    @Test
    public void migrateNewNodeNoPurge() {
        this.grantAdmin();
        this.createTestSchema(false);
        this.createMicroschemas();
        NodeResponse testNode = this.createTestNode();
        this.publishNode(testNode);
        this.assertVersions(testNode, "PD(1.0)=>I(0.1)");
        this.updateMicroschema();
        this.assertVersions(testNode, "PD(2.0)=>(1.0)=>I(0.1)");
    }

    @Test
    public void migrateUpdatedNodeNoPurge() {
        this.grantAdmin();
        this.createTestSchema(false);
        this.createMicroschemas();
        NodeResponse testNode = this.createTestNode();
        this.publishNode(testNode);
        this.assertVersions(testNode, "PD(1.0)=>I(0.1)");
        testNode = this.addLocation(testNode, this.location("aut", "salzburg"));
        this.assertVersions(testNode, "PD(2.0)=>(1.1)=>(1.0)=>I(0.1)");
        testNode = this.addLocation(testNode, this.location("aut", "innsbruck"));
        this.assertVersions(testNode, "PD(3.0)=>(2.1)=>(2.0)=>(1.1)=>(1.0)=>I(0.1)");
        testNode = this.addLocation(testNode, this.location("aut", "klagenfurt"));
        this.assertVersions(testNode, "PD(4.0)=>(3.1)=>(3.0)=>(2.1)=>(2.0)=>(1.1)=>(1.0)=>I(0.1)");
        this.updateMicroschema();
        this.assertVersions(testNode, "PD(5.0)=>(4.0)=>(3.1)=>(3.0)=>(2.1)=>(2.0)=>(1.1)=>(1.0)=>I(0.1)");
    }

    @Test
    public void migrateModifiedNode() {
        this.grantAdmin();
        this.createTestSchema(false);
        this.createMicroschemas();
        NodeResponse testNode = this.createTestNode();
        testNode = this.addLocation(testNode, this.location("aut", "eisenstadt"), true);
        this.assertVersions(testNode, "PD(1.0)=>(0.2)=>I(0.1)");
        testNode = this.addLocation(testNode, this.location("aut", "bregenz"), false);
        this.assertVersions(testNode, "D(1.1)=>P(1.0)=>(0.2)=>I(0.1)");
        this.updateMicroschema();
        this.assertVersions(testNode, "D(2.1)=>P(2.0)=>(1.1)=>(1.0)=>(0.2)=>I(0.1)");
        this.assertLocations(testNode, "0.1", this.location("aut", "vienna"), this.location("aut", "graz"), this.location("aut", "linz"));
        this.assertLocations(testNode, "0.2", this.location("aut", "vienna"), this.location("aut", "graz"), this.location("aut", "linz"), this.location("aut", "eisenstadt"));
        this.assertLocations(testNode, "1.0", this.location("aut", "vienna"), this.location("aut", "graz"), this.location("aut", "linz"), this.location("aut", "eisenstadt"));
        this.assertLocations(testNode, "1.1", this.location("aut", "vienna"), this.location("aut", "graz"), this.location("aut", "linz"), this.location("aut", "eisenstadt"), this.location("aut", "bregenz"));
        this.assertLocations(testNode, "2.0", this.location("aut", "vienna"), this.location("aut", "graz"), this.location("aut", "linz"), this.location("aut", "eisenstadt"));
        this.assertLocations(testNode, "2.1", this.location("aut", "vienna"), this.location("aut", "graz"), this.location("aut", "linz"), this.location("aut", "eisenstadt"), this.location("aut", "bregenz"));
    }

    public void updateMicroschema() {
        MicroschemaUpdateRequest updateSchemaRequest = this.addRandomField(this.phoneMicroschema);
        this.waitForLatestJob(() -> this.client().updateMicroschema(this.phoneMicroschema.getUuid(), updateSchemaRequest, new ParameterProvider[0]).blockingAwait());
    }

    private NodeResponse createTestNode() {
        return (NodeResponse)this.client().createNode("dummy", new NodeCreateRequest().setSchemaName("testSchema").setParentNodeUuid(this.getProject().getRootNode().getUuid()).setLanguage("en").setFields(FieldMap.of((String)"name", (Field)StringField.of((String)"testNode"), (String)"phone", (Field)this.phoneNumber("+43", "1234567"), (String)"locations", (Field)new MicronodeFieldListImpl().setItems(Arrays.asList(this.location("aut", "vienna"), this.location("aut", "graz"), this.location("aut", "linz"))))), new ParameterProvider[0]).blockingGet();
    }

    private NodeResponse addLocation(NodeResponse node, MicronodeResponse location) {
        return this.addLocation(node, location, true);
    }

    private NodeResponse addLocation(NodeResponse node, MicronodeResponse location, boolean publish) {
        NodeUpdateRequest updateRequest = node.toRequest();
        MicronodeFieldList locations = updateRequest.getFields().getMicronodeFieldList("locations");
        locations.getItems().add(location);
        updateRequest.getFields().put("locations", (Field)locations);
        NodeResponse nodeResponse = (NodeResponse)this.client().updateNode("dummy", node.getUuid(), updateRequest, new ParameterProvider[0]).blockingGet();
        if (publish) {
            this.publishNode(nodeResponse);
        }
        return (NodeResponse)this.client().findNodeByUuid("dummy", nodeResponse.getUuid(), new ParameterProvider[0]).blockingGet();
    }

    private void assertLocations(NodeResponse node, String version, MicronodeResponse ... expected) {
        NodeResponse nodeResponse = (NodeResponse)this.client().findNodeByUuid("dummy", node.getUuid(), new ParameterProvider[]{new VersioningParametersImpl().setVersion(version)}).blockingGet();
        ((AbstractObjectAssert)Assertions.assertThat((Object)nodeResponse.getFields().getMicronodeFieldList("locations")).as("Locations of version " + version, new Object[0])).isNotNull();
        Assertions.assertThat((List)nodeResponse.getFields().getMicronodeFieldList("locations").getItems()).as("Locations of version " + version, new Object[0]).usingElementComparator(this::compareLocations).containsOnly((Object[])expected);
    }

    private int compareLocations(MicronodeField a, MicronodeField b) {
        int cmp = this.getValue(a.getFields(), "country").compareTo(this.getValue(b.getFields(), "country"));
        if (cmp != 0) {
            return cmp;
        }
        return this.getValue(a.getFields(), "city").compareTo(this.getValue(b.getFields(), "city"));
    }

    private String getValue(FieldMap map, String key) {
        StringFieldImpl field = map.getStringField(key);
        return field != null ? field.toString() : null;
    }

    private MicronodeResponse phoneNumber(String countryCode, String number) {
        MicronodeResponse micronodeResponse = new MicronodeResponse();
        micronodeResponse.setMicroschema((MicroschemaReference)new MicroschemaReferenceImpl().setName("phonenumber"));
        FieldMap fields = micronodeResponse.getFields();
        fields.put("countrycode", (Field)StringField.of((String)countryCode));
        fields.put("number", (Field)StringField.of((String)number));
        return micronodeResponse;
    }

    private MicronodeResponse location(String country, String city) {
        MicronodeResponse micronodeResponse = new MicronodeResponse();
        micronodeResponse.setMicroschema((MicroschemaReference)new MicroschemaReferenceImpl().setName("location"));
        FieldMap fields = micronodeResponse.getFields();
        fields.put("country", (Field)StringField.of((String)country));
        fields.put("city", (Field)StringField.of((String)city));
        return micronodeResponse;
    }

    private void createTestSchema() {
        this.createTestSchema(true);
    }

    private void createTestSchema(boolean autoPurge) {
        SchemaCreateRequest createRequest = new SchemaCreateRequest();
        createRequest.setName("testSchema");
        createRequest.setAutoPurge(Boolean.valueOf(autoPurge));
        createRequest.setFields(Arrays.asList(new StringFieldSchemaImpl().setName("name"), new MicronodeFieldSchemaImpl().setName("phone"), new ListFieldSchemaImpl().setListType("micronode").setName("locations")));
        SchemaResponse schemaResponse = (SchemaResponse)this.client().createSchema(createRequest, new ParameterProvider[0]).blockingGet();
        this.client().assignSchemaToProject("dummy", schemaResponse.getUuid()).blockingAwait();
    }

    private void createMicroschemas() {
        this.phoneMicroschema = this.createAndAssign(new MicroschemaCreateRequest().setName("phonenumber").setFields(Arrays.asList(new StringFieldSchemaImpl().setName("countrycode"), new StringFieldSchemaImpl().setName("number"))));
        this.createAndAssign(new MicroschemaCreateRequest().setName("location").setFields(Arrays.asList(new StringFieldSchemaImpl().setName("country"), new StringFieldSchemaImpl().setName("city"))));
    }

    private MicroschemaResponse createAndAssign(MicroschemaCreateRequest microschemaCreateRequest) {
        MicroschemaResponse microschemaResponse = (MicroschemaResponse)this.client().createMicroschema(microschemaCreateRequest).blockingGet();
        this.client().assignMicroschemaToProject("dummy", microschemaResponse.getUuid()).blockingAwait();
        return microschemaResponse;
    }
}

