/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.schema;

import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.HibCoreElement;
import com.gentics.mesh.core.data.dao.MicroschemaDao;
import com.gentics.mesh.core.data.dao.RoleDao;
import com.gentics.mesh.core.data.perm.InternalPermission;
import com.gentics.mesh.core.data.project.HibProject;
import com.gentics.mesh.core.data.schema.HibMicroschema;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.MeshEvent;
import com.gentics.mesh.core.rest.event.project.ProjectMicroschemaEventModel;
import com.gentics.mesh.core.rest.microschema.impl.MicroschemaResponse;
import com.gentics.mesh.core.rest.project.ProjectCreateRequest;
import com.gentics.mesh.core.rest.project.ProjectReference;
import com.gentics.mesh.core.rest.project.ProjectResponse;
import com.gentics.mesh.core.rest.schema.MicroschemaListResponse;
import com.gentics.mesh.core.rest.schema.MicroschemaReference;
import com.gentics.mesh.core.rest.schema.SchemaReference;
import com.gentics.mesh.core.rest.schema.impl.SchemaReferenceImpl;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.netty.handler.codec.http.HttpResponseStatus;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class MicroschemaProjectEndpointTest
extends AbstractMeshTest {
    @Test
    public void testReadProjectMicroschemas() {
        try (Tx tx = this.tx();){
            MicroschemaListResponse list = (MicroschemaListResponse)ClientHelper.call(() -> this.client().findMicroschemas("dummy", new ParameterProvider[0]));
            Assert.assertEquals((long)2L, (long)list.getData().size());
            ClientHelper.call(() -> this.client().unassignMicroschemaFromProject("dummy", this.microschemaContainer("vcard").getUuid()));
            list = (MicroschemaListResponse)ClientHelper.call(() -> this.client().findMicroschemas("dummy", new ParameterProvider[0]));
            Assert.assertEquals((long)1L, (long)list.getData().size());
        }
    }

    @Test
    public void testAddMicroschemaToExtraProject() {
        String name = "test12345";
        String uuid = (String)this.tx(() -> this.microschemaContainer("vcard").getUuid());
        ProjectCreateRequest request = new ProjectCreateRequest();
        request.setSchema((SchemaReference)new SchemaReferenceImpl().setName("folder"));
        request.setName("test12345");
        ProjectResponse restProject = (ProjectResponse)ClientHelper.call(() -> this.client().createProject(request));
        this.expect(MeshEvent.PROJECT_MICROSCHEMA_ASSIGNED).match(1, ProjectMicroschemaEventModel.class, event -> {
            MicroschemaReference microschemaRef = event.getMicroschema();
            Assert.assertNotNull((Object)microschemaRef);
            Assert.assertEquals((Object)"vcard", (Object)microschemaRef.getName());
            Assert.assertEquals((Object)uuid, (Object)microschemaRef.getUuid());
            ProjectReference projectRef = event.getProject();
            Assert.assertNotNull((Object)projectRef);
            Assert.assertEquals((Object)restProject.getName(), (Object)projectRef.getName());
            Assert.assertEquals((Object)restProject.getUuid(), (Object)projectRef.getUuid());
        });
        ClientHelper.call(() -> this.client().assignMicroschemaToProject(restProject.getName(), uuid));
        this.awaitEvents();
    }

    @Test
    public void testAddMicroschemaToProjectWithPerm() throws Exception {
        HibProject extraProject;
        HibMicroschema microschema = this.microschemaContainer("vcard");
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            ProjectCreateRequest request = new ProjectCreateRequest();
            request.setSchema((SchemaReference)new SchemaReferenceImpl().setName("folder"));
            request.setName("extraProject");
            ProjectResponse created = (ProjectResponse)ClientHelper.call(() -> this.client().createProject(request));
            extraProject = (HibProject)tx.projectDao().findByUuid(created.getUuid());
            roleDao.grantPermissions(this.role(), (HibBaseElement)microschema, new InternalPermission[]{InternalPermission.READ_PERM});
            roleDao.grantPermissions(this.role(), (HibBaseElement)extraProject, new InternalPermission[]{InternalPermission.UPDATE_PERM});
            tx.success();
        }
        tx = this.tx();
        try {
            MicroschemaDao microschemaDao = tx.microschemaDao();
            MicroschemaResponse restMicroschema = (MicroschemaResponse)ClientHelper.call(() -> this.client().assignMicroschemaToProject(extraProject.getName(), microschema.getUuid()));
            Assertions.assertThat((String)restMicroschema.getUuid()).isEqualTo((Object)microschema.getUuid());
            Assert.assertNotNull((String)"The microschema should be added to the extra project", (Object)microschemaDao.findByUuid((HibCoreElement)extraProject, microschema.getUuid()));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testAddMicroschemaToProjectWithoutPerm() throws Exception {
        HibProject extraProject;
        String projectUuid;
        String microschemaUuid;
        HibMicroschema microschema;
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            microschema = this.microschemaContainer("vcard");
            microschemaUuid = microschema.getUuid();
            ProjectCreateRequest request = new ProjectCreateRequest();
            request.setName("extraProject");
            request.setSchema((SchemaReference)new SchemaReferenceImpl().setName("folder"));
            ProjectResponse response = (ProjectResponse)ClientHelper.call(() -> this.client().createProject(request));
            projectUuid = response.getUuid();
            extraProject = (HibProject)tx.projectDao().findByUuid(projectUuid);
            roleDao.revokePermissions(this.role(), (HibBaseElement)extraProject, new InternalPermission[]{InternalPermission.UPDATE_PERM});
            tx.success();
        }
        ClientHelper.call(() -> this.client().assignMicroschemaToProject("extraProject", microschemaUuid), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{projectUuid, InternalPermission.UPDATE_PERM.getRestPerm().getName()});
        tx = this.tx();
        try {
            MicroschemaDao microschemaDao = tx.microschemaDao();
            microschema = this.microschemaContainer("vcard");
            Assert.assertFalse((String)"The microschema should not have been added to the extra project but it was", (boolean)microschemaDao.contains((HibCoreElement)extraProject, (HibCoreElement)microschema));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testRemoveMicroschemaFromProjectWithPerm() throws Exception {
        HibProject project = this.project();
        HibMicroschema microschema = this.microschemaContainer("vcard");
        String microschemaUuid = (String)this.tx(() -> microschema.getUuid());
        String microschemaName = "vcard";
        try (Tx tx = this.tx();){
            Assert.assertTrue((String)"The microschema should be assigned to the project.", (boolean)tx.microschemaDao().contains((HibCoreElement)project, (HibCoreElement)microschema));
        }
        this.expect(MeshEvent.PROJECT_MICROSCHEMA_UNASSIGNED).match(1, ProjectMicroschemaEventModel.class, event -> {
            MicroschemaReference microschemaRef = event.getMicroschema();
            Assert.assertNotNull((Object)microschemaRef);
            Assert.assertEquals((Object)microschemaName, (Object)microschemaRef.getName());
            Assert.assertEquals((Object)microschemaUuid, (Object)microschemaRef.getUuid());
            ProjectReference projectRef = event.getProject();
            Assert.assertNotNull((Object)projectRef);
            Assert.assertEquals((Object)"dummy", (Object)projectRef.getName());
            Assert.assertEquals((Object)this.projectUuid(), (Object)projectRef.getUuid());
        });
        ClientHelper.call(() -> this.client().unassignMicroschemaFromProject("dummy", microschemaUuid));
        this.awaitEvents();
        MicroschemaListResponse list = (MicroschemaListResponse)ClientHelper.call(() -> this.client().findMicroschemas("dummy", new ParameterProvider[0]));
        try (Tx tx = this.tx();){
            Assert.assertEquals((String)"The removed microschema should not be listed in the response", (long)0L, (long)list.getData().stream().filter(s -> s.getUuid().equals(microschemaUuid)).count());
            Assert.assertFalse((String)"The microschema should no longer be assigned to the project.", (boolean)tx.microschemaDao().contains((HibCoreElement)this.project(), (HibCoreElement)microschema));
        }
    }

    @Test
    public void testRemoveMicroschemaFromProjectWithoutPerm() throws Exception {
        HibProject project = this.project();
        HibMicroschema microschema = this.microschemaContainer("vcard");
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            Assert.assertTrue((String)"The microschema should be assigned to the project.", (boolean)tx.microschemaDao().contains((HibCoreElement)project, (HibCoreElement)microschema));
            roleDao.revokePermissions(this.role(), (HibBaseElement)project, new InternalPermission[]{InternalPermission.UPDATE_PERM});
            tx.success();
        }
        tx = this.tx();
        try {
            ClientHelper.call(() -> this.client().unassignMicroschemaFromProject(project.getName(), microschema.getUuid()), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{project.getUuid(), InternalPermission.UPDATE_PERM.getRestPerm().getName()});
            Assert.assertTrue((String)"The microschema should still be listed for the project.", (boolean)tx.microschemaDao().contains((HibCoreElement)project, (HibCoreElement)microschema));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }
}

