/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.schema;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.assertj.impl.MicronodeAssert;
import com.gentics.mesh.assertj.impl.NodeAssert;
import com.gentics.mesh.assertj.impl.NodeGraphFieldContainerAssert;
import com.gentics.mesh.context.InternalActionContext;
import com.gentics.mesh.context.impl.InternalRoutingActionContextImpl;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.HibNodeFieldContainer;
import com.gentics.mesh.core.data.branch.HibBranch;
import com.gentics.mesh.core.data.branch.HibBranchSchemaVersion;
import com.gentics.mesh.core.data.dao.BranchDao;
import com.gentics.mesh.core.data.dao.ContentDao;
import com.gentics.mesh.core.data.dao.JobDao;
import com.gentics.mesh.core.data.dao.NodeDao;
import com.gentics.mesh.core.data.dao.PersistingBranchDao;
import com.gentics.mesh.core.data.dao.PersistingMicroschemaDao;
import com.gentics.mesh.core.data.dao.PersistingSchemaDao;
import com.gentics.mesh.core.data.dao.SchemaDao;
import com.gentics.mesh.core.data.node.HibMicronode;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.node.field.list.HibMicronodeFieldList;
import com.gentics.mesh.core.data.node.field.nesting.HibMicronodeField;
import com.gentics.mesh.core.data.schema.HibFieldSchemaVersionElement;
import com.gentics.mesh.core.data.schema.HibMicroschema;
import com.gentics.mesh.core.data.schema.HibMicroschemaVersion;
import com.gentics.mesh.core.data.schema.HibSchema;
import com.gentics.mesh.core.data.schema.HibSchemaChange;
import com.gentics.mesh.core.data.schema.HibSchemaVersion;
import com.gentics.mesh.core.data.schema.HibUpdateFieldChange;
import com.gentics.mesh.core.data.user.HibUser;
import com.gentics.mesh.core.db.CommonTx;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.common.ContainerType;
import com.gentics.mesh.core.rest.job.JobListResponse;
import com.gentics.mesh.core.rest.job.JobResponse;
import com.gentics.mesh.core.rest.job.JobStatus;
import com.gentics.mesh.core.rest.microschema.MicroschemaVersionModel;
import com.gentics.mesh.core.rest.microschema.impl.MicroschemaModelImpl;
import com.gentics.mesh.core.rest.microschema.impl.MicroschemaUpdateRequest;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.NodeUpdateRequest;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.MicronodeField;
import com.gentics.mesh.core.rest.node.field.impl.StringFieldImpl;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.ListFieldSchema;
import com.gentics.mesh.core.rest.schema.MicronodeFieldSchema;
import com.gentics.mesh.core.rest.schema.SchemaReference;
import com.gentics.mesh.core.rest.schema.SchemaVersionModel;
import com.gentics.mesh.core.rest.schema.StringFieldSchema;
import com.gentics.mesh.core.rest.schema.change.impl.SchemaChangeOperation;
import com.gentics.mesh.core.rest.schema.impl.ListFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.MicronodeFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.SchemaCreateRequest;
import com.gentics.mesh.core.rest.schema.impl.SchemaModelImpl;
import com.gentics.mesh.core.rest.schema.impl.SchemaReferenceImpl;
import com.gentics.mesh.core.rest.schema.impl.SchemaResponse;
import com.gentics.mesh.core.rest.schema.impl.SchemaUpdateRequest;
import com.gentics.mesh.etc.config.search.ComplianceMode;
import com.gentics.mesh.event.EventQueueBatch;
import com.gentics.mesh.json.JsonUtil;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.PublishParametersImpl;
import com.gentics.mesh.parameter.impl.VersioningParametersImpl;
import com.gentics.mesh.search.TrackingSearchProvider;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.test.util.TestUtils;
import com.gentics.mesh.util.IndexOptionHelper;
import com.gentics.mesh.util.Tuple;
import com.gentics.mesh.util.UUIDUtil;
import io.vertx.core.json.JsonObject;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.TRACKING, testSize=TestSize.FULL, startServer=true, clusterMode=false)
public class NodeMigrationEndpointTest
extends AbstractMeshTest {
    @Test
    public void testInitialAssignment() throws Exception {
        HibBranchSchemaVersion edge3;
        String versionCUuid;
        HibSchemaVersion versionC;
        PersistingSchemaDao schemaDao;
        HibBranchSchemaVersion assignment2;
        String versionBUuid;
        HibSchemaVersion versionB;
        HibBranchSchemaVersion assignment1;
        this.tx(tx -> tx.jobDao().clear());
        SchemaCreateRequest request = new SchemaCreateRequest();
        request.setName("dummy");
        request.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"text"));
        request.setSegmentField("text");
        request.setDisplayField("text");
        request.validate();
        SchemaResponse schemaResponse = (SchemaResponse)ClientHelper.call(() -> this.client().createSchema(request, new ParameterProvider[0]));
        String versionUuid = (String)this.tx(tx -> ((HibSchemaVersion)((HibSchema)tx.schemaDao().findByName("dummy")).getLatestVersion()).getUuid());
        ClientHelper.call(() -> this.client().assignSchemaToProject("dummy", schemaResponse.getUuid()));
        ClientHelper.call(() -> this.client().assignBranchSchemaVersions("dummy", this.initialBranchUuid(), new SchemaReference[]{schemaResponse.toReference()}));
        try (Tx tx2 = this.tx();){
            assignment1 = tx2.branchDao().findBranchSchemaEdge(this.initialBranch(), (HibSchemaVersion)((HibSchema)tx2.schemaDao().findByName("dummy")).getLatestVersion());
            Assert.assertEquals((Object)JobStatus.COMPLETED, (Object)assignment1.getMigrationStatus());
            Assert.assertNull((Object)assignment1.getJobUuid());
            Assert.assertTrue((String)"The assignment should be active.", (boolean)assignment1.isActive());
        }
        MeshAssertions.assertThat((JobListResponse)((JobListResponse)this.adminCall(() -> this.client().findJobs(new ParameterProvider[0])))).isEmpty();
        this.waitForSearchIdleEvent();
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasCreate(ContentDao.composeIndexName((String)this.projectUuid(), (String)this.initialBranchUuid(), (String)versionUuid, (ContainerType)ContainerType.DRAFT, null, null));
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasCreate(ContentDao.composeIndexName((String)this.projectUuid(), (String)this.initialBranchUuid(), (String)versionUuid, (ContainerType)ContainerType.PUBLISHED, null, null));
        this.mesh().jobWorkerVerticle().stop();
        SchemaUpdateRequest updateRequest = new SchemaUpdateRequest();
        updateRequest.setName("dummy");
        updateRequest.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"text"));
        updateRequest.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"text2"));
        updateRequest.setSegmentField("text");
        updateRequest.setDisplayField("text");
        updateRequest.validate();
        ClientHelper.call(() -> this.client().updateSchema(schemaResponse.getUuid(), updateRequest, new ParameterProvider[0]));
        this.waitForSearchIdleEvent();
        try (Tx tx3 = this.tx();){
            SchemaDao schemaDao2 = tx3.schemaDao();
            versionB = (HibSchemaVersion)((HibSchema)schemaDao2.findByName("dummy")).getLatestVersion();
            versionBUuid = versionB.getUuid();
            Assert.assertNotEquals((Object)versionUuid, (Object)versionBUuid);
            assignment2 = tx3.branchDao().findBranchSchemaEdge(this.initialBranch(), (HibSchemaVersion)((HibSchema)tx3.schemaDao().findByName("dummy")).getLatestVersion());
            Assert.assertNotNull((Object)assignment2.getJobUuid());
            Assert.assertEquals((String)"The migration should be queued", (Object)JobStatus.QUEUED, (Object)assignment2.getMigrationStatus());
            Assert.assertTrue((String)"The assignment should be active.", (boolean)assignment2.isActive());
            MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasCreate(ContentDao.composeIndexName((String)this.projectUuid(), (String)this.initialBranchUuid(), (String)versionBUuid, (ContainerType)ContainerType.DRAFT, null, null)).hasNoDropEvents();
            MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasCreate(ContentDao.composeIndexName((String)this.projectUuid(), (String)this.initialBranchUuid(), (String)versionBUuid, (ContainerType)ContainerType.PUBLISHED, null, null)).hasNoDropEvents();
            MeshAssertions.assertThat((JobListResponse)((JobListResponse)this.adminCall(() -> this.client().findJobs(new ParameterProvider[0])))).hasInfos(1);
        }
        this.mesh().jobWorkerVerticle().start();
        this.triggerAndWaitForAllJobs(JobStatus.COMPLETED);
        tx3 = this.tx();
        try {
            assignment1 = (HibBranchSchemaVersion)CommonTx.get().load(assignment1.getId(), assignment1.getClass());
            assignment2 = (HibBranchSchemaVersion)CommonTx.get().load(assignment2.getId(), assignment2.getClass());
            Assert.assertNotNull((Object)assignment2.getJobUuid());
            Assert.assertEquals((Object)JobStatus.COMPLETED, (Object)assignment2.getMigrationStatus());
            Assert.assertTrue((String)"The assignment should be active.", (boolean)assignment2.isActive());
            Assert.assertFalse((String)"The previous assignment should be inactive.", (boolean)assignment1.isActive());
        }
        finally {
            if (tx3 != null) {
                tx3.close();
            }
        }
        this.waitForSearchIdleEvent();
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasDrop(ContentDao.composeIndexPattern((String)this.projectUuid(), (String)this.initialBranchUuid(), (String)versionUuid));
        this.trackingSearchProvider().clear().blockingAwait();
        this.mesh().jobWorkerVerticle().stop();
        NodeCreateRequest nodeCreateRequest = new NodeCreateRequest();
        nodeCreateRequest.setLanguage("en");
        nodeCreateRequest.setSchemaName("dummy");
        nodeCreateRequest.setParentNodeUuid((String)this.tx(() -> this.folder("2015").getUuid()));
        nodeCreateRequest.getFields().put("text", (Field)new StringFieldImpl().setString("text_value"));
        nodeCreateRequest.getFields().put("text2", (Field)new StringFieldImpl().setString("text2_value"));
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", nodeCreateRequest, new ParameterProvider[0]));
        this.waitForSearchIdleEvent();
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasStore(ContentDao.composeIndexName((String)this.projectUuid(), (String)this.initialBranchUuid(), (String)versionBUuid, (ContainerType)ContainerType.DRAFT, null, null), response.getUuid() + "-en");
        updateRequest.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"text3"));
        ClientHelper.call(() -> this.client().updateSchema(schemaResponse.getUuid(), updateRequest, new ParameterProvider[0]));
        this.waitForSearchIdleEvent();
        try (Tx tx4 = this.tx();){
            schemaDao = ((CommonTx)tx4.unwrap()).schemaDao();
            versionC = (HibSchemaVersion)this.tx(() -> (HibSchemaVersion)((HibSchema)schemaDao.findByName("dummy")).getLatestVersion());
            versionCUuid = versionC.getUuid();
            Assert.assertTrue((String)"There should be editable containers (one draft) which should be linked to the version.", (boolean)schemaDao.findDraftFieldContainers(versionB, this.initialBranchUuid()).hasNext());
            Assert.assertNotEquals((String)"A new latest version should have been created.", (Object)versionBUuid, (Object)versionCUuid);
            edge3 = tx4.branchDao().findBranchSchemaEdge(this.initialBranch(), (HibSchemaVersion)((HibSchema)schemaDao.findByName("dummy")).getLatestVersion());
            Assert.assertNotNull((Object)edge3.getJobUuid());
            Assert.assertEquals((Object)JobStatus.QUEUED, (Object)edge3.getMigrationStatus());
            Assert.assertFalse((String)"The previous assignment should be inactive.", (boolean)assignment1.isActive());
            Assert.assertTrue((String)"The previous assignment should be active since it has not yet been migrated.", (boolean)assignment2.isActive());
            Assert.assertTrue((String)"The assignment should be active.", (boolean)edge3.isActive());
            MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasCreate(ContentDao.composeIndexName((String)this.projectUuid(), (String)this.initialBranchUuid(), (String)versionCUuid, (ContainerType)ContainerType.DRAFT, null, null)).hasNoDropEvents();
            MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasCreate(ContentDao.composeIndexName((String)this.projectUuid(), (String)this.initialBranchUuid(), (String)versionCUuid, (ContainerType)ContainerType.PUBLISHED, null, null)).hasNoDropEvents();
            MeshAssertions.assertThat((JobListResponse)((JobListResponse)this.adminCall(() -> this.client().findJobs(new ParameterProvider[0])))).hasInfos(2);
        }
        this.mesh().jobWorkerVerticle().start();
        this.triggerAndWaitForAllJobs(JobStatus.COMPLETED);
        this.waitForSearchIdleEvent();
        tx4 = this.tx();
        try {
            edge3 = (HibBranchSchemaVersion)CommonTx.get().load(edge3.getId(), edge3.getClass());
            schemaDao = ((CommonTx)tx4.unwrap()).schemaDao();
            Assert.assertNotNull((Object)edge3.getJobUuid());
            Assert.assertEquals((Object)JobStatus.COMPLETED, (Object)edge3.getMigrationStatus());
            Assert.assertFalse((String)"The previous assignment should be inactive.", (boolean)assignment1.isActive());
            Assert.assertFalse((String)"The previous assignment should be inactive since it has been been migrated.", (boolean)assignment1.isActive());
            Assert.assertTrue((String)"The assignment should be active.", (boolean)edge3.isActive());
            Assert.assertFalse((String)"There should no longer be an editable container (one draft) linked to the version since the migration should have updated the link.", (boolean)schemaDao.findDraftFieldContainers(versionB, this.initialBranchUuid()).hasNext());
            Assert.assertTrue((String)"There should now be versions linked to the new schema version instead.", (boolean)schemaDao.findDraftFieldContainers(versionC, this.initialBranchUuid()).hasNext());
        }
        finally {
            if (tx4 != null) {
                tx4.close();
            }
        }
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasDrop(ContentDao.composeIndexPattern((String)this.projectUuid(), (String)this.initialBranchUuid(), (String)versionBUuid));
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasDelete(ContentDao.composeIndexName((String)this.projectUuid(), (String)this.initialBranchUuid(), (String)versionBUuid, (ContainerType)ContainerType.DRAFT, null, null), response.getUuid() + "-en");
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasStore(ContentDao.composeIndexName((String)this.projectUuid(), (String)this.initialBranchUuid(), (String)versionCUuid, (ContainerType)ContainerType.DRAFT, null, null), response.getUuid() + "-en");
    }

    @Test
    public void testEmptyMigration() throws Throwable {
        SchemaCreateRequest request = new SchemaCreateRequest();
        request.setName("dummy");
        request.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"text"));
        request.setSegmentField("text");
        request.setDisplayField("text");
        request.validate();
        SchemaResponse schemaResponse = (SchemaResponse)ClientHelper.call(() -> this.client().createSchema(request, new ParameterProvider[0]));
        String versionUuid = (String)this.tx(tx -> ((HibSchemaVersion)((HibSchema)tx.schemaDao().findByName("dummy")).getLatestVersion()).getUuid());
        ClientHelper.call(() -> this.client().assignSchemaToProject("dummy", schemaResponse.getUuid()));
        ClientHelper.call(() -> this.client().assignBranchSchemaVersions("dummy", this.initialBranchUuid(), new SchemaReference[]{schemaResponse.toReference()}));
        try (Tx tx2 = this.tx();){
            JobDao jobDao = tx2.jobDao();
            Assert.assertEquals((long)0L, (long)TestUtils.toList((Iterable)jobDao.findAll()).size());
        }
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasCreate(ContentDao.composeIndexName((String)this.projectUuid(), (String)this.initialBranchUuid(), (String)versionUuid, (ContainerType)ContainerType.DRAFT, null, null));
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasCreate(ContentDao.composeIndexName((String)this.projectUuid(), (String)this.initialBranchUuid(), (String)versionUuid, (ContainerType)ContainerType.PUBLISHED, null, null));
    }

    @Test
    public void testMigrateByESFieldNull() {
        this.assertFieldEsSettingUpdateForValue(null);
    }

    @Test
    public void testMigrateByESFieldEmpty() {
        this.assertFieldEsSettingUpdateForValue(new JsonObject());
    }

    private void assertFieldEsSettingUpdateForValue(JsonObject value) {
        String schemaUuid = (String)this.tx(() -> this.schemaContainer("content").getUuid());
        SchemaResponse beforeSchema = (SchemaResponse)ClientHelper.call(() -> this.client().findSchemaByUuid(schemaUuid, new ParameterProvider[0]));
        Assert.assertEquals((Object)"1.0", (Object)beforeSchema.getVersion());
        SchemaVersionModel schemaModel = (SchemaVersionModel)this.tx(() -> {
            JsonObject setting = new JsonObject().put("test", (Object)"123");
            HibSchemaVersion version = (HibSchemaVersion)this.schemaContainer("content").getLatestVersion();
            SchemaVersionModel schema = version.getSchema();
            schema.getField("slug").setElasticsearch(setting);
            version.setJson(schema.toJson());
            return schema;
        });
        SchemaUpdateRequest request = (SchemaUpdateRequest)JsonUtil.readValue((String)schemaModel.toJson(), SchemaUpdateRequest.class);
        this.waitForJobs(() -> {
            request.getField("slug").setElasticsearch(value);
            ClientHelper.call(() -> this.client().updateSchema(schemaUuid, request, new ParameterProvider[0]));
        }, JobStatus.COMPLETED, 1);
        SchemaResponse afterSchema = (SchemaResponse)ClientHelper.call(() -> this.client().findSchemaByUuid(schemaUuid, new ParameterProvider[0]));
        Assert.assertEquals((Object)"2.0", (Object)afterSchema.getVersion());
        Assert.assertEquals((String)"The ES setting of the slug field should have been set to empty json.", (Object)new JsonObject(), (Object)afterSchema.getField("slug").getElasticsearch());
    }

    @Test
    public void testMigrateByESSchemaNull() {
        String schemaUuid = (String)this.tx(() -> this.schemaContainer("content").getUuid());
        SchemaResponse beforeSchema = (SchemaResponse)ClientHelper.call(() -> this.client().findSchemaByUuid(schemaUuid, new ParameterProvider[0]));
        Assert.assertEquals((Object)"1.0", (Object)beforeSchema.getVersion());
        SchemaVersionModel schemaModel = (SchemaVersionModel)this.tx(() -> {
            JsonObject setting = new JsonObject().put("test", (Object)"123");
            HibSchemaVersion version = (HibSchemaVersion)this.schemaContainer("content").getLatestVersion();
            SchemaVersionModel schema = version.getSchema();
            schema.setElasticsearch(setting);
            version.setJson(schema.toJson());
            return schema;
        });
        SchemaUpdateRequest request = (SchemaUpdateRequest)JsonUtil.readValue((String)schemaModel.toJson(), SchemaUpdateRequest.class);
        this.waitForJobs(() -> {
            request.setElasticsearch(new JsonObject());
            ClientHelper.call(() -> this.client().updateSchema(schemaUuid, request, new ParameterProvider[0]));
        }, JobStatus.COMPLETED, 1);
        SchemaResponse afterSchema = (SchemaResponse)ClientHelper.call(() -> this.client().findSchemaByUuid(schemaUuid, new ParameterProvider[0]));
        Assert.assertEquals((Object)"2.0", (Object)afterSchema.getVersion());
        Assert.assertEquals((String)"The ES setting of the schema should have been set to {}.", (Object)new JsonObject(), (Object)afterSchema.getElasticsearch());
    }

    @Test
    public void testStringHtmlMigration() {
        String FIELD_NAME_1 = "testField1";
        String FIELD_NAME_2 = "testField2";
        String SCHEMA_NAME = "testSchema";
        String PARENT_NODE_UUID = (String)this.tx(() -> this.project().getBaseNode().getUuid());
        SchemaCreateRequest schemaCreate = new SchemaCreateRequest();
        schemaCreate.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"testField1"));
        schemaCreate.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"testField2"));
        schemaCreate.setName("testSchema");
        schemaCreate.setDisplayField("testField1");
        SchemaResponse schema = (SchemaResponse)ClientHelper.call(() -> this.client().createSchema(schemaCreate, new ParameterProvider[0]));
        ClientHelper.call(() -> this.client().assignSchemaToProject("dummy", schema.getUuid()));
        NodeCreateRequest nodeCreateRequest = new NodeCreateRequest();
        nodeCreateRequest.setSchemaName("testSchema");
        nodeCreateRequest.getFields().put("testField1", (Field)FieldUtil.createStringField((String)"test123"));
        nodeCreateRequest.setLanguage("en");
        nodeCreateRequest.setParentNodeUuid(PARENT_NODE_UUID);
        ClientHelper.call(() -> this.client().createNode("dummy", nodeCreateRequest, new ParameterProvider[0]));
        SchemaUpdateRequest schemaUpdate = new SchemaUpdateRequest();
        schemaUpdate.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"testField1"));
        schemaUpdate.addField((FieldSchema)FieldUtil.createHtmlFieldSchema((String)"testField2"));
        schemaUpdate.setName("testSchema");
        schemaUpdate.setDisplayField("testField1");
        this.waitForJob(() -> ClientHelper.call(() -> this.client().updateSchema(schema.getUuid(), schemaUpdate, new ParameterProvider[0])));
    }

    @Test
    public void testStartSchemaMigration() throws Throwable {
        String jobUuid;
        HibNode secondNode;
        HibNode firstNode;
        HibSchemaVersion versionB;
        HibSchema container;
        String oldFieldName = "oldname";
        String newFieldName = "changedfield";
        try (Tx tx = this.tx();){
            PersistingBranchDao branchDao = ((CommonTx)tx.unwrap()).branchDao();
            NodeDao nodeDao = tx.nodeDao();
            container = this.createDummySchemaWithChanges(oldFieldName, newFieldName, false);
            versionB = (HibSchemaVersion)container.getLatestVersion();
            HibSchemaVersion versionA = (HibSchemaVersion)versionB.getPreviousVersion();
            HibUser user = this.user();
            EventQueueBatch batch = this.createBatch();
            Assert.assertNull((String)"No job should be scheduled since this is the first time we assigned the schema to the branch. No need for a migration", (Object)branchDao.assignSchemaVersion(this.project().getLatestBranch(), user, versionA, batch));
            batch.dispatch();
            String english = this.english();
            HibNode parentNode = this.folder("2015");
            firstNode = nodeDao.create(parentNode, user, versionA, this.project());
            HibNodeFieldContainer firstEnglishContainer = tx.contentDao().createFieldContainer(firstNode, english, firstNode.getProject().getLatestBranch(), user);
            firstEnglishContainer.createString(oldFieldName).setString("first content");
            secondNode = nodeDao.create(parentNode, user, versionA, this.project());
            HibNodeFieldContainer secondEnglishContainer = tx.contentDao().createFieldContainer(secondNode, english, secondNode.getProject().getLatestBranch(), user);
            secondEnglishContainer.createString(oldFieldName).setString("second content");
            HibBranch latestBranch = this.reloadBranch(this.project().getLatestBranch());
            jobUuid = branchDao.assignSchemaVersion(latestBranch, user, versionB, batch).getUuid();
            tx.success();
        }
        this.triggerAndWaitForJob(jobUuid);
        this.waitForSearchIdleEvent();
        tx = this.tx();
        try {
            ((NodeAssert)MeshAssertions.assertThat((HibNode)firstNode).as("Migrated Node", new Object[0])).isOf(container).hasTranslation("en");
            ((NodeGraphFieldContainerAssert)MeshAssertions.assertThat((HibNodeFieldContainer)tx.contentDao().getFieldContainer(firstNode, "en")).as("Migrated field container", new Object[0])).isOf(versionB).hasVersion("0.2");
            ((AbstractCharSequenceAssert)MeshAssertions.assertThat((String)tx.contentDao().getFieldContainer(firstNode, "en").getString(newFieldName).getString()).as("Migrated field value", new Object[0])).isEqualTo((Object)"first content");
            ((NodeAssert)MeshAssertions.assertThat((HibNode)secondNode).as("Migrated Node", new Object[0])).isOf(container).hasTranslation("en");
            ((NodeGraphFieldContainerAssert)MeshAssertions.assertThat((HibNodeFieldContainer)tx.contentDao().getFieldContainer(secondNode, "en")).as("Migrated field container", new Object[0])).isOf(versionB).hasVersion("0.2");
            ((AbstractCharSequenceAssert)MeshAssertions.assertThat((String)tx.contentDao().getFieldContainer(secondNode, "en").getString(newFieldName).getString()).as("Migrated field value", new Object[0])).isEqualTo((Object)"second content");
            int store = 2;
            int update = 0;
            int delete = 2;
            int indexDrop = 1;
            int indexCreate = 2;
            MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasEvents((long)store, (long)update, (long)delete, (long)indexDrop, (long)indexCreate);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        JobListResponse status = (JobListResponse)this.adminCall(() -> this.client().findJobs(new ParameterProvider[0]));
        MeshAssertions.assertThat((JobListResponse)status).listsAll(JobStatus.COMPLETED).hasInfos(1).containsJobs(new String[]{jobUuid});
    }

    @Test
    public void testMigrateAddRawField() throws Throwable {
        HibNode node = this.content();
        String nodeUuid = this.contentUuid();
        try (Tx tx2 = this.tx();){
            HibNode parentNode = this.content();
            ContentDao contentDao = tx2.contentDao();
            HibNodeFieldContainer original = contentDao.getLatestDraftFieldContainer(parentNode, this.english());
            HibNodeFieldContainer newContainer = contentDao.createFieldContainer(parentNode, this.english(), this.project().getLatestBranch(), this.user(), original, true);
            newContainer.getString("title").setString(TestUtils.getRandomHash((int)40000));
            newContainer.getString("teaser").setString(TestUtils.getRandomHash((int)40000));
            tx2.success();
        }
        String schemaUuid = (String)this.tx(() -> node.getSchemaContainer().getUuid());
        int nFieldContainers = (Integer)this.tx(tx -> {
            ContentDao contentDao = tx.contentDao();
            HibSchemaVersion schemaVersion = (HibSchemaVersion)node.getSchemaContainer().getLatestVersion();
            return Long.valueOf(((CommonTx)tx.unwrap()).schemaDao().getFieldContainers(schemaVersion, this.initialBranchUuid()).filter(arg_0 -> ((ContentDao)contentDao).isPublished(arg_0)).count()).intValue();
        });
        this.waitForJob(() -> {
            SchemaUpdateRequest request = (SchemaUpdateRequest)this.tx(() -> (SchemaUpdateRequest)JsonUtil.readValue((String)((HibSchemaVersion)node.getSchemaContainer().getLatestVersion()).getJson(), SchemaUpdateRequest.class));
            request.getField("teaser").setElasticsearch(IndexOptionHelper.getRawFieldOption());
            ClientHelper.call(() -> this.client().updateSchema(schemaUuid, request, new ParameterProvider[0]));
        });
        JobListResponse status = (JobListResponse)this.adminCall(() -> this.client().findJobs(new ParameterProvider[0]));
        MeshAssertions.assertThat((JobListResponse)status).listsAll(JobStatus.COMPLETED).hasInfos(1);
        this.waitForSearchIdleEvent();
        int store = nFieldContainers + nFieldContainers + 1;
        int update = 0;
        int delete = nFieldContainers + nFieldContainers;
        int dropIndex = 1;
        int createIndex = 2;
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasEvents((long)store, (long)update, (long)delete, (long)dropIndex, (long)createIndex);
        for (JsonObject mapping : this.trackingSearchProvider().getCreateIndexEvents().values()) {
            String basePath = "$.mapping.default";
            if (this.complianceMode() == ComplianceMode.ES_7) {
                basePath = "$.mapping";
            }
            MeshAssertions.assertThat((JsonObject)mapping).has(basePath + ".properties.fields.properties.teaser.fields.raw.type", "keyword", "The mapping should include a raw field for the teaser field");
            MeshAssertions.assertThat((JsonObject)mapping).hasNot(basePath + ".properties.fields.properties.title.fields.raw", "The mapping should not include a raw field for the title field");
        }
        JsonObject doc = this.trackingSearchProvider().getStoreEvents().entrySet().stream().filter(e -> ((String)e.getKey()).endsWith(nodeUuid + "-en")).map(e -> (JsonObject)e.getValue()).sorted(Comparator.comparing(json -> json.getJsonObject("fields").getString("teaser").length()).reversed()).findFirst().orElseThrow();
        String teaser = doc.getJsonObject("fields").getString("teaser");
        MeshAssertions.assertThat((String)teaser).hasSize(32700);
        String content = doc.getJsonObject("fields").getString("title");
        MeshAssertions.assertThat((String)content).hasSize(40000);
    }

    @Test
    public void testMigrateAgain() throws Throwable {
        String jobAUuid;
        HibNode firstNode;
        HibSchemaVersion versionA;
        HibSchemaVersion versionB;
        HibSchema container;
        String oldFieldName = "oldname";
        String newFieldName = "changedfield";
        try (Tx tx = this.tx();){
            NodeDao nodeDao = tx.nodeDao();
            container = this.createDummySchemaWithChanges(oldFieldName, newFieldName, false);
            versionB = (HibSchemaVersion)container.getLatestVersion();
            versionA = (HibSchemaVersion)versionB.getPreviousVersion();
            HibUser user = this.user();
            EventQueueBatch batch = this.createBatch();
            Assert.assertNull((String)"No job should be scheduled since this is the first time we assigned the schema to the branch. No need for a migration", (Object)tx.branchDao().assignSchemaVersion(this.project().getLatestBranch(), user, versionA, batch));
            String english = this.english();
            HibNode parentNode = this.folder("2015");
            firstNode = nodeDao.create(parentNode, user, versionA, this.project());
            Tx.get().commit();
            HibNodeFieldContainer firstEnglishContainer = tx.contentDao().createFieldContainer(firstNode, english, firstNode.getProject().getLatestBranch(), user);
            firstEnglishContainer.createString(oldFieldName).setString("first content");
            HibBranch latestBranch = this.reloadBranch(this.project().getLatestBranch());
            jobAUuid = tx.branchDao().assignSchemaVersion(latestBranch, user, versionB, batch).getUuid();
            tx.success();
        }
        Thread.sleep(1000L);
        this.triggerAndWaitForJob(jobAUuid);
        this.doSchemaMigration(versionA, versionB);
        tx = this.tx();
        try {
            ((NodeAssert)MeshAssertions.assertThat((HibNode)firstNode).as("Migrated Node", new Object[0])).isOf(container).hasTranslation("en");
            ((NodeGraphFieldContainerAssert)MeshAssertions.assertThat((HibNodeFieldContainer)tx.contentDao().getFieldContainer(firstNode, "en")).as("Migrated field container", new Object[0])).isOf(versionB).hasVersion("0.2");
            ((AbstractCharSequenceAssert)MeshAssertions.assertThat((String)tx.contentDao().getFieldContainer(firstNode, "en").getString(newFieldName).getString()).as("Migrated field value", new Object[0])).isEqualTo((Object)"first content");
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        JobListResponse status = (JobListResponse)this.adminCall(() -> this.client().findJobs(new ParameterProvider[0]));
        MeshAssertions.assertThat((JobListResponse)status).listsAll(JobStatus.COMPLETED).hasInfos(2);
        MeshAssertions.assertThat((JobListResponse)status).containsJobs(new String[]{jobAUuid});
    }

    @Test
    public void testMigratePublished() throws Throwable {
        HibNode node;
        HibSchemaVersion versionA;
        HibSchemaVersion versionB;
        String oldFieldName = "oldname";
        String fieldName = "changedfield";
        try (Tx tx = this.tx();){
            NodeDao nodeDao = tx.nodeDao();
            BranchDao branchDao = tx.branchDao();
            HibSchema container = this.createDummySchemaWithChanges(oldFieldName, fieldName, false);
            versionB = (HibSchemaVersion)container.getLatestVersion();
            versionA = (HibSchemaVersion)versionB.getPreviousVersion();
            EventQueueBatch batch = this.createBatch();
            branchDao.assignSchemaVersion(this.project().getLatestBranch(), this.user(), versionA, batch);
            Tx.get().commit();
            node = nodeDao.create(this.folder("2015"), this.user(), versionA, this.project());
            HibNodeFieldContainer englishContainer = tx.contentDao().createFieldContainer(node, this.english(), this.project().getLatestBranch(), this.user());
            englishContainer.createString(oldFieldName).setString("content");
            englishContainer.createString("name").setString("someName");
            InternalRoutingActionContextImpl ac = new InternalRoutingActionContextImpl(this.mockRoutingContext());
            nodeDao.publish(node, (InternalActionContext)ac, this.createBulkContext(), "en");
            branchDao.assignSchemaVersion(this.project().getLatestBranch(), this.user(), versionB, batch);
            tx.success();
        }
        this.doSchemaMigration(versionA, versionB);
        tx = this.tx();
        try {
            ContentDao contentDao = tx.contentDao();
            ((NodeGraphFieldContainerAssert)MeshAssertions.assertThat((HibNodeFieldContainer)tx.contentDao().getFieldContainer(node, "en")).as("Migrated draft", new Object[0])).isOf(versionB).hasVersion("2.0");
            ((NodeGraphFieldContainerAssert)MeshAssertions.assertThat((HibNodeFieldContainer)contentDao.getFieldContainer(node, "en", this.project().getLatestBranch().getUuid(), ContainerType.PUBLISHED)).as("Migrated published", new Object[0])).isOf(versionB).hasVersion("2.0");
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        JobListResponse status = (JobListResponse)this.adminCall(() -> this.client().findJobs(new ParameterProvider[0]));
        MeshAssertions.assertThat((JobListResponse)status).listsAll(JobStatus.COMPLETED);
    }

    @Test
    public void testMicronodeListMigration() throws Exception {
        SchemaUpdateRequest schemaUpdate = (SchemaUpdateRequest)this.tx(() -> (SchemaUpdateRequest)JsonUtil.readValue((String)((HibSchemaVersion)this.schemaContainer("content").getLatestVersion()).getJson(), SchemaUpdateRequest.class));
        schemaUpdate.addField((FieldSchema)FieldUtil.createListFieldSchema((String)"micronode", (String)"micronode").setAllowedSchemas(new String[]{"vcard"}));
        String schemaUuid = (String)this.db().tx(() -> this.schemaContainer("content").getUuid());
        this.waitForJobs(() -> ClientHelper.call(() -> this.client().updateSchema(schemaUuid, schemaUpdate, new ParameterProvider[0])), JobStatus.COMPLETED, 1);
        String parentNodeUuid = (String)this.tx(() -> this.folder("2015").getUuid());
        NodeCreateRequest nodeCreateRequest = new NodeCreateRequest();
        nodeCreateRequest.setSchema((SchemaReference)new SchemaReferenceImpl().setName("content"));
        nodeCreateRequest.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"test"));
        nodeCreateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)"test"));
        MicronodeField micronodeA = FieldUtil.createMicronodeField((String)"vcard", (Tuple[])new Tuple[]{Tuple.tuple((Object)"firstName", (Object)FieldUtil.createStringField((String)"test-updated-firstname")), Tuple.tuple((Object)"lastName", (Object)FieldUtil.createStringField((String)"test-updated-lastname"))});
        MicronodeField micronodeB = FieldUtil.createMicronodeField((String)"vcard", (Tuple[])new Tuple[]{Tuple.tuple((Object)"firstName", (Object)FieldUtil.createStringField((String)"test")), Tuple.tuple((Object)"lastName", (Object)FieldUtil.createStringField((String)"test"))});
        nodeCreateRequest.getFields().put("micronode", FieldUtil.createMicronodeListField((MicronodeField[])new MicronodeField[]{micronodeA, micronodeB}));
        nodeCreateRequest.setParentNodeUuid(parentNodeUuid);
        nodeCreateRequest.setLanguage("en");
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", nodeCreateRequest, new ParameterProvider[0]));
        String nodeUuid = response.getUuid();
        MeshAssertions.assertThat((List)response.getFields().getMicronodeFieldList("micronode").getItems()).isNotEmpty();
        ClientHelper.call(() -> this.client().publishNode("dummy", nodeUuid, new ParameterProvider[0]));
        schemaUpdate.setName("someOtherName");
        ListFieldSchema micronodeListFieldSchema = (ListFieldSchema)schemaUpdate.getField("micronode", ListFieldSchema.class);
        micronodeListFieldSchema.setAllowedSchemas(new String[]{"vcard", "captionedImage"});
        this.waitForJobs(() -> ClientHelper.call(() -> this.client().updateSchema(schemaUuid, schemaUpdate, new ParameterProvider[0])), JobStatus.COMPLETED, 1);
        NodeResponse migratedNode = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", nodeUuid, new ParameterProvider[]{new VersioningParametersImpl().setVersion("published")}));
        MeshAssertions.assertThat((List)migratedNode.getFields().getMicronodeFieldList("micronode").getItems()).isNotEmpty();
        Assert.assertNotEquals((String)"The node should have been migrated due to the schema update.", (Object)migratedNode.getVersion(), (Object)response.getVersion());
        ListFieldSchema micronodeListFieldSchema2 = (ListFieldSchema)schemaUpdate.getField("micronode", ListFieldSchema.class);
        micronodeListFieldSchema2.setAllowedSchemas(new String[]{"vcard"});
        schemaUpdate.addField((FieldSchema)FieldUtil.createMicronodeFieldSchema((String)"otherMicronode").setAllowedMicroSchemas(new String[]{"vcard"}));
        this.waitForJobs(() -> ClientHelper.call(() -> this.client().updateSchema(schemaUuid, schemaUpdate, new ParameterProvider[0])), JobStatus.COMPLETED, 1);
        migratedNode = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", nodeUuid, new ParameterProvider[]{new VersioningParametersImpl().setVersion("published")}));
        MeshAssertions.assertThat((List)migratedNode.getFields().getMicronodeFieldList("micronode").getItems()).isNotEmpty();
        Assert.assertNotEquals((String)"The node should have been migrated due to the schema update.", (Object)migratedNode.getVersion(), (Object)response.getVersion());
        String microschemaUuid = (String)this.tx(() -> this.microschemaContainer("vcard").getUuid());
        MicroschemaUpdateRequest microschemaUpdate = (MicroschemaUpdateRequest)this.db().tx(() -> (MicroschemaUpdateRequest)JsonUtil.readValue((String)this.microschemaContainer("vcard").getLatestVersion().getJson(), MicroschemaUpdateRequest.class));
        microschemaUpdate.setName("someOtherName2");
        microschemaUpdate.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"enemenemuh"));
        this.waitForJobs(() -> ClientHelper.call(() -> this.client().updateMicroschema(microschemaUuid, microschemaUpdate, new ParameterProvider[0])), JobStatus.COMPLETED, 1);
        NodeResponse migratedNode2 = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", nodeUuid, new ParameterProvider[]{new VersioningParametersImpl().setVersion("published")}));
        MeshAssertions.assertThat((List)migratedNode2.getFields().getMicronodeFieldList("micronode").getItems()).isNotEmpty();
        Assert.assertNotEquals((String)"The node should have been migrated due to the schema update.", (Object)migratedNode.getVersion(), (Object)migratedNode2.getVersion());
        JobListResponse status = (JobListResponse)this.adminCall(() -> this.client().findJobs(new ParameterProvider[0]));
        MeshAssertions.assertThat((JobListResponse)status).listsAll(JobStatus.COMPLETED).hasInfos(4);
    }

    @Test
    public void testMigrationFailureInSetup() throws Exception {
        String jobUuid = (String)this.tx(tx -> {
            JobDao jobDao = tx.jobDao();
            return jobDao.enqueueMicroschemaMigration(this.user(), this.initialBranch(), this.microschemaContainer("vcard").getLatestVersion(), this.microschemaContainer("vcard").getLatestVersion()).getUuid();
        });
        this.client().deleteProject(this.projectUuid()).blockingAwait();
        this.triggerAndWaitForJob(jobUuid, JobStatus.FAILED);
        JobListResponse status = (JobListResponse)this.adminCall(() -> this.client().findJobs(new ParameterProvider[0]));
        MeshAssertions.assertThat((JobListResponse)status).listsAll(JobStatus.FAILED).hasInfos(1);
        Assert.assertNotNull((String)"An error should be stored along with the info.", (Object)((JobResponse)status.getData().get(0)).getErrorDetail());
    }

    @Test
    public void testMigrationInfoCleanup() throws Exception {
        for (int i = 0; i < 10; ++i) {
            this.tx(tx -> {
                JobDao jobDao = tx.jobDao();
                HibSchemaVersion version = (HibSchemaVersion)this.schemaContainer("content").getLatestVersion();
                return jobDao.enqueueSchemaMigration(this.user(), this.initialBranch(), version, version);
            });
        }
        this.triggerAndWaitForAllJobs(JobStatus.COMPLETED);
        JobListResponse status = (JobListResponse)this.adminCall(() -> this.client().findJobs(new ParameterProvider[0]));
        MeshAssertions.assertThat((JobListResponse)status).listsAll(JobStatus.COMPLETED).hasInfos(10);
    }

    @Test
    public void testMigrateDraftAndPublished() throws Throwable {
        this.disableAutoPurge();
        SchemaCreateRequest request = new SchemaCreateRequest();
        request.setName("dummy");
        request.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"text"));
        request.setSegmentField("text");
        request.setDisplayField("text");
        request.validate();
        SchemaResponse schemaResponse = (SchemaResponse)ClientHelper.call(() -> this.client().createSchema(request, new ParameterProvider[0]));
        ClientHelper.call(() -> this.client().assignSchemaToProject("dummy", schemaResponse.getUuid()));
        ClientHelper.call(() -> this.client().assignBranchSchemaVersions("dummy", this.initialBranchUuid(), new SchemaReference[]{schemaResponse.toReference()}));
        NodeCreateRequest nodeCreateRequest = new NodeCreateRequest();
        nodeCreateRequest.setLanguage("en");
        nodeCreateRequest.setSchemaName("dummy");
        nodeCreateRequest.setParentNodeUuid((String)this.tx(() -> this.folder("2015").getUuid()));
        nodeCreateRequest.getFields().put("text", (Field)new StringFieldImpl().setString("text_value"));
        NodeResponse draftResponse = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", nodeCreateRequest, new ParameterProvider[0]));
        MeshAssertions.assertThat((NodeResponse)draftResponse).hasVersion("0.1");
        ClientHelper.call(() -> this.client().publishNode("dummy", draftResponse.getUuid(), new ParameterProvider[0]));
        NodeUpdateRequest nodeUpdateRequest = new NodeUpdateRequest();
        nodeUpdateRequest.setLanguage("en");
        nodeUpdateRequest.setVersion("0.1");
        nodeUpdateRequest.getFields().put("text", (Field)new StringFieldImpl().setString("text2_value"));
        MeshAssertions.assertThat((NodeResponse)((NodeResponse)ClientHelper.call(() -> this.client().updateNode("dummy", draftResponse.getUuid(), nodeUpdateRequest, new ParameterProvider[0])))).hasVersion("1.1");
        MeshAssertions.assertThat((NodeResponse)((NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", draftResponse.getUuid(), new ParameterProvider[]{new VersioningParametersImpl().published()})))).hasVersion("1.0");
        SchemaUpdateRequest updateRequest = new SchemaUpdateRequest();
        updateRequest.setName("dummy");
        updateRequest.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"text"));
        updateRequest.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"text2"));
        updateRequest.setSegmentField("text");
        updateRequest.setDisplayField("text");
        updateRequest.validate();
        this.waitForJobs(() -> ClientHelper.call(() -> this.client().updateSchema(schemaResponse.getUuid(), updateRequest, new ParameterProvider[0])), JobStatus.COMPLETED, 1);
        MeshAssertions.assertThat((NodeResponse)((NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", draftResponse.getUuid(), new ParameterProvider[0])))).hasVersion("2.1").hasStringField("text", "text2_value");
        this.triggerAndWaitForAllJobs(JobStatus.COMPLETED);
        JobListResponse status = (JobListResponse)this.adminCall(() -> this.client().findJobs(new ParameterProvider[0]));
        MeshAssertions.assertThat((JobListResponse)status).listsAll(JobStatus.COMPLETED).hasInfos(1);
        MeshAssertions.assertThat((NodeResponse)((NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", draftResponse.getUuid(), new ParameterProvider[0])))).hasStringField("text", "text2_value").hasVersion("2.1").hasSchemaVersion("dummy", "2.0");
        MeshAssertions.assertThat((NodeResponse)((NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", draftResponse.getUuid(), new ParameterProvider[]{new VersioningParametersImpl().published()})))).hasStringField("text", "text_value").hasSchemaVersion("dummy", "2.0").hasVersion("2.0");
    }

    @Test
    public void testMigrateDraftAndSamePublished() throws Throwable {
        SchemaCreateRequest request = new SchemaCreateRequest();
        request.setName("dummy");
        request.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"text"));
        request.setSegmentField("text");
        request.setDisplayField("text");
        request.validate();
        SchemaResponse schemaResponse = (SchemaResponse)ClientHelper.call(() -> this.client().createSchema(request, new ParameterProvider[0]));
        ClientHelper.call(() -> this.client().assignSchemaToProject("dummy", schemaResponse.getUuid()));
        ClientHelper.call(() -> this.client().assignBranchSchemaVersions("dummy", this.initialBranchUuid(), new SchemaReference[]{schemaResponse.toReference()}));
        NodeCreateRequest nodeCreateRequest = new NodeCreateRequest();
        nodeCreateRequest.setLanguage("en");
        nodeCreateRequest.setSchemaName("dummy");
        nodeCreateRequest.setParentNodeUuid((String)this.tx(() -> this.folder("2015").getUuid()));
        nodeCreateRequest.getFields().put("text", (Field)new StringFieldImpl().setString("text_value"));
        NodeResponse draftResponse = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", nodeCreateRequest, new ParameterProvider[0]));
        MeshAssertions.assertThat((NodeResponse)draftResponse).hasVersion("0.1");
        ClientHelper.call(() -> this.client().publishNode("dummy", draftResponse.getUuid(), new ParameterProvider[0]));
        MeshAssertions.assertThat((NodeResponse)((NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", draftResponse.getUuid(), new ParameterProvider[]{new VersioningParametersImpl().published()})))).hasVersion("1.0");
        SchemaUpdateRequest updateRequest = new SchemaUpdateRequest();
        updateRequest.setName("dummy");
        updateRequest.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"text"));
        updateRequest.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"text2"));
        updateRequest.setSegmentField("text");
        updateRequest.setDisplayField("text");
        updateRequest.validate();
        this.waitForJobs(() -> ClientHelper.call(() -> this.client().updateSchema(schemaResponse.getUuid(), updateRequest, new ParameterProvider[0])), JobStatus.COMPLETED, 1);
        MeshAssertions.assertThat((NodeResponse)((NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", draftResponse.getUuid(), new ParameterProvider[0])))).hasVersion("2.0").hasStringField("text", "text_value").hasSchemaVersion("dummy", "2.0");
        JobListResponse status = (JobListResponse)this.adminCall(() -> this.client().findJobs(new ParameterProvider[0]));
        MeshAssertions.assertThat((JobListResponse)status).listsAll(JobStatus.COMPLETED).hasInfos(1);
        MeshAssertions.assertThat((NodeResponse)((NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", draftResponse.getUuid(), new ParameterProvider[0])))).hasStringField("text", "text_value").hasVersion("2.0").hasSchemaVersion("dummy", "2.0");
        MeshAssertions.assertThat((NodeResponse)((NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", draftResponse.getUuid(), new ParameterProvider[]{new VersioningParametersImpl().published()})))).hasStringField("text", "text_value").hasSchemaVersion("dummy", "2.0").hasVersion("2.0");
    }

    @Test
    public void testStartMicroschemaMigration() throws Throwable {
        HibMicronodeField secondMicronodeField;
        HibNode secondNode;
        HibMicronodeField firstMicronodeField;
        HibNode firstNode;
        HibMicroschemaVersion versionB;
        HibMicroschemaVersion versionA;
        this.disableAutoPurge();
        String oldFieldName = "field";
        String newFieldName = "changedfield";
        String micronodeFieldName = "micronodefield";
        try (Tx tx2 = this.tx();){
            PersistingMicroschemaDao microschemaDao = (PersistingMicroschemaDao)tx2.microschemaDao();
            ClientHelper.call(() -> this.client().takeNodeOffline("dummy", this.project().getBaseNode().getUuid(), new ParameterProvider[]{new PublishParametersImpl().setRecursive(true)}));
            HibMicroschema container = (HibMicroschema)microschemaDao.createPersisted(UUIDUtil.randomUUID());
            container.generateBucketId();
            container.setCreated(this.user());
            versionA = this.createMicroschemaVersion(tx2, container, v -> {
                container.setLatestVersion(v);
                MicroschemaModelImpl microschemaA = new MicroschemaModelImpl();
                microschemaA.setName("migratedSchema");
                microschemaA.setVersion("1.0");
                StringFieldSchema oldField = FieldUtil.createStringFieldSchema((String)oldFieldName);
                microschemaA.addField((FieldSchema)oldField);
                v.setName("migratedSchema");
                v.setSchema((MicroschemaVersionModel)microschemaA);
            });
            versionB = this.createMicroschemaVersion(tx2, container, v -> {
                MicroschemaModelImpl microschemaB = new MicroschemaModelImpl();
                microschemaB.setName("migratedSchema");
                microschemaB.setVersion("2.0");
                StringFieldSchema newField = FieldUtil.createStringFieldSchema((String)newFieldName);
                microschemaB.addField((FieldSchema)newField);
                v.setName("migratedSchema");
                v.setSchema((MicroschemaVersionModel)microschemaB);
            });
            microschemaDao.mergeIntoPersisted((HibBaseElement)container);
            HibUpdateFieldChange updateFieldChange = (HibUpdateFieldChange)microschemaDao.createPersistedChange((HibFieldSchemaVersionElement)versionA, SchemaChangeOperation.UPDATEFIELD);
            updateFieldChange.setFieldName(oldFieldName);
            updateFieldChange.setRestProperty("name", (Object)newFieldName);
            updateFieldChange.setPreviousContainerVersion((HibFieldSchemaVersionElement)versionA);
            updateFieldChange.setNextSchemaContainerVersion((HibFieldSchemaVersionElement)versionB);
            versionA.setNextVersion(versionB);
            versionA.setNextChange((HibSchemaChange)updateFieldChange);
            String english = this.english();
            firstNode = tx2.nodeDao().findByUuidGlobal(this.folder("2015").getUuid());
            SchemaVersionModel schema = ((HibSchemaVersion)firstNode.getSchemaContainer().getLatestVersion()).getSchema();
            schema.addField((FieldSchema)new MicronodeFieldSchemaImpl().setName(micronodeFieldName).setLabel("Micronode Field"));
            ((MicronodeFieldSchema)schema.getField(micronodeFieldName, MicronodeFieldSchema.class)).setAllowedMicroSchemas(new String[]{versionA.getName()});
            ((HibSchemaVersion)firstNode.getSchemaContainer().getLatestVersion()).setSchema(schema);
            this.actions().updateSchemaVersion((HibFieldSchemaVersionElement)((HibSchemaVersion)firstNode.getSchemaContainer().getLatestVersion()));
            Tx.get().commit();
            firstMicronodeField = tx2.contentDao().createFieldContainer(firstNode, english, firstNode.getProject().getLatestBranch(), this.user()).createMicronode(micronodeFieldName, versionA);
            firstMicronodeField.getMicronode().createString(oldFieldName).setString("first content");
            secondNode = this.folder("news");
            secondMicronodeField = tx2.contentDao().createFieldContainer(secondNode, english, secondNode.getProject().getLatestBranch(), this.user()).createMicronode(micronodeFieldName, versionA);
            secondMicronodeField.getMicronode().createString(oldFieldName).setString("second content");
            tx2.success();
        }
        String jobUuid = (String)this.tx(tx -> tx.jobDao().enqueueMicroschemaMigration(this.user(), this.initialBranch(), versionA, versionB).getUuid());
        this.triggerAndWaitForJob(jobUuid);
        try (Tx tx3 = this.tx();){
            ((MicronodeAssert)MeshAssertions.assertThat((HibMicronode)firstMicronodeField.getMicronode()).as("Old Micronode", new Object[0])).isOf(versionA);
            ((AbstractCharSequenceAssert)MeshAssertions.assertThat((String)firstMicronodeField.getMicronode().getString(oldFieldName).getString()).as("Old field value", new Object[0])).isEqualTo((Object)"first content");
            ((NodeGraphFieldContainerAssert)MeshAssertions.assertThat((HibNodeFieldContainer)tx3.contentDao().getFieldContainer(firstNode, "en")).as("Migrated field container", new Object[0])).hasVersion("1.2");
            ((MicronodeAssert)MeshAssertions.assertThat((HibMicronode)tx3.contentDao().getFieldContainer(firstNode, "en").getMicronode(micronodeFieldName).getMicronode()).as("Migrated Micronode", new Object[0])).isOf(versionB);
            ((AbstractCharSequenceAssert)MeshAssertions.assertThat((String)tx3.contentDao().getFieldContainer(firstNode, "en").getMicronode(micronodeFieldName).getMicronode().getString(newFieldName).getString()).as("Migrated field value", new Object[0])).isEqualTo((Object)"first content");
            ((MicronodeAssert)MeshAssertions.assertThat((HibMicronode)secondMicronodeField.getMicronode()).as("Old Micronode", new Object[0])).isOf(versionA);
            ((AbstractCharSequenceAssert)MeshAssertions.assertThat((String)secondMicronodeField.getMicronode().getString(oldFieldName).getString()).as("Old field value", new Object[0])).isEqualTo((Object)"second content");
            ((NodeGraphFieldContainerAssert)MeshAssertions.assertThat((HibNodeFieldContainer)tx3.contentDao().getFieldContainer(secondNode, "en")).as("Migrated field container", new Object[0])).hasVersion("1.2");
            ((MicronodeAssert)MeshAssertions.assertThat((HibMicronode)tx3.contentDao().getFieldContainer(secondNode, "en").getMicronode(micronodeFieldName).getMicronode()).as("Migrated Micronode", new Object[0])).isOf(versionB);
            ((AbstractCharSequenceAssert)MeshAssertions.assertThat((String)tx3.contentDao().getFieldContainer(secondNode, "en").getMicronode(micronodeFieldName).getMicronode().getString(newFieldName).getString()).as("Migrated field value", new Object[0])).isEqualTo((Object)"second content");
        }
        JobListResponse status = (JobListResponse)this.adminCall(() -> this.client().findJobs(new ParameterProvider[0]));
        MeshAssertions.assertThat((JobListResponse)status).listsAll(JobStatus.COMPLETED).hasInfos(1);
    }

    @Test
    public void testMicroschemaMigrationInListField() throws Throwable {
        HibMicronodeFieldList secondMicronodeListField;
        HibNode secondNode;
        HibMicronodeFieldList firstMicronodeListField;
        HibNode firstNode;
        HibMicroschemaVersion versionB;
        HibMicroschemaVersion versionA;
        String oldFieldName = "field";
        String newFieldName = "changedfield";
        String micronodeFieldName = "micronodefield";
        try (Tx tx2 = this.tx();){
            PersistingMicroschemaDao microschemaDao = (PersistingMicroschemaDao)tx2.microschemaDao();
            ContentDao contentDao = tx2.contentDao();
            HibMicroschema container = (HibMicroschema)microschemaDao.createPersisted(UUIDUtil.randomUUID());
            container.generateBucketId();
            container.setCreated(this.user());
            versionA = this.createMicroschemaVersion(tx2, container, v -> {
                container.setLatestVersion(v);
                MicroschemaModelImpl microschemaA = new MicroschemaModelImpl();
                microschemaA.setName("migratedSchema");
                microschemaA.setVersion("1.0");
                StringFieldSchema oldField = FieldUtil.createStringFieldSchema((String)oldFieldName);
                microschemaA.addField((FieldSchema)oldField);
                v.setName("migratedSchema");
                v.setSchema((MicroschemaVersionModel)microschemaA);
            });
            versionB = this.createMicroschemaVersion(tx2, container, v -> {
                MicroschemaModelImpl microschemaB = new MicroschemaModelImpl();
                microschemaB.setName("migratedSchema");
                microschemaB.setVersion("2.0");
                StringFieldSchema newField = FieldUtil.createStringFieldSchema((String)newFieldName);
                microschemaB.addField((FieldSchema)newField);
                v.setName("migratedSchema");
                v.setSchema((MicroschemaVersionModel)microschemaB);
            });
            microschemaDao.mergeIntoPersisted((HibBaseElement)container);
            Tx.get().commit();
            this.actions().updateSchemaVersion((HibFieldSchemaVersionElement)versionA);
            this.actions().updateSchemaVersion((HibFieldSchemaVersionElement)versionB);
            HibUpdateFieldChange updateFieldChange = (HibUpdateFieldChange)microschemaDao.createPersistedChange((HibFieldSchemaVersionElement)versionA, SchemaChangeOperation.UPDATEFIELD);
            updateFieldChange.setFieldName(oldFieldName);
            updateFieldChange.setRestProperty("name", (Object)newFieldName);
            updateFieldChange.setPreviousContainerVersion((HibFieldSchemaVersionElement)versionA);
            updateFieldChange.setNextSchemaContainerVersion((HibFieldSchemaVersionElement)versionB);
            versionA.setNextVersion(versionB);
            versionA.setNextChange((HibSchemaChange)updateFieldChange);
            String en = this.english();
            firstNode = this.folder("2015");
            SchemaVersionModel schema = ((HibSchemaVersion)firstNode.getSchemaContainer().getLatestVersion()).getSchema();
            schema.addField(new ListFieldSchemaImpl().setListType("micronode").setAllowedSchemas(new String[]{versionA.getName()}).setName(micronodeFieldName).setLabel("Micronode List Field"));
            ((HibSchemaVersion)firstNode.getSchemaContainer().getLatestVersion()).setSchema(schema);
            this.actions().updateSchemaVersion((HibFieldSchemaVersionElement)((HibSchemaVersion)firstNode.getSchemaContainer().getLatestVersion()));
            HibBranch branch = firstNode.getProject().getLatestBranch();
            HibNodeFieldContainer oldContainer = contentDao.getFieldContainer(firstNode, en, branch, ContainerType.DRAFT);
            HibNodeFieldContainer newContainer = contentDao.createFieldContainer(firstNode, en, branch, this.user(), oldContainer, true);
            firstMicronodeListField = newContainer.createMicronodeList(micronodeFieldName);
            HibMicronode micronode = firstMicronodeListField.createMicronode(versionA);
            micronode.createString(oldFieldName).setString("first content");
            secondNode = this.folder("news");
            HibBranch branch2 = secondNode.getProject().getLatestBranch();
            HibNodeFieldContainer oldContainer2 = contentDao.getFieldContainer(secondNode, en, branch2, ContainerType.DRAFT);
            secondMicronodeListField = contentDao.createFieldContainer(secondNode, en, branch2, this.user(), oldContainer2, true).createMicronodeList(micronodeFieldName);
            micronode = secondMicronodeListField.createMicronode(versionA);
            micronode.createString(oldFieldName).setString("second content");
            micronode = secondMicronodeListField.createMicronode(versionA);
            micronode.createString(oldFieldName).setString("third content");
            tx2.success();
        }
        String jobUuid = (String)this.tx(tx -> tx.jobDao().enqueueMicroschemaMigration(this.user(), this.project().getLatestBranch(), versionA, versionB).getUuid());
        this.triggerAndWaitForJob(jobUuid);
        try (Tx tx3 = this.tx();){
            ((MicronodeAssert)MeshAssertions.assertThat((HibMicronode)((HibMicronodeField)firstMicronodeListField.getList().get(0)).getMicronode()).as("Old Micronode", new Object[0])).isOf(versionA);
            ((AbstractCharSequenceAssert)MeshAssertions.assertThat((String)((HibMicronodeField)firstMicronodeListField.getList().get(0)).getMicronode().getString(oldFieldName).getString()).as("Old field value", new Object[0])).isEqualTo((Object)"first content");
            ((NodeGraphFieldContainerAssert)MeshAssertions.assertThat((HibNodeFieldContainer)tx3.contentDao().getFieldContainer(firstNode, "en")).as("Migrated field container", new Object[0])).hasVersion("2.1");
            ((MicronodeAssert)MeshAssertions.assertThat((HibMicronode)((HibMicronodeField)tx3.contentDao().getFieldContainer(firstNode, "en").getMicronodeList(micronodeFieldName).getList().get(0)).getMicronode()).as("Migrated Micronode", new Object[0])).isOf(versionB);
            ((AbstractCharSequenceAssert)MeshAssertions.assertThat((String)((HibMicronodeField)tx3.contentDao().getFieldContainer(firstNode, "en").getMicronodeList(micronodeFieldName).getList().get(0)).getMicronode().getString(newFieldName).getString()).as("Migrated field value", new Object[0])).isEqualTo((Object)"first content");
            ((MicronodeAssert)MeshAssertions.assertThat((HibMicronode)((HibMicronodeField)secondMicronodeListField.getList().get(0)).getMicronode()).as("Old Micronode", new Object[0])).isOf(versionA);
            ((AbstractCharSequenceAssert)MeshAssertions.assertThat((String)((HibMicronodeField)secondMicronodeListField.getList().get(0)).getMicronode().getString(oldFieldName).getString()).as("Old field value", new Object[0])).isEqualTo((Object)"second content");
            ((MicronodeAssert)MeshAssertions.assertThat((HibMicronode)((HibMicronodeField)secondMicronodeListField.getList().get(1)).getMicronode()).as("Old Micronode", new Object[0])).isOf(versionA);
            ((AbstractCharSequenceAssert)MeshAssertions.assertThat((String)((HibMicronodeField)secondMicronodeListField.getList().get(1)).getMicronode().getString(oldFieldName).getString()).as("Old field value", new Object[0])).isEqualTo((Object)"third content");
            ((NodeGraphFieldContainerAssert)MeshAssertions.assertThat((HibNodeFieldContainer)tx3.contentDao().getFieldContainer(secondNode, "en")).as("Migrated field container", new Object[0])).hasVersion("2.1");
            ((MicronodeAssert)MeshAssertions.assertThat((HibMicronode)((HibMicronodeField)tx3.contentDao().getFieldContainer(secondNode, "en").getMicronodeList(micronodeFieldName).getList().get(0)).getMicronode()).as("Migrated Micronode", new Object[0])).isOf(versionB);
            ((AbstractCharSequenceAssert)MeshAssertions.assertThat((String)((HibMicronodeField)tx3.contentDao().getFieldContainer(secondNode, "en").getMicronodeList(micronodeFieldName).getList().get(0)).getMicronode().getString(newFieldName).getString()).as("Migrated field value", new Object[0])).isEqualTo((Object)"second content");
            ((MicronodeAssert)MeshAssertions.assertThat((HibMicronode)((HibMicronodeField)tx3.contentDao().getFieldContainer(secondNode, "en").getMicronodeList(micronodeFieldName).getList().get(1)).getMicronode()).as("Migrated Micronode", new Object[0])).isOf(versionB);
            ((AbstractCharSequenceAssert)MeshAssertions.assertThat((String)((HibMicronodeField)tx3.contentDao().getFieldContainer(secondNode, "en").getMicronodeList(micronodeFieldName).getList().get(1)).getMicronode().getString(newFieldName).getString()).as("Migrated field value", new Object[0])).isEqualTo((Object)"third content");
        }
        JobListResponse status = (JobListResponse)this.adminCall(() -> this.client().findJobs(new ParameterProvider[0]));
        MeshAssertions.assertThat((JobListResponse)status).listsAll(JobStatus.COMPLETED).hasInfos(1);
    }

    @Test
    public void testMicroschemaMigrationMixedList() throws Throwable {
        HibMicronodeFieldList firstMicronodeListField;
        HibNode firstNode;
        HibMicroschemaVersion versionB;
        HibMicroschemaVersion versionA;
        this.disableAutoPurge();
        String oldFieldName = "field";
        String newFieldName = "changedfield";
        String micronodeFieldName = "micronodefield";
        try (Tx tx2 = this.tx();){
            PersistingMicroschemaDao microschemaDao = (PersistingMicroschemaDao)tx2.microschemaDao();
            ContentDao contentDao = tx2.contentDao();
            HibMicroschema container = (HibMicroschema)microschemaDao.createPersisted(UUIDUtil.randomUUID());
            container.generateBucketId();
            container.setCreated(this.user());
            versionA = this.createMicroschemaVersion(tx2, container, v -> {
                container.setLatestVersion(v);
                MicroschemaModelImpl microschemaA = new MicroschemaModelImpl();
                microschemaA.setName("migratedSchema");
                microschemaA.setVersion("1.0");
                StringFieldSchema oldField = FieldUtil.createStringFieldSchema((String)oldFieldName);
                microschemaA.addField((FieldSchema)oldField);
                v.setName("migratedSchema");
                v.setSchema((MicroschemaVersionModel)microschemaA);
            });
            versionB = this.createMicroschemaVersion(tx2, container, v -> {
                MicroschemaModelImpl microschemaB = new MicroschemaModelImpl();
                microschemaB.setName("migratedSchema");
                microschemaB.setVersion("2.0");
                StringFieldSchema newField = FieldUtil.createStringFieldSchema((String)newFieldName);
                microschemaB.addField((FieldSchema)newField);
                v.setName("migratedSchema");
                v.setSchema((MicroschemaVersionModel)microschemaB);
            });
            microschemaDao.mergeIntoPersisted((HibBaseElement)container);
            HibUpdateFieldChange updateFieldChange = (HibUpdateFieldChange)microschemaDao.createPersistedChange((HibFieldSchemaVersionElement)versionA, SchemaChangeOperation.UPDATEFIELD);
            updateFieldChange.setFieldName(oldFieldName);
            updateFieldChange.setRestProperty("name", (Object)newFieldName);
            updateFieldChange.setPreviousContainerVersion((HibFieldSchemaVersionElement)versionA);
            updateFieldChange.setNextSchemaContainerVersion((HibFieldSchemaVersionElement)versionB);
            versionA.setNextVersion(versionB);
            versionA.setNextChange((HibSchemaChange)updateFieldChange);
            String english = this.english();
            firstNode = this.folder("2015");
            SchemaVersionModel schema = ((HibSchemaVersion)firstNode.getSchemaContainer().getLatestVersion()).getSchema();
            schema.addField(new ListFieldSchemaImpl().setListType("micronode").setAllowedSchemas(new String[]{versionA.getName(), "vcard"}).setName(micronodeFieldName).setLabel("Micronode List Field"));
            ((HibSchemaVersion)firstNode.getSchemaContainer().getLatestVersion()).setSchema(schema);
            this.actions().updateSchemaVersion((HibFieldSchemaVersionElement)((HibSchemaVersion)firstNode.getSchemaContainer().getLatestVersion()));
            Tx.get().commit();
            HibNodeFieldContainer org = contentDao.getFieldContainer(firstNode, english, firstNode.getProject().getLatestBranch(), ContainerType.DRAFT);
            HibNodeFieldContainer newContainer = contentDao.createFieldContainer(firstNode, english, firstNode.getProject().getLatestBranch(), this.user(), org, true);
            firstMicronodeListField = newContainer.createMicronodeList(micronodeFieldName);
            HibMicronode micronode = firstMicronodeListField.createMicronode(versionA);
            micronode.createString(oldFieldName).setString("first content");
            micronode = firstMicronodeListField.createMicronode(this.microschemaContainer("vcard").getLatestVersion());
            micronode.createString("firstName").setString("Max");
            tx2.success();
        }
        String jobUuid = (String)this.tx(tx -> tx.jobDao().enqueueMicroschemaMigration(this.user(), this.project().getLatestBranch(), versionA, versionB).getUuid());
        this.triggerAndWaitForJob(jobUuid);
        try (Tx tx3 = this.tx();){
            ((MicronodeAssert)MeshAssertions.assertThat((HibMicronode)((HibMicronodeField)firstMicronodeListField.getList().get(0)).getMicronode()).as("Old Micronode", new Object[0])).isOf(versionA);
            ((AbstractCharSequenceAssert)MeshAssertions.assertThat((String)((HibMicronodeField)firstMicronodeListField.getList().get(0)).getMicronode().getString(oldFieldName).getString()).as("Old field value", new Object[0])).isEqualTo((Object)"first content");
            ((MicronodeAssert)MeshAssertions.assertThat((HibMicronode)((HibMicronodeField)firstMicronodeListField.getList().get(1)).getMicronode()).as("Old Micronode", new Object[0])).isOf(this.microschemaContainer("vcard").getLatestVersion());
            ((AbstractCharSequenceAssert)MeshAssertions.assertThat((String)((HibMicronodeField)firstMicronodeListField.getList().get(1)).getMicronode().getString("firstName").getString()).as("Old field value", new Object[0])).isEqualTo((Object)"Max");
            ((NodeGraphFieldContainerAssert)MeshAssertions.assertThat((HibNodeFieldContainer)tx3.contentDao().getFieldContainer(firstNode, "en")).as("Migrated field container", new Object[0])).hasVersion("2.1");
            ((MicronodeAssert)MeshAssertions.assertThat((HibMicronode)((HibMicronodeField)tx3.contentDao().getFieldContainer(firstNode, "en").getMicronodeList(micronodeFieldName).getList().get(0)).getMicronode()).as("Migrated Micronode", new Object[0])).isOf(versionB);
            ((AbstractCharSequenceAssert)MeshAssertions.assertThat((String)((HibMicronodeField)tx3.contentDao().getFieldContainer(firstNode, "en").getMicronodeList(micronodeFieldName).getList().get(0)).getMicronode().getString(newFieldName).getString()).as("Migrated field value", new Object[0])).isEqualTo((Object)"first content");
            ((MicronodeAssert)MeshAssertions.assertThat((HibMicronode)((HibMicronodeField)tx3.contentDao().getFieldContainer(firstNode, "en").getMicronodeList(micronodeFieldName).getList().get(1)).getMicronode()).as("Not migrated Micronode", new Object[0])).isOf(this.microschemaContainer("vcard").getLatestVersion());
            ((AbstractCharSequenceAssert)MeshAssertions.assertThat((String)((HibMicronodeField)tx3.contentDao().getFieldContainer(firstNode, "en").getMicronodeList(micronodeFieldName).getList().get(1)).getMicronode().getString("firstName").getString()).as("Not migrated field value", new Object[0])).isEqualTo((Object)"Max");
        }
        JobListResponse status = (JobListResponse)this.adminCall(() -> this.client().findJobs(new ParameterProvider[0]));
        MeshAssertions.assertThat((JobListResponse)status).listsAll(JobStatus.COMPLETED).hasInfos(1);
    }

    private HibSchema createDummySchemaWithChanges(String oldFieldName, String newFieldName, boolean setAddRaw) {
        PersistingSchemaDao schemaDao = CommonTx.get().schemaDao();
        HibSchema container = (HibSchema)schemaDao.createPersisted(UUIDUtil.randomUUID());
        HibSchemaVersion versionA = this.createSchemaVersion(Tx.get(), container, v -> {
            SchemaModelImpl schemaA = new SchemaModelImpl();
            schemaA.setName("migratedSchema");
            schemaA.setVersion("1.0");
            StringFieldSchema oldField = FieldUtil.createStringFieldSchema((String)oldFieldName);
            schemaA.addField((FieldSchema)oldField);
            schemaA.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"name"));
            schemaA.setDisplayField("name");
            schemaA.setSegmentField("name");
            schemaA.setContainer(Boolean.valueOf(false));
            schemaA.validate();
            v.setName("migratedSchema");
            v.setSchema((SchemaVersionModel)schemaA);
            container.setLatestVersion((HibFieldSchemaVersionElement)v);
        });
        container.generateBucketId();
        container.setName(UUID.randomUUID().toString());
        container.setCreated(this.user());
        schemaDao.mergeIntoPersisted((HibBaseElement)container);
        HibSchemaVersion versionB = this.createSchemaVersion(Tx.get(), container, v -> {
            SchemaModelImpl schemaB = new SchemaModelImpl();
            schemaB.setName("migratedSchema");
            schemaB.setVersion("2.0");
            StringFieldSchema newField = FieldUtil.createStringFieldSchema((String)newFieldName);
            if (setAddRaw) {
                newField.setElasticsearch(IndexOptionHelper.getRawFieldOption());
            }
            schemaB.addField((FieldSchema)newField);
            schemaB.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"name"));
            schemaB.setDisplayField("name");
            schemaB.setSegmentField("name");
            schemaB.setContainer(Boolean.valueOf(false));
            schemaB.validate();
            v.setName("migratedSchema");
            v.setSchema((SchemaVersionModel)schemaB);
            v.setSchemaContainer(container);
        });
        HibUpdateFieldChange updateFieldChange = (HibUpdateFieldChange)schemaDao.createPersistedChange((HibFieldSchemaVersionElement)versionA, SchemaChangeOperation.UPDATEFIELD);
        updateFieldChange.setFieldName(oldFieldName);
        updateFieldChange.setRestProperty("name", (Object)newFieldName);
        updateFieldChange.setPreviousContainerVersion((HibFieldSchemaVersionElement)versionA);
        updateFieldChange.setNextSchemaContainerVersion((HibFieldSchemaVersionElement)versionB);
        versionA.setNextChange((HibSchemaChange)updateFieldChange);
        container.setLatestVersion((HibFieldSchemaVersionElement)versionB);
        versionA.setNextVersion((HibFieldSchemaVersionElement)versionB);
        versionB.setPreviousVersion((HibFieldSchemaVersionElement)versionA);
        schemaDao.mergeIntoPersisted((HibBaseElement)container);
        Tx.get().commit();
        this.actions().updateSchemaVersion((HibFieldSchemaVersionElement)versionA);
        this.actions().updateSchemaVersion((HibFieldSchemaVersionElement)versionB);
        return container;
    }

    private void doSchemaMigration(HibSchemaVersion versionA, HibSchemaVersion versionB) throws Throwable {
        String jobUuid = (String)this.tx(tx -> {
            JobDao jobDao = tx.jobDao();
            return jobDao.enqueueSchemaMigration(this.user(), this.project().getLatestBranch(), versionA, versionB).getUuid();
        });
        this.triggerAndWaitForJob(jobUuid);
    }
}

