/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.schema;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.core.rest.branch.BranchCreateRequest;
import com.gentics.mesh.core.rest.job.JobStatus;
import com.gentics.mesh.core.rest.microschema.impl.MicroschemaCreateRequest;
import com.gentics.mesh.core.rest.microschema.impl.MicroschemaResponse;
import com.gentics.mesh.core.rest.microschema.impl.MicroschemaUpdateRequest;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.NodeUpdateRequest;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.project.ProjectResponse;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.impl.SchemaCreateRequest;
import com.gentics.mesh.core.rest.schema.impl.SchemaResponse;
import com.gentics.mesh.core.rest.schema.impl.SchemaUpdateRequest;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.client.VersioningParametersImpl;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.util.Tuple;
import org.junit.Before;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.PROJECT, startServer=true)
public class NodeMigrationInBranchTest
extends AbstractMeshTest {
    public static final String DEFAULT_BRANCH_NAME = "dummy";
    public static final String BRANCH_NAME = "newbranch";
    public static final String MICROSCHEMA_NAME = "microschema";
    public static final String SCHEMA_NAME = "migration_schema";
    public static final String STRING_FIELD_NAME = "stringfield";
    public static final String NEW_STRING_FIELD_NAME = "new_stringfield";
    public static final String MICRONODE_FIELD_NAME = "micronodefield";
    private MicroschemaResponse microschema;
    private SchemaResponse schema;
    private NodeResponse newInDefault;
    private NodeResponse publishedInDefault;
    private NodeResponse modifiedInDefault;
    private NodeResponse newInBranch;
    private NodeResponse publishedInBranch;
    private NodeResponse modifiedInBranch;

    @Before
    public void setup() {
        MicroschemaCreateRequest microschemaCreateRequest = new MicroschemaCreateRequest().setName(MICROSCHEMA_NAME);
        microschemaCreateRequest.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)STRING_FIELD_NAME));
        this.microschema = (MicroschemaResponse)ClientHelper.call(() -> this.client().createMicroschema(microschemaCreateRequest));
        ClientHelper.call(() -> this.client().assignMicroschemaToProject(DEFAULT_BRANCH_NAME, this.microschema.getUuid()));
        SchemaCreateRequest createSchemaRequest = new SchemaCreateRequest().setName(SCHEMA_NAME);
        createSchemaRequest.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)STRING_FIELD_NAME));
        createSchemaRequest.addField((FieldSchema)FieldUtil.createMicronodeFieldSchema((String)MICRONODE_FIELD_NAME));
        this.schema = (SchemaResponse)ClientHelper.call(() -> this.client().createSchema(createSchemaRequest, new ParameterProvider[0]));
        ClientHelper.call(() -> this.client().assignSchemaToProject(DEFAULT_BRANCH_NAME, this.schema.getUuid()));
        ClientHelper.call(() -> this.client().createBranch(DEFAULT_BRANCH_NAME, new BranchCreateRequest().setName(BRANCH_NAME).setLatest(false), new ParameterProvider[0]));
        ProjectResponse project = (ProjectResponse)ClientHelper.call(() -> this.client().findProjectByName(DEFAULT_BRANCH_NAME, new ParameterProvider[0]));
        this.newInDefault = this.createNode(project.getRootNode().getUuid(), DEFAULT_BRANCH_NAME, false, false);
        this.publishedInDefault = this.createNode(project.getRootNode().getUuid(), DEFAULT_BRANCH_NAME, true, false);
        this.modifiedInDefault = this.createNode(project.getRootNode().getUuid(), DEFAULT_BRANCH_NAME, true, true);
        this.newInBranch = this.createNode(project.getRootNode().getUuid(), BRANCH_NAME, false, false);
        this.publishedInBranch = this.createNode(project.getRootNode().getUuid(), BRANCH_NAME, true, false);
        this.modifiedInBranch = this.createNode(project.getRootNode().getUuid(), BRANCH_NAME, true, true);
    }

    @Test
    public void testNodeMigration() {
        this.waitForJobs(() -> {
            SchemaUpdateRequest updateSchema = new SchemaUpdateRequest();
            updateSchema.setName(SCHEMA_NAME);
            updateSchema.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)NEW_STRING_FIELD_NAME));
            ClientHelper.call(() -> this.client().updateSchema(this.schema.getUuid(), updateSchema, new ParameterProvider[0]));
        }, JobStatus.COMPLETED, 2);
        this.assertVersions(this.newInDefault.getUuid(), "en", "D(0.2)=>I(0.1)", DEFAULT_BRANCH_NAME);
        this.assertVersions(this.publishedInDefault.getUuid(), "en", "PD(2.0)=>I(0.1)", DEFAULT_BRANCH_NAME);
        this.assertVersions(this.modifiedInDefault.getUuid(), "en", "D(2.1)=>P(2.0)=>I(0.1)", DEFAULT_BRANCH_NAME);
        this.assertVersions(this.newInBranch.getUuid(), "en", "D(0.2)=>I(0.1)", BRANCH_NAME);
        this.assertVersions(this.publishedInBranch.getUuid(), "en", "PD(2.0)=>I(0.1)", BRANCH_NAME);
        this.assertVersions(this.modifiedInBranch.getUuid(), "en", "D(2.1)=>P(2.0)=>I(0.1)", BRANCH_NAME);
    }

    @Test
    public void testMicronodeMigration() {
        this.waitForJobs(() -> {
            MicroschemaUpdateRequest updateRequest = new MicroschemaUpdateRequest();
            updateRequest.setName(MICROSCHEMA_NAME);
            updateRequest.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)NEW_STRING_FIELD_NAME));
            ClientHelper.call(() -> this.client().updateMicroschema(this.microschema.getUuid(), updateRequest, new ParameterProvider[0]));
        }, JobStatus.COMPLETED, 2);
        this.assertVersions(this.newInDefault.getUuid(), "en", "D(0.2)=>I(0.1)", DEFAULT_BRANCH_NAME);
        this.assertVersions(this.publishedInDefault.getUuid(), "en", "PD(2.0)=>I(0.1)", DEFAULT_BRANCH_NAME);
        this.assertVersions(this.modifiedInDefault.getUuid(), "en", "D(2.1)=>P(2.0)=>I(0.1)", DEFAULT_BRANCH_NAME);
        this.assertVersions(this.newInBranch.getUuid(), "en", "D(0.2)=>I(0.1)", BRANCH_NAME);
        this.assertVersions(this.publishedInBranch.getUuid(), "en", "PD(2.0)=>I(0.1)", BRANCH_NAME);
        this.assertVersions(this.modifiedInBranch.getUuid(), "en", "D(2.1)=>P(2.0)=>I(0.1)", BRANCH_NAME);
    }

    protected NodeResponse createNode(String parentNodeUuid, String branchName, boolean publish, boolean modify) {
        NodeCreateRequest createNodeRequest = new NodeCreateRequest().setLanguage("en").setSchemaName(SCHEMA_NAME).setParentNodeUuid(parentNodeUuid);
        createNodeRequest.getFields().put(STRING_FIELD_NAME, (Field)FieldUtil.createStringField((String)"field value"));
        createNodeRequest.getFields().put(MICRONODE_FIELD_NAME, (Field)FieldUtil.createMicronodeField((String)MICROSCHEMA_NAME, (Tuple[])new Tuple[]{Tuple.tuple((Object)STRING_FIELD_NAME, (Object)FieldUtil.createStringField((String)"micro value"))}));
        NodeResponse node = (NodeResponse)ClientHelper.call(() -> this.client().createNode(DEFAULT_BRANCH_NAME, createNodeRequest, new ParameterProvider[]{new VersioningParametersImpl().setBranch(branchName)}));
        if (publish) {
            ClientHelper.call(() -> this.client().publishNode(DEFAULT_BRANCH_NAME, node.getUuid(), new ParameterProvider[]{new VersioningParametersImpl().setBranch(branchName)}));
        }
        if (modify) {
            NodeUpdateRequest updateNodeRequest = new NodeUpdateRequest().setLanguage("en").setVersion("draft");
            updateNodeRequest.getFields().put(STRING_FIELD_NAME, (Field)FieldUtil.createStringField((String)"modified field value"));
            updateNodeRequest.getFields().put(MICRONODE_FIELD_NAME, (Field)FieldUtil.createMicronodeField((String)MICROSCHEMA_NAME, (Tuple[])new Tuple[]{Tuple.tuple((Object)STRING_FIELD_NAME, (Object)FieldUtil.createStringField((String)"modified micro value"))}));
            ClientHelper.call(() -> this.client().updateNode(DEFAULT_BRANCH_NAME, node.getUuid(), updateNodeRequest, new ParameterProvider[]{new VersioningParametersImpl().setBranch(branchName)}));
        }
        return node;
    }
}

