/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.schema;

import com.gentics.mesh.core.rest.node.FieldMap;
import com.gentics.mesh.core.rest.node.FieldMapImpl;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.impl.NodeFieldImpl;
import com.gentics.mesh.core.rest.node.field.list.impl.NodeFieldListImpl;
import com.gentics.mesh.core.rest.node.field.list.impl.NodeFieldListItemImpl;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.impl.ListFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.NodeFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.SchemaCreateRequest;
import com.gentics.mesh.core.rest.schema.impl.SchemaResponse;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.Collections;
import org.junit.Before;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.TRACKING, testSize=TestSize.FULL, startServer=true)
public class SchemaAllowNodeFieldTest
extends AbstractMeshTest {
    private String nodeUuid;
    private String testNodeUuid;

    @Before
    public void setUp() throws Exception {
        this.nodeUuid = (String)this.tx(() -> this.folder("2015").getUuid());
    }

    private void createSchema(FieldSchema field) {
        field.setName("testField");
        SchemaCreateRequest req = new SchemaCreateRequest();
        req.setName("test");
        req.setFields(Collections.singletonList(field));
        SchemaResponse response = (SchemaResponse)this.client().createSchema(req, new ParameterProvider[0]).blockingGet();
        this.client().assignSchemaToProject("dummy", response.getUuid()).blockingAwait();
    }

    private void createNode(Field field) {
        NodeCreateRequest req = new NodeCreateRequest();
        req.setLanguage("en");
        req.setSchemaName("test");
        req.setParentNodeUuid(this.nodeUuid);
        FieldMapImpl fieldMap = new FieldMapImpl();
        fieldMap.put("testField", field);
        req.setFields((FieldMap)fieldMap);
        this.client().createNode("dummy", req, new ParameterProvider[0]).blockingAwait();
    }

    private void createTestNode() {
        NodeCreateRequest nodeReq = new NodeCreateRequest();
        nodeReq.setLanguage("en");
        nodeReq.setSchemaName("test");
        nodeReq.setParentNodeUuid(this.nodeUuid);
        NodeResponse createdNode = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", nodeReq, new ParameterProvider[0]));
        this.testNodeUuid = createdNode.getUuid();
    }

    private void createNodeAndExpectFailure(Field field) {
        NodeCreateRequest req = new NodeCreateRequest();
        req.setLanguage("en");
        req.setSchemaName("test");
        req.setParentNodeUuid(this.nodeUuid);
        FieldMapImpl fieldMap = new FieldMapImpl();
        fieldMap.put("testField", field);
        req.setFields((FieldMap)fieldMap);
        ClientHelper.call(() -> this.client().createNode("dummy", req, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"node_error_invalid_schema_field_value", (String[])new String[]{"testField", "test"});
    }

    private void runTest(Field nodeField) {
        this.createNode(nodeField);
    }

    private void runTestAndExpectFailure(Field nodeField) {
        this.createNodeAndExpectFailure(nodeField);
    }

    @Test
    public void node() {
        this.createSchema((FieldSchema)new NodeFieldSchemaImpl().setAllowedSchemas(new String[]{"test"}));
        this.createTestNode();
        this.runTest((Field)new NodeFieldImpl().setUuid(this.testNodeUuid));
    }

    @Test
    public void nodeNotAllowed() {
        this.createSchema((FieldSchema)new NodeFieldSchemaImpl().setAllowedSchemas(new String[]{"test2"}));
        this.createTestNode();
        this.runTestAndExpectFailure((Field)new NodeFieldImpl().setUuid(this.testNodeUuid));
    }

    @Test
    public void nodeList() {
        this.createSchema((FieldSchema)new ListFieldSchemaImpl().setListType("node").setAllowedSchemas(new String[]{"test"}));
        this.createTestNode();
        this.runTest((Field)new NodeFieldListImpl().setItems(Collections.singletonList(new NodeFieldListItemImpl().setUuid(this.testNodeUuid))));
    }

    @Test
    public void nodeListNotAllowed() {
        this.createSchema((FieldSchema)new ListFieldSchemaImpl().setListType("node").setAllowedSchemas(new String[]{"test2"}));
        this.createTestNode();
        this.runTestAndExpectFailure((Field)new NodeFieldListImpl().setItems(Collections.singletonList(new NodeFieldListItemImpl().setUuid(this.testNodeUuid))));
    }
}

