/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.schema;

import com.gentics.mesh.core.data.dao.PersistingSchemaDao;
import com.gentics.mesh.core.data.schema.HibFieldSchemaElement;
import com.gentics.mesh.core.data.schema.HibFieldSchemaVersionElement;
import com.gentics.mesh.core.data.schema.HibMicroschema;
import com.gentics.mesh.core.data.schema.HibMicroschemaVersion;
import com.gentics.mesh.core.data.schema.HibRemoveFieldChange;
import com.gentics.mesh.core.data.schema.HibSchema;
import com.gentics.mesh.core.data.schema.HibSchemaChange;
import com.gentics.mesh.core.data.schema.HibSchemaVersion;
import com.gentics.mesh.core.db.CommonTx;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.schema.change.impl.SchemaChangeOperation;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.util.UUIDUtil;
import java.util.function.Function;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class SchemaChangeTest
extends AbstractMeshTest {
    @Test
    public void testDomainModel() {
        try (Tx tx = this.tx();){
            CommonTx ctx = (CommonTx)tx;
            PersistingSchemaDao schemaDao = ctx.schemaDao();
            HibSchema container = (HibSchema)schemaDao.createPersisted(UUIDUtil.randomUUID());
            HibSchemaVersion versionA = this.createSchemaVersion((Tx)ctx, container, v -> container.setLatestVersion((HibFieldSchemaVersionElement)v));
            HibSchemaVersion versionB = this.createSchemaVersion((Tx)ctx, container, v -> {});
            HibSchemaVersion versionC = this.createSchemaVersion((Tx)ctx, container, v -> {});
            HibRemoveFieldChange change = (HibRemoveFieldChange)schemaDao.createPersistedChange((HibFieldSchemaVersionElement)versionA, SchemaChangeOperation.REMOVEFIELD);
            container.setLatestVersion((HibFieldSchemaVersionElement)versionA);
            Assert.assertEquals((String)"The uuid of the latest version did not match to versionA's uuid.", (Object)versionA.getUuid(), (Object)((HibSchemaVersion)container.getLatestVersion()).getUuid());
            Assert.assertNull((String)"The previous change should be null since we did not link it to any schema version.", (Object)versionA.getPreviousChange());
            Assert.assertNull((String)"The next change should be null since we did not link it to any schema version.", (Object)versionA.getNextChange());
            versionA.setNextChange((HibSchemaChange)change);
            Assert.assertNotNull((String)"The next change was not found but we linked it to the schema container.", (Object)versionA.getNextChange());
            versionA.setPreviousChange((HibSchemaChange)change);
            Assert.assertNotNull((String)"The previous change was not found but we linked it to the schema container.", (Object)versionA.getPreviousChange());
            Assert.assertNull((String)"The next version was not yet set and thus should be null but it was not.", (Object)versionB.getNextVersion());
            versionB.setNextVersion((HibFieldSchemaVersionElement)versionC);
            Assert.assertNotNull((Object)versionB.getNextVersion());
            Assert.assertNull((String)"The next version was not yet set and thus should be null but it was not.", (Object)versionB.getPreviousVersion());
            versionB.setPreviousVersion((HibFieldSchemaVersionElement)versionA);
            Assert.assertNotNull((Object)versionB.getPreviousVersion());
        }
    }

    @Test
    public void testMicroschemaChanges() {
        try (Tx tx = this.tx();){
            CommonTx ctx = (CommonTx)tx;
            HibMicroschema container = this.createMicroschema((Tx)ctx);
            HibMicroschemaVersion versionA = this.createMicroschemaVersion((Tx)ctx, container, v -> container.setLatestVersion(v));
            HibMicroschemaVersion versionB = this.createMicroschemaVersion((Tx)ctx, container, v -> {});
            container.setLatestVersion(versionB);
            HibSchemaChange<?> oldChange = this.chainChanges((HibFieldSchemaVersionElement)versionA, (HibFieldSchemaVersionElement)versionB, version -> ctx.microschemaDao().createPersistedChange((HibFieldSchemaVersionElement)((HibMicroschemaVersion)version), SchemaChangeOperation.REMOVEFIELD));
            this.validate((HibFieldSchemaElement)container, (HibFieldSchemaVersionElement)versionA, (HibFieldSchemaVersionElement)versionB, oldChange, container1 -> this.createMicroschemaVersion((Tx)CommonTx.get(), (HibMicroschema)container1, v -> {}));
        }
    }

    @Test
    public void testChangeChain() {
        try (Tx tx = this.tx();){
            CommonTx ctx = (CommonTx)tx;
            HibSchema container = this.createSchema((Tx)ctx);
            HibSchemaVersion versionA = this.createSchemaVersion((Tx)ctx, container, v -> container.setLatestVersion((HibFieldSchemaVersionElement)v));
            HibSchemaVersion versionB = this.createSchemaVersion((Tx)ctx, container, v -> {});
            container.setLatestVersion((HibFieldSchemaVersionElement)versionA);
            HibSchemaChange<?> oldChange = this.chainChanges((HibFieldSchemaVersionElement)versionA, (HibFieldSchemaVersionElement)versionB, version -> ctx.schemaDao().createPersistedChange((HibFieldSchemaVersionElement)((HibSchemaVersion)version), SchemaChangeOperation.REMOVEFIELD));
            this.validate((HibFieldSchemaElement)container, (HibFieldSchemaVersionElement)versionA, (HibFieldSchemaVersionElement)versionB, oldChange, container1 -> this.createSchemaVersion((Tx)CommonTx.get(), (HibSchema)container1, v -> {}));
        }
    }

    private HibSchemaChange<?> chainChanges(HibFieldSchemaVersionElement versionA, HibFieldSchemaVersionElement versionB, Function<HibFieldSchemaVersionElement, HibSchemaChange<?>> schemaChangeProvider) {
        HibSchemaChange<?> oldChange = null;
        for (int i = 0; i < 3; ++i) {
            HibSchemaChange<?> change = schemaChangeProvider.apply(versionB);
            if (oldChange == null) {
                oldChange = change;
                Assert.assertNull((String)"The change has not yet been connected to any schema", (Object)oldChange.getPreviousContainerVersion());
                versionA.setNextChange(oldChange);
                Assert.assertNotNull((String)"The change has been connected to the schema container and thus the connection should be loadable", (Object)oldChange.getPreviousContainerVersion());
                continue;
            }
            oldChange.setNextChange(change);
            oldChange = change;
        }
        return oldChange;
    }

    private void validate(HibFieldSchemaElement container, HibFieldSchemaVersionElement versionA, HibFieldSchemaVersionElement versionB, HibSchemaChange<?> oldChange, Function<HibFieldSchemaElement, HibFieldSchemaVersionElement> schemaVersionProvider) {
        versionA.setNextVersion(versionB);
        Assert.assertNull((Object)oldChange.getNextContainerVersion());
        oldChange.setNextSchemaContainerVersion(versionB);
        Assert.assertNotNull((Object)oldChange.getNextContainerVersion());
        Assert.assertNotNull((String)"The containerA should have a next change", (Object)versionA.getNextChange());
        Assert.assertNull((String)"The container should not have any previous change", (Object)versionA.getPreviousChange());
        HibSchemaChange secondLastChange = versionA.getNextChange().getNextChange();
        HibSchemaChange lastChange = secondLastChange.getNextChange();
        Assert.assertNull((String)"This is the last change in the chain and thus no next change should be set", (Object)lastChange.getNextChange());
        Assert.assertEquals((String)"The previous change from the last change should be the second last change.", (Object)secondLastChange.getUuid(), (Object)lastChange.getPreviousChange().getUuid());
        Assert.assertEquals((String)"The last change should be connected to the containerB but it was not.", (Object)versionB.getUuid(), (Object)lastChange.getNextContainerVersion().getUuid());
        Assert.assertNull((String)"The change has no from schema container because it it part of a chain of changes.", (Object)lastChange.getPreviousContainerVersion());
        Assert.assertEquals((String)"The previous change of the schema that was connected to the last change did not match the last change.", (Object)lastChange.getUuid(), (Object)lastChange.getNextContainerVersion().getPreviousChange().getUuid());
        HibFieldSchemaVersionElement versionC = schemaVersionProvider.apply(container);
        HibSchemaChange firstChange = versionA.getNextChange();
        firstChange.setPreviousContainerVersion(versionC);
        Assert.assertNotEquals((String)"The first change should no longer be connected to containerA", (Object)versionA.getUuid(), (Object)firstChange.getPreviousContainerVersion().getUuid());
        Assert.assertEquals((String)"The chain of changes should now be connected to container version C", (Object)versionC.getUuid(), (Object)firstChange.getPreviousContainerVersion().getUuid());
        Assert.assertNotNull((String)"Version A should have a next version.", (Object)versionA.getNextVersion());
        Assert.assertEquals((String)"Version B should be the next version of version A.", (Object)versionB.getUuid(), (Object)versionA.getNextVersion().getUuid());
        container.setLatestVersion(versionB);
        HibFieldSchemaVersionElement latest = container.getLatestVersion();
        Assert.assertNotNull((String)"There should always be a latest version", (Object)latest);
        Assert.assertEquals((String)"Version B should represent the latest version but it did not", (Object)versionB.getUuid(), (Object)latest.getUuid());
    }
}

