/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.schema;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.HibNodeFieldContainer;
import com.gentics.mesh.core.data.branch.HibBranch;
import com.gentics.mesh.core.data.dao.ContentDao;
import com.gentics.mesh.core.data.dao.SchemaDao;
import com.gentics.mesh.core.data.dao.UserDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.perm.InternalPermission;
import com.gentics.mesh.core.data.schema.HibFieldSchemaElement;
import com.gentics.mesh.core.data.schema.HibSchema;
import com.gentics.mesh.core.data.schema.HibSchemaVersion;
import com.gentics.mesh.core.db.CommonTx;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.MeshEvent;
import com.gentics.mesh.core.rest.common.ContainerType;
import com.gentics.mesh.core.rest.common.GenericMessageResponse;
import com.gentics.mesh.core.rest.error.GenericRestException;
import com.gentics.mesh.core.rest.event.impl.MeshElementEventModelImpl;
import com.gentics.mesh.core.rest.job.JobStatus;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.NodeUpdateRequest;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.impl.NumberFieldImpl;
import com.gentics.mesh.core.rest.node.field.impl.StringFieldImpl;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.ListFieldSchema;
import com.gentics.mesh.core.rest.schema.SchemaModel;
import com.gentics.mesh.core.rest.schema.SchemaReference;
import com.gentics.mesh.core.rest.schema.StringFieldSchema;
import com.gentics.mesh.core.rest.schema.change.impl.SchemaChangeModel;
import com.gentics.mesh.core.rest.schema.change.impl.SchemaChangesListModel;
import com.gentics.mesh.core.rest.schema.impl.ListFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.SchemaReferenceImpl;
import com.gentics.mesh.core.rest.schema.impl.SchemaResponse;
import com.gentics.mesh.core.rest.schema.impl.SchemaUpdateRequest;
import com.gentics.mesh.json.JsonUtil;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.SchemaUpdateParametersImpl;
import com.gentics.mesh.parameter.impl.VersioningParametersImpl;
import com.gentics.mesh.search.AbstractNodeSearchEndpointTest;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.category.FailingTests;
import com.gentics.mesh.test.util.TestUtils;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.util.Objects;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.testcontainers.shaded.com.google.common.collect.Iterators;

@RunWith(value=Parameterized.class)
@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class SchemaChangesEndpointTest
extends AbstractNodeSearchEndpointTest {
    public SchemaChangesEndpointTest(ElasticsearchTestMode elasticsearch) throws Exception {
        super(elasticsearch);
    }

    @Test
    public void testUpdateName() throws GenericRestException, Exception {
        String name = "new_name";
        HibSchema schemaContainer = this.schemaContainer("content");
        String schemaUuid = (String)this.tx(() -> schemaContainer.getUuid());
        HibSchemaVersion currentVersion = (HibSchemaVersion)this.tx(() -> (HibSchemaVersion)schemaContainer.getLatestVersion());
        SchemaUpdateRequest request = (SchemaUpdateRequest)JsonUtil.readValue((String)((String)this.tx(() -> ((HibSchemaVersion)schemaContainer.getLatestVersion()).getJson())), SchemaUpdateRequest.class);
        request.setName(name);
        this.mesh().serverSchemaStorage().clear();
        this.waitForJobs(() -> {
            GenericMessageResponse message = (GenericMessageResponse)ClientHelper.call(() -> this.client().updateSchema(schemaUuid, request, new ParameterProvider[0]));
            MeshAssertions.assertThat((GenericMessageResponse)message).matches("schema_updated_migration_invoked", new String[]{"content", "2.0"});
        }, JobStatus.COMPLETED, 1);
        try (Tx tx = this.tx();){
            SchemaDao schemaDao = tx.schemaDao();
            currentVersion = this.reloadSchemaVersion(currentVersion);
            Assert.assertEquals((String)"The name of the old version should not be updated", (Object)"content", (Object)currentVersion.getName());
            Assert.assertEquals((String)"The name of the schema was not updated", (Object)name, (Object)((HibSchemaVersion)currentVersion.getNextVersion()).getName());
            HibSchema reloaded = (HibSchema)schemaDao.findByUuid(schemaUuid);
            Assert.assertEquals((String)"The name should have been updated", (Object)name, (Object)reloaded.getName());
        }
    }

    @Test
    public void testApplyChanges() throws IOException {
        String json = TestUtils.getJson((String)"schema-changes.json");
        String uuid = (String)this.tx(() -> this.schemaContainer("folder").getUuid());
        SchemaChangesListModel changes = (SchemaChangesListModel)JsonUtil.readValue((String)json, SchemaChangesListModel.class);
        this.expect(MeshEvent.SCHEMA_UPDATED).match(1, MeshElementEventModelImpl.class, event -> {
            Assert.assertEquals((Object)"folder", (Object)event.getName());
            Assert.assertEquals((Object)uuid, (Object)event.getUuid());
        }).one();
        this.expect(MeshEvent.SCHEMA_MIGRATION_START).none();
        ClientHelper.call(() -> this.client().applyChangesToSchema(uuid, changes));
        this.awaitEvents();
        SchemaResponse response = (SchemaResponse)ClientHelper.call(() -> this.client().findSchemaByUuid(uuid, new ParameterProvider[0]));
        Assert.assertEquals((Object)"string", (Object)response.getField("pub_dir").getType());
        Assert.assertNull((String)"Slug should have been removed.", (Object)response.getField("slug"));
        Assert.assertEquals((Object)"pub_dir", (Object)response.getDisplayField());
        Assert.assertEquals((Object)"name", (Object)response.getSegmentField());
        Assert.assertEquals((long)2L, (long)response.getFields().size());
    }

    @Test
    public void testUpdateWithConflictingName() {
        try (Tx tx = this.tx();){
            String name = "folder";
            String originalSchemaName = "content";
            HibSchema schema = this.schemaContainer(originalSchemaName);
            SchemaUpdateRequest request = (SchemaUpdateRequest)JsonUtil.readValue((String)((HibSchemaVersion)schema.getLatestVersion()).getJson(), SchemaUpdateRequest.class);
            this.mesh().serverSchemaStorage().clear();
            request.setName(name);
            ClientHelper.call(() -> this.client().updateSchema(schema.getUuid(), request, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.CONFLICT, (String)"schema_conflicting_name", (String[])new String[]{name});
            Assert.assertEquals((String)"The name of the schema was updated", (Object)originalSchemaName, (Object)((HibSchemaVersion)schema.getLatestVersion()).getName());
        }
    }

    private SchemaUpdateRequest buildListFieldUpdateRequest(SchemaResponse schema) {
        SchemaUpdateRequest req = new SchemaUpdateRequest();
        req.setName(schema.getName());
        req.setFields(schema.getFields());
        return req;
    }

    @Test
    public void testListTypeChange() throws Exception {
        HibSchema schemaContainer = this.schemaContainer("content");
        String schemaUuid = (String)this.tx(() -> schemaContainer.getUuid());
        SchemaResponse schema = (SchemaResponse)ClientHelper.call(() -> this.client().findSchemaByUuid(schemaUuid, new ParameterProvider[0]));
        ListFieldSchemaImpl listField = new ListFieldSchemaImpl();
        listField.setListType("string");
        listField.setName("testListType");
        listField.setLabel("testListTypeLabel");
        schema.getFields().add(listField);
        this.waitForJobs(() -> ClientHelper.call(() -> this.client().updateSchema(schemaUuid, this.buildListFieldUpdateRequest(schema), new ParameterProvider[0])), JobStatus.COMPLETED, 1);
        SchemaResponse updated = (SchemaResponse)ClientHelper.call(() -> this.client().findSchemaByUuid(schemaUuid, new ParameterProvider[0]));
        Assert.assertNotNull((String)"The new field should have been added to the schema.", (Object)updated.getField("testListType"));
        listField = (ListFieldSchema)updated.getField("testListType");
        Assert.assertEquals((String)"The list type should be string.", (Object)"string", (Object)listField.getListType());
        listField.setListType("micronode");
        this.waitForJobs(() -> ClientHelper.call(() -> this.client().updateSchema(schemaUuid, this.buildListFieldUpdateRequest(updated), new ParameterProvider[0])), JobStatus.COMPLETED, 1);
        SchemaResponse changed = (SchemaResponse)ClientHelper.call(() -> this.client().findSchemaByUuid(schemaUuid, new ParameterProvider[0]));
        Assert.assertNotNull((String)"The new field should still be in the schema.", (Object)changed.getField("testListType"));
        listField = (ListFieldSchema)changed.getField("testListType");
        Assert.assertEquals((String)"The list type should have changed to micronode.", (Object)"micronode", (Object)listField.getListType());
    }

    @Test
    public void testFieldTypeChange() throws Exception {
        HibSchema schemaContainer = this.schemaContainer("content");
        String schemaUuid = (String)this.tx(() -> schemaContainer.getUuid());
        HibSchemaVersion currentVersion = (HibSchemaVersion)this.tx(() -> (HibSchemaVersion)schemaContainer.getLatestVersion());
        Assert.assertNull((String)"The schema should not yet have any changes", this.tx(() -> currentVersion.getNextChange()));
        SchemaChangesListModel listOfChanges = new SchemaChangesListModel();
        SchemaChangeModel change = SchemaChangeModel.createChangeFieldTypeChange((String)"content", (String)"boolean");
        listOfChanges.getChanges().add(change);
        GenericMessageResponse status = (GenericMessageResponse)ClientHelper.call(() -> this.client().applyChangesToSchema(schemaUuid, listOfChanges));
        MeshAssertions.assertThat((GenericMessageResponse)status).matches("schema_changes_applied", new String[]{"content"});
        SchemaResponse updatedSchema = (SchemaResponse)ClientHelper.call(() -> this.client().findSchemaByUuid(schemaUuid, new ParameterProvider[0]));
        this.waitForJobs(() -> ClientHelper.call(() -> this.client().assignBranchSchemaVersions("dummy", this.initialBranchUuid(), new SchemaReference[]{((SchemaReference)new SchemaReferenceImpl().setName("content")).setVersion(updatedSchema.getVersion())})), JobStatus.COMPLETED, 1);
        try (Tx tx = this.tx();){
            HibSchemaVersion reloaded = this.reloadSchemaVersion(currentVersion);
            Assert.assertNotNull((String)"The change should have been added to the schema.", (Object)reloaded.getNextChange());
            Assert.assertNotNull((String)"The container should now have a new version", (Object)reloaded.getNextVersion());
            HibNode node = this.content();
            Assert.assertTrue((String)"The version of the original schema and the schema that is now linked to the node should be different.", (!Objects.equals(reloaded.getVersion(), tx.contentDao().getFieldContainer(node, "en").getSchemaContainerVersion().getVersion()) ? 1 : 0) != 0);
            Assert.assertNull((String)"There should no longer be a content field of type html", (Object)tx.contentDao().getFieldContainer(node, "en").getHtml("content"));
        }
    }

    @Test
    public void testRemoveAddFieldTypeWithSameKey() throws Exception {
        SchemaUpdateRequest request;
        HibSchema schemaContainer = this.schemaContainer("content");
        try (Tx tx = this.tx();){
            HibNode content = this.content();
            ContentDao contentDao = tx.contentDao();
            HibNodeFieldContainer original = contentDao.getLatestDraftFieldContainer(content, this.english());
            HibNodeFieldContainer newContainer = contentDao.createFieldContainer(content, this.english(), this.project().getLatestBranch(), this.user(), original, true);
            newContainer.getHtml("content").setHtml("42.1");
            request = (SchemaUpdateRequest)JsonUtil.readValue((String)((HibSchemaVersion)schemaContainer.getLatestVersion()).getJson(), SchemaUpdateRequest.class);
            request.removeField("content");
            request.addField((FieldSchema)FieldUtil.createNumberFieldSchema((String)"content"));
            tx.success();
        }
        this.mesh().serverSchemaStorage().clear();
        tx = this.tx();
        try {
            GenericMessageResponse status = (GenericMessageResponse)ClientHelper.call(() -> this.client().updateSchema(schemaContainer.getUuid(), request, new ParameterProvider[]{new SchemaUpdateParametersImpl().setUpdateAssignedBranches(false)}));
            MeshAssertions.assertThat((GenericMessageResponse)status).matches("schema_updated_migration_deferred", new String[]{request.getName(), "2.0"});
            SchemaResponse updatedSchema = (SchemaResponse)ClientHelper.call(() -> this.client().findSchemaByUuid(schemaContainer.getUuid(), new ParameterProvider[0]));
            this.waitForJobs(() -> ClientHelper.call(() -> this.client().assignBranchSchemaVersions("dummy", this.project().getLatestBranch().getUuid(), new SchemaReference[]{((SchemaReference)new SchemaReferenceImpl().setName("content")).setVersion(updatedSchema.getVersion())})), JobStatus.COMPLETED, 1);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.tx();
        try {
            request.setVersion(request.getVersion() + "1");
            NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", this.contentUuid(), new ParameterProvider[]{new VersioningParametersImpl().draft()}));
            Assert.assertNotNull((String)"The response should contain the content field.", (Object)response.getFields().hasField("content"));
            Assert.assertEquals((String)"The type of the content field was not changed to a number field.", NumberFieldImpl.class, response.getFields().getNumberField("content").getClass());
            Assert.assertEquals((Object)"2.1", (Object)response.getVersion());
            NodeUpdateRequest nodeUpdateRequest = new NodeUpdateRequest();
            nodeUpdateRequest.setLanguage("en");
            nodeUpdateRequest.getFields().put("content", (Field)new NumberFieldImpl().setNumber((Number)42.01));
            nodeUpdateRequest.setVersion("2.1");
            response = (NodeResponse)ClientHelper.call(() -> this.client().updateNode("dummy", this.contentUuid(), nodeUpdateRequest, new ParameterProvider[0]));
            Assert.assertNotNull((Object)response);
            Assert.assertNotNull((Object)response.getFields().hasField("content"));
            Assert.assertEquals((Object)42.01, (Object)response.getFields().getNumberField("content").getNumber());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testApplyWithEmptyChangesList() {
        try (Tx tx = this.tx();){
            HibSchema container = this.schemaContainer("content");
            SchemaChangesListModel listOfChanges = new SchemaChangesListModel();
            ClientHelper.call(() -> this.client().applyChangesToSchema(container.getUuid(), listOfChanges), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"schema_migration_no_changes_specified", (String[])new String[0]);
        }
    }

    @Test
    public void testUnsetSegmentField() throws JsonParseException, JsonMappingException, IOException {
        SchemaChangesListModel listOfChanges = new SchemaChangesListModel();
        SchemaChangeModel change = SchemaChangeModel.createUpdateSchemaChange();
        change.setProperty("segmentFieldname", null);
        listOfChanges.getChanges().add(change);
        String uuid = (String)this.db().tx(() -> this.schemaContainer("content").getUuid());
        HibSchemaVersion currentVersion = (HibSchemaVersion)this.db().tx(() -> {
            HibSchema container = this.schemaContainer("content");
            HibSchemaVersion version = (HibSchemaVersion)container.getLatestVersion();
            Assert.assertNull((String)"The schema should not yet have any changes", (Object)version.getNextChange());
            return version;
        });
        ClientHelper.call(() -> this.client().applyChangesToSchema(uuid, listOfChanges));
        try (Tx tx = this.tx();){
            HibSchema container = this.schemaContainer("content");
            currentVersion = this.reloadSchemaVersion(currentVersion);
            Assert.assertNull((String)"The segment field reference should have been set to null", (Object)((HibSchemaVersion)currentVersion.getNextVersion()).getSchema().getSegmentField());
        }
    }

    @Test
    public void testRemoveSegmentField() throws Exception {
        HibNode node = this.content();
        HibSchema container = this.schemaContainer("content");
        SchemaChangesListModel listOfChanges = new SchemaChangesListModel();
        try (Tx tx = this.tx();){
            Assert.assertNotNull((String)"The node should have a filename string graph field", (Object)tx.contentDao().getFieldContainer(node, "en").getString("slug"));
            SchemaChangeModel change = SchemaChangeModel.createRemoveFieldChange((String)"slug");
            listOfChanges.getChanges().add(change);
            tx.success();
        }
        tx = this.tx();
        try {
            Assert.assertNull((String)"The schema should not yet have any changes", (Object)((HibSchemaVersion)container.getLatestVersion()).getNextChange());
            ClientHelper.call(() -> this.client().applyChangesToSchema(container.getUuid(), listOfChanges), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"schema_error_segmentfield_invalid", (String[])new String[]{"slug"});
            HibNodeFieldContainer fieldContainer = tx.contentDao().getFieldContainer(node, "en");
            Assert.assertNull((String)"The node should still have a filename string graph field", (Object)fieldContainer.getHtml("slug"));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testRemoveField() throws Exception {
        HibNode node = this.content();
        HibSchema schemaContainer = this.schemaContainer("content");
        String schemaUuid = (String)this.tx(() -> schemaContainer.getUuid());
        HibSchemaVersion currentVersion = (HibSchemaVersion)this.tx(() -> (HibSchemaVersion)schemaContainer.getLatestVersion());
        Assert.assertNotNull((String)"The node should have a html graph field", this.tx(tx -> tx.contentDao().getFieldContainer(node, "en").getHtml("content")));
        SchemaChangesListModel listOfChanges = new SchemaChangesListModel();
        SchemaChangeModel change = SchemaChangeModel.createRemoveFieldChange((String)"content");
        listOfChanges.getChanges().add(change);
        try (Tx tx2 = this.tx();){
            Assert.assertNull((String)"The schema should not yet have any changes", (Object)((HibSchemaVersion)schemaContainer.getLatestVersion()).getNextChange());
        }
        ClientHelper.call(() -> this.client().applyChangesToSchema(schemaUuid, listOfChanges));
        SchemaResponse updatedSchema = (SchemaResponse)ClientHelper.call(() -> this.client().findSchemaByUuid(schemaUuid, new ParameterProvider[0]));
        this.waitForJobs(() -> ClientHelper.call(() -> this.client().assignBranchSchemaVersions("dummy", this.initialBranchUuid(), new SchemaReference[]{((SchemaReference)new SchemaReferenceImpl().setName("content")).setVersion(updatedSchema.getVersion())})), JobStatus.COMPLETED, 1);
        try (Tx tx3 = this.tx();){
            currentVersion = this.reloadSchemaVersion(currentVersion);
            Assert.assertNotNull((String)"The change should have been added to the schema.", (Object)currentVersion.getNextChange());
            HibNodeFieldContainer fieldContainer = tx3.contentDao().getFieldContainer(node, "en");
            Assert.assertNull((String)"The node should no longer have a content html graph field", (Object)fieldContainer.getHtml("content"));
        }
    }

    @Test
    public void testAddField() throws Exception {
        HibSchema schemaContainer = this.schemaContainer("content");
        String schemaUuid = (String)this.tx(() -> schemaContainer.getUuid());
        HibSchemaVersion currentVersion = (HibSchemaVersion)this.tx(() -> (HibSchemaVersion)schemaContainer.getLatestVersion());
        Assert.assertNull((String)"The schema should not yet have any changes", this.tx(() -> currentVersion.getNextChange()));
        SchemaChangesListModel listOfChanges = new SchemaChangesListModel();
        JsonObject elasticSearch = new JsonObject().put("test", (Object)"test");
        SchemaChangeModel change = SchemaChangeModel.createAddFieldChange((String)"newField", (String)"html", (String)"label1234", (JsonObject)elasticSearch);
        listOfChanges.getChanges().add(change);
        GenericMessageResponse status = (GenericMessageResponse)ClientHelper.call(() -> this.client().applyChangesToSchema(schemaUuid, listOfChanges));
        MeshAssertions.assertThat((GenericMessageResponse)status).matches("schema_changes_applied", new String[]{"content"});
        SchemaResponse updatedSchema = (SchemaResponse)ClientHelper.call(() -> this.client().findSchemaByUuid(schemaUuid, new ParameterProvider[0]));
        this.waitForJobs(() -> ClientHelper.call(() -> this.client().assignBranchSchemaVersions("dummy", this.initialBranchUuid(), new SchemaReference[]{((SchemaReference)new SchemaReferenceImpl().setName("content")).setVersion(updatedSchema.getVersion())})), JobStatus.COMPLETED, 1);
        try (Tx tx = this.tx();){
            HibSchemaVersion reloaded = this.reloadSchemaVersion(currentVersion);
            Assert.assertNotNull((String)"The change should have been added to the schema.", (Object)reloaded.getNextChange());
            Assert.assertNotEquals((String)"The container should now have a new version", (Object)reloaded.getUuid(), (Object)((HibSchemaVersion)this.schemaContainer("content").getLatestVersion()).getUuid());
            HibNode node = this.content();
            Assert.assertNotNull((String)"The schema of the node should contain the new field schema", (Object)tx.contentDao().getFieldContainer(node, "en").getSchemaContainerVersion().getSchema().getField("newField"));
            Assert.assertTrue((String)"The version of the original schema and the schema that is now linked to the node should be different.", (!Objects.equals(reloaded.getVersion(), tx.contentDao().getFieldContainer(node, "en").getSchemaContainerVersion().getVersion()) ? 1 : 0) != 0);
            Assert.assertEquals((Object)"label1234", (Object)tx.contentDao().getFieldContainer(node, "en").getSchemaContainerVersion().getSchema().getField("newField").getLabel());
            Assert.assertEquals((Object)elasticSearch, (Object)tx.contentDao().getFieldContainer(node, "en").getSchemaContainerVersion().getSchema().getField("newField").getElasticsearch());
        }
    }

    @Test
    public void testAddRestrictedField() throws Exception {
        HibSchema schemaContainer = this.schemaContainer("content");
        String schemaUuid = (String)this.tx(() -> schemaContainer.getUuid());
        HibSchemaVersion currentVersion = (HibSchemaVersion)this.tx(() -> (HibSchemaVersion)schemaContainer.getLatestVersion());
        Assert.assertNull((String)"The schema should not yet have any changes", this.tx(() -> currentVersion.getNextChange()));
        SchemaChangesListModel listOfChanges = new SchemaChangesListModel();
        SchemaChangeModel change = SchemaChangeModel.createAddFieldChange((String)"newField", (String)"string", (String)"label1234", null);
        change.getProperties().put("allow", new String[]{"5678"});
        listOfChanges.getChanges().add(change);
        GenericMessageResponse status = (GenericMessageResponse)ClientHelper.call(() -> this.client().applyChangesToSchema(schemaUuid, listOfChanges));
        MeshAssertions.assertThat((GenericMessageResponse)status).matches("schema_changes_applied", new String[]{"content"});
        SchemaResponse updatedSchema = (SchemaResponse)ClientHelper.call(() -> this.client().findSchemaByUuid(schemaUuid, new ParameterProvider[0]));
        this.waitForJobs(() -> ClientHelper.call(() -> this.client().assignBranchSchemaVersions("dummy", this.initialBranchUuid(), new SchemaReference[]{((SchemaReference)new SchemaReferenceImpl().setName("content")).setVersion(updatedSchema.getVersion())})), JobStatus.COMPLETED, 1);
        try (Tx tx = this.tx();){
            HibSchemaVersion reloaded = this.reloadSchemaVersion(currentVersion);
            Assert.assertNotNull((String)"The change should have been added to the schema.", (Object)reloaded.getNextChange());
            Assert.assertNotEquals((String)"The container should now have a new version", (Object)reloaded.getUuid(), (Object)((HibSchemaVersion)this.schemaContainer("content").getLatestVersion()).getUuid());
            HibNode node = this.content();
            Assert.assertNotNull((String)"The schema of the node should contain the new field schema", (Object)tx.contentDao().getFieldContainer(node, "en").getSchemaContainerVersion().getSchema().getField("newField"));
            Assert.assertTrue((String)"The version of the original schema and the schema that is now linked to the node should be different.", (!Objects.equals(reloaded.getVersion(), tx.contentDao().getFieldContainer(node, "en").getSchemaContainerVersion().getVersion()) ? 1 : 0) != 0);
            Assert.assertArrayEquals((Object[])new String[]{"5678"}, (Object[])((StringFieldSchema)tx.contentDao().getFieldContainer(node, "en").getSchemaContainerVersion().getSchema().getField("newField", StringFieldSchema.class)).getAllowedValues());
        }
    }

    @Test
    public void testRemoveFieldRestriction() throws Exception {
        HibSchema schemaContainer = this.schemaContainer("content");
        String schemaUuid = (String)this.tx(() -> schemaContainer.getUuid());
        HibSchemaVersion currentVersion = (HibSchemaVersion)this.tx(() -> (HibSchemaVersion)schemaContainer.getLatestVersion());
        Assert.assertNull((String)"The schema should not yet have any changes", this.tx(() -> currentVersion.getNextChange()));
        SchemaChangesListModel listOfChanges = new SchemaChangesListModel();
        SchemaChangeModel change = SchemaChangeModel.createAddFieldChange((String)"newField", (String)"string", (String)"label1234", null);
        change.getProperties().put("allow", new String[]{"5678"});
        listOfChanges.getChanges().add(change);
        GenericMessageResponse status = (GenericMessageResponse)ClientHelper.call(() -> this.client().applyChangesToSchema(schemaUuid, listOfChanges));
        MeshAssertions.assertThat((GenericMessageResponse)status).matches("schema_changes_applied", new String[]{"content"});
        SchemaResponse updatedSchema = (SchemaResponse)ClientHelper.call(() -> this.client().findSchemaByUuid(schemaUuid, new ParameterProvider[0]));
        this.waitForJobs(() -> ClientHelper.call(() -> this.client().assignBranchSchemaVersions("dummy", this.initialBranchUuid(), new SchemaReference[]{((SchemaReference)new SchemaReferenceImpl().setName("content")).setVersion(updatedSchema.getVersion())})), JobStatus.COMPLETED, 1);
        try (Tx tx = this.tx();){
            HibSchemaVersion reloaded = this.reloadSchemaVersion(currentVersion);
            Assert.assertNotNull((String)"The change should have been added to the schema.", (Object)reloaded.getNextChange());
            Assert.assertNotEquals((String)"The container should now have a new version", (Object)reloaded.getUuid(), (Object)((HibSchemaVersion)this.schemaContainer("content").getLatestVersion()).getUuid());
            HibNode node = this.content();
            Assert.assertNotNull((String)"The schema of the node should contain the new field schema", (Object)tx.contentDao().getFieldContainer(node, "en").getSchemaContainerVersion().getSchema().getField("newField"));
            Assert.assertTrue((String)"The version of the original schema and the schema that is now linked to the node should be different.", (!Objects.equals(reloaded.getVersion(), tx.contentDao().getFieldContainer(node, "en").getSchemaContainerVersion().getVersion()) ? 1 : 0) != 0);
            Assert.assertArrayEquals((Object[])new String[]{"5678"}, (Object[])((StringFieldSchema)tx.contentDao().getFieldContainer(node, "en").getSchemaContainerVersion().getSchema().getField("newField", StringFieldSchema.class)).getAllowedValues());
        }
        SchemaChangesListModel listOfChanges2 = new SchemaChangesListModel();
        change = SchemaChangeModel.createFieldRestrictionChange((String)"newField", null);
        listOfChanges2.getChanges().add(change);
        status = (GenericMessageResponse)ClientHelper.call(() -> this.client().applyChangesToSchema(schemaUuid, listOfChanges2));
        MeshAssertions.assertThat((GenericMessageResponse)status).matches("schema_changes_applied", new String[]{"content"});
        SchemaResponse updatedSchema2 = (SchemaResponse)ClientHelper.call(() -> this.client().findSchemaByUuid(schemaUuid, new ParameterProvider[0]));
        this.waitForJobs(() -> ClientHelper.call(() -> this.client().assignBranchSchemaVersions("dummy", this.initialBranchUuid(), new SchemaReference[]{((SchemaReference)new SchemaReferenceImpl().setName("content")).setVersion(updatedSchema2.getVersion())})), JobStatus.COMPLETED, 1);
        try (Tx tx = this.tx();){
            HibSchemaVersion reloaded = this.reloadSchemaVersion(currentVersion);
            Assert.assertNotNull((String)"The change should have been added to the schema.", (Object)reloaded.getNextChange());
            Assert.assertNotEquals((String)"The container should now have a new version", (Object)reloaded.getUuid(), (Object)((HibSchemaVersion)this.schemaContainer("content").getLatestVersion()).getUuid());
            HibNode node = this.content();
            Assert.assertNotNull((String)"The schema of the node should contain the new field schema", (Object)tx.contentDao().getFieldContainer(node, "en").getSchemaContainerVersion().getSchema().getField("newField"));
            Assert.assertTrue((String)"The version of the original schema and the schema that is now linked to the node should be different.", (!Objects.equals(currentVersion.getVersion(), tx.contentDao().getFieldContainer(node, "en").getSchemaContainerVersion().getVersion()) ? 1 : 0) != 0);
            Assert.assertArrayEquals((Object[])new String[0], (Object[])((StringFieldSchema)tx.contentDao().getFieldContainer(node, "en").getSchemaContainerVersion().getSchema().getField("newField", StringFieldSchema.class)).getAllowedValues());
        }
    }

    @Test
    public void testUpdateMultipleTimes() throws Exception {
        HibSchemaVersion currentVersion;
        HibSchema container;
        try (Tx tx = this.tx();){
            container = this.schemaContainer("content");
            currentVersion = (HibSchemaVersion)container.getLatestVersion();
            Assert.assertNull((String)"The schema should not yet have any changes", (Object)currentVersion.getNextChange());
        }
        String containerUuid = (String)this.db().tx(() -> this.schemaContainer("content").getUuid());
        String branchUuid = (String)this.db().tx(() -> this.project().getLatestBranch().getUuid());
        for (int i = 0; i < 10; ++i) {
            SchemaChangesListModel listOfChanges = new SchemaChangesListModel();
            SchemaChangeModel change = SchemaChangeModel.createAddFieldChange((String)("newField_" + i), (String)"html", null, null);
            listOfChanges.getChanges().add(change);
            GenericMessageResponse status = (GenericMessageResponse)ClientHelper.call(() -> this.client().applyChangesToSchema(containerUuid, listOfChanges));
            MeshAssertions.assertThat((GenericMessageResponse)status).matches("schema_changes_applied", new String[]{"content"});
            SchemaResponse updatedSchema = (SchemaResponse)ClientHelper.call(() -> this.client().findSchemaByUuid(containerUuid, new ParameterProvider[0]));
            this.waitForJobs(() -> ClientHelper.call(() -> this.client().assignBranchSchemaVersions("dummy", branchUuid, new SchemaReference[]{((SchemaReference)new SchemaReferenceImpl().setName("content")).setVersion(updatedSchema.getVersion())})), JobStatus.COMPLETED, 1);
            try (Tx tx = this.tx();){
                HibSchemaVersion reloaded = this.reloadSchemaVersion(currentVersion);
                Assert.assertNotNull((String)"The change should have been added to the schema.", (Object)reloaded.getNextChange());
                Assert.assertNotEquals((String)"The container should now have a new version", (Object)reloaded.getUuid(), (Object)((HibSchemaVersion)this.schemaContainer("content").getLatestVersion()).getUuid());
                HibNode node = this.content();
                Assert.assertNotNull((String)"The schema of the node should contain the new field schema", (Object)tx.contentDao().getFieldContainer(node, "en").getSchemaContainerVersion().getSchema().getField("newField_" + i));
                Assert.assertTrue((String)"The version of the original schema and the schema that is now linked to the node should be different.", (!Objects.equals(reloaded.getVersion(), tx.contentDao().getFieldContainer(node, "en").getSchemaContainerVersion().getVersion()) ? 1 : 0) != 0);
                continue;
            }
        }
        try (Tx tx = this.tx();){
            UserDao userDao = tx.userDao();
            SchemaDao schemaDao = tx.schemaDao();
            Assert.assertEquals((String)"We invoked 10 migration. Thus we expect 11 versions.", (long)11L, (long)Iterators.size(schemaDao.findAllVersions((HibFieldSchemaElement)container).iterator()));
            Assert.assertNull((String)"The last version should not have any changes", (Object)((HibSchemaVersion)container.getLatestVersion()).getNextChange());
            Assert.assertNull((String)"The last version should not have any futher versions", (Object)((HibSchemaVersion)container.getLatestVersion()).getNextVersion());
            HibSchemaVersion version = (HibSchemaVersion)this.schemaContainer("content").getLatestVersion();
            int nVersions = 0;
            while ((version = (HibSchemaVersion)version.getPreviousVersion()) != null) {
                Assert.assertNotNull((String)("The schema version {" + version.getUuid() + "-" + version.getVersion() + "} should have a next change"), (Object)version.getNextChange());
                Assert.assertEquals((String)"The version is not referencing the correct parent container.", (Object)container.getUuid(), (Object)version.getSchemaContainer().getUuid());
                ++nVersions;
            }
            Assert.assertEquals((String)"The latest version should have exactly 10 previous versions.", (long)nVersions, (long)10L);
            Assert.assertTrue((String)"The user should still have update permissions on the schema", (boolean)userDao.hasPermission(this.user(), (HibBaseElement)container, InternalPermission.UPDATE_PERM));
        }
    }

    @Test
    public void testNoChangesUpdate() {
        try (Tx tx = this.tx();){
            HibSchema container = this.schemaContainer("content");
            SchemaUpdateRequest schema = (SchemaUpdateRequest)JsonUtil.readValue((String)((HibSchemaVersion)container.getLatestVersion()).getSchema().toJson(), SchemaUpdateRequest.class);
            GenericMessageResponse status = (GenericMessageResponse)ClientHelper.call(() -> this.client().updateSchema(container.getUuid(), schema, new ParameterProvider[0]));
            MeshAssertions.assertThat((GenericMessageResponse)status).matches("schema_update_no_difference_detected", new String[0]);
        }
    }

    @Test
    public void testUpdateAddField() throws Exception {
        SchemaUpdateRequest schema;
        String schemaUuid = (String)this.tx(() -> this.schemaContainer("content").getUuid());
        try (Tx tx = this.tx();){
            HibSchema container = this.schemaContainer("content");
            schema = (SchemaUpdateRequest)JsonUtil.readValue((String)((HibSchemaVersion)container.getLatestVersion()).getJson(), SchemaUpdateRequest.class);
            Assert.assertEquals((String)"The segment field slug should be set", (Object)"slug", (Object)schema.getSegmentField());
            schema.getFields().add(FieldUtil.createStringFieldSchema((String)"extraname").setLabel("someLabel"));
            this.mesh().serverSchemaStorage().clear();
            tx.success();
        }
        GenericMessageResponse status = (GenericMessageResponse)ClientHelper.call(() -> this.client().updateSchema(schemaUuid, schema, new ParameterProvider[]{new SchemaUpdateParametersImpl().setUpdateAssignedBranches(false)}));
        MeshAssertions.assertThat((GenericMessageResponse)status).matches("schema_updated_migration_deferred", new String[]{"content", "2.0"});
        SchemaResponse updatedSchema = (SchemaResponse)ClientHelper.call(() -> this.client().findSchemaByUuid(schemaUuid, new ParameterProvider[0]));
        this.waitForJobs(() -> ClientHelper.call(() -> this.client().assignBranchSchemaVersions("dummy", this.initialBranchUuid(), new SchemaReference[]{((SchemaReference)new SchemaReferenceImpl().setName("content")).setVersion(updatedSchema.getVersion())})), JobStatus.COMPLETED, 1);
        SchemaModel reloadedSchema = (SchemaModel)ClientHelper.call(() -> this.client().findSchemaByUuid(schemaUuid, new ParameterProvider[0]));
        Assert.assertEquals((String)"The segment field slug should be set", (Object)"slug", (Object)reloadedSchema.getSegmentField());
        Assert.assertEquals((Object)"someLabel", (Object)reloadedSchema.getField("extraname").getLabel());
        schema.setVersion(schema.getVersion() + "1");
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", this.contentUuid(), new ParameterProvider[]{new VersioningParametersImpl().draft()}));
        Assert.assertNotNull((Object)response);
        NodeUpdateRequest nodeUpdateRequest = new NodeUpdateRequest();
        nodeUpdateRequest.setLanguage("en");
        nodeUpdateRequest.setVersion("2.0");
        nodeUpdateRequest.getFields().put("extraname", (Field)new StringFieldImpl().setString("sometext"));
        response = (NodeResponse)ClientHelper.call(() -> this.client().updateNode("dummy", this.contentUuid(), nodeUpdateRequest, new ParameterProvider[0]));
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getFields().getStringField("extraname"));
        Assert.assertEquals((Object)"sometext", (Object)response.getFields().getStringField("extraname").getString());
        response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", this.contentUuid(), new ParameterProvider[]{new VersioningParametersImpl().draft()}));
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getFields().hasField("extraname"));
    }

    @Test
    public void testRemoveField2() throws Exception {
        SchemaUpdateRequest schema;
        String nodeUuid;
        String containerUuid = (String)this.db().tx(() -> this.schemaContainer("content").getUuid());
        String branchUuid = (String)this.db().tx(() -> this.project().getLatestBranch().getUuid());
        try (Tx tx = this.tx();){
            HibNode content = this.content();
            nodeUuid = content.getUuid();
            HibSchema container = this.schemaContainer("content");
            schema = (SchemaUpdateRequest)JsonUtil.readValue((String)((HibSchemaVersion)container.getLatestVersion()).getJson(), SchemaUpdateRequest.class);
            schema.removeField("content");
            this.mesh().serverSchemaStorage().clear();
        }
        ClientHelper.call(() -> this.client().updateSchema(containerUuid, schema, new ParameterProvider[]{new SchemaUpdateParametersImpl().setUpdateAssignedBranches(false)}));
        SchemaResponse updatedSchema = (SchemaResponse)ClientHelper.call(() -> this.client().findSchemaByUuid(containerUuid, new ParameterProvider[0]));
        Assert.assertEquals((Object)"2.0", (Object)updatedSchema.getVersion());
        Assert.assertNull((String)"The content field should have been removed", (Object)updatedSchema.getField("content"));
        this.waitForJobs(() -> ClientHelper.call(() -> this.client().assignBranchSchemaVersions("dummy", branchUuid, new SchemaReference[]{((SchemaReference)new SchemaReferenceImpl().setName("content")).setVersion(updatedSchema.getVersion())})), JobStatus.COMPLETED, 1);
        schema.setVersion(schema.getVersion() + "1");
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", nodeUuid, new ParameterProvider[]{new VersioningParametersImpl().draft()}));
        Assert.assertNull((Object)response.getFields().getStringField("content"));
    }

    @Test
    public void testMigrationForBranch() throws Exception {
        SchemaUpdateRequest request;
        HibSchema schemaContainer = this.schemaContainer("content");
        String schemaUuid = (String)this.tx(() -> schemaContainer.getUuid());
        HibNode content = this.content();
        HibBranch newBranch = this.createBranch("newbranch", true);
        try (Tx tx = this.tx();){
            request = (SchemaUpdateRequest)JsonUtil.readValue((String)((HibSchemaVersion)schemaContainer.getLatestVersion()).getSchema().toJson(), SchemaUpdateRequest.class);
            request.getFields().add(FieldUtil.createStringFieldSchema((String)"extraname"));
            this.mesh().serverSchemaStorage().clear();
            tx.success();
        }
        ClientHelper.call(() -> this.client().updateSchema(schemaUuid, request, new ParameterProvider[]{new SchemaUpdateParametersImpl().setUpdateAssignedBranches(false)}));
        SchemaResponse updatedSchema = (SchemaResponse)ClientHelper.call(() -> this.client().findSchemaByUuid(schemaUuid, new ParameterProvider[0]));
        this.waitForJobs(() -> ClientHelper.call(() -> this.client().assignBranchSchemaVersions("dummy", this.initialBranchUuid(), new SchemaReference[]{((SchemaReference)new SchemaReferenceImpl().setName("content")).setVersion(updatedSchema.getVersion())})), JobStatus.COMPLETED, 1);
        try (Tx tx = this.tx();){
            ContentDao contentDao = tx.contentDao();
            MeshAssertions.assertThat((HibNodeFieldContainer)contentDao.getFieldContainer(content, "en", this.initialBranchUuid(), ContainerType.DRAFT)).isOf((HibSchemaVersion)this.schemaContainer("content").getLatestVersion());
            MeshAssertions.assertThat((HibNodeFieldContainer)contentDao.getFieldContainer(content, "en", newBranch.getUuid(), ContainerType.DRAFT)).isOf((HibSchemaVersion)((HibSchemaVersion)this.schemaContainer("content").getLatestVersion()).getPreviousVersion());
        }
    }

    @Test
    @Category(value={FailingTests.class})
    public void testUpdateFieldName() throws Exception {
        String contentFieldValue;
        HibNode node = this.content();
        HibSchema schemaContainer = this.schemaContainer("content");
        String schemaUuid = (String)this.tx(() -> schemaContainer.getUuid());
        try (Tx tx2 = this.tx();){
            Assert.assertNotNull((String)"The node should have a html graph field", (Object)tx2.contentDao().getFieldContainer(node, "en").getHtml("content"));
            contentFieldValue = tx2.contentDao().getFieldContainer(node, "en").getHtml("content").getHTML();
        }
        Assert.assertEquals((Object)"1.0", this.tx(tx -> tx.contentDao().getFieldContainer(node, "en").getVersion().toString()));
        SchemaChangesListModel listOfChanges = new SchemaChangesListModel();
        SchemaChangeModel change = SchemaChangeModel.createRenameFieldChange((String)"content", (String)"newcontent");
        listOfChanges.getChanges().add(change);
        try (Tx tx3 = this.tx();){
            Assert.assertNull((String)"The schema should not yet have any changes", (Object)((HibSchemaVersion)schemaContainer.getLatestVersion()).getNextChange());
        }
        ClientHelper.call(() -> this.client().applyChangesToSchema(schemaUuid, listOfChanges));
        SchemaResponse updatedSchema = (SchemaResponse)ClientHelper.call(() -> this.client().findSchemaByUuid(schemaUuid, new ParameterProvider[0]));
        this.waitForJob(() -> ClientHelper.call(() -> this.client().assignBranchSchemaVersions("dummy", this.initialBranchUuid(), new SchemaReference[]{((SchemaReference)new SchemaReferenceImpl().setName("content")).setVersion(updatedSchema.getVersion())})));
        Assert.assertEquals((Object)"2.0", this.tx(tx -> tx.contentDao().getFieldContainer(node, "en").getVersion().toString()));
        Assert.assertNull((String)"We would expect the new version to not include the old field value.", this.tx(tx -> tx.contentDao().getFieldContainer(node, "en").getHtml("content")));
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", this.contentUuid(), new ParameterProvider[]{new VersioningParametersImpl().draft()}));
        Assert.assertTrue((boolean)response.getFields().hasField("newcontent"));
        Assert.assertFalse((boolean)response.getFields().hasField("content"));
        Assert.assertEquals((String)"The field value was not preserved.", (Object)contentFieldValue, (Object)response.getFields().getHtmlField("newcontent").getHTML());
    }

    private HibSchemaVersion reloadSchemaVersion(HibSchemaVersion schemaVersion) {
        return (HibSchemaVersion)CommonTx.get().load(schemaVersion.getId(), CommonTx.get().schemaDao().getVersionPersistenceClass());
    }
}

