/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.gentics.mesh.core.rest.schema.change.impl.SchemaChangeModel;
import com.gentics.mesh.core.rest.schema.change.impl.SchemaChangesListModel;
import com.gentics.mesh.core.rest.schema.impl.SchemaCreateRequest;
import com.gentics.mesh.core.rest.schema.impl.SchemaResponse;
import com.gentics.mesh.core.rest.schema.impl.StringFieldSchemaImpl;
import com.gentics.mesh.json.JsonUtil;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class SchemaDiffEndpointElasticSearchTest
extends AbstractMeshTest {
    @Test
    public void testElasticSearchField() throws IOException {
        SchemaResponse schema = this.createESSchema();
        Assertions.assertThat(this.getChanges(schema, schema.toJson())).isEmpty();
        Assertions.assertThat(this.getChanges(schema, EsSchema.missingSchema())).isEmpty();
        Assertions.assertThat(this.getChanges(schema, EsSchema.nullSchema())).isEmpty();
        Assertions.assertThat(this.getChanges(schema, EsSchema.emptySchema())).isEmpty();
        Assertions.assertThat(this.getChanges(schema, EsSchema.missingField())).isEmpty();
        Assertions.assertThat(this.getChanges(schema, EsSchema.nullField())).isEmpty();
        Assertions.assertThat(this.getChanges(schema, EsSchema.emptyField())).isEmpty();
        Assert.assertEquals((long)this.getChanges(schema, EsSchema.fieldMapping()).size(), (long)1L);
        Assert.assertEquals((long)this.getChanges(schema, EsSchema.schemaMapping()).size(), (long)1L);
    }

    private List<SchemaChangeModel> getChanges(SchemaResponse original, String updated) throws IOException {
        String body = this.httpClient().newCall(new Request.Builder().addHeader("Authorization", "Bearer " + this.client().getAuthentication().getToken()).url(String.format("http://localhost:%d/api/v%d/schemas/%s/diff", this.port(), 2, original.getUuid())).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)updated)).build()).execute().body().string();
        return ((SchemaChangesListModel)JsonUtil.readValue((String)body, SchemaChangesListModel.class)).getChanges();
    }

    private SchemaResponse createESSchema() {
        SchemaCreateRequest request = new SchemaCreateRequest();
        request.setElasticsearch(new JsonObject());
        request.setName(EsSchema.NAME);
        request.setFields(Arrays.asList(new StringFieldSchemaImpl().setName(EsSchema.FIELD_NAME).setElasticsearch(new JsonObject())));
        return (SchemaResponse)this.client().createSchema(request, new ParameterProvider[0]).toSingle().blockingGet();
    }

    private static class EsSchema {
        private static String NAME = "EsSchema";
        private static String FIELD_NAME = "name";
        private static ObjectMapper mapper = new ObjectMapper();

        private EsSchema() {
        }

        private static ObjectNode basicRequest() {
            return (ObjectNode)mapper.createObjectNode().put("name", NAME).set("fields", (JsonNode)mapper.createArrayNode().add((JsonNode)mapper.createObjectNode().put("name", FIELD_NAME).put("type", "string")));
        }

        private static ObjectNode field(ObjectNode request) {
            return (ObjectNode)request.get("fields").get(0);
        }

        public static String missingField() {
            return EsSchema.basicRequest().toString();
        }

        public static String nullField() {
            ObjectNode request = EsSchema.basicRequest();
            EsSchema.field(request).set("elasticsearch", (JsonNode)NullNode.getInstance());
            return request.toString();
        }

        public static String missingSchema() {
            return EsSchema.basicRequest().toString();
        }

        public static String nullSchema() {
            return EsSchema.basicRequest().set("elasticsearch", (JsonNode)NullNode.getInstance()).toString();
        }

        public static String fieldMapping() {
            ObjectNode request = EsSchema.basicRequest();
            EsSchema.field(request).set("elasticsearch", mapper.createObjectNode().set("raw", (JsonNode)mapper.createObjectNode().put("type", "keyword")));
            return request.toString();
        }

        public static String schemaMapping() {
            return EsSchema.basicRequest().set("elasticsearch", mapper.createObjectNode().set("analysis", mapper.createObjectNode().set("stop", (JsonNode)mapper.createObjectNode().put("type", "stop").put("stopwords", "_english_")))).toString();
        }

        public static String emptySchema() {
            return EsSchema.basicRequest().set("elasticsearch", (JsonNode)mapper.createObjectNode()).toString();
        }

        public static String emptyField() {
            ObjectNode request = EsSchema.basicRequest();
            EsSchema.field(request).set("elasticsearch", (JsonNode)mapper.createObjectNode()).toString();
            return request.toString();
        }
    }
}

