/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.schema;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.data.schema.HibSchema;
import com.gentics.mesh.core.data.schema.HibSchemaVersion;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.error.GenericRestException;
import com.gentics.mesh.core.rest.schema.BinaryFieldSchema;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.NodeFieldSchema;
import com.gentics.mesh.core.rest.schema.SchemaModel;
import com.gentics.mesh.core.rest.schema.SchemaVersionModel;
import com.gentics.mesh.core.rest.schema.StringFieldSchema;
import com.gentics.mesh.core.rest.schema.change.impl.SchemaChangeModel;
import com.gentics.mesh.core.rest.schema.change.impl.SchemaChangeOperation;
import com.gentics.mesh.core.rest.schema.change.impl.SchemaChangesListModel;
import com.gentics.mesh.core.rest.schema.impl.HtmlFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.SchemaCreateRequest;
import com.gentics.mesh.core.rest.schema.impl.SchemaModelImpl;
import com.gentics.mesh.core.rest.schema.impl.SchemaResponse;
import com.gentics.mesh.core.rest.schema.impl.StringFieldSchemaImpl;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.vertx.core.json.JsonObject;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class SchemaDiffEndpointTest
extends AbstractMeshTest {
    private SchemaModel getSchema() {
        SchemaModelImpl schema = new SchemaModelImpl();
        schema.setName("content");
        schema.setDescription("Content schema for blogposts");
        schema.setDisplayField("title");
        schema.setSegmentField("slug");
        StringFieldSchemaImpl slugFieldSchema = new StringFieldSchemaImpl();
        slugFieldSchema.setName("slug");
        slugFieldSchema.setLabel("Slug");
        slugFieldSchema.setRequired(true);
        schema.addField((FieldSchema)slugFieldSchema);
        StringFieldSchemaImpl titleFieldSchema = new StringFieldSchemaImpl();
        titleFieldSchema.setName("title");
        titleFieldSchema.setLabel("Title");
        schema.addField((FieldSchema)titleFieldSchema);
        StringFieldSchemaImpl nameFieldSchema = new StringFieldSchemaImpl();
        nameFieldSchema.setName("teaser");
        nameFieldSchema.setLabel("Teaser");
        nameFieldSchema.setRequired(true);
        schema.addField((FieldSchema)nameFieldSchema);
        HtmlFieldSchemaImpl contentFieldSchema = new HtmlFieldSchemaImpl();
        contentFieldSchema.setName("content");
        contentFieldSchema.setLabel("Content");
        schema.addField((FieldSchema)contentFieldSchema);
        schema.setContainer(Boolean.valueOf(false));
        return schema;
    }

    @Test
    public void testDiffContainerFlag() {
        String schemaUuid = (String)this.tx(() -> this.schemaContainer("content").getUuid());
        SchemaModel request = this.getSchema();
        request.setContainer(null);
        SchemaChangesListModel changes = (SchemaChangesListModel)ClientHelper.call(() -> this.client().diffSchema(schemaUuid, request));
        MeshAssertions.assertThat((List)changes.getChanges()).hasSize(0);
        request.setContainer(Boolean.valueOf(false));
        changes = (SchemaChangesListModel)ClientHelper.call(() -> this.client().diffSchema(schemaUuid, request));
        MeshAssertions.assertThat((List)changes.getChanges()).hasSize(0);
        request.setContainer(Boolean.valueOf(true));
        changes = (SchemaChangesListModel)ClientHelper.call(() -> this.client().diffSchema(schemaUuid, request));
        MeshAssertions.assertThat((List)changes.getChanges()).hasSize(1);
        MeshAssertions.assertThat((SchemaChangeModel)((SchemaChangeModel)changes.getChanges().get(0))).is(SchemaChangeOperation.UPDATESCHEMA).hasProperty("container", (Object)true);
    }

    @Test
    public void testDiffAutoPurgeFlag() {
        String schemaUuid = (String)this.tx(() -> this.schemaContainer("content").getUuid());
        SchemaModel request = this.getSchema();
        request.setAutoPurge(null);
        SchemaChangesListModel changes = (SchemaChangesListModel)ClientHelper.call(() -> this.client().diffSchema(schemaUuid, request));
        MeshAssertions.assertThat((List)changes.getChanges()).hasSize(0);
        request.setAutoPurge(Boolean.valueOf(false));
        changes = (SchemaChangesListModel)ClientHelper.call(() -> this.client().diffSchema(schemaUuid, request));
        MeshAssertions.assertThat((SchemaChangeModel)((SchemaChangeModel)changes.getChanges().get(0))).is(SchemaChangeOperation.UPDATESCHEMA).hasProperty("autoPurge", (Object)false);
        request.setAutoPurge(Boolean.valueOf(true));
        changes = (SchemaChangesListModel)ClientHelper.call(() -> this.client().diffSchema(schemaUuid, request));
        MeshAssertions.assertThat((List)changes.getChanges()).hasSize(1);
        MeshAssertions.assertThat((SchemaChangeModel)((SchemaChangeModel)changes.getChanges().get(0))).is(SchemaChangeOperation.UPDATESCHEMA).hasProperty("autoPurge", (Object)true);
    }

    @Test
    public void testDiffDescription() {
        String SCHEMA_NAME = "TestSchema";
        SchemaCreateRequest request = new SchemaCreateRequest();
        request.setName("TestSchema");
        SchemaResponse response = (SchemaResponse)ClientHelper.call(() -> this.client().createSchema(request, new ParameterProvider[0]));
        Assert.assertNull((Object)response.getDescription());
        SchemaChangesListModel changes = (SchemaChangesListModel)ClientHelper.call(() -> this.client().diffSchema(response.getUuid(), (SchemaModel)response));
        MeshAssertions.assertThat((List)changes.getChanges()).isEmpty();
        response.setDescription("SetToSomething");
        changes = (SchemaChangesListModel)ClientHelper.call(() -> this.client().diffSchema(response.getUuid(), (SchemaModel)response));
        MeshAssertions.assertThat((List)changes.getChanges()).hasSize(1);
        SchemaChangeModel change = (SchemaChangeModel)changes.getChanges().get(0);
        Assert.assertEquals((Object)"SetToSomething", (Object)change.getProperty("description"));
    }

    @Test
    public void testDiffDisplayField() throws GenericRestException, Exception {
        try (Tx tx = this.tx();){
            HibSchema container = this.schemaContainer("content");
            SchemaModel request = this.getSchema();
            request.setDisplayField("slug");
            SchemaChangesListModel changes = (SchemaChangesListModel)ClientHelper.call(() -> this.client().diffSchema(container.getUuid(), request));
            Assert.assertNotNull((Object)changes);
            MeshAssertions.assertThat((List)changes.getChanges()).hasSize(1);
            MeshAssertions.assertThat((SchemaChangeModel)((SchemaChangeModel)changes.getChanges().get(0))).is(SchemaChangeOperation.UPDATESCHEMA).hasProperty("displayFieldname", (Object)"slug");
        }
    }

    @Test
    public void testNoDiff() {
        try (Tx tx = this.tx();){
            HibSchema container = this.schemaContainer("content");
            SchemaModel request = this.getSchema();
            SchemaChangesListModel changes = (SchemaChangesListModel)ClientHelper.call(() -> this.client().diffSchema(container.getUuid(), request));
            Assert.assertNotNull((Object)changes);
            MeshAssertions.assertThat((List)changes.getChanges()).isEmpty();
        }
    }

    @Test
    public void testAllowFieldDiff() {
        String schemaUuid = (String)this.tx(() -> this.schemaContainer("content").getUuid());
        try (Tx tx = this.tx();){
            HibSchemaVersion version = (HibSchemaVersion)this.schemaContainer("content").getLatestVersion();
            SchemaVersionModel schema = version.getSchema();
            ((StringFieldSchema)schema.getField("slug", StringFieldSchema.class)).setAllowedValues(new String[]{"A", "B", "C"});
            version.setJson(schema.toJson());
            tx.success();
        }
        SchemaModel request = this.getSchema();
        StringFieldSchema field = (StringFieldSchema)request.getField("slug", StringFieldSchema.class);
        field.setAllowedValues(new String[]{"a", "b", "c"});
        SchemaChangesListModel changes = (SchemaChangesListModel)ClientHelper.call(() -> this.client().diffSchema(schemaUuid, request));
        MeshAssertions.assertThat((List)changes.getChanges()).hasSize(1);
        SchemaChangeModel change = (SchemaChangeModel)changes.getChanges().get(0);
        MeshAssertions.assertThat((SchemaChangeModel)change).is(SchemaChangeOperation.UPDATEFIELD).forField("slug").hasProperty("allow", (Object)Arrays.asList("a", "b", "c").toArray());
    }

    @Test
    public void testAllowNullFieldDiff() {
        String schemaUuid = (String)this.tx(() -> this.schemaContainer("content").getUuid());
        try (Tx tx = this.tx();){
            HibSchemaVersion version = (HibSchemaVersion)this.schemaContainer("content").getLatestVersion();
            SchemaVersionModel schema = version.getSchema();
            ((StringFieldSchema)schema.getField("slug", StringFieldSchema.class)).setAllowedValues(new String[]{"A", "B", "C"});
            version.setJson(schema.toJson());
            tx.success();
        }
        SchemaModel request = this.getSchema();
        SchemaChangesListModel changes = (SchemaChangesListModel)ClientHelper.call(() -> this.client().diffSchema(schemaUuid, request));
        MeshAssertions.assertThat((List)changes.getChanges()).hasSize(1);
        SchemaChangeModel change = (SchemaChangeModel)changes.getChanges().get(0);
        MeshAssertions.assertThat((SchemaChangeModel)change).is(SchemaChangeOperation.UPDATEFIELD).forField("slug").hasProperty("allow", null);
    }

    @Test
    public void testAllowEmptyFieldDiff() {
        String schemaUuid = (String)this.tx(() -> this.schemaContainer("content").getUuid());
        try (Tx tx = this.tx();){
            HibSchemaVersion version = (HibSchemaVersion)this.schemaContainer("content").getLatestVersion();
            SchemaVersionModel schema = version.getSchema();
            ((StringFieldSchema)schema.getField("slug", StringFieldSchema.class)).setAllowedValues(new String[]{"A", "B", "C"});
            version.setJson(schema.toJson());
            tx.success();
        }
        SchemaModel request = this.getSchema();
        ((StringFieldSchema)request.getField("slug", StringFieldSchema.class)).setAllowedValues(new String[0]);
        SchemaChangesListModel changes = (SchemaChangesListModel)ClientHelper.call(() -> this.client().diffSchema(schemaUuid, request));
        MeshAssertions.assertThat((List)changes.getChanges()).hasSize(1);
        SchemaChangeModel change = (SchemaChangeModel)changes.getChanges().get(0);
        MeshAssertions.assertThat((SchemaChangeModel)change).is(SchemaChangeOperation.UPDATEFIELD).forField("slug").hasProperty("allow", (Object)new String[0]);
    }

    @Test
    public void testESFieldDiff() {
        String schemaUuid = (String)this.tx(() -> this.schemaContainer("content").getUuid());
        SchemaModel request = this.getSchema();
        FieldSchema field = request.getField("slug");
        JsonObject setting = new JsonObject().put("test", (Object)"123");
        field.setElasticsearch(setting);
        SchemaChangesListModel changes = (SchemaChangesListModel)ClientHelper.call(() -> this.client().diffSchema(schemaUuid, request));
        MeshAssertions.assertThat((List)changes.getChanges()).hasSize(1);
        SchemaChangeModel change = (SchemaChangeModel)changes.getChanges().get(0);
        MeshAssertions.assertThat((SchemaChangeModel)change).is(SchemaChangeOperation.UPDATEFIELD).forField("slug").hasProperty("elasticsearch", (Object)setting);
    }

    @Test
    public void testESFieldDiffOnNewField() {
        String schemaUuid = (String)this.tx(() -> this.schemaContainer("content").getUuid());
        SchemaModel request = this.getSchema();
        StringFieldSchemaImpl testField = new StringFieldSchemaImpl();
        testField.setName("test");
        JsonObject setting = new JsonObject().put("test", (Object)"123");
        testField.setElasticsearch(setting);
        request.getFields().add(testField);
        SchemaChangesListModel changes = (SchemaChangesListModel)ClientHelper.call(() -> this.client().diffSchema(schemaUuid, request));
        MeshAssertions.assertThat((List)changes.getChanges()).hasSize(2);
        SchemaChangeModel change = (SchemaChangeModel)changes.getChanges().get(0);
        MeshAssertions.assertThat((SchemaChangeModel)change).is(SchemaChangeOperation.ADDFIELD).forField("test").hasProperty("elasticsearch", (Object)setting);
    }

    @Test
    public void testESFieldNullDiff() {
        this.assertESHandlingForValue(null);
    }

    @Test
    public void testESFieldNullDiff2() {
        this.assertESHandlingForValue(new JsonObject());
    }

    private void assertESHandlingForValue(JsonObject newValueForSetting) {
        String schemaUuid = (String)this.tx(() -> this.schemaContainer("content").getUuid());
        try (Tx tx = this.tx();){
            JsonObject setting = new JsonObject().put("test", (Object)"123");
            HibSchemaVersion version = (HibSchemaVersion)this.schemaContainer("content").getLatestVersion();
            SchemaVersionModel schema = version.getSchema();
            schema.getField("slug").setElasticsearch(setting);
            version.setJson(schema.toJson());
            tx.success();
        }
        SchemaModel request = this.getSchema();
        FieldSchema field = request.getField("slug");
        field.setElasticsearch(newValueForSetting);
        SchemaChangesListModel changes = (SchemaChangesListModel)ClientHelper.call(() -> this.client().diffSchema(schemaUuid, request));
        MeshAssertions.assertThat((List)changes.getChanges()).hasSize(1);
        SchemaChangeModel change = (SchemaChangeModel)changes.getChanges().get(0);
        System.out.println(change.toJson());
        MeshAssertions.assertThat((SchemaChangeModel)change).is(SchemaChangeOperation.UPDATEFIELD).forField("slug").hasProperty("elasticsearch", new LinkedHashMap());
    }

    @Test
    public void testAddField() {
        try (Tx tx = this.tx();){
            HibSchema schema = this.schemaContainer("content");
            SchemaModel request = this.getSchema();
            BinaryFieldSchema binaryField = FieldUtil.createBinaryFieldSchema((String)"binary");
            binaryField.setAllowedMimeTypes(new String[]{"one", "two"});
            request.addField((FieldSchema)binaryField);
            SchemaChangesListModel changes = (SchemaChangesListModel)ClientHelper.call(() -> this.client().diffSchema(schema.getUuid(), request));
            Assert.assertNotNull((Object)changes);
            MeshAssertions.assertThat((List)changes.getChanges()).hasSize(2);
            MeshAssertions.assertThat((SchemaChangeModel)((SchemaChangeModel)changes.getChanges().get(0))).is(SchemaChangeOperation.ADDFIELD).forField("binary");
            MeshAssertions.assertThat((SchemaChangeModel)((SchemaChangeModel)changes.getChanges().get(1))).is(SchemaChangeOperation.UPDATESCHEMA).hasProperty("order", (Object)new String[]{"slug", "title", "teaser", "content", "binary"});
        }
    }

    @Test
    public void testAddNodeField() {
        try (Tx tx = this.tx();){
            HibSchema schema = this.schemaContainer("content");
            SchemaModel request = this.getSchema();
            NodeFieldSchema nodeField = FieldUtil.createNodeFieldSchema((String)"node");
            nodeField.setAllowedSchemas(new String[]{"content"});
            request.addField((FieldSchema)nodeField);
            SchemaChangesListModel changes = (SchemaChangesListModel)ClientHelper.call(() -> this.client().diffSchema(schema.getUuid(), request));
            Assert.assertNotNull((Object)changes);
            MeshAssertions.assertThat((List)changes.getChanges()).hasSize(2);
            MeshAssertions.assertThat((SchemaChangeModel)((SchemaChangeModel)changes.getChanges().get(0))).is(SchemaChangeOperation.ADDFIELD).forField("node").hasProperty("allow", (Object)new String[]{"content"});
            MeshAssertions.assertThat((SchemaChangeModel)((SchemaChangeModel)changes.getChanges().get(1))).is(SchemaChangeOperation.UPDATESCHEMA).hasProperty("order", (Object)new String[]{"slug", "title", "teaser", "content", "node"});
        }
    }

    @Test
    public void testDefaultMigration() {
        try (Tx tx = this.tx();){
            HibSchema schema = this.schemaContainer("content");
            SchemaModel request = this.getSchema();
            request.removeField("content");
            SchemaChangesListModel changes = (SchemaChangesListModel)ClientHelper.call(() -> this.client().diffSchema(schema.getUuid(), request));
            Assert.assertNotNull((Object)changes);
            MeshAssertions.assertThat((List)changes.getChanges()).hasSize(2);
            MeshAssertions.assertThat((SchemaChangeModel)((SchemaChangeModel)changes.getChanges().get(0))).is(SchemaChangeOperation.REMOVEFIELD).forField("content");
            MeshAssertions.assertThat((SchemaChangeModel)((SchemaChangeModel)changes.getChanges().get(1))).is(SchemaChangeOperation.UPDATESCHEMA).hasProperty("order", (Object)new String[]{"slug", "title", "teaser"});
        }
    }
}

