/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.schema;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.assertj.impl.MeshElementEventModelAssert;
import com.gentics.mesh.core.data.dao.SchemaDao;
import com.gentics.mesh.core.data.schema.HibSchema;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.MeshEvent;
import com.gentics.mesh.core.rest.common.Permission;
import com.gentics.mesh.core.rest.common.PermissionInfo;
import com.gentics.mesh.core.rest.event.MeshElementEventModel;
import com.gentics.mesh.core.rest.event.impl.MeshElementEventModelImpl;
import com.gentics.mesh.core.rest.schema.impl.SchemaCreateRequest;
import com.gentics.mesh.core.rest.schema.impl.SchemaResponse;
import com.gentics.mesh.core.rest.schema.impl.SchemaUpdateRequest;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.UNREACHABLE, testSize=TestSize.FULL, startServer=true)
public class SchemaEndpointNoEsTest
extends AbstractMeshTest {
    @Test
    public void testCreate() {
        SchemaCreateRequest createRequest = FieldUtil.createMinimalValidSchemaCreateRequest();
        this.expect(MeshEvent.SCHEMA_CREATED).match(1, MeshElementEventModelImpl.class, event -> ((MeshElementEventModelAssert)MeshAssertions.assertThat((MeshElementEventModel)event).hasName(createRequest.getName())).uuidNotNull());
        SchemaResponse restSchema = (SchemaResponse)ClientHelper.call(() -> this.client().createSchema(createRequest, new ParameterProvider[0]));
        this.awaitEvents();
        try (Tx tx = this.tx();){
            SchemaDao schemaDao = tx.schemaDao();
            MeshAssertions.assertThat((SchemaCreateRequest)createRequest).matches(restSchema);
            MeshAssertions.assertThat((PermissionInfo)restSchema.getPermissions()).hasPerm(new Permission[]{Permission.CREATE, Permission.READ, Permission.UPDATE, Permission.DELETE});
            HibSchema schemaContainer = (HibSchema)schemaDao.findByUuid(restSchema.getUuid());
            Assert.assertNotNull((Object)schemaContainer);
            Assert.assertEquals((String)"Name does not match with the requested name", (Object)createRequest.getName(), (Object)schemaContainer.getName());
        }
    }

    @Test
    public void testUpdate() {
        SchemaCreateRequest createRequest = new SchemaCreateRequest().setName("testSchema").setFields(Arrays.asList(FieldUtil.createStringFieldSchema((String)"stringField")));
        SchemaResponse created = (SchemaResponse)ClientHelper.call(() -> this.client().createSchema(createRequest, new ParameterProvider[0]));
        SchemaUpdateRequest updateRequest = created.toUpdateRequest().setFields(Arrays.asList(FieldUtil.createBooleanFieldSchema((String)"booleanField")));
        ClientHelper.call(() -> this.client().updateSchema(created.getUuid(), updateRequest, new ParameterProvider[0]));
    }
}

