/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.schema;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.assertj.impl.MeshElementEventModelAssert;
import com.gentics.mesh.context.BulkActionContext;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.dao.DaoGlobal;
import com.gentics.mesh.core.data.dao.NodeDao;
import com.gentics.mesh.core.data.dao.RoleDao;
import com.gentics.mesh.core.data.dao.SchemaDao;
import com.gentics.mesh.core.data.job.HibJob;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.perm.InternalPermission;
import com.gentics.mesh.core.data.schema.HibFieldSchemaElement;
import com.gentics.mesh.core.data.schema.HibSchema;
import com.gentics.mesh.core.data.schema.HibSchemaVersion;
import com.gentics.mesh.core.db.CommonTx;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.MeshEvent;
import com.gentics.mesh.core.rest.branch.BranchReference;
import com.gentics.mesh.core.rest.common.AbstractResponse;
import com.gentics.mesh.core.rest.common.ListResponse;
import com.gentics.mesh.core.rest.common.Permission;
import com.gentics.mesh.core.rest.common.PermissionInfo;
import com.gentics.mesh.core.rest.error.GenericRestException;
import com.gentics.mesh.core.rest.event.EventCauseInfo;
import com.gentics.mesh.core.rest.event.MeshElementEventModel;
import com.gentics.mesh.core.rest.event.branch.BranchMicroschemaAssignModel;
import com.gentics.mesh.core.rest.event.branch.BranchSchemaAssignEventModel;
import com.gentics.mesh.core.rest.event.impl.MeshElementEventModelImpl;
import com.gentics.mesh.core.rest.event.migration.SchemaMigrationMeshEventModel;
import com.gentics.mesh.core.rest.event.node.NodeMeshEventModel;
import com.gentics.mesh.core.rest.event.node.SchemaMigrationCause;
import com.gentics.mesh.core.rest.job.JobStatus;
import com.gentics.mesh.core.rest.microschema.impl.MicroschemaCreateRequest;
import com.gentics.mesh.core.rest.microschema.impl.MicroschemaResponse;
import com.gentics.mesh.core.rest.project.ProjectReference;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.MicroschemaListResponse;
import com.gentics.mesh.core.rest.schema.MicroschemaReference;
import com.gentics.mesh.core.rest.schema.SchemaListResponse;
import com.gentics.mesh.core.rest.schema.SchemaReference;
import com.gentics.mesh.core.rest.schema.SchemaVersionModel;
import com.gentics.mesh.core.rest.schema.impl.ListFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.MicronodeFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.SchemaCreateRequest;
import com.gentics.mesh.core.rest.schema.impl.SchemaModelImpl;
import com.gentics.mesh.core.rest.schema.impl.SchemaResponse;
import com.gentics.mesh.core.rest.schema.impl.SchemaUpdateRequest;
import com.gentics.mesh.json.JsonUtil;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.PagingParametersImpl;
import com.gentics.mesh.parameter.impl.RolePermissionParametersImpl;
import com.gentics.mesh.parameter.impl.VersioningParametersImpl;
import com.gentics.mesh.search.TrackingSearchProvider;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.test.context.MeshTestHelper;
import com.gentics.mesh.test.definition.BasicRestTestcases;
import com.gentics.mesh.test.util.MeshAssert;
import com.gentics.mesh.util.UUIDUtil;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.reactivex.Observable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.TRACKING, testSize=TestSize.FULL, startServer=true)
public class SchemaEndpointTest
extends AbstractMeshTest
implements BasicRestTestcases {
    @After
    public void waitForJobs() {
        this.grantAdmin();
        this.triggerAndWaitForAllJobs(JobStatus.COMPLETED);
    }

    @Override
    @Test
    public void testCreate() throws GenericRestException, Exception {
        SchemaCreateRequest createRequest = FieldUtil.createMinimalValidSchemaCreateRequest();
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasEvents(0L, 0L, 0L, 0L, 0L);
        this.expect(MeshEvent.SCHEMA_CREATED).match(1, MeshElementEventModelImpl.class, event -> ((MeshElementEventModelAssert)MeshAssertions.assertThat((MeshElementEventModel)event).hasName(createRequest.getName())).uuidNotNull());
        SchemaResponse restSchema = (SchemaResponse)ClientHelper.call(() -> this.client().createSchema(createRequest, new ParameterProvider[0]));
        this.waitForSearchIdleEvent();
        this.awaitEvents();
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasEvents(1L, 0L, 0L, 0L, 0L);
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasStore(HibSchema.composeIndexName(), HibSchema.composeDocumentId((String)restSchema.getUuid()));
        try (Tx tx = this.tx();){
            SchemaDao schemaDao = tx.schemaDao();
            MeshAssertions.assertThat((SchemaCreateRequest)createRequest).matches(restSchema);
            MeshAssertions.assertThat((PermissionInfo)restSchema.getPermissions()).hasPerm(new Permission[]{Permission.CREATE, Permission.READ, Permission.UPDATE, Permission.DELETE});
            HibSchema schemaContainer = (HibSchema)schemaDao.findByUuid(restSchema.getUuid());
            Assert.assertNotNull((Object)schemaContainer);
            Assert.assertEquals((String)"Name does not match with the requested name", (Object)createRequest.getName(), (Object)schemaContainer.getName());
        }
    }

    @Test
    public void testCreateWithoutContainerFlag() {
        SchemaCreateRequest createRequest = FieldUtil.createMinimalValidSchemaCreateRequest();
        createRequest.setContainer(null);
        SchemaResponse schema = (SchemaResponse)ClientHelper.call(() -> this.client().createSchema(createRequest, new ParameterProvider[0]));
        Assert.assertFalse((String)"The flag should be set to false", (boolean)schema.getContainer());
    }

    @Test
    public void testUpdateWithoutContainerFlag() {
        SchemaCreateRequest createRequest = FieldUtil.createMinimalValidSchemaCreateRequest();
        createRequest.setContainer(Boolean.valueOf(true));
        SchemaResponse schema = (SchemaResponse)ClientHelper.call(() -> this.client().createSchema(createRequest, new ParameterProvider[0]));
        Assert.assertTrue((String)"The flag should be set to true", (boolean)schema.getContainer());
        SchemaUpdateRequest updateRequest = schema.toUpdateRequest();
        updateRequest.setContainer(null);
        ClientHelper.call(() -> this.client().updateSchema(schema.getUuid(), updateRequest, new ParameterProvider[0]));
        SchemaResponse schema2 = (SchemaResponse)ClientHelper.call(() -> this.client().findSchemaByUuid(schema.getUuid(), new ParameterProvider[0]));
        Assert.assertTrue((String)"The schema container flag should still be set to true", (boolean)schema2.getContainer());
    }

    @Override
    @Test
    public void testCreateWithNoPerm() throws Exception {
        SchemaCreateRequest schema = FieldUtil.createMinimalValidSchemaCreateRequest();
        String schemaRootUuid = (String)this.db().tx(() -> Tx.get().data().permissionRoots().schema().getUuid());
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            roleDao.revokePermissions(this.role(), tx.data().permissionRoots().schema(), new InternalPermission[]{InternalPermission.CREATE_PERM});
            tx.success();
        }
        ClientHelper.call(() -> this.client().createSchema(schema, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{schemaRootUuid, InternalPermission.CREATE_PERM.getRestPerm().getName()});
    }

    @Override
    @Test
    public void testCreateWithUuid() throws Exception {
        SchemaCreateRequest schema = FieldUtil.createMinimalValidSchemaCreateRequest();
        String uuid = UUIDUtil.randomUUID();
        SchemaResponse resp = (SchemaResponse)ClientHelper.call(() -> this.client().createSchema(uuid, schema, new ParameterProvider[0]));
        Assert.assertEquals((String)"The created schema did not contain the expected uuid.", (Object)uuid, (Object)resp.getUuid());
    }

    @Override
    @Test
    @Ignore(value="Not valid over dup UUIDs being allowed globally")
    public void testCreateWithDuplicateUuid() throws Exception {
    }

    @Override
    @Test
    public void testCreateReadDelete() throws GenericRestException, Exception {
        try (Tx tx = this.tx();){
            MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasEvents(0L, 0L, 0L, 0L, 0L);
        }
        SchemaCreateRequest schema = FieldUtil.createMinimalValidSchemaCreateRequest();
        SchemaResponse restSchema = (SchemaResponse)ClientHelper.call(() -> this.client().createSchema(schema, new ParameterProvider[0]));
        this.waitForSearchIdleEvent();
        try (Tx tx = this.tx();){
            MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasEvents(1L, 0L, 0L, 0L, 0L);
            MeshAssertions.assertThat((SchemaCreateRequest)schema).matches(restSchema);
            MeshAssert.assertElement((DaoGlobal)tx.schemaDao(), (String)restSchema.getUuid(), (boolean)true);
        }
        ClientHelper.call(() -> this.client().findSchemaByUuid(restSchema.getUuid(), new ParameterProvider[0]));
        this.trackingSearchProvider().reset();
        ClientHelper.call(() -> this.client().deleteSchema(restSchema.getUuid()));
        this.waitForSearchIdleEvent();
        tx = this.tx();
        try {
            MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasEvents(0L, 0L, 1L, 0L, 0L);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Override
    @Test
    public void testReadMultiple() throws Exception {
        int totalSchemas;
        int nSchemas = 22;
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            SchemaDao schemaDao = tx.schemaDao();
            SchemaVersionModel schema = FieldUtil.createMinimalValidSchema();
            schema.setName("No_Perm_Schema");
            HibSchema noPermSchema = schemaDao.create(schema, this.user());
            SchemaModelImpl dummySchema = new SchemaModelImpl();
            dummySchema.setName("No_Perm_Schema");
            dummySchema.setVersion("1.0");
            ((HibSchemaVersion)noPermSchema.getLatestVersion()).setSchema((SchemaVersionModel)dummySchema);
            for (int i = 0; i < 22; ++i) {
                schema = FieldUtil.createMinimalValidSchema();
                schema.setName("extra_schema_" + i);
                HibSchema extraSchema = schemaDao.create(schema, this.user());
                ((HibSchemaVersion)extraSchema.getLatestVersion()).setSchema((SchemaVersionModel)new SchemaModelImpl().setVersion("1.0").setName("extra_schema_" + i));
                roleDao.grantPermissions(this.role(), (HibBaseElement)extraSchema, new InternalPermission[]{InternalPermission.READ_PERM});
            }
            totalSchemas = 22 + this.data().getSchemaContainers().size();
            tx.success();
        }
        tx = this.tx();
        try {
            SchemaListResponse restResponse = (SchemaListResponse)ClientHelper.call(() -> this.client().findSchemas(new ParameterProvider[0]));
            Assert.assertNull((Object)restResponse.getMetainfo().getPerPage());
            Assert.assertEquals((long)1L, (long)restResponse.getMetainfo().getCurrentPage());
            Assert.assertEquals((long)25L, (long)restResponse.getData().size());
            long perPage = 11L;
            restResponse = (SchemaListResponse)ClientHelper.call(() -> this.client().findSchemas(new ParameterProvider[]{new PagingParametersImpl(2, Long.valueOf(perPage))}));
            Assert.assertEquals((long)perPage, (long)restResponse.getData().size());
            int totalPages = (int)Math.ceil((double)totalSchemas / (double)perPage);
            Assert.assertEquals((String)"The response did not contain the correct amount of items", (long)11L, (long)restResponse.getData().size());
            Assert.assertEquals((long)2L, (long)restResponse.getMetainfo().getCurrentPage());
            Assert.assertEquals((long)totalPages, (long)restResponse.getMetainfo().getPageCount());
            Assert.assertEquals((long)perPage, (long)restResponse.getMetainfo().getPerPage());
            Assert.assertEquals((long)totalSchemas, (long)restResponse.getMetainfo().getTotalCount());
            ArrayList allSchemas = new ArrayList();
            for (int page = 1; page <= totalPages; ++page) {
                restResponse = (SchemaListResponse)this.client().findSchemas(new ParameterProvider[]{new PagingParametersImpl(page, Long.valueOf(perPage))}).blockingGet();
                allSchemas.addAll(restResponse.getData());
            }
            Assert.assertEquals((String)"Somehow not all schemas were loaded when loading all pages.", (long)totalSchemas, (long)allSchemas.size());
            ClientHelper.call(() -> this.client().findSchemas(new ParameterProvider[]{new PagingParametersImpl(-1, Long.valueOf(perPage))}), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"error_page_parameter_must_be_positive", (String[])new String[]{"-1"});
            ClientHelper.call(() -> this.client().findSchemas(new ParameterProvider[]{new PagingParametersImpl(1, Long.valueOf(-1L))}), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"error_pagesize_parameter", (String[])new String[]{"-1"});
            SchemaListResponse list = (SchemaListResponse)ClientHelper.call(() -> this.client().findSchemas(new ParameterProvider[]{new PagingParametersImpl(4242, Long.valueOf(25L))}));
            Assert.assertEquals((long)4242L, (long)list.getMetainfo().getCurrentPage());
            Assert.assertEquals((long)0L, (long)list.getData().size());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.verifySorting(param -> (ListResponse)ClientHelper.call(() -> this.client().findSchemas(new ParameterProvider[]{param})), SchemaResponse::getName, "name", "List of schema names");
    }

    @Test
    public void testReadMetaCountOnly() {
        SchemaListResponse list = (SchemaListResponse)ClientHelper.call(() -> this.client().findSchemas(new ParameterProvider[]{new PagingParametersImpl(1, Long.valueOf(0L))}));
        Assert.assertEquals((long)0L, (long)list.getData().size());
    }

    @Override
    @Test
    public void testReadByUUID() throws Exception {
        try (Tx tx = this.tx();){
            HibSchema container = this.schemaContainer("content");
            HibSchemaVersion schemaVersion = (HibSchemaVersion)container.getLatestVersion();
            SchemaResponse restSchema = (SchemaResponse)ClientHelper.call(() -> this.client().findSchemaByUuid(container.getUuid(), new ParameterProvider[0]));
            MeshAssertions.assertThat((SchemaResponse)restSchema).matches(schemaVersion).isValid();
        }
    }

    @Test
    public void testReadVersion() {
        String uuid = (String)this.tx(() -> this.schemaContainer("content").getUuid());
        String latestVersion = (String)this.tx(() -> ((HibSchemaVersion)this.schemaContainer("content").getLatestVersion()).getVersion());
        String json = (String)this.tx(() -> ((HibSchemaVersion)this.schemaContainer("content").getLatestVersion()).getJson());
        SchemaResponse restSchema = (SchemaResponse)ClientHelper.call(() -> this.client().findSchemaByUuid(uuid, new ParameterProvider[]{new VersioningParametersImpl().setVersion(latestVersion)}));
        Assert.assertEquals((String)"The loaded version did not match up with the requested version.", (Object)latestVersion, (Object)restSchema.getVersion());
        SchemaUpdateRequest request = (SchemaUpdateRequest)JsonUtil.readValue((String)json, SchemaUpdateRequest.class);
        request.setDescription("New description");
        request.addField((FieldSchema)FieldUtil.createHtmlFieldSchema((String)"someHtml"));
        this.grantAdmin();
        this.waitForJobs(() -> ClientHelper.call(() -> this.client().updateSchema(uuid, request, new ParameterProvider[0])), JobStatus.COMPLETED, 1);
        this.revokeAdmin();
        restSchema = (SchemaResponse)ClientHelper.call(() -> this.client().findSchemaByUuid(uuid, new ParameterProvider[]{new VersioningParametersImpl().setVersion(latestVersion)}));
        Assert.assertEquals((String)"The loaded version did not match up with the requested version.", (Object)latestVersion, (Object)restSchema.getVersion());
        restSchema = (SchemaResponse)ClientHelper.call(() -> this.client().findSchemaByUuid(uuid, new ParameterProvider[0]));
        Assert.assertEquals((String)"The loaded version did not match up with the requested version.", (Object)"2.0", (Object)restSchema.getVersion());
        restSchema = (SchemaResponse)ClientHelper.call(() -> this.client().findSchemaByUuid(uuid, new ParameterProvider[]{new VersioningParametersImpl().setVersion("2.0")}));
        Assert.assertEquals((String)"The loaded version did not match up with the requested version.", (Object)"2.0", (Object)restSchema.getVersion());
    }

    @Test
    public void testReadBogusVersion() {
        String uuid = (String)this.tx(() -> this.schemaContainer("content").getUuid());
        ClientHelper.call(() -> this.client().findSchemaByUuid(uuid, new ParameterProvider[]{new VersioningParametersImpl().setVersion("5.0")}), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"object_not_found_for_uuid_version", (String[])new String[]{uuid, "5.0"});
        ClientHelper.call(() -> this.client().findSchemaByUuid(uuid, new ParameterProvider[]{new VersioningParametersImpl().setVersion("sadgsdgasgd")}), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"error_illegal_version", (String[])new String[]{"sadgsdgasgd"});
    }

    @Override
    @Test
    public void testReadByUuidWithRolePerms() {
        String uuid = (String)this.db().tx(() -> this.schemaContainer("content").getUuid());
        SchemaResponse schema = (SchemaResponse)ClientHelper.call(() -> this.client().findSchemaByUuid(uuid, new ParameterProvider[]{new RolePermissionParametersImpl().setRoleUuid((String)this.db().tx(() -> this.role().getUuid()))}));
        Assert.assertNotNull((Object)schema.getRolePerms());
        MeshAssertions.assertThat((PermissionInfo)schema.getRolePerms()).hasPerm(Permission.basicPermissions());
    }

    @Override
    @Test
    public void testReadByUUIDWithMissingPermission() throws Exception {
        String uuid = (String)this.tx(() -> this.schemaContainer("content").getUuid());
        this.tx(tx -> {
            RoleDao roleDao = tx.roleDao();
            HibSchema schema = this.schemaContainer("content");
            roleDao.grantPermissions(this.role(), (HibBaseElement)schema, new InternalPermission[]{InternalPermission.DELETE_PERM});
            roleDao.grantPermissions(this.role(), (HibBaseElement)schema, new InternalPermission[]{InternalPermission.UPDATE_PERM});
            roleDao.grantPermissions(this.role(), (HibBaseElement)schema, new InternalPermission[]{InternalPermission.CREATE_PERM});
            roleDao.revokePermissions(this.role(), (HibBaseElement)schema, new InternalPermission[]{InternalPermission.READ_PERM});
        });
        ClientHelper.call(() -> this.client().findSchemaByUuid(uuid, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{uuid, InternalPermission.READ_PERM.getRestPerm().getName()});
    }

    @Test
    public void testReadSchemaByInvalidUUID() throws Exception {
        ClientHelper.call(() -> this.client().findSchemaByUuid("bogus", new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"object_not_found_for_uuid", (String[])new String[]{"bogus"});
    }

    @Override
    @Test
    @Ignore(value="Update tests are covered by dedicated test class")
    public void testUpdate() throws GenericRestException, Exception {
    }

    @Test
    public void testCreateWithConflictingName() {
        String name = "folder";
        SchemaCreateRequest request = new SchemaCreateRequest();
        request.setSegmentField("name");
        request.getFields().add(FieldUtil.createStringFieldSchema((String)"name").setRequired(true));
        request.setDisplayField("name");
        request.setName(name);
        ClientHelper.call(() -> this.client().createSchema(request, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.CONFLICT, (String)"schema_conflicting_name", (String[])new String[]{name});
    }

    @Test
    public void testUpdateWithUrlFields() {
        String uuid = (String)this.tx(() -> this.schemaContainer("folder").getUuid());
        String json = (String)this.tx(() -> ((HibSchemaVersion)this.schemaContainer("folder").getLatestVersion()).getJson());
        SchemaUpdateRequest request = (SchemaUpdateRequest)JsonUtil.readValue((String)json, SchemaUpdateRequest.class);
        request.setUrlFields(new String[]{"slug"});
        this.waitForJob(() -> ClientHelper.call(() -> this.client().updateSchema(uuid, request, new ParameterProvider[0])));
    }

    @Test
    public void testSetAutoPurgeToNull() {
        String schemaUuid = (String)this.tx(() -> this.schemaContainer("folder").getUuid());
        SchemaResponse response = (SchemaResponse)ClientHelper.call(() -> this.client().findSchemaByUuid(schemaUuid, new ParameterProvider[0]));
        Assert.assertNull((Object)response.getAutoPurge());
        SchemaUpdateRequest request = response.toUpdateRequest();
        request.setAutoPurge(Boolean.valueOf(true));
        this.waitForJob(() -> ClientHelper.call(() -> this.client().updateSchema(schemaUuid, request, new ParameterProvider[0])));
        Assert.assertTrue((String)"The flag should be updated", (boolean)((SchemaResponse)ClientHelper.call(() -> this.client().findSchemaByUuid(schemaUuid, new ParameterProvider[0]))).getAutoPurge());
        request.setAutoPurge(null);
        this.waitForJob(() -> ClientHelper.call(() -> this.client().updateSchema(schemaUuid, request, new ParameterProvider[0])));
        Assert.assertNull((String)"The flag should be updated to null", (Object)((SchemaResponse)ClientHelper.call(() -> this.client().findSchemaByUuid(schemaUuid, new ParameterProvider[0]))).getAutoPurge());
    }

    @Test
    public void testUpdateWithReferencedMicroschema() {
        String MICROSCHEMA_NAME = "TestMicroschema";
        SchemaUpdateRequest schemaUpdate = (SchemaUpdateRequest)this.tx(() -> (SchemaUpdateRequest)JsonUtil.readValue((String)((HibSchemaVersion)this.schemaContainer("content").getLatestVersion()).getJson(), SchemaUpdateRequest.class));
        String schemaUuid = (String)this.tx(() -> this.schemaContainer("content").getUuid());
        String schemaVersion = (String)this.tx(() -> ((HibSchemaVersion)this.schemaContainer("content").getLatestVersion()).getVersion());
        MicroschemaCreateRequest microschemaRequest = new MicroschemaCreateRequest();
        microschemaRequest.setName("TestMicroschema");
        microschemaRequest.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"text"));
        microschemaRequest.addField((FieldSchema)FieldUtil.createNodeFieldSchema((String)"nodeRef").setAllowedSchemas(new String[]{"content"}));
        this.expect(MeshEvent.MICROSCHEMA_CREATED).match(1, MeshElementEventModelImpl.class, event -> {
            Assert.assertEquals((String)"The microschema name did not match.", (Object)"TestMicroschema", (Object)event.getName());
            Assert.assertNotNull((String)"The schema uuid was not set", (Object)event.getUuid());
            Assert.assertNotNull((String)"The origin has not been set", (Object)event.getOrigin());
        });
        MicroschemaResponse microschemaResponse = (MicroschemaResponse)ClientHelper.call(() -> this.client().createMicroschema(microschemaRequest));
        this.awaitEvents();
        String microschemaUuid = microschemaResponse.getUuid();
        List filteredList = ((MicroschemaListResponse)ClientHelper.call(() -> this.client().findMicroschemas("dummy", new ParameterProvider[0]))).getData().stream().filter(microschema -> microschema.getUuid().equals(microschemaUuid)).collect(Collectors.toList());
        MeshAssertions.assertThat(filteredList).isEmpty();
        schemaUpdate.addField((FieldSchema)FieldUtil.createMicronodeFieldSchema((String)"micro").setAllowedMicroSchemas(new String[]{"TestMicroschema"}));
        this.expect(MeshEvent.SCHEMA_UPDATED).match(1, MeshElementEventModelImpl.class, event -> {
            Assert.assertEquals((Object)"content", (Object)event.getName());
            Assert.assertEquals((Object)schemaUuid, (Object)event.getUuid());
        });
        this.expect(MeshEvent.MICROSCHEMA_BRANCH_ASSIGN).match(1, BranchMicroschemaAssignModel.class, event -> {
            BranchReference branch = event.getBranch();
            Assert.assertNotNull((String)"Branch reference was not set", (Object)branch);
            Assert.assertNotNull((Object)branch.getName());
            Assert.assertEquals((Object)this.initialBranchUuid(), (Object)branch.getUuid());
            MicroschemaReference schema = (MicroschemaReference)event.getSchema();
            Assert.assertNotNull((String)"The microschema reference has not been set", (Object)schema);
            Assert.assertEquals((String)"Missing microschema name", (Object)"TestMicroschema", (Object)schema.getName());
            Assert.assertNotNull((String)"Microschema uuid not set in event.", (Object)schema.getUuid());
            ProjectReference project = event.getProject();
            Assert.assertNotNull((String)"The project reference was not set", (Object)project);
            Assert.assertNotNull((Object)project.getName());
            Assert.assertNotNull((Object)project.getUuid());
        });
        this.expect(MeshEvent.SCHEMA_BRANCH_ASSIGN).match(1, BranchSchemaAssignEventModel.class, event -> {
            BranchReference branch = event.getBranch();
            Assert.assertNotNull((String)"Branch reference was not set", (Object)branch);
            Assert.assertNotNull((Object)branch.getName());
            Assert.assertEquals((Object)this.initialBranchUuid(), (Object)branch.getUuid());
            SchemaReference schema = (SchemaReference)event.getSchema();
            Assert.assertNotNull((String)"The schema reference has not been set", (Object)schema);
            Assert.assertEquals((String)"Missing Schema name", (Object)"content", (Object)schema.getName());
            Assert.assertEquals((String)"Schema uuid did not match.", (Object)schemaUuid, (Object)schema.getUuid());
            ProjectReference project = event.getProject();
            Assert.assertNotNull((String)"The project reference was not set", (Object)project);
            Assert.assertNotNull((Object)project.getName());
            Assert.assertNotNull((Object)project.getUuid());
        });
        this.expect(MeshEvent.SCHEMA_MIGRATION_START).match(1, SchemaMigrationMeshEventModel.class, event -> this.assertMigrationEvent((SchemaMigrationMeshEventModel)event, schemaVersion, schemaUuid));
        this.expect(MeshEvent.NODE_UPDATED).match(36, NodeMeshEventModel.class, event -> {
            EventCauseInfo cause = event.getCause();
            Assert.assertTrue((String)"The cause of the node update event did not have the correct type.", (boolean)(cause instanceof SchemaMigrationCause));
            SchemaMigrationCause migrationCause = (SchemaMigrationCause)cause;
            this.assertMigrationEvent((SchemaMigrationMeshEventModel)migrationCause, schemaVersion, schemaUuid);
        });
        this.expect(MeshEvent.SCHEMA_MIGRATION_FINISHED).match(1, SchemaMigrationMeshEventModel.class, event -> this.assertMigrationEvent((SchemaMigrationMeshEventModel)event, schemaVersion, schemaUuid));
        this.grantAdmin();
        this.waitForJob(() -> ClientHelper.call(() -> this.client().updateSchema(schemaUuid, schemaUpdate, new ParameterProvider[0])));
        this.revokeAdmin();
        this.awaitEvents();
        filteredList = ((MicroschemaListResponse)ClientHelper.call(() -> this.client().findMicroschemas("dummy", new ParameterProvider[0]))).getData().stream().filter(microschema -> microschema.getUuid().equals(microschemaUuid)).collect(Collectors.toList());
        MeshAssertions.assertThat(filteredList).hasSize(1);
    }

    private void assertMigrationEvent(SchemaMigrationMeshEventModel event, String schemaVersion, String schemaUuid) {
        SchemaReference from = event.getFromVersion();
        Assert.assertNotNull((Object)from);
        Assert.assertEquals((String)"The from schema uuid did not match.", (Object)schemaUuid, (Object)from.getUuid());
        Assert.assertEquals((String)"The from version did not match", (Object)schemaVersion, (Object)from.getVersion());
        SchemaReference to = event.getToVersion();
        Assert.assertNotNull((Object)to);
        Assert.assertEquals((String)"The to schema uuid did not match.", (Object)schemaUuid, (Object)to.getUuid());
        System.out.println(event.toJson());
        BranchReference branch = event.getBranch();
        Assert.assertNotNull((Object)branch);
        Assert.assertEquals((String)"Branch name did not match.", (Object)"dummy", (Object)branch.getName());
        Assert.assertEquals((String)"Branch uuid did not match", (Object)this.initialBranchUuid(), (Object)branch.getUuid());
        ProjectReference project = event.getProject();
        Assert.assertNotNull((Object)project);
        Assert.assertEquals((String)"The project name did not match up.", (Object)"dummy", (Object)project.getName());
        Assert.assertEquals((String)"The project uuid did notmatch up.", (Object)this.projectUuid(), (Object)project.getUuid());
    }

    @Test
    public void testUpdateWithConflictingName() {
        String name = "newschema";
        SchemaCreateRequest request = new SchemaCreateRequest();
        request.setSegmentField("name");
        request.getFields().add(FieldUtil.createStringFieldSchema((String)"name").setRequired(true));
        request.setDisplayField("name");
        request.setName(name);
        SchemaResponse response = (SchemaResponse)ClientHelper.call(() -> this.client().createSchema(request, new ParameterProvider[0]));
        SchemaUpdateRequest updateRequest = new SchemaUpdateRequest();
        updateRequest.setSegmentField("name");
        updateRequest.getFields().add(FieldUtil.createStringFieldSchema((String)"name").setRequired(true));
        updateRequest.setDisplayField("name");
        updateRequest.setName("folder");
        ClientHelper.call(() -> this.client().updateSchema(response.getUuid(), updateRequest, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.CONFLICT, (String)"schema_conflicting_name", (String[])new String[]{"folder"});
    }

    @Override
    @Test
    public void testUpdateWithBogusUuid() throws GenericRestException, Exception {
        try (Tx tx = this.tx();){
            SchemaDao schemaDao = tx.schemaDao();
            HibSchema schema = this.schemaContainer("content");
            String oldName = schema.getName();
            SchemaUpdateRequest request = new SchemaUpdateRequest();
            request.setName("new-name");
            ClientHelper.call(() -> this.client().updateSchema("bogus", request, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"object_not_found_for_uuid", (String[])new String[]{"bogus"});
            HibSchema reloaded = (HibSchema)schemaDao.findByUuid(schema.getUuid());
            Assert.assertEquals((String)"The name should not have been changed.", (Object)oldName, (Object)reloaded.getName());
        }
    }

    @Test
    public void testDeleteWithChanges() {
        SchemaCreateRequest schemaCreateRequest = new SchemaCreateRequest();
        schemaCreateRequest.setName("fordeletion");
        SchemaResponse response = (SchemaResponse)ClientHelper.call(() -> this.client().createSchema(schemaCreateRequest, new ParameterProvider[0]));
        String uuid = response.getUuid();
        SchemaUpdateRequest request = response.toUpdateRequest();
        request.setDescription("Updated schema for deletion");
        ClientHelper.call(() -> this.client().updateSchema(uuid, request, new ParameterProvider[0]));
        ClientHelper.call(() -> this.client().deleteSchema(uuid));
    }

    @Override
    @Test
    public void testDeleteByUUID() throws Exception {
        try (Tx tx2 = this.tx();){
            SchemaDao schemaDao = tx2.schemaDao();
            HibSchema schema = this.schemaContainer("content");
            MeshAssertions.assertThat((Iterable)schemaDao.getNodes(schema)).isNotEmpty();
        }
        String uuid = (String)this.db().tx(() -> this.schemaContainer("content").getUuid());
        ClientHelper.call(() -> this.client().deleteSchema(uuid), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"schema_delete_still_in_use", (String[])new String[]{uuid});
        this.grantAdmin();
        this.waitForJobs(() -> {
            SchemaResponse schemaResponse = (SchemaResponse)ClientHelper.call(() -> this.client().findSchemaByUuid(uuid, new ParameterProvider[0]));
            SchemaUpdateRequest request = (SchemaUpdateRequest)JsonUtil.readValue((String)schemaResponse.toJson(), SchemaUpdateRequest.class);
            request.setDescription("SomeOtherDescription");
            ClientHelper.call(() -> this.client().updateSchema(uuid, request, new ParameterProvider[0]));
        }, JobStatus.COMPLETED, 1);
        String jobUuid = (String)this.tx(tx -> ((HibJob)((HibSchemaVersion)((HibSchema)tx.schemaDao().findByUuid(uuid)).getLatestVersion()).referencedJobsViaTo().iterator().next()).getUuid());
        try (Tx tx3 = this.tx();){
            SchemaDao schemaDao = tx3.schemaDao();
            HibSchema reloaded = (HibSchema)schemaDao.findByUuid(uuid);
            NodeDao nodeDao = tx3.nodeDao();
            Assert.assertNotNull((String)"The schema should not have been deleted.", (Object)reloaded);
            MeshAssertions.assertThat((Iterable)schemaDao.getNodes(reloaded)).isNotEmpty();
            BulkActionContext context = this.createBulkContext();
            for (HibNode node : schemaDao.getNodes((HibSchema)schemaDao.findByUuid(this.getSchemaContainer().getUuid())).list()) {
                nodeDao.delete(node, context, false, true);
            }
            MeshAssertions.assertThat((Iterable)schemaDao.getNodes((HibSchema)schemaDao.findByUuid(uuid))).isEmpty();
            tx3.success();
        }
        String versionUuid = (String)this.tx(() -> ((HibSchemaVersion)this.schemaContainer("content").getLatestVersion()).getUuid());
        Object versionId = this.tx(() -> ((HibSchemaVersion)this.schemaContainer("content").getLatestVersion()).getId());
        Assert.assertNotNull((String)"The version should exist.", this.tx(tx -> (HibSchemaVersion)((CommonTx)tx.unwrap()).schemaDao().findVersionByUuid((HibFieldSchemaElement)this.schemaContainer("content"), versionUuid)));
        this.expect(MeshEvent.SCHEMA_DELETED).match(1, MeshElementEventModelImpl.class, event -> ((MeshElementEventModelAssert)MeshAssertions.assertThat((MeshElementEventModel)event).hasName("content")).hasUuid(uuid));
        ClientHelper.call(() -> this.client().deleteSchema(uuid));
        this.awaitEvents();
        try (Tx tx4 = this.tx();){
            SchemaDao schemaDao = tx4.schemaDao();
            Assert.assertNull((String)"The referenced job should have been deleted", (Object)((CommonTx)tx4.unwrap()).jobDao().findByUuid(jobUuid));
            HibSchema reloaded = (HibSchema)schemaDao.findByUuid(uuid);
            Assert.assertNull((String)"The version of the schema container should have been deleted as well.", (Object)((CommonTx)tx4.unwrap()).load(versionId, ((CommonTx)tx4.unwrap()).schemaDao().getVersionPersistenceClass()));
            Assert.assertNull((String)"The schema should have been deleted.", (Object)reloaded);
        }
    }

    @Override
    @Test
    public void testDeleteByUUIDWithNoPermission() throws Exception {
        HibSchema schema = this.schemaContainer("content");
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            roleDao.revokePermissions(this.role(), (HibBaseElement)schema, new InternalPermission[]{InternalPermission.DELETE_PERM});
            tx.success();
        }
        tx = this.tx();
        try {
            ClientHelper.call(() -> this.client().deleteSchema(schema.getUuid()), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{schema.getUuid(), InternalPermission.DELETE_PERM.getRestPerm().getName()});
            MeshAssert.assertElement((DaoGlobal)tx.schemaDao(), (String)schema.getUuid(), (boolean)true);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Override
    @Test
    @Ignore(value="Fails on CI pipeline. See https://github.com/gentics/mesh/issues/608")
    public void testUpdateMultithreaded() throws Exception {
        String uuid = (String)this.tx(() -> this.schemaContainer("content").getUuid());
        String json = (String)this.tx(() -> ((HibSchemaVersion)this.schemaContainer("content").getLatestVersion()).getJson());
        int nJobs = 20;
        Observable.range((int)0, (int)nJobs).flatMapCompletable(i -> {
            SchemaUpdateRequest request = (SchemaUpdateRequest)JsonUtil.readValue((String)json, SchemaUpdateRequest.class);
            request.setName("newname" + i);
            return this.client().updateSchema(uuid, request, new ParameterProvider[0]).toCompletable();
        }).blockingAwait();
    }

    @Override
    @Test
    @Ignore(value="not yet supported")
    public void testReadByUuidMultithreaded() throws Exception {
        int nJobs = 10;
        try (Tx tx = this.tx();){
            HibSchema schema = this.schemaContainer("content");
            String uuid = schema.getUuid();
            Observable.range((int)0, (int)nJobs).flatMapCompletable(i -> this.client().findSchemaByUuid(uuid, new ParameterProvider[0]).toCompletable()).blockingAwait();
        }
    }

    @Override
    @Test
    @Ignore(value="not yet supported")
    public void testDeleteByUUIDMultithreaded() throws Exception {
        int nJobs = 3;
        try (Tx tx = this.tx();){
            HibSchema schema = this.schemaContainer("content");
            ClientHelper.validateDeletion(i -> this.client().deleteSchema(schema.getUuid()), (int)nJobs);
        }
    }

    @Override
    @Test
    public void testCreateMultithreaded() throws Exception {
        int nJobs = 20;
        List uuids = (List)Observable.range((int)0, (int)nJobs).flatMapSingle(i -> {
            SchemaCreateRequest request = new SchemaCreateRequest();
            request.setName("new_schema_name_" + i);
            return this.client().createSchema(request, new ParameterProvider[0]).toSingle();
        }).map(AbstractResponse::getUuid).toList().blockingGet();
        MeshTestHelper.validateCreation(uuids);
    }

    @Override
    @Test
    public void testReadByUuidMultithreadedNonBlocking() throws Exception {
        int nJobs = 200;
        try (Tx tx = this.tx();){
            HibSchema schema = this.schemaContainer("content");
            MeshTestHelper.awaitConcurrentRequests(nJobs, i -> this.client().findSchemaByUuid(schema.getUuid(), new ParameterProvider[0]));
        }
    }

    @Override
    @Test
    public void testUpdateByUUIDWithoutPerm() throws Exception {
        String schemaUuid;
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            HibSchema schema = this.schemaContainer("content");
            roleDao.revokePermissions(this.role(), (HibBaseElement)schema, new InternalPermission[]{InternalPermission.UPDATE_PERM});
            schemaUuid = schema.getUuid();
            tx.success();
        }
        SchemaUpdateRequest request = new SchemaUpdateRequest();
        request.setName("new-name");
        ClientHelper.call(() -> this.client().updateSchema(schemaUuid, request, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{schemaUuid, InternalPermission.UPDATE_PERM.getRestPerm().getName()});
    }

    @Override
    @Test
    public void testPermissionResponse() {
        SchemaResponse schema = (SchemaResponse)((SchemaListResponse)this.client().findSchemas(new ParameterProvider[0]).blockingGet()).getData().get(0);
        MeshAssertions.assertThat((PermissionInfo)schema.getPermissions()).hasNoPublishPermsSet();
    }

    @Test
    public void testConflictingNameWithMicroschema() throws InterruptedException {
        MicroschemaCreateRequest microSchemaRequest = new MicroschemaCreateRequest().setName("test");
        SchemaCreateRequest schemaRequest = new SchemaCreateRequest().setName("test");
        this.client().createMicroschema(microSchemaRequest).blockingAwait();
        ClientHelper.call(() -> this.client().createSchema(schemaRequest, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.CONFLICT, (String)"microschema_conflicting_name", (String[])new String[]{"test"});
    }

    @Test
    public void testDuplicateLanguage() {
        ClientHelper.call(() -> this.client().createSchema(this.loadResourceJsonAsPojo("schemas/languageOverride/duplicateLanguage.json", SchemaCreateRequest.class), new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"error_language_duplicate_override", (String[])new String[]{"de"});
    }

    @Test
    public void testMicronodeFieldWithoutAllow() {
        SchemaResponse response = (SchemaResponse)ClientHelper.call(() -> {
            SchemaCreateRequest request = new SchemaCreateRequest().setName("withoutallow");
            request.addField((FieldSchema)new MicronodeFieldSchemaImpl().setName("field"));
            return this.client().createSchema(request, new ParameterProvider[0]);
        });
        this.tx(tx -> {
            HibSchema schema = (HibSchema)tx.schemaDao().findByUuid(response.getUuid());
            HibSchemaVersion version = (HibSchemaVersion)schema.getLatestVersion();
            ((AbstractCharSequenceAssert)MeshAssertions.assertThat((String)version.getMicroschemaVersionHash(this.initialBranch())).as("Microschema Version Hash", new Object[0])).isNull();
        });
    }

    @Test
    public void testMicronodeListFieldWithoutAllow() {
        SchemaResponse response = (SchemaResponse)ClientHelper.call(() -> {
            SchemaCreateRequest request = new SchemaCreateRequest().setName("withoutallow");
            request.addField(new ListFieldSchemaImpl().setListType("micronode").setName("field"));
            return this.client().createSchema(request, new ParameterProvider[0]);
        });
        this.tx(tx -> {
            HibSchema schema = (HibSchema)tx.schemaDao().findByUuid(response.getUuid());
            HibSchemaVersion version = (HibSchemaVersion)schema.getLatestVersion();
            ((AbstractCharSequenceAssert)MeshAssertions.assertThat((String)version.getMicroschemaVersionHash(this.initialBranch())).as("Microschema Version Hash", new Object[0])).isNull();
        });
    }
}

