/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.schema;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.data.i18n.I18NUtil;
import com.gentics.mesh.core.rest.error.GenericRestException;
import com.gentics.mesh.core.rest.microschema.impl.MicroschemaModelImpl;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.FieldSchemaContainer;
import com.gentics.mesh.core.rest.schema.ListFieldSchema;
import com.gentics.mesh.core.rest.schema.SchemaModel;
import com.gentics.mesh.core.rest.schema.SchemaVersionModel;
import com.gentics.mesh.core.rest.schema.StringFieldSchema;
import com.gentics.mesh.core.rest.schema.impl.HtmlFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.ListFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.SchemaModelImpl;
import com.gentics.mesh.json.JsonUtil;
import com.gentics.mesh.json.MeshJsonException;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;

public class SchemaModelTest {
    private void expectErrorOnValidate(FieldSchemaContainer container, String bodyMessageI18nKey, String ... i18nParams) {
        try {
            container.validate();
            Assert.fail((String)("No exception was thrown but we would expect a {" + bodyMessageI18nKey + "} error."));
        }
        catch (GenericRestException e) {
            Assert.assertEquals((String)"The exception did not contain the expected message.", (Object)bodyMessageI18nKey, (Object)e.getI18nKey());
            Assert.assertArrayEquals((Object[])i18nParams, (Object[])e.getI18nParameters());
            Locale en = Locale.ENGLISH;
            String text = I18NUtil.get((Locale)en, (String)bodyMessageI18nKey, (String[])i18nParams);
            Assert.assertNotEquals((String)("English translation for key " + bodyMessageI18nKey + " not found"), (Object)text, (Object)bodyMessageI18nKey);
            Locale de = Locale.GERMAN;
            text = I18NUtil.get((Locale)de, (String)bodyMessageI18nKey, (String[])i18nParams);
            Assert.assertNotEquals((String)("German translation for key " + bodyMessageI18nKey + " not found"), (Object)text, (Object)bodyMessageI18nKey);
        }
    }

    @Test
    public void testSimpleSchema() throws IOException {
        SchemaModelImpl schema = new SchemaModelImpl();
        schema.setName("dummySchema");
        schema.setContainer(Boolean.valueOf(true));
        schema.addField((FieldSchema)new HtmlFieldSchemaImpl().setLabel("Label").setName("Name").setRequired(true));
        this.validateSchema((SchemaModel)schema);
    }

    @Test
    public void testSchemaWithNoFieldType() throws IOException {
        SchemaModelImpl schema = new SchemaModelImpl();
        schema.setName("dummySchema");
        schema.setContainer(Boolean.valueOf(true));
        schema.addField((FieldSchema)new HtmlFieldSchemaImpl().setLabel("Label").setName("Name").setRequired(true));
        JsonObject json = new JsonObject(schema.toJson());
        json.getJsonArray("fields").getJsonObject(0).remove("type");
        try {
            JsonUtil.readValue((String)json.encodePrettily(), SchemaModelImpl.class);
            Assert.fail((String)"An error should have been thrown");
        }
        catch (GenericRestException e) {
            MeshAssertions.assertThat((GenericRestException)e).matches("error_json_structure_invalid", new String[]{"8", "4", "fields", "Missing type property for field {Name}"});
        }
    }

    @Test
    public void testSchemaNameValidation() {
        SchemaModelImpl schema = new SchemaModelImpl();
        schema.setContainer(Boolean.valueOf(true));
        schema.addField((FieldSchema)new HtmlFieldSchemaImpl().setLabel("Label").setName("Name").setRequired(true));
        schema.setName("dummySchema");
        schema.validate();
        schema.setName("dummy-name");
        this.expectErrorOnValidate((FieldSchemaContainer)schema, "schema_error_invalid_name", schema.getName());
        schema.setName("DummyName");
        schema.validate();
        schema.setName("D\u00f6mmyN\u00e4me");
        this.expectErrorOnValidate((FieldSchemaContainer)schema, "schema_error_invalid_name", schema.getName());
        schema.setName("0.9");
        this.expectErrorOnValidate((FieldSchemaContainer)schema, "schema_error_invalid_name", schema.getName());
        schema.setName("a0");
        schema.validate();
        schema.setName("0");
        this.expectErrorOnValidate((FieldSchemaContainer)schema, "schema_error_invalid_name", schema.getName());
        schema.setName("ab cd");
        this.expectErrorOnValidate((FieldSchemaContainer)schema, "schema_error_invalid_name", schema.getName());
    }

    @Test
    public void testComplexSchema() throws IOException {
        SchemaModelImpl schema = new SchemaModelImpl();
        schema.setName("dummySchema");
        schema.setDisplayField("name");
        schema.setSegmentField("name_2");
        schema.setContainer(Boolean.valueOf(true));
        schema.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"name"));
        schema.addField(FieldUtil.createHtmlFieldSchema((String)"name_1").setLabel("label_1").setRequired(true));
        schema.addField(FieldUtil.createStringFieldSchema((String)"name_2").setLabel("label_2").setRequired(true));
        schema.addField(FieldUtil.createNumberFieldSchema((String)"name_3").setLabel("label_3").setRequired(true));
        schema.addField(FieldUtil.createDateFieldSchema((String)"name_4").setLabel("label_4").setRequired(true));
        schema.addField(FieldUtil.createBooleanFieldSchema((String)"name_5").setLabel("label_5").setRequired(true));
        ListFieldSchemaImpl listFieldSchema = new ListFieldSchemaImpl();
        listFieldSchema.setLabel("label_7").setName("name_7").setRequired(true);
        listFieldSchema.setAllowedSchemas(new String[]{"folder", "videos"});
        listFieldSchema.setListType("node");
        schema.addField((FieldSchema)listFieldSchema);
        schema.validate();
        this.validateSchema((SchemaModel)schema);
    }

    private void validateSchema(SchemaModel schema) throws JsonParseException, JsonMappingException, IOException {
        Assert.assertNotNull((Object)schema);
        String json = schema.toJson();
        System.out.println(json);
        Assert.assertNotNull((Object)json);
        SchemaModel deserializedSchema = (SchemaModel)JsonUtil.readValue((String)json, SchemaModelImpl.class);
        Assert.assertEquals((long)schema.getFields().size(), (long)deserializedSchema.getFields().size());
        Assert.assertNotNull((Object)deserializedSchema);
    }

    @Test
    public void testNoNameInvalid() throws MeshJsonException {
        SchemaModelImpl schema = new SchemaModelImpl();
        this.expectErrorOnValidate((FieldSchemaContainer)schema, "schema_error_no_name", new String[0]);
    }

    @Test
    public void testNoFields() throws MeshJsonException {
        SchemaModelImpl schema = new SchemaModelImpl();
        schema.setName("test");
        schema.validate();
    }

    @Test
    public void testSegmentFieldNotSet() throws MeshJsonException {
        SchemaVersionModel schema = FieldUtil.createMinimalValidSchema();
        schema.setSegmentField(null);
        schema.validate();
    }

    @Test
    public void testSegmentFieldInvalid() throws MeshJsonException {
        SchemaModelImpl schema = new SchemaModelImpl();
        schema.setName("test");
        schema.setSegmentField("invalid");
        schema.setDisplayField("name");
        schema.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"name"));
        this.expectErrorOnValidate((FieldSchemaContainer)schema, "schema_error_segmentfield_invalid", "invalid");
    }

    @Test
    public void testMinimalSchemaValid() throws MeshJsonException {
        SchemaVersionModel schema = FieldUtil.createMinimalValidSchema();
        schema.validate();
    }

    @Test
    public void testDisplayFieldNotSet() throws MeshJsonException {
        SchemaModelImpl schema = new SchemaModelImpl();
        schema.setName("test");
        schema.setSegmentField("name");
        schema.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"name"));
        schema.validate();
    }

    @Test
    public void testDuplicateLabelCheckWithNullValues() {
        SchemaModelImpl schema = new SchemaModelImpl();
        schema.setName("test");
        schema.setSegmentField("fieldA");
        schema.setDisplayField("fieldB");
        StringFieldSchema fieldA = FieldUtil.createStringFieldSchema((String)"fieldA");
        StringFieldSchema fieldB = FieldUtil.createStringFieldSchema((String)"fieldB");
        fieldA.setLabel(null);
        fieldB.setLabel(null);
        schema.addField((FieldSchema)fieldA);
        schema.addField((FieldSchema)fieldB);
        schema.validate();
    }

    @Test
    public void testInvalidListType() {
        SchemaVersionModel schema = FieldUtil.createMinimalValidSchema();
        ListFieldSchema listField = FieldUtil.createListFieldSchema((String)"listField");
        listField.setListType("blabla");
        schema.addField((FieldSchema)listField);
        this.expectErrorOnValidate((FieldSchemaContainer)schema, "schema_error_list_type_invalid", "blabla", "listField");
    }

    @Test
    public void testMissingListType() {
        SchemaVersionModel schema = FieldUtil.createMinimalValidSchema();
        ListFieldSchema listField = FieldUtil.createListFieldSchema((String)"listField");
        listField.setListType(null);
        schema.addField((FieldSchema)listField);
        this.expectErrorOnValidate((FieldSchemaContainer)schema, "schema_error_list_type_missing", "listField");
    }

    @Test
    public void testDisplayFieldInvalid() {
        SchemaModelImpl schema = new SchemaModelImpl();
        schema.setName("test");
        schema.setSegmentField("name");
        schema.setDisplayField("invalid");
        schema.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"name"));
        this.expectErrorOnValidate((FieldSchemaContainer)schema, "schema_error_displayfield_invalid", "invalid");
    }

    @Test
    public void testBinaryDisplayField() {
        SchemaModelImpl schema = new SchemaModelImpl();
        schema.setName("test");
        schema.setDisplayField("binary");
        schema.addField((FieldSchema)FieldUtil.createBinaryFieldSchema((String)"binary"));
        schema.validate();
    }

    @Test
    public void testDuplicateFieldSchemaName() {
        SchemaModelImpl schema = new SchemaModelImpl();
        schema.setName("test");
        schema.setSegmentField("name");
        schema.setDisplayField("name");
        schema.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"name"));
        schema.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"name"));
        this.expectErrorOnValidate((FieldSchemaContainer)schema, "schema_error_duplicate_field_name", "name");
    }

    @Test
    public void testCaseSensitivityDuplicateSchemaName() {
        SchemaModelImpl schema = new SchemaModelImpl();
        schema.setName("test");
        schema.setSegmentField("name");
        schema.setDisplayField("name");
        schema.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"name"));
        schema.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"Name"));
        this.expectErrorOnValidate((FieldSchemaContainer)schema, "schema_error_duplicate_field_name", "Name");
    }

    @Test
    public void testDisplayFieldInvalidType() {
        SchemaModelImpl schema = new SchemaModelImpl();
        schema.setName("test");
        schema.setSegmentField("name");
        schema.setDisplayField("name");
        schema.addField((FieldSchema)FieldUtil.createNumberFieldSchema((String)"name"));
        this.expectErrorOnValidate((FieldSchemaContainer)schema, "schema_error_displayfield_type_invalid", "name");
    }

    @Test
    public void testSegmentFieldBinaryField() {
        SchemaVersionModel schema = FieldUtil.createMinimalValidSchema();
        schema.addField((FieldSchema)FieldUtil.createBinaryFieldSchema((String)"binaryField"));
        schema.setSegmentField("binaryField");
        schema.validate();
    }

    @Test
    public void testSegmentFieldToNoStringOrBinaryFieldInvalid() {
        SchemaVersionModel schema = FieldUtil.createMinimalValidSchema();
        schema.addField((FieldSchema)FieldUtil.createNumberFieldSchema((String)"numberField"));
        schema.setSegmentField("numberField");
        this.expectErrorOnValidate((FieldSchemaContainer)schema, "schema_error_segmentfield_type_invalid", "number");
    }

    @Test
    public void testMicroschemaUnsupportedFieldTypeBinary() {
        MicroschemaModelImpl schema = new MicroschemaModelImpl();
        schema.setName("test");
        schema.setDescription("some blub");
        schema.addField((FieldSchema)FieldUtil.createBinaryFieldSchema((String)"binary"));
        this.expectErrorOnValidate((FieldSchemaContainer)schema, "microschema_error_field_type_not_allowed", "binary", "binary");
    }

    @Test
    public void testMicroschemaUnsupportedFieldTypeMicronode() {
        MicroschemaModelImpl schema = new MicroschemaModelImpl();
        schema.setName("test");
        schema.setDescription("some blub");
        schema.addField((FieldSchema)FieldUtil.createMicronodeFieldSchema((String)"micronode"));
        this.expectErrorOnValidate((FieldSchemaContainer)schema, "microschema_error_field_type_not_allowed", "micronode", "micronode");
    }

    @Test
    public void testMicroschemaUnsupportedFieldTypeMicronodeList() {
        MicroschemaModelImpl schema = new MicroschemaModelImpl();
        schema.setName("test");
        schema.setDescription("some blub");
        schema.addField((FieldSchema)FieldUtil.createListFieldSchema((String)"list").setListType("micronode"));
        this.expectErrorOnValidate((FieldSchemaContainer)schema, "microschema_error_field_type_not_allowed", "list", "list:micronode");
    }

    @Test
    public void testMicroschemaUnsupportedFieldTypeBinaryList() {
        MicroschemaModelImpl schema = new MicroschemaModelImpl();
        schema.setName("test");
        schema.setDescription("some blub");
        schema.addField((FieldSchema)FieldUtil.createListFieldSchema((String)"list").setListType("binary"));
        this.expectErrorOnValidate((FieldSchemaContainer)schema, "microschema_error_field_type_not_allowed", "list", "list:binary");
    }
}

