/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.schema;

import com.gentics.mesh.core.rest.microschema.impl.MicroschemaCreateRequest;
import com.gentics.mesh.core.rest.schema.impl.SchemaCreateRequest;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.rest.client.MeshRequest;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractNaughtyStringTest;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.TRACKING, testSize=TestSize.FULL, startServer=true)
public class SchemaNameTest
extends AbstractNaughtyStringTest {
    private Predicate<String> isValidName = Pattern.compile("^[_A-Za-z][_0-9A-Za-z]*$").asPredicate();

    @Test
    public void testCreateSchema() {
        SchemaCreateRequest request = new SchemaCreateRequest();
        request.setName(this.input);
        this.runTest(this.client().createSchema(request, new ParameterProvider[0]));
    }

    @Test
    public void testCreateMicroschema() {
        MicroschemaCreateRequest request = new MicroschemaCreateRequest();
        request.setName(this.input);
        this.runTest(this.client().createMicroschema(request));
    }

    private void runTest(MeshRequest<?> request) {
        if (this.isValidName.test(this.input)) {
            request.blockingAwait();
        } else {
            try {
                request.blockingAwait();
                Assert.fail((String)("Request should have thrown an exception. Tested string: " + this.input));
            }
            catch (RuntimeException ex) {
                ClientHelper.call(() -> request, (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST);
            }
        }
    }
}

