/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.schema;

import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.HibCoreElement;
import com.gentics.mesh.core.data.dao.ProjectDao;
import com.gentics.mesh.core.data.dao.RoleDao;
import com.gentics.mesh.core.data.dao.SchemaDao;
import com.gentics.mesh.core.data.perm.InternalPermission;
import com.gentics.mesh.core.data.project.HibProject;
import com.gentics.mesh.core.data.schema.HibSchema;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.MeshEvent;
import com.gentics.mesh.core.rest.event.project.ProjectSchemaEventModel;
import com.gentics.mesh.core.rest.project.ProjectCreateRequest;
import com.gentics.mesh.core.rest.project.ProjectReference;
import com.gentics.mesh.core.rest.project.ProjectResponse;
import com.gentics.mesh.core.rest.schema.SchemaListResponse;
import com.gentics.mesh.core.rest.schema.SchemaReference;
import com.gentics.mesh.core.rest.schema.impl.SchemaReferenceImpl;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.netty.handler.codec.http.HttpResponseStatus;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class SchemaProjectEndpointTest
extends AbstractMeshTest {
    @Test
    public void testReadProjectSchemas() {
        try (Tx tx = this.tx();){
            SchemaListResponse list = (SchemaListResponse)ClientHelper.call(() -> this.client().findSchemas("dummy", new ParameterProvider[0]));
            Assert.assertEquals((long)3L, (long)list.getData().size());
            ClientHelper.call(() -> this.client().unassignSchemaFromProject("dummy", this.schemaContainer("folder").getUuid()));
            list = (SchemaListResponse)ClientHelper.call(() -> this.client().findSchemas("dummy", new ParameterProvider[0]));
            Assert.assertEquals((long)2L, (long)list.getData().size());
        }
    }

    @Test
    public void testAddSchemaToExtraProject() {
        String name = "test12345";
        try (Tx tx = this.tx();){
            HibSchema schema = this.schemaContainer("content");
            ProjectCreateRequest request = new ProjectCreateRequest();
            request.setSchema((SchemaReference)new SchemaReferenceImpl().setName("folder"));
            request.setName("test12345");
            ProjectResponse restProject = (ProjectResponse)ClientHelper.call(() -> this.client().createProject(request));
            ClientHelper.call(() -> this.client().assignSchemaToProject(restProject.getName(), schema.getUuid()));
        }
    }

    @Test
    public void testAddSchemaToProjectWithPerm() throws Exception {
        HibProject extraProject;
        String schemaUuid = (String)this.tx(() -> this.schemaContainer("content").getUuid());
        ProjectCreateRequest request = new ProjectCreateRequest();
        request.setName("extraProject");
        request.setSchemaRef("folder");
        ProjectResponse created = (ProjectResponse)ClientHelper.call(() -> this.client().createProject(request));
        String projectUuid = created.getUuid();
        String projectName = created.getName();
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            ProjectDao projectDao = tx.projectDao();
            extraProject = (HibProject)projectDao.findByUuid(created.getUuid());
            HibSchema schema = this.schemaContainer("content");
            roleDao.grantPermissions(this.role(), (HibBaseElement)schema, new InternalPermission[]{InternalPermission.READ_PERM});
            roleDao.grantPermissions(this.role(), (HibBaseElement)extraProject, new InternalPermission[]{InternalPermission.UPDATE_PERM});
            tx.success();
        }
        this.expect(MeshEvent.PROJECT_SCHEMA_ASSIGNED).match(1, ProjectSchemaEventModel.class, event -> {
            ProjectReference projectRef = event.getProject();
            Assert.assertNotNull((Object)projectRef);
            Assert.assertEquals((Object)projectName, (Object)projectRef.getName());
            Assert.assertEquals((Object)projectUuid, (Object)projectRef.getUuid());
            SchemaReference schemaRef = event.getSchema();
            Assert.assertNotNull((Object)schemaRef);
            Assert.assertEquals((Object)"content", (Object)schemaRef.getName());
            Assert.assertEquals((Object)schemaUuid, (Object)schemaRef.getUuid());
        });
        ClientHelper.call(() -> this.client().assignSchemaToProject(projectName, schemaUuid));
        this.awaitEvents();
        tx = this.tx();
        try {
            SchemaDao schemaDao = tx.schemaDao();
            ProjectDao projectRoot = tx.projectDao();
            extraProject = (HibProject)projectRoot.findByUuid(created.getUuid());
            Assert.assertNotNull((String)"The schema should be added to the extra project", (Object)schemaDao.findByUuid((HibCoreElement)extraProject, schemaUuid));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testAddSchemaToProjectWithoutPerm() throws Exception {
        String schemaUuid = (String)this.tx(() -> this.schemaContainer("content").getUuid());
        ProjectCreateRequest request = new ProjectCreateRequest();
        request.setName("extraProject");
        request.setSchema((SchemaReference)new SchemaReferenceImpl().setName("folder"));
        ProjectResponse response = (ProjectResponse)ClientHelper.call(() -> this.client().createProject(request));
        String projectUuid = response.getUuid();
        HibProject extraProject = (HibProject)this.tx(tx -> {
            RoleDao roleDao = tx.roleDao();
            ProjectDao projectDao = tx.projectDao();
            HibProject p = (HibProject)projectDao.findByUuid(projectUuid);
            roleDao.revokePermissions(this.role(), (HibBaseElement)p, new InternalPermission[]{InternalPermission.UPDATE_PERM});
            return p;
        });
        ClientHelper.call(() -> this.client().assignSchemaToProject("extraProject", schemaUuid), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{projectUuid, InternalPermission.UPDATE_PERM.getRestPerm().getName()});
        try (Tx tx2 = this.tx();){
            SchemaDao schemaDao = tx2.schemaDao();
            HibSchema schema = this.schemaContainer("content");
            Assert.assertFalse((String)"The schema should not have been added to the extra project but it was", (boolean)schemaDao.contains((HibCoreElement)extraProject, (HibCoreElement)schema));
        }
    }

    @Test
    public void testRemoveSchemaFromProjectWithPerm() throws Exception {
        HibProject project = this.project();
        HibSchema schema = this.schemaContainer("content");
        String schemaUuid = (String)this.tx(() -> schema.getUuid());
        try (Tx tx = this.tx();){
            SchemaDao schemaDao = tx.schemaDao();
            Assert.assertTrue((String)"The schema should be assigned to the project.", (boolean)schemaDao.contains((HibCoreElement)project, (HibCoreElement)schema));
        }
        this.expect(MeshEvent.PROJECT_SCHEMA_UNASSIGNED).match(1, ProjectSchemaEventModel.class, event -> {
            ProjectReference projectRef = event.getProject();
            Assert.assertNotNull((Object)projectRef);
            Assert.assertEquals((Object)"dummy", (Object)projectRef.getName());
            Assert.assertEquals((Object)this.projectUuid(), (Object)projectRef.getUuid());
            SchemaReference schemaRef = event.getSchema();
            Assert.assertNotNull((Object)schemaRef);
            Assert.assertEquals((Object)"content", (Object)schemaRef.getName());
            Assert.assertEquals((Object)schemaUuid, (Object)schemaRef.getUuid());
        });
        ClientHelper.call(() -> this.client().unassignSchemaFromProject("dummy", schemaUuid));
        this.awaitEvents();
        SchemaListResponse list = (SchemaListResponse)ClientHelper.call(() -> this.client().findSchemas("dummy", new ParameterProvider[0]));
        Assert.assertEquals((String)"The removed schema should not be listed in the response", (long)0L, (long)list.getData().stream().filter(s -> s.getUuid().equals(schemaUuid)).count());
        try (Tx tx = this.tx();){
            SchemaDao schemaDao = tx.schemaDao();
            Assert.assertFalse((String)"The schema should no longer be assigned to the project.", (boolean)schemaDao.contains((HibCoreElement)project, (HibCoreElement)schema));
        }
    }

    @Test
    public void testRemoveSchemaFromProjectWithoutPerm() throws Exception {
        HibSchema schema = this.schemaContainer("content");
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            SchemaDao schemaDao = tx.schemaDao();
            Assert.assertTrue((String)"The schema should be assigned to the project.", (boolean)schemaDao.contains((HibCoreElement)this.project(), (HibCoreElement)schema));
            roleDao.revokePermissions(this.role(), (HibBaseElement)this.project(), new InternalPermission[]{InternalPermission.UPDATE_PERM});
            tx.success();
        }
        tx = this.tx();
        try {
            SchemaDao schemaDao = tx.schemaDao();
            ClientHelper.call(() -> this.client().unassignSchemaFromProject("dummy", schema.getUuid()), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{this.projectUuid(), InternalPermission.UPDATE_PERM.getRestPerm().getName()});
            Assert.assertTrue((String)"The schema should still be listed for the project.", (boolean)schemaDao.contains((HibCoreElement)this.project(), (HibCoreElement)schema));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }
}

