/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.schema;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.context.BranchMigrationContext;
import com.gentics.mesh.context.BulkActionContext;
import com.gentics.mesh.context.impl.BranchMigrationContextImpl;
import com.gentics.mesh.core.data.Bucket;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.HibNodeFieldContainer;
import com.gentics.mesh.core.data.branch.HibBranch;
import com.gentics.mesh.core.data.dao.NodeDao;
import com.gentics.mesh.core.data.dao.RoleDao;
import com.gentics.mesh.core.data.dao.SchemaDao;
import com.gentics.mesh.core.data.dao.UserDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.page.Page;
import com.gentics.mesh.core.data.perm.InternalPermission;
import com.gentics.mesh.core.data.schema.HibSchema;
import com.gentics.mesh.core.data.schema.HibSchemaVersion;
import com.gentics.mesh.core.data.service.BasicObjectTestcases;
import com.gentics.mesh.core.data.user.HibUser;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.common.ContainerType;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.impl.StringFieldImpl;
import com.gentics.mesh.core.rest.schema.SchemaModel;
import com.gentics.mesh.core.rest.schema.SchemaReference;
import com.gentics.mesh.core.rest.schema.SchemaVersionModel;
import com.gentics.mesh.core.rest.schema.impl.SchemaModelImpl;
import com.gentics.mesh.core.rest.schema.impl.SchemaReferenceImpl;
import com.gentics.mesh.core.rest.user.NodeReference;
import com.gentics.mesh.error.InvalidArgumentException;
import com.gentics.mesh.error.MeshSchemaException;
import com.gentics.mesh.json.JsonUtil;
import com.gentics.mesh.parameter.PagingParameters;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.client.VersioningParametersImpl;
import com.gentics.mesh.parameter.impl.PagingParametersImpl;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Triple;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class SchemaTest
extends AbstractMeshTest
implements BasicObjectTestcases {
    @Override
    @Test
    public void testTransformToReference() throws Exception {
        try (Tx tx = this.tx();){
            HibSchema schema = this.schemaContainer("folder");
            SchemaReference reference = ((HibSchemaVersion)schema.getLatestVersion()).transformToReference();
            Assert.assertNotNull((Object)reference);
            Assert.assertEquals((Object)schema.getUuid(), (Object)reference.getUuid());
            Assert.assertEquals((Object)((HibSchemaVersion)schema.getLatestVersion()).getName(), (Object)reference.getName());
            Assert.assertEquals((Object)((HibSchemaVersion)schema.getLatestVersion()).getVersion(), (Object)reference.getVersion());
        }
    }

    @Test
    public void testGetContentFromSchemaVersion() {
        Bucket bucket = new Bucket(0, 0x3FFFFFFF, 0, 1);
        HibNodeFieldContainer content = (HibNodeFieldContainer)this.tx(tx -> tx.contentDao().getLatestDraftFieldContainer(this.content(), "en"));
        HibSchemaVersion version = (HibSchemaVersion)this.tx(() -> (HibSchemaVersion)this.schemaContainer("content").getLatestVersion());
        HibNodeFieldContainer bucketMax = (HibNodeFieldContainer)this.tx(tx -> this.createContentWithBuckedId(content, Integer.MAX_VALUE));
        long before = (Long)this.tx(tx -> {
            SchemaDao schemaDao = tx.schemaDao();
            return schemaDao.getFieldContainers(version, this.initialBranchUuid(), bucket).count();
        });
        HibNodeFieldContainer bucket100 = (HibNodeFieldContainer)this.tx(tx -> this.createContentWithBuckedId(bucketMax, 100));
        this.tx(tx -> {
            SchemaDao schemaDao = tx.schemaDao();
            long after = schemaDao.getFieldContainers(version, this.initialBranchUuid(), bucket).count();
            Assert.assertEquals((String)"We should find one more content.", (long)(before + 1L), (long)after);
        });
        HibNodeFieldContainer bucketEnd = (HibNodeFieldContainer)this.tx(tx -> this.createContentWithBuckedId(bucket100, bucket.end()));
        this.tx(tx -> {
            SchemaDao schemaDao = tx.schemaDao();
            long after = schemaDao.getFieldContainers(version, this.initialBranchUuid(), bucket).count();
            Assert.assertEquals((String)"We should still find the altered element ", (long)(before + 1L), (long)after);
        });
        this.tx(tx -> this.createContentWithBuckedId(bucketEnd, bucket.end() + 1));
        this.tx(tx -> {
            SchemaDao schemaDao = tx.schemaDao();
            long after = schemaDao.getFieldContainers(version, this.initialBranchUuid(), bucket).count();
            Assert.assertEquals((String)"We should still find the altered element ", (long)before, (long)after);
        });
    }

    private HibNodeFieldContainer createContentWithBuckedId(HibNodeFieldContainer container, int bucketId) {
        HibNodeFieldContainer newContainer = Tx.get().contentDao().createFieldContainer(container.getNode(), this.english(), this.project().getLatestBranch(), this.user(), container, true);
        newContainer.setBucketId(Integer.valueOf(bucketId));
        return newContainer;
    }

    @Override
    @Test
    public void testFindByName() throws IOException {
        try (Tx tx = this.tx();){
            SchemaDao schemaDao = tx.schemaDao();
            HibSchema schemaContainer = (HibSchema)schemaDao.findByName("content");
            Assert.assertNotNull((Object)schemaContainer);
            Assert.assertEquals((Object)"content", (Object)((HibSchemaVersion)schemaContainer.getLatestVersion()).getSchema().getName());
            Assert.assertNull((Object)schemaDao.findByName("content1235"));
        }
    }

    @Override
    @Test
    public void testRootNode() throws MeshSchemaException {
        try (Tx tx = this.tx();){
            SchemaDao schemaDao = tx.schemaDao();
            long nSchemasBefore = schemaDao.count();
            SchemaVersionModel schema = FieldUtil.createMinimalValidSchema();
            Assert.assertNotNull((Object)schemaDao.create(schema, this.user()));
            long nSchemasAfter = schemaDao.count();
            Assert.assertEquals((long)(nSchemasBefore + 1L), (long)nSchemasAfter);
        }
    }

    @Test
    public void testDefaultSchema() {
        try (Tx tx = this.tx();){
            Assert.assertEquals((long)this.schemaContainers().size(), (long)tx.schemaDao().count());
        }
    }

    @Test
    public void testSchemaStorage() {
        try (Tx tx = this.tx();){
            this.meshDagger().serverSchemaStorage().clear();
            this.meshDagger().serverSchemaStorage().init();
            SchemaVersionModel schema = this.meshDagger().serverSchemaStorage().getSchema("folder");
            Assert.assertNotNull((Object)schema);
            Assert.assertEquals((Object)"folder", (Object)schema.getName());
        }
    }

    @Override
    @Test
    public void testFindAllVisible() throws InvalidArgumentException {
        try (Tx tx = this.tx();){
            Page page = tx.schemaDao().findAll(this.mockActionContext(), (PagingParameters)new PagingParametersImpl(1, Long.valueOf(25L)));
            Assert.assertNotNull((Object)page);
        }
    }

    @Override
    @Test
    public void testFindAll() throws InvalidArgumentException {
        try (Tx tx = this.tx();){
            int size = Iterables.size((Iterable)tx.schemaDao().findAll());
            Assert.assertEquals((long)this.schemaContainers().size(), (long)size);
        }
    }

    @Override
    @Test
    public void testFindByUUID() throws Exception {
        try (Tx tx = this.tx();){
            String uuid = this.getSchemaContainer().getUuid();
            Assert.assertNotNull((String)"The schema could not be found", (Object)tx.schemaDao().findByUuid(uuid));
        }
    }

    @Override
    @Test
    public void testDelete() throws Exception {
        this.tx(tx -> {
            SchemaDao schemaDao = tx.schemaDao();
            BulkActionContext context = this.createBulkContext();
            String uuid = this.getSchemaContainer().getUuid();
            NodeDao nodeDao = tx.nodeDao();
            HibSchema schema = (HibSchema)tx.schemaDao().findByUuid(uuid);
            for (HibNode node : schemaDao.getNodes(schema)) {
                nodeDao.delete(node, context, false, true);
            }
        });
        this.tx(tx -> {
            SchemaDao schemaDao = tx.schemaDao();
            BulkActionContext context = this.createBulkContext();
            String uuid = this.getSchemaContainer().getUuid();
            HibSchema schema = (HibSchema)tx.schemaDao().findByUuid(uuid);
            schemaDao.delete((HibBaseElement)schema, context);
            Assert.assertNull((String)"The schema should have been deleted", (Object)tx.schemaDao().findByUuid(uuid));
        });
    }

    @Override
    @Test
    public void testTransformation() throws IOException {
        try (Tx tx = this.tx();){
            HibSchema container = this.getSchemaContainer();
            SchemaVersionModel schema = ((HibSchemaVersion)container.getLatestVersion()).getSchema();
            Assert.assertNotNull((Object)schema);
            String json = schema.toJson();
            Assert.assertNotNull((Object)json);
            SchemaModel deserializedSchema = (SchemaModel)JsonUtil.readValue((String)json, SchemaModelImpl.class);
            Assert.assertNotNull((Object)deserializedSchema);
        }
    }

    @Override
    @Test
    public void testCreateDelete() throws Exception {
        try (Tx tx = this.tx();){
            SchemaDao schemaDao = tx.schemaDao();
            SchemaVersionModel schema = FieldUtil.createMinimalValidSchema();
            HibSchema newContainer = schemaDao.create(schema, this.user());
            Assert.assertNotNull((Object)newContainer);
            String uuid = newContainer.getUuid();
            schemaDao.delete((HibBaseElement)newContainer, this.createBulkContext());
            Assert.assertNull((String)"The container should have been deleted", (Object)tx.schemaDao().findByUuid(uuid));
        }
    }

    @Override
    @Test
    public void testCRUDPermissions() throws MeshSchemaException {
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            UserDao userDao = tx.userDao();
            SchemaDao schemaDao = tx.schemaDao();
            SchemaVersionModel schema = FieldUtil.createMinimalValidSchema();
            HibSchema newContainer = schemaDao.create(schema, this.user());
            Assert.assertFalse((boolean)roleDao.hasPermission(this.role(), InternalPermission.CREATE_PERM, (HibBaseElement)newContainer));
            userDao.inheritRolePermissions(this.getRequestUser(), tx.data().permissionRoots().schema(), (HibBaseElement)newContainer);
            Assert.assertTrue((String)"The addCRUDPermissionOnRole method should add the needed permissions on the new schema container.", (boolean)roleDao.hasPermission(this.role(), InternalPermission.CREATE_PERM, (HibBaseElement)newContainer));
        }
    }

    @Override
    @Test
    public void testRead() throws IOException {
        try (Tx tx = this.tx();){
            Assert.assertNotNull((Object)((HibSchemaVersion)this.getSchemaContainer().getLatestVersion()).getSchema());
        }
    }

    @Override
    @Test
    public void testCreate() throws IOException {
        try (Tx tx = this.tx();){
            Assert.assertNotNull((Object)((HibSchemaVersion)this.getSchemaContainer().getLatestVersion()).getSchema());
            Assert.assertEquals((String)"The schema container and schema rest model version must always be in sync", (Object)((HibSchemaVersion)this.getSchemaContainer().getLatestVersion()).getVersion(), (Object)((HibSchemaVersion)this.getSchemaContainer().getLatestVersion()).getSchema().getVersion());
        }
    }

    @Override
    @Test
    public void testUpdate() throws IOException {
        try (Tx tx = this.tx();){
            SchemaDao schemaDao = tx.schemaDao();
            HibSchema schemaContainer = (HibSchema)schemaDao.findByName("content");
            HibSchemaVersion currentVersion = (HibSchemaVersion)schemaContainer.getLatestVersion();
            SchemaVersionModel schema = currentVersion.getSchema();
            schema.setName("changed");
            currentVersion.setSchema(schema);
            Assert.assertEquals((Object)"changed", (Object)currentVersion.getSchema().getName());
            currentVersion.setName("changed2");
            schema = currentVersion.getSchema();
            schema.setContainer(Boolean.valueOf(true));
            Assert.assertTrue((String)"The schema container flag should be set to true since we updated it.", (boolean)schema.getContainer());
            currentVersion.setSchema(schema);
            schema = currentVersion.getSchema();
            Assert.assertTrue((boolean)schema.getContainer());
            schema = currentVersion.getSchema();
            schema.setContainer(Boolean.valueOf(false));
            Assert.assertFalse((boolean)schema.getContainer());
            currentVersion.setSchema(schema);
            schema = currentVersion.getSchema();
            Assert.assertFalse((boolean)schema.getContainer());
        }
    }

    @Override
    @Test
    public void testReadPermission() throws MeshSchemaException {
        try (Tx tx = this.tx();){
            SchemaDao schemaDao = tx.schemaDao();
            SchemaVersionModel schema = FieldUtil.createMinimalValidSchema();
            HibSchema newContainer = schemaDao.create(schema, this.user());
            this.testPermission(InternalPermission.READ_PERM, (HibBaseElement)newContainer);
        }
    }

    @Override
    @Test
    public void testDeletePermission() throws MeshSchemaException {
        try (Tx tx = this.tx();){
            SchemaDao schemaDao = tx.schemaDao();
            SchemaVersionModel schema = FieldUtil.createMinimalValidSchema();
            HibSchema newContainer = schemaDao.create(schema, this.user());
            this.testPermission(InternalPermission.DELETE_PERM, (HibBaseElement)newContainer);
        }
    }

    @Override
    @Test
    public void testUpdatePermission() throws MeshSchemaException {
        try (Tx tx = this.tx();){
            SchemaDao schemaDao = tx.schemaDao();
            SchemaVersionModel schema = FieldUtil.createMinimalValidSchema();
            HibSchema newContainer = schemaDao.create(schema, this.user());
            this.testPermission(InternalPermission.UPDATE_PERM, (HibBaseElement)newContainer);
        }
    }

    @Override
    @Test
    public void testCreatePermission() throws MeshSchemaException {
        try (Tx tx = this.tx();){
            SchemaDao schemaDao = tx.schemaDao();
            SchemaVersionModel schema = FieldUtil.createMinimalValidSchema();
            HibSchema newContainer = schemaDao.create(schema, this.user());
            this.testPermission(InternalPermission.CREATE_PERM, (HibBaseElement)newContainer);
        }
    }

    @Test
    public void testFindNodes() {
        String projectName = (String)this.tx(() -> this.project().getName());
        String initialBranchUuid = (String)this.tx(() -> this.project().getInitialBranch().getUuid());
        String baseNodeUuid = (String)this.tx(() -> this.project().getBaseNode().getUuid());
        Set folders = (Set)this.tx(() -> this.data().getFolders().values().stream().map(node -> this.getDisplayName((HibNode)node, initialBranchUuid)).collect(Collectors.toSet()));
        folders.add((String)this.tx(() -> this.getDisplayName(this.project().getBaseNode(), initialBranchUuid)));
        String news = (String)this.tx(tx -> {
            RoleDao roleDao = tx.roleDao();
            HibNode newsFolder = this.data().getFolder("news");
            roleDao.revokePermissions(this.role(), (HibBaseElement)newsFolder, new InternalPermission[]{InternalPermission.READ_PERM});
            return this.getDisplayName(newsFolder, initialBranchUuid);
        });
        this.tx(tx -> {
            RoleDao roleDao = tx.roleDao();
            HibNode newsFolder = this.data().getFolder("deals");
            roleDao.revokePermissions(this.role(), (HibBaseElement)newsFolder, new InternalPermission[]{InternalPermission.READ_PUBLISHED_PERM});
            return newsFolder.getUuid();
        });
        String product = (String)this.tx(tx -> {
            RoleDao roleDao = tx.roleDao();
            HibNode newsFolder = this.data().getFolder("products");
            roleDao.revokePermissions(this.role(), (HibBaseElement)newsFolder, new InternalPermission[]{InternalPermission.READ_PERM});
            roleDao.revokePermissions(this.role(), (HibBaseElement)newsFolder, new InternalPermission[]{InternalPermission.READ_PUBLISHED_PERM});
            return this.getDisplayName(newsFolder, initialBranchUuid);
        });
        folders.remove(product);
        String newBranchUuid = (String)this.tx(() -> {
            HibBranch newBranch = this.createBranch("newbranch");
            BranchMigrationContextImpl context = new BranchMigrationContextImpl();
            context.setNewBranch(newBranch);
            context.setOldBranch(newBranch.getPreviousBranch());
            this.meshDagger().branchMigrationHandler().migrateBranch((BranchMigrationContext)context).blockingAwait();
            return newBranch.getUuid();
        });
        String initialDraftFolder = ((NodeResponse)ClientHelper.call(() -> {
            NodeCreateRequest nodeCreateRequest = new NodeCreateRequest().setParentNode(new NodeReference().setUuid(baseNodeUuid)).setSchema((SchemaReference)new SchemaReferenceImpl().setName("folder")).setLanguage("en");
            nodeCreateRequest.getFields().put("name", (Field)new StringFieldImpl().setString("in initial branch"));
            return this.client().createNode(projectName, nodeCreateRequest, new ParameterProvider[]{new VersioningParametersImpl().setBranch(initialBranchUuid)});
        })).getDisplayName();
        String newDraftFolder = ((NodeResponse)ClientHelper.call(() -> {
            NodeCreateRequest nodeCreateRequest = new NodeCreateRequest().setParentNode(new NodeReference().setUuid(baseNodeUuid)).setSchema((SchemaReference)new SchemaReferenceImpl().setName("folder")).setLanguage("en");
            nodeCreateRequest.getFields().put("name", (Field)new StringFieldImpl().setString("in new branch"));
            return this.client().createNode(projectName, nodeCreateRequest, new ParameterProvider[]{new VersioningParametersImpl().setBranch(newBranchUuid)});
        })).getDisplayName();
        for (Triple testCase : Arrays.asList(Triple.of((Object)initialBranchUuid, (Object)ContainerType.DRAFT, (Object)initialDraftFolder), Triple.of((Object)newBranchUuid, (Object)ContainerType.DRAFT, (Object)newDraftFolder), Triple.of((Object)initialBranchUuid, (Object)ContainerType.PUBLISHED, (Object)null), Triple.of((Object)newBranchUuid, (Object)ContainerType.PUBLISHED, (Object)null))) {
            HashSet<String> expected = new HashSet<String>(folders);
            if (testCase.getRight() != null) {
                expected.add((String)testCase.getRight());
            }
            if (testCase.getMiddle() == ContainerType.DRAFT) {
                expected.remove(news);
            }
            Tx tx2 = this.tx();
            try {
                SchemaDao schemaDao = tx2.schemaDao();
                HibUser user = this.user();
                HibSchemaVersion folderSchema = (HibSchemaVersion)this.schemaContainer("folder").getLatestVersion();
                List nodes = schemaDao.findNodes(folderSchema, (String)testCase.getLeft(), user, (ContainerType)testCase.getMiddle()).list();
                List nodeUuids = nodes.stream().map(node -> this.getDisplayName((HibNode)node, (String)testCase.getLeft())).collect(Collectors.toList());
                ((AbstractListAssert)Assertions.assertThat(nodeUuids).doesNotHaveDuplicates()).containsOnlyElementsOf(expected);
            }
            finally {
                if (tx2 == null) continue;
                tx2.close();
            }
        }
    }
}

