/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.schema;

import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.impl.SchemaCreateRequest;
import com.gentics.mesh.core.rest.schema.impl.SchemaResponse;
import com.gentics.mesh.core.rest.schema.impl.SchemaUpdateRequest;
import com.gentics.mesh.core.rest.schema.impl.StringFieldSchemaImpl;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.vertx.core.json.JsonObject;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class SchemaUpdateEndpointNewFieldsTest
extends AbstractMeshTest {
    @Test
    public void testCreateNewFieldWithElasticSearchProperties() {
        FieldSchema field1 = this.createFieldSchema("field1");
        field1.setElasticsearch(new JsonObject().put("test", (Object)"123"));
        SchemaResponse schema = this.createSchema(field1);
        FieldSchema field2 = this.createFieldSchema("field2");
        JsonObject elasticSearch = new JsonObject().put("test", (Object)"123");
        field2.setElasticsearch(elasticSearch);
        SchemaUpdateRequest schemaUpdateRequest = schema.toUpdateRequest();
        schemaUpdateRequest.getFields().add(field2);
        ClientHelper.call(() -> this.client().updateSchema(schema.getUuid(), schemaUpdateRequest, new ParameterProvider[0]));
        SchemaResponse response = (SchemaResponse)ClientHelper.call(() -> this.client().findSchemaByUuid(schema.getUuid(), new ParameterProvider[0]));
        Assertions.assertThat((Iterable)((FieldSchema)response.getField("field2", FieldSchema.class)).getElasticsearch()).isEqualTo((Object)elasticSearch);
    }

    private SchemaResponse createSchema(FieldSchema ... schemas) {
        SchemaCreateRequest request = new SchemaCreateRequest();
        request.setName("test");
        List fields = Arrays.stream(schemas).collect(Collectors.toList());
        request.setFields(fields);
        return (SchemaResponse)this.client().createSchema(request, new ParameterProvider[0]).blockingGet();
    }

    private FieldSchema createFieldSchema(String name) {
        StringFieldSchemaImpl schema = new StringFieldSchemaImpl();
        schema.setName(name);
        schema.setLabel(name);
        return schema;
    }
}

