/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.schema;

import com.gentics.mesh.core.rest.schema.impl.AbstractFieldSchema;
import com.gentics.mesh.core.rest.schema.impl.BinaryFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.BooleanFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.DateFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.HtmlFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.ListFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.MicronodeFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.NodeFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.NumberFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.SchemaCreateRequest;
import com.gentics.mesh.core.rest.schema.impl.SchemaResponse;
import com.gentics.mesh.core.rest.schema.impl.SchemaUpdateRequest;
import com.gentics.mesh.core.rest.schema.impl.StringFieldSchemaImpl;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.google.common.collect.Streams;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@MeshTestSetting(elasticsearch=ElasticsearchTestMode.TRACKING, testSize=TestSize.FULL, startServer=true)
public class SchemaUpdateEndpointTest
extends AbstractMeshTest {
    @Parameterized.Parameter(value=0)
    public Supplier<AbstractFieldSchema> fieldSchemaSupplier;
    @Parameterized.Parameter(value=1)
    public String name;

    @Parameterized.Parameters(name="{index}: {1}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({StringFieldSchemaImpl::new, "StringFieldSchema"}, {NumberFieldSchemaImpl::new, "NumberFieldSchema"}, {HtmlFieldSchemaImpl::new, "HtmlFieldSchema"}, {BooleanFieldSchemaImpl::new, "BooleanFieldSchema"}, {DateFieldSchemaImpl::new, "DateFieldSchema"}, {BinaryFieldSchemaImpl::new, "BinaryFieldSchema"}, {NodeFieldSchemaImpl::new, "NodeFieldSchema"}, {() -> (MicronodeFieldSchemaImpl)new MicronodeFieldSchemaImpl().setAllowedMicroSchemas(new String[0]), "MicronodeFieldSchema"}, {() -> (ListFieldSchemaImpl)new ListFieldSchemaImpl().setListType("string"), "StringListFieldSchemaImpl"}, {() -> (ListFieldSchemaImpl)new ListFieldSchemaImpl().setListType("number"), "NumberListFieldSchemaImpl"}, {() -> (ListFieldSchemaImpl)new ListFieldSchemaImpl().setListType("date"), "DateListFieldSchemaImpl"}, {() -> (ListFieldSchemaImpl)new ListFieldSchemaImpl().setListType("boolean"), "BooleanListFieldSchemaImpl"}, {() -> (ListFieldSchemaImpl)new ListFieldSchemaImpl().setListType("html"), "HtmlListFieldSchemaImpl"}, {() -> (ListFieldSchemaImpl)new ListFieldSchemaImpl().setListType("node"), "NodeListFieldSchemaImpl"}, {() -> (ListFieldSchemaImpl)new ListFieldSchemaImpl().setListType("micronode"), "MicrondoeListFieldSchemaImpl"});
    }

    @Test
    public void updateSchemaFields() {
        SchemaResponse schema = this.createSchemaWithField(this.fieldSchemaSupplier);
        SchemaUpdateRequest request = this.changeFieldTypes(schema);
        ClientHelper.call(() -> this.client().updateSchema(schema.getUuid(), request, new ParameterProvider[0]));
    }

    private SchemaResponse createSchemaWithField(Supplier<AbstractFieldSchema> fieldSchemaSupplier) {
        return this.createSchemaWithField(20, "testSchema", fieldSchemaSupplier);
    }

    private SchemaResponse createSchemaWithField(int fieldAmount, String schemaName, Supplier<AbstractFieldSchema> fieldSchemaSupplier) {
        SchemaCreateRequest request = new SchemaCreateRequest();
        request.setName(schemaName);
        request.setFields(IntStream.rangeClosed(1, fieldAmount).mapToObj(i -> ((AbstractFieldSchema)fieldSchemaSupplier.get()).setName("field" + i)).collect(Collectors.toList()));
        return (SchemaResponse)this.client().createSchema(request, new ParameterProvider[0]).blockingGet();
    }

    private SchemaUpdateRequest changeFieldTypes(SchemaResponse schema) {
        return schema.toUpdateRequest().setFields(Streams.mapWithIndex(this.createAllSchemaFields(), (field, i) -> field.setName("field" + i)).collect(Collectors.toList()));
    }

    private Stream<AbstractFieldSchema> createAllSchemaFields() {
        return Stream.concat(Stream.of(new StringFieldSchemaImpl(), new NumberFieldSchemaImpl(), new HtmlFieldSchemaImpl(), new BooleanFieldSchemaImpl(), new DateFieldSchemaImpl(), new BinaryFieldSchemaImpl(), new NodeFieldSchemaImpl(), (MicronodeFieldSchemaImpl)new MicronodeFieldSchemaImpl().setAllowedMicroSchemas(new String[0])), this.generateAllListSchemaFields());
    }

    private Stream<AbstractFieldSchema> generateAllListSchemaFields() {
        return Stream.of("string", "number", "date", "boolean", "html", "node", "micronode").map(type -> (ListFieldSchemaImpl)new ListFieldSchemaImpl().setListType(type));
    }
}

