/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.schema.change;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.data.schema.HibAddFieldChange;
import com.gentics.mesh.core.data.schema.HibFieldSchemaVersionElement;
import com.gentics.mesh.core.data.schema.HibSchemaChange;
import com.gentics.mesh.core.data.schema.HibSchemaVersion;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.schema.BinaryFieldSchema;
import com.gentics.mesh.core.rest.schema.DateFieldSchema;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.FieldSchemaContainer;
import com.gentics.mesh.core.rest.schema.FieldSchemaContainerVersion;
import com.gentics.mesh.core.rest.schema.ListFieldSchema;
import com.gentics.mesh.core.rest.schema.MicronodeFieldSchema;
import com.gentics.mesh.core.rest.schema.NodeFieldSchema;
import com.gentics.mesh.core.rest.schema.NumberFieldSchema;
import com.gentics.mesh.core.rest.schema.SchemaVersionModel;
import com.gentics.mesh.core.rest.schema.StringFieldSchema;
import com.gentics.mesh.core.rest.schema.change.impl.SchemaChangeModel;
import com.gentics.mesh.core.rest.schema.change.impl.SchemaChangeOperation;
import com.gentics.mesh.core.rest.schema.impl.SchemaModelImpl;
import com.gentics.mesh.core.schema.change.AbstractChangeTest;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractObjectArrayAssert;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=false)
public class AddFieldChangeTest
extends AbstractChangeTest {
    @Override
    @Test
    public void testFields() throws IOException {
        try (Tx tx = this.tx();){
            HibSchemaVersion version = (HibSchemaVersion)this.createVersion(this.schemaDao(tx));
            HibAddFieldChange change = (HibAddFieldChange)this.createChange(this.schemaDao(tx), version, SchemaChangeOperation.ADDFIELD);
            change.setFieldName("fieldName");
            Assert.assertEquals((Object)"fieldName", (Object)change.getFieldName());
            change.setRestProperty("key1", (Object)"value1");
            change.setRestProperty("key2", (Object)"value2");
            Assert.assertEquals((Object)"value1", (Object)change.getRestProperty("key1"));
        }
    }

    @Override
    @Test
    public void testApply() {
        try (Tx tx = this.tx();){
            HibSchemaVersion version = (HibSchemaVersion)this.createVersion(this.schemaDao(tx));
            SchemaModelImpl schema = new SchemaModelImpl();
            HibAddFieldChange change = (HibAddFieldChange)this.createChange(this.schemaDao(tx), version, SchemaChangeOperation.ADDFIELD);
            change.setFieldName("name");
            change.setType("html");
            version.setSchema((SchemaVersionModel)schema);
            version.setNextChange((HibSchemaChange)change);
            FieldSchemaContainerVersion updatedSchema = this.mutator.apply((HibFieldSchemaVersionElement)version);
            MeshAssertions.assertThat((FieldSchemaContainer)updatedSchema).hasField("name");
        }
    }

    @Test
    public void testApplyStringFieldAtEndPosition() {
        try (Tx tx = this.tx();){
            HibSchemaVersion version = (HibSchemaVersion)this.createVersion(this.schemaDao(tx));
            SchemaModelImpl schema = new SchemaModelImpl();
            schema.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"firstField"));
            schema.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"secondField"));
            schema.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"thirdField"));
            HibAddFieldChange change = (HibAddFieldChange)this.createChange(this.schemaDao(tx), version, SchemaChangeOperation.ADDFIELD);
            change.setFieldName("stringField");
            change.setType("string");
            change.setInsertAfterPosition("thirdField");
            version.setSchema((SchemaVersionModel)schema);
            version.setNextChange((HibSchemaChange)change);
            FieldSchemaContainerVersion updatedSchema = this.mutator.apply((HibFieldSchemaVersionElement)version);
            Assert.assertArrayEquals((Object[])new String[]{"firstField", "secondField", "thirdField", "stringField"}, (Object[])updatedSchema.getFields().stream().map(field -> field.getName()).toArray());
            MeshAssertions.assertThat((FieldSchemaContainer)updatedSchema).hasField("stringField");
            Assert.assertTrue((String)"The created field was not of the string string field.", (boolean)(updatedSchema.getField("stringField") instanceof StringFieldSchema));
        }
    }

    @Test
    public void testApplyStringFieldAtPosition() {
        try (Tx tx = this.tx();){
            HibSchemaVersion version = (HibSchemaVersion)this.createVersion(this.schemaDao(tx));
            SchemaModelImpl schema = new SchemaModelImpl();
            schema.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"firstField"));
            schema.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"secondField"));
            schema.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"thirdField"));
            HibAddFieldChange change = (HibAddFieldChange)this.createChange(this.schemaDao(tx), version, SchemaChangeOperation.ADDFIELD);
            change.setFieldName("stringField");
            change.setType("string");
            change.setInsertAfterPosition("firstField");
            version.setSchema((SchemaVersionModel)schema);
            version.setNextChange((HibSchemaChange)change);
            FieldSchemaContainerVersion updatedSchema = this.mutator.apply((HibFieldSchemaVersionElement)version);
            Assert.assertArrayEquals((Object[])new String[]{"firstField", "stringField", "secondField", "thirdField"}, (Object[])updatedSchema.getFields().stream().map(FieldSchema::getName).toArray());
            MeshAssertions.assertThat((FieldSchemaContainer)updatedSchema).hasField("stringField");
            Assert.assertTrue((String)"The created field was not of the string string field.", (boolean)(updatedSchema.getField("stringField") instanceof StringFieldSchema));
        }
    }

    @Test
    public void testApplyStringField() {
        try (Tx tx = this.tx();){
            HibSchemaVersion version = (HibSchemaVersion)this.createVersion(this.schemaDao(tx));
            SchemaModelImpl schema = new SchemaModelImpl();
            HibAddFieldChange change = (HibAddFieldChange)this.createChange(this.schemaDao(tx), version, SchemaChangeOperation.ADDFIELD);
            change.setFieldName("stringField");
            change.setType("string");
            version.setSchema((SchemaVersionModel)schema);
            version.setNextChange((HibSchemaChange)change);
            FieldSchemaContainerVersion updatedSchema = this.mutator.apply((HibFieldSchemaVersionElement)version);
            MeshAssertions.assertThat((FieldSchemaContainer)updatedSchema).hasField("stringField");
            Assert.assertTrue((String)"The created field was not of the string string field.", (boolean)(updatedSchema.getField("stringField") instanceof StringFieldSchema));
        }
    }

    @Test
    public void testApplyNodeField() {
        try (Tx tx = this.tx();){
            HibSchemaVersion version = (HibSchemaVersion)this.createVersion(this.schemaDao(tx));
            SchemaModelImpl schema = new SchemaModelImpl();
            HibAddFieldChange change = (HibAddFieldChange)this.createChange(this.schemaDao(tx), version, SchemaChangeOperation.ADDFIELD);
            change.setFieldName("nodeField");
            change.setType("node");
            version.setSchema((SchemaVersionModel)schema);
            version.setNextChange((HibSchemaChange)change);
            FieldSchemaContainerVersion updatedSchema = this.mutator.apply((HibFieldSchemaVersionElement)version);
            MeshAssertions.assertThat((FieldSchemaContainer)updatedSchema).hasField("nodeField");
            Assert.assertTrue((String)("The created field was not of the type node field." + updatedSchema.getField("nodeField").getClass()), (boolean)(updatedSchema.getField("nodeField") instanceof NodeFieldSchema));
        }
    }

    @Test
    public void testApplyMicronodeField() {
        try (Tx tx = this.tx();){
            HibSchemaVersion version = (HibSchemaVersion)this.createVersion(this.schemaDao(tx));
            SchemaModelImpl schema = new SchemaModelImpl();
            HibAddFieldChange change = (HibAddFieldChange)this.createChange(this.schemaDao(tx), version, SchemaChangeOperation.ADDFIELD);
            change.setFieldName("micronodeField");
            change.setType("micronode");
            version.setSchema((SchemaVersionModel)schema);
            version.setNextChange((HibSchemaChange)change);
            FieldSchemaContainerVersion updatedSchema = this.mutator.apply((HibFieldSchemaVersionElement)version);
            MeshAssertions.assertThat((FieldSchemaContainer)updatedSchema).hasField("micronodeField");
            Assert.assertTrue((String)"The created field was not of the type micronode field.", (boolean)(updatedSchema.getField("micronodeField") instanceof MicronodeFieldSchema));
        }
    }

    @Test
    public void testApplyDateField() {
        try (Tx tx = this.tx();){
            HibSchemaVersion version = (HibSchemaVersion)this.createVersion(this.schemaDao(tx));
            SchemaModelImpl schema = new SchemaModelImpl();
            HibAddFieldChange change = (HibAddFieldChange)this.createChange(this.schemaDao(tx), version, SchemaChangeOperation.ADDFIELD);
            change.setFieldName("dateField");
            change.setType("date");
            version.setSchema((SchemaVersionModel)schema);
            version.setNextChange((HibSchemaChange)change);
            FieldSchemaContainerVersion updatedSchema = this.mutator.apply((HibFieldSchemaVersionElement)version);
            MeshAssertions.assertThat((FieldSchemaContainer)updatedSchema).hasField("dateField");
            Assert.assertTrue((String)"The created field was not of the type date field.", (boolean)(updatedSchema.getField("dateField") instanceof DateFieldSchema));
        }
    }

    @Test
    public void testApplyNumberField() {
        try (Tx tx = this.tx();){
            HibSchemaVersion version = (HibSchemaVersion)this.createVersion(this.schemaDao(tx));
            SchemaModelImpl schema = new SchemaModelImpl();
            HibAddFieldChange change = (HibAddFieldChange)this.createChange(this.schemaDao(tx), version, SchemaChangeOperation.ADDFIELD);
            change.setFieldName("numberField");
            change.setType("number");
            version.setSchema((SchemaVersionModel)schema);
            version.setNextChange((HibSchemaChange)change);
            FieldSchemaContainerVersion updatedSchema = this.mutator.apply((HibFieldSchemaVersionElement)version);
            MeshAssertions.assertThat((FieldSchemaContainer)updatedSchema).hasField("numberField");
            Assert.assertTrue((String)"The created field was not of the type number field.", (boolean)(updatedSchema.getField("numberField") instanceof NumberFieldSchema));
        }
    }

    @Test
    public void testApplyBinaryField() {
        try (Tx tx = this.tx();){
            HibSchemaVersion version = (HibSchemaVersion)this.createVersion(this.schemaDao(tx));
            SchemaModelImpl schema = new SchemaModelImpl();
            HibAddFieldChange change = (HibAddFieldChange)this.createChange(this.schemaDao(tx), version, SchemaChangeOperation.ADDFIELD);
            change.setFieldName("binaryField");
            change.setType("binary");
            version.setSchema((SchemaVersionModel)schema);
            version.setNextChange((HibSchemaChange)change);
            FieldSchemaContainerVersion updatedSchema = this.mutator.apply((HibFieldSchemaVersionElement)version);
            MeshAssertions.assertThat((FieldSchemaContainer)updatedSchema).hasField("binaryField");
            Assert.assertTrue((String)"The created field was not of the type binary field.", (boolean)(updatedSchema.getField("binaryField") instanceof BinaryFieldSchema));
        }
    }

    @Test
    public void testApplyListField() {
        try (Tx tx = this.tx();){
            HibSchemaVersion version = (HibSchemaVersion)this.createVersion(this.schemaDao(tx));
            SchemaModelImpl schema = new SchemaModelImpl();
            HibAddFieldChange change = (HibAddFieldChange)this.createChange(this.schemaDao(tx), version, SchemaChangeOperation.ADDFIELD);
            change.setFieldName("listField");
            change.setType("list");
            change.setListType("html");
            version.setSchema((SchemaVersionModel)schema);
            version.setNextChange((HibSchemaChange)change);
            FieldSchemaContainerVersion updatedSchema = this.mutator.apply((HibFieldSchemaVersionElement)version);
            MeshAssertions.assertThat((FieldSchemaContainer)updatedSchema).hasField("listField");
            Assert.assertTrue((String)"The created field was not of the type binary field.", (boolean)(updatedSchema.getField("listField") instanceof ListFieldSchema));
            ListFieldSchema list = (ListFieldSchema)updatedSchema.getField("listField");
            Assert.assertEquals((String)"The list type was incorrect.", (Object)"html", (Object)list.getListType());
        }
    }

    @Test
    public void testApplyRequiredTrue() {
        try (Tx tx = this.tx();){
            HibSchemaVersion version = (HibSchemaVersion)this.createVersion(this.schemaDao(tx));
            SchemaModelImpl schema = new SchemaModelImpl();
            HibAddFieldChange change = (HibAddFieldChange)this.createChange(this.schemaDao(tx), version, SchemaChangeOperation.ADDFIELD);
            change.setFieldName("requiredField");
            change.setType("string");
            change.setRestProperty("required", (Object)true);
            version.setSchema((SchemaVersionModel)schema);
            version.setNextChange((HibSchemaChange)change);
            FieldSchemaContainerVersion updatedSchema = this.mutator.apply((HibFieldSchemaVersionElement)version);
            MeshAssertions.assertThat((FieldSchemaContainer)updatedSchema).hasField("requiredField");
            ((AbstractBooleanAssert)MeshAssertions.assertThat((boolean)updatedSchema.getField("requiredField").isRequired()).as("Required flag", new Object[0])).isTrue();
        }
    }

    @Test
    public void testApplyRequiredFalse() {
        try (Tx tx = this.tx();){
            HibSchemaVersion version = (HibSchemaVersion)this.createVersion(this.schemaDao(tx));
            SchemaModelImpl schema = new SchemaModelImpl();
            HibAddFieldChange change = (HibAddFieldChange)this.createChange(this.schemaDao(tx), version, SchemaChangeOperation.ADDFIELD);
            change.setFieldName("optionalField");
            change.setType("string");
            change.setRestProperty("required", (Object)false);
            version.setSchema((SchemaVersionModel)schema);
            version.setNextChange((HibSchemaChange)change);
            FieldSchemaContainerVersion updatedSchema = this.mutator.apply((HibFieldSchemaVersionElement)version);
            MeshAssertions.assertThat((FieldSchemaContainer)updatedSchema).hasField("optionalField");
            ((AbstractBooleanAssert)MeshAssertions.assertThat((boolean)updatedSchema.getField("optionalField").isRequired()).as("Required flag", new Object[0])).isFalse();
        }
    }

    @Test
    public void testApplyRequiredNull() {
        try (Tx tx = this.tx();){
            HibSchemaVersion version = (HibSchemaVersion)this.createVersion(this.schemaDao(tx));
            SchemaModelImpl schema = new SchemaModelImpl();
            HibAddFieldChange change = (HibAddFieldChange)this.createChange(this.schemaDao(tx), version, SchemaChangeOperation.ADDFIELD);
            change.setFieldName("defaultRequiredField");
            change.setType("string");
            version.setSchema((SchemaVersionModel)schema);
            version.setNextChange((HibSchemaChange)change);
            FieldSchemaContainerVersion updatedSchema = this.mutator.apply((HibFieldSchemaVersionElement)version);
            MeshAssertions.assertThat((FieldSchemaContainer)updatedSchema).hasField("defaultRequiredField");
            ((AbstractBooleanAssert)MeshAssertions.assertThat((boolean)updatedSchema.getField("defaultRequiredField").isRequired()).as("Required flag", new Object[0])).isFalse();
        }
    }

    @Test
    public void testApplyStringFieldAllow() {
        this.testApplyStringFieldAllowance(true);
    }

    @Test
    public void testApplyNodeFieldAllow() {
        this.testApplyNodeFieldAllowance(true);
    }

    @Test
    public void testApplyNodeListFieldAllow() {
        this.testApplyNodeListFieldAllowance(true);
    }

    @Test
    public void testApplyMicronodeFieldAllow() {
        this.testApplyMicronodeFieldAllowance(true);
    }

    @Test
    public void testApplyMicronodeListFieldAllow() {
        this.testApplyMicronodeListFieldAllowance(true);
    }

    @Test
    public void testApplyStringFieldDisallow() {
        this.testApplyStringFieldAllowance(true);
        this.testApplyStringFieldAllowance(false);
    }

    @Test
    public void testApplyNodeFieldDisallow() {
        this.testApplyNodeFieldAllowance(true);
        this.testApplyNodeFieldAllowance(false);
    }

    @Test
    public void testApplyNodeListFieldDisallow() {
        this.testApplyNodeListFieldAllowance(true);
        this.testApplyNodeListFieldAllowance(false);
    }

    @Test
    public void testApplyMicronodeFieldDisallow() {
        this.testApplyMicronodeFieldAllowance(true);
        this.testApplyMicronodeFieldAllowance(false);
    }

    @Test
    public void testApplyMicronodeListFieldDisallow() {
        this.testApplyMicronodeListFieldAllowance(true);
        this.testApplyMicronodeListFieldAllowance(false);
    }

    private void testApplyStringFieldAllowance(boolean allow) {
        try (Tx tx = this.tx();){
            String[] stringArray;
            HibSchemaVersion version = (HibSchemaVersion)this.createVersion(this.schemaDao(tx));
            SchemaModelImpl schema = new SchemaModelImpl();
            HibAddFieldChange change = (HibAddFieldChange)this.createChange(this.schemaDao(tx), version, SchemaChangeOperation.ADDFIELD);
            change.setFieldName("stringAllowField");
            change.setType("string");
            if (allow) {
                String[] stringArray2 = new String[3];
                stringArray2[0] = "one";
                stringArray2[1] = "two";
                stringArray = stringArray2;
                stringArray2[2] = "three";
            } else {
                stringArray = null;
            }
            change.setRestProperty("allow", stringArray);
            version.setSchema((SchemaVersionModel)schema);
            version.setNextChange((HibSchemaChange)change);
            FieldSchemaContainerVersion updatedSchema = this.mutator.apply((HibFieldSchemaVersionElement)version);
            MeshAssertions.assertThat((FieldSchemaContainer)updatedSchema).hasField("stringAllowField");
            AbstractObjectArrayAssert assertion = (AbstractObjectArrayAssert)MeshAssertions.assertThat((Object[])((StringFieldSchema)updatedSchema.getField("stringAllowField", StringFieldSchema.class)).getAllowedValues()).as("Allowed values", new Object[0]);
            if (allow) {
                assertion.containsExactly((Object[])new String[]{"one", "two", "three"});
            } else {
                assertion.isNullOrEmpty();
            }
        }
    }

    private void testApplyNodeFieldAllowance(boolean allow) {
        try (Tx tx = this.tx();){
            String[] stringArray;
            HibSchemaVersion version = (HibSchemaVersion)this.createVersion(this.schemaDao(tx));
            SchemaModelImpl schema = new SchemaModelImpl();
            HibAddFieldChange change = (HibAddFieldChange)this.createChange(this.schemaDao(tx), version, SchemaChangeOperation.ADDFIELD);
            change.setFieldName("nodeAllowField");
            change.setType("node");
            if (allow) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "content";
            } else {
                stringArray = null;
            }
            change.setRestProperty("allow", stringArray);
            version.setSchema((SchemaVersionModel)schema);
            version.setNextChange((HibSchemaChange)change);
            FieldSchemaContainerVersion updatedSchema = this.mutator.apply((HibFieldSchemaVersionElement)version);
            MeshAssertions.assertThat((FieldSchemaContainer)updatedSchema).hasField("nodeAllowField");
            AbstractObjectArrayAssert assertion = (AbstractObjectArrayAssert)MeshAssertions.assertThat((Object[])((NodeFieldSchema)updatedSchema.getField("nodeAllowField", NodeFieldSchema.class)).getAllowedSchemas()).as("Allowed schemas", new Object[0]);
            if (allow) {
                assertion.containsExactly((Object[])new String[]{"content"});
            } else {
                assertion.isNullOrEmpty();
            }
        }
    }

    private void testApplyNodeListFieldAllowance(boolean allow) {
        try (Tx tx = this.tx();){
            String[] stringArray;
            HibSchemaVersion version = (HibSchemaVersion)this.createVersion(this.schemaDao(tx));
            SchemaModelImpl schema = new SchemaModelImpl();
            HibAddFieldChange change = (HibAddFieldChange)this.createChange(this.schemaDao(tx), version, SchemaChangeOperation.ADDFIELD);
            change.setFieldName("nodeListFieldAllow");
            change.setType("list");
            change.setListType("node");
            if (allow) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "content";
            } else {
                stringArray = null;
            }
            change.setRestProperty("allow", stringArray);
            version.setSchema((SchemaVersionModel)schema);
            version.setNextChange((HibSchemaChange)change);
            FieldSchemaContainerVersion updatedSchema = this.mutator.apply((HibFieldSchemaVersionElement)version);
            MeshAssertions.assertThat((FieldSchemaContainer)updatedSchema).hasField("nodeListFieldAllow");
            AbstractObjectArrayAssert assertion = (AbstractObjectArrayAssert)MeshAssertions.assertThat((Object[])((ListFieldSchema)updatedSchema.getField("nodeListFieldAllow", ListFieldSchema.class)).getAllowedSchemas()).as("Allowed schemas", new Object[0]);
            if (allow) {
                assertion.containsExactly((Object[])new String[]{"content"});
            } else {
                assertion.isNullOrEmpty();
            }
        }
    }

    private void testApplyMicronodeFieldAllowance(boolean allow) {
        try (Tx tx = this.tx();){
            String[] stringArray;
            HibSchemaVersion version = (HibSchemaVersion)this.createVersion(this.schemaDao(tx));
            SchemaModelImpl schema = new SchemaModelImpl();
            HibAddFieldChange change = (HibAddFieldChange)this.createChange(this.schemaDao(tx), version, SchemaChangeOperation.ADDFIELD);
            change.setFieldName("micronodeAllowField");
            change.setType("micronode");
            if (allow) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "content";
            } else {
                stringArray = null;
            }
            change.setRestProperty("allow", stringArray);
            version.setSchema((SchemaVersionModel)schema);
            version.setNextChange((HibSchemaChange)change);
            FieldSchemaContainerVersion updatedSchema = this.mutator.apply((HibFieldSchemaVersionElement)version);
            MeshAssertions.assertThat((FieldSchemaContainer)updatedSchema).hasField("micronodeAllowField");
            AbstractObjectArrayAssert assertion = (AbstractObjectArrayAssert)MeshAssertions.assertThat((Object[])((MicronodeFieldSchema)updatedSchema.getField("micronodeAllowField", MicronodeFieldSchema.class)).getAllowedMicroSchemas()).as("Allowed schemas", new Object[0]);
            if (allow) {
                assertion.containsExactly((Object[])new String[]{"content"});
            } else {
                assertion.isNullOrEmpty();
            }
        }
    }

    private void testApplyMicronodeListFieldAllowance(boolean allow) {
        try (Tx tx = this.tx();){
            String[] stringArray;
            HibSchemaVersion version = (HibSchemaVersion)this.createVersion(this.schemaDao(tx));
            SchemaModelImpl schema = new SchemaModelImpl();
            HibAddFieldChange change = (HibAddFieldChange)this.createChange(this.schemaDao(tx), version, SchemaChangeOperation.ADDFIELD);
            change.setFieldName("micronodeListFieldAllow");
            change.setType("list");
            change.setListType("micronode");
            if (allow) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "content";
            } else {
                stringArray = null;
            }
            change.setRestProperty("allow", stringArray);
            version.setSchema((SchemaVersionModel)schema);
            version.setNextChange((HibSchemaChange)change);
            FieldSchemaContainerVersion updatedSchema = this.mutator.apply((HibFieldSchemaVersionElement)version);
            MeshAssertions.assertThat((FieldSchemaContainer)updatedSchema).hasField("micronodeListFieldAllow");
            AbstractObjectArrayAssert assertion = (AbstractObjectArrayAssert)MeshAssertions.assertThat((Object[])((ListFieldSchema)updatedSchema.getField("micronodeListFieldAllow", ListFieldSchema.class)).getAllowedSchemas()).as("Allowed schemas", new Object[0]);
            if (allow) {
                assertion.containsExactly((Object[])new String[]{"content"});
            } else {
                assertion.isNullOrEmpty();
            }
        }
    }

    @Override
    @Test
    public void testUpdateFromRest() {
        try (Tx tx = this.tx();){
            HibSchemaVersion version = (HibSchemaVersion)this.createVersion(this.schemaDao(tx));
            JsonObject elasticSearch = new JsonObject().put("test", (Object)"test");
            SchemaChangeModel model = SchemaChangeModel.createAddFieldChange((String)"testField", (String)"html", (String)"test123", (JsonObject)elasticSearch);
            HibAddFieldChange change = (HibAddFieldChange)this.schemaDao(tx).createChange((HibFieldSchemaVersionElement)version, model);
            Assert.assertEquals((Object)change.getType(), model.getProperties().get("type"));
            Assert.assertEquals((Object)change.getFieldName(), (Object)model.getProperty("field"));
            Assert.assertEquals((Object)change.getLabel(), (Object)model.getProperty("label"));
        }
    }

    @Override
    @Test
    public void testTransformToRest() throws IOException {
        try (Tx tx = this.tx();){
            HibSchemaVersion version = (HibSchemaVersion)this.createVersion(this.schemaDao(tx));
            HibAddFieldChange change = (HibAddFieldChange)this.createChange(this.schemaDao(tx), version, SchemaChangeOperation.ADDFIELD);
            change.setFieldName("name");
            change.setType("html");
            change.setRestProperty("someProperty", (Object)"test");
            SchemaChangeModel model = change.transformToRest();
            Assert.assertEquals((Object)change.getUuid(), (Object)model.getUuid());
            Assert.assertEquals((Object)change.getType(), (Object)model.getProperty("type"));
            Assert.assertEquals((Object)change.getFieldName(), (Object)model.getProperty("field"));
            Assert.assertEquals((String)"The generic rest property from the change should have been set for the rest model.", (Object)"test", (Object)change.getRestProperty("someProperty"));
        }
    }
}

