/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.schema.change;

import com.gentics.mesh.core.data.schema.HibFieldSchemaElement;
import com.gentics.mesh.core.data.schema.HibFieldSchemaVersionElement;
import com.gentics.mesh.core.data.schema.HibFieldTypeChange;
import com.gentics.mesh.core.data.schema.HibSchema;
import com.gentics.mesh.core.data.schema.HibSchemaChange;
import com.gentics.mesh.core.data.schema.HibSchemaVersion;
import com.gentics.mesh.core.data.schema.HibUpdateFieldChange;
import com.gentics.mesh.core.data.schema.handler.FieldSchemaContainerMutator;
import com.gentics.mesh.core.db.CommonTx;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.schema.BinaryFieldSchema;
import com.gentics.mesh.core.rest.schema.BooleanFieldSchema;
import com.gentics.mesh.core.rest.schema.DateFieldSchema;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.HtmlFieldSchema;
import com.gentics.mesh.core.rest.schema.ListFieldSchema;
import com.gentics.mesh.core.rest.schema.MicronodeFieldSchema;
import com.gentics.mesh.core.rest.schema.NodeFieldSchema;
import com.gentics.mesh.core.rest.schema.NumberFieldSchema;
import com.gentics.mesh.core.rest.schema.SchemaModel;
import com.gentics.mesh.core.rest.schema.SchemaVersionModel;
import com.gentics.mesh.core.rest.schema.StringFieldSchema;
import com.gentics.mesh.core.rest.schema.change.impl.SchemaChangeOperation;
import com.gentics.mesh.core.rest.schema.impl.BinaryFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.BooleanFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.DateFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.HtmlFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.ListFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.MicronodeFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.NodeFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.NumberFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.SchemaModelImpl;
import com.gentics.mesh.core.rest.schema.impl.StringFieldSchemaImpl;
import com.gentics.mesh.error.MeshSchemaException;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.util.IndexOptionHelper;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=false)
public class FieldSchemaContainerMutatorTest
extends AbstractMeshTest {
    private FieldSchemaContainerMutator mutator = new FieldSchemaContainerMutator();

    @Test
    public void testNullOperation() throws MeshSchemaException {
        try (Tx tx = this.tx();){
            CommonTx ctx = (CommonTx)tx.unwrap();
            SchemaModelImpl schemaModel = new SchemaModelImpl();
            HibSchema schema = ctx.schemaDao().create((SchemaVersionModel)schemaModel, this.user());
            HibSchemaVersion version = (HibSchemaVersion)ctx.schemaDao().createPersistedVersion((HibFieldSchemaElement)schema, v -> v.setSchema((SchemaVersionModel)schemaModel));
            SchemaModel updatedSchema = (SchemaModel)this.mutator.apply((HibFieldSchemaVersionElement)version);
            Assert.assertNotNull((Object)updatedSchema);
            Assert.assertEquals((String)"No changes were specified. No modification should happen.", (Object)schemaModel, (Object)updatedSchema);
        }
    }

    @Test
    public void testUpdateTypeAndAllowProperty() throws MeshSchemaException {
        try (Tx tx = this.tx();){
            CommonTx ctx = (CommonTx)tx.unwrap();
            SchemaModelImpl schemaModel = new SchemaModelImpl("testschema");
            HibSchema schema = ctx.schemaDao().create((SchemaVersionModel)schemaModel, this.user());
            HibSchemaVersion version = (HibSchemaVersion)ctx.schemaDao().createPersistedVersion((HibFieldSchemaElement)schema, v -> {
                NumberFieldSchemaImpl numberField = new NumberFieldSchemaImpl();
                numberField.setName("testField");
                numberField.setRequired(true);
                numberField.setLabel("originalLabel");
                schemaModel.addField((FieldSchema)numberField);
                v.setSchema((SchemaVersionModel)schemaModel);
            });
            HibFieldTypeChange fieldTypeChange = (HibFieldTypeChange)ctx.schemaDao().createPersistedChange((HibFieldSchemaVersionElement)version, SchemaChangeOperation.CHANGEFIELDTYPE);
            fieldTypeChange.setFieldName("testField");
            fieldTypeChange.setRestProperty("type", (Object)"string");
            fieldTypeChange.setRestProperty("allow", (Object)new String[]{"testValue"});
            version.setNextChange((HibSchemaChange)fieldTypeChange);
            SchemaModel updatedSchema = (SchemaModel)this.mutator.apply((HibFieldSchemaVersionElement)version);
            StringFieldSchema stringFieldSchema = (StringFieldSchema)updatedSchema.getField("testField", StringFieldSchemaImpl.class);
            Assert.assertNotNull((Object)stringFieldSchema);
            Assertions.assertThat((Object[])stringFieldSchema.getAllowedValues()).containsExactly((Object[])new String[]{"testValue"});
        }
    }

    @Test
    public void testUpdateLabel() throws MeshSchemaException {
        try (Tx tx = this.tx();){
            CommonTx ctx = (CommonTx)tx.unwrap();
            SchemaModelImpl schemaModel = new SchemaModelImpl("testschema");
            HibSchema schema = ctx.schemaDao().create((SchemaVersionModel)schemaModel, this.user());
            HibSchemaVersion version = (HibSchemaVersion)ctx.schemaDao().createPersistedVersion((HibFieldSchemaElement)schema, v -> {
                StringFieldSchemaImpl stringField = new StringFieldSchemaImpl();
                stringField.setAllowedValues(new String[]{"blub"});
                stringField.setName("stringField");
                stringField.setRequired(true);
                stringField.setLabel("originalLabel");
                schemaModel.addField((FieldSchema)stringField);
                v.setSchema((SchemaVersionModel)schemaModel);
            });
            HibUpdateFieldChange stringFieldUpdate = (HibUpdateFieldChange)ctx.schemaDao().createPersistedChange((HibFieldSchemaVersionElement)version, SchemaChangeOperation.UPDATEFIELD);
            stringFieldUpdate.setFieldName("stringField");
            stringFieldUpdate.setRestProperty("label", (Object)"UpdatedLabel");
            version.setNextChange((HibSchemaChange)stringFieldUpdate);
            SchemaModel updatedSchema = (SchemaModel)this.mutator.apply((HibFieldSchemaVersionElement)version);
            StringFieldSchema stringFieldSchema = (StringFieldSchema)updatedSchema.getField("stringField", StringFieldSchemaImpl.class);
            Assert.assertNotNull((Object)stringFieldSchema);
            Assert.assertEquals((Object)"UpdatedLabel", (Object)stringFieldSchema.getLabel());
        }
    }

    @Test
    public void testAUpdateFields() throws MeshSchemaException {
        try (Tx tx = this.tx();){
            CommonTx ctx = (CommonTx)tx.unwrap();
            SchemaModelImpl schemaModel = new SchemaModelImpl("testschema");
            HibSchema schema = ctx.schemaDao().create((SchemaVersionModel)schemaModel, this.user());
            HibSchemaVersion version = (HibSchemaVersion)ctx.schemaDao().createPersistedVersion((HibFieldSchemaElement)schema, v -> {
                BinaryFieldSchemaImpl binaryField = new BinaryFieldSchemaImpl();
                binaryField.setName("binaryField");
                binaryField.setAllowedMimeTypes(new String[]{"oldTypes"});
                binaryField.setRequired(true);
                schemaModel.addField((FieldSchema)binaryField);
                StringFieldSchemaImpl stringField = new StringFieldSchemaImpl();
                stringField.setAllowedValues(new String[]{"blub"});
                stringField.setName("stringField");
                stringField.setRequired(true);
                schemaModel.addField((FieldSchema)stringField);
                NodeFieldSchemaImpl nodeField = new NodeFieldSchemaImpl();
                nodeField.setAllowedSchemas(new String[]{"blub"});
                nodeField.setName("nodeField");
                nodeField.setRequired(true);
                schemaModel.addField((FieldSchema)nodeField);
                MicronodeFieldSchemaImpl micronodeField = new MicronodeFieldSchemaImpl();
                micronodeField.setAllowedMicroSchemas(new String[]{"blub"});
                micronodeField.setName("micronodeField");
                micronodeField.setRequired(true);
                schemaModel.addField((FieldSchema)micronodeField);
                NumberFieldSchemaImpl numberField = new NumberFieldSchemaImpl();
                numberField.setName("numberField");
                numberField.setRequired(true);
                schemaModel.addField((FieldSchema)numberField);
                HtmlFieldSchemaImpl htmlField = new HtmlFieldSchemaImpl();
                htmlField.setName("htmlField");
                htmlField.setRequired(true);
                schemaModel.addField((FieldSchema)htmlField);
                BooleanFieldSchemaImpl booleanField = new BooleanFieldSchemaImpl();
                booleanField.setName("booleanField");
                booleanField.setRequired(true);
                schemaModel.addField((FieldSchema)booleanField);
                DateFieldSchemaImpl dateField = new DateFieldSchemaImpl();
                dateField.setName("dateField");
                dateField.setRequired(true);
                schemaModel.addField((FieldSchema)dateField);
                ListFieldSchemaImpl listField = new ListFieldSchemaImpl();
                listField.setName("listField");
                listField.setListType("micronode");
                listField.setRequired(true);
                schemaModel.addField((FieldSchema)listField);
                v.setSchema((SchemaVersionModel)schemaModel);
            });
            HibUpdateFieldChange binaryFieldUpdate = (HibUpdateFieldChange)ctx.schemaDao().createPersistedChange((HibFieldSchemaVersionElement)version, SchemaChangeOperation.UPDATEFIELD);
            binaryFieldUpdate.setFieldName("binaryField");
            binaryFieldUpdate.setRestProperty("allowedMimeTypes", (Object)new String[]{"newTypes"});
            binaryFieldUpdate.setRestProperty("required", (Object)false);
            version.setNextChange((HibSchemaChange)binaryFieldUpdate);
            HibUpdateFieldChange nodeFieldUpdate = (HibUpdateFieldChange)ctx.schemaDao().createPersistedChange((HibFieldSchemaVersionElement)version, SchemaChangeOperation.UPDATEFIELD);
            nodeFieldUpdate.setFieldName("nodeField");
            nodeFieldUpdate.setRestProperty("allow", (Object)new String[]{"schemaA", "schemaB"});
            nodeFieldUpdate.setRestProperty("required", (Object)false);
            binaryFieldUpdate.setNextChange((HibSchemaChange)nodeFieldUpdate);
            HibUpdateFieldChange stringFieldUpdate = (HibUpdateFieldChange)ctx.schemaDao().createPersistedChange((HibFieldSchemaVersionElement)version, SchemaChangeOperation.UPDATEFIELD);
            stringFieldUpdate.setRestProperty("allow", (Object)new String[]{"valueA", "valueB"});
            stringFieldUpdate.setFieldName("stringField");
            stringFieldUpdate.setRestProperty("required", (Object)false);
            stringFieldUpdate.setIndexOptions(IndexOptionHelper.getRawFieldOption());
            nodeFieldUpdate.setNextChange((HibSchemaChange)stringFieldUpdate);
            HibUpdateFieldChange htmlFieldUpdate = (HibUpdateFieldChange)ctx.schemaDao().createPersistedChange((HibFieldSchemaVersionElement)version, SchemaChangeOperation.UPDATEFIELD);
            htmlFieldUpdate.setFieldName("htmlField");
            htmlFieldUpdate.setRestProperty("required", (Object)false);
            htmlFieldUpdate.setRestProperty("elasticsearch", (Object)IndexOptionHelper.getRawFieldOption().encode());
            stringFieldUpdate.setNextChange((HibSchemaChange)htmlFieldUpdate);
            HibUpdateFieldChange numberFieldUpdate = (HibUpdateFieldChange)ctx.schemaDao().createPersistedChange((HibFieldSchemaVersionElement)version, SchemaChangeOperation.UPDATEFIELD);
            numberFieldUpdate.setFieldName("numberField");
            numberFieldUpdate.setRestProperty("required", (Object)false);
            htmlFieldUpdate.setNextChange((HibSchemaChange)numberFieldUpdate);
            HibUpdateFieldChange dateFieldUpdate = (HibUpdateFieldChange)ctx.schemaDao().createPersistedChange((HibFieldSchemaVersionElement)version, SchemaChangeOperation.UPDATEFIELD);
            dateFieldUpdate.setFieldName("dateField");
            dateFieldUpdate.setRestProperty("required", (Object)false);
            numberFieldUpdate.setNextChange((HibSchemaChange)dateFieldUpdate);
            HibUpdateFieldChange booleanFieldUpdate = (HibUpdateFieldChange)ctx.schemaDao().createPersistedChange((HibFieldSchemaVersionElement)version, SchemaChangeOperation.UPDATEFIELD);
            booleanFieldUpdate.setFieldName("booleanField");
            booleanFieldUpdate.setRestProperty("required", (Object)false);
            dateFieldUpdate.setNextChange((HibSchemaChange)booleanFieldUpdate);
            HibUpdateFieldChange micronodeFieldUpdate = (HibUpdateFieldChange)ctx.schemaDao().createPersistedChange((HibFieldSchemaVersionElement)version, SchemaChangeOperation.UPDATEFIELD);
            micronodeFieldUpdate.setFieldName("micronodeField");
            micronodeFieldUpdate.setRestProperty("allow", (Object)new String[]{"A", "B", "C"});
            micronodeFieldUpdate.setRestProperty("required", (Object)false);
            booleanFieldUpdate.setNextChange((HibSchemaChange)micronodeFieldUpdate);
            HibUpdateFieldChange listFieldUpdate = (HibUpdateFieldChange)ctx.schemaDao().createPersistedChange((HibFieldSchemaVersionElement)version, SchemaChangeOperation.UPDATEFIELD);
            listFieldUpdate.setFieldName("listField");
            listFieldUpdate.setRestProperty("required", (Object)false);
            listFieldUpdate.setRestProperty("allow", (Object)new String[]{"A1", "B1", "C1"});
            micronodeFieldUpdate.setNextChange((HibSchemaChange)listFieldUpdate);
            SchemaModel updatedSchema = (SchemaModel)this.mutator.apply((HibFieldSchemaVersionElement)version);
            BinaryFieldSchema binaryFieldSchema = (BinaryFieldSchema)updatedSchema.getField("binaryField", BinaryFieldSchemaImpl.class);
            Assert.assertNotNull((Object)binaryFieldSchema);
            Assert.assertArrayEquals((Object[])new String[]{"newTypes"}, (Object[])binaryFieldSchema.getAllowedMimeTypes());
            Assert.assertFalse((String)"The required flag should now be set to false.", (boolean)binaryFieldSchema.isRequired());
            Assert.assertNull((String)"The elasticsearch settings were not set correctly.", (Object)binaryFieldSchema.getElasticsearch());
            NodeFieldSchema nodeFieldSchema = (NodeFieldSchema)updatedSchema.getField("nodeField", NodeFieldSchemaImpl.class);
            Assert.assertNotNull((Object)nodeFieldSchema);
            Assert.assertArrayEquals((Object[])new String[]{"schemaA", "schemaB"}, (Object[])nodeFieldSchema.getAllowedSchemas());
            Assert.assertFalse((String)"The required flag should now be set to false.", (boolean)nodeFieldSchema.isRequired());
            Assert.assertNull((String)"The elasticsearch settings were not set correctly.", (Object)nodeFieldSchema.getElasticsearch());
            MicronodeFieldSchema micronodeFieldSchema = (MicronodeFieldSchema)updatedSchema.getField("micronodeField", MicronodeFieldSchemaImpl.class);
            Assert.assertNotNull((Object)micronodeFieldSchema);
            Assert.assertArrayEquals((Object[])new String[]{"A", "B", "C"}, (Object[])micronodeFieldSchema.getAllowedMicroSchemas());
            Assert.assertFalse((String)"The required flag should now be set to false.", (boolean)micronodeFieldSchema.isRequired());
            Assert.assertNull((String)"The elasticsearch settings were not set correctly.", (Object)micronodeFieldSchema.getElasticsearch());
            StringFieldSchema stringFieldSchema = (StringFieldSchema)updatedSchema.getField("stringField", StringFieldSchemaImpl.class);
            Assert.assertNotNull((Object)stringFieldSchema);
            Assert.assertArrayEquals((Object[])new String[]{"valueA", "valueB"}, (Object[])stringFieldSchema.getAllowedValues());
            Assert.assertFalse((String)"The required flag should now be set to false.", (boolean)stringFieldSchema.isRequired());
            Assert.assertTrue((String)("The index option did not contain the raw field. {" + stringFieldSchema.getElasticsearch().encodePrettily() + "}"), (boolean)stringFieldSchema.getElasticsearch().containsKey("raw"));
            HtmlFieldSchema htmlFieldSchema = (HtmlFieldSchema)updatedSchema.getField("htmlField", HtmlFieldSchemaImpl.class);
            Assert.assertNotNull((Object)htmlFieldSchema);
            Assert.assertFalse((String)"The required flag should now be set to false.", (boolean)htmlFieldSchema.isRequired());
            Assert.assertTrue((String)("The elasticsearch settings did not contain the raw field. {" + htmlFieldSchema.getElasticsearch().encodePrettily() + "}"), (boolean)htmlFieldSchema.getElasticsearch().containsKey("raw"));
            BooleanFieldSchema booleanFieldSchema = (BooleanFieldSchema)updatedSchema.getField("booleanField", BooleanFieldSchemaImpl.class);
            Assert.assertFalse((String)"The required flag should now be set to false.", (boolean)booleanFieldSchema.isRequired());
            Assert.assertNull((String)"The elasticsearch settings were not set correctly.", (Object)booleanFieldSchema.getElasticsearch());
            DateFieldSchema dateFieldSchema = (DateFieldSchema)updatedSchema.getField("dateField", DateFieldSchemaImpl.class);
            Assert.assertFalse((String)"The required flag should now be set to false.", (boolean)dateFieldSchema.isRequired());
            Assert.assertNull((String)"The index option was not set correctly.", (Object)dateFieldSchema.getElasticsearch());
            NumberFieldSchema numberFieldSchema = (NumberFieldSchema)updatedSchema.getField("numberField", NumberFieldSchemaImpl.class);
            Assert.assertFalse((String)"The required flag should now be set to false.", (boolean)numberFieldSchema.isRequired());
            Assert.assertNull((String)"The elasticsearch settings were not set correctly.", (Object)numberFieldSchema.getElasticsearch());
            ListFieldSchema listFieldSchema = (ListFieldSchema)updatedSchema.getField("listField", ListFieldSchemaImpl.class);
            Assert.assertFalse((String)"The required flag should now be set to false.", (boolean)listFieldSchema.isRequired());
            Assert.assertNotNull((Object)listFieldSchema.getAllowedSchemas());
            Assertions.assertThat((Object[])listFieldSchema.getAllowedSchemas()).contains((Object[])new String[]{"A1", "B1", "C1"});
            Assert.assertNull((String)"The index option was not set correctly.", (Object)listFieldSchema.getElasticsearch());
        }
    }
}

