/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.schema.change;

import com.gentics.mesh.core.data.schema.HibFieldSchemaElement;
import com.gentics.mesh.core.data.schema.HibFieldSchemaVersionElement;
import com.gentics.mesh.core.data.schema.HibFieldTypeChange;
import com.gentics.mesh.core.data.schema.HibSchema;
import com.gentics.mesh.core.data.schema.HibSchemaChange;
import com.gentics.mesh.core.data.schema.HibSchemaVersion;
import com.gentics.mesh.core.db.CommonTx;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.ListFieldSchema;
import com.gentics.mesh.core.rest.schema.SchemaModel;
import com.gentics.mesh.core.rest.schema.SchemaVersionModel;
import com.gentics.mesh.core.rest.schema.change.impl.SchemaChangeModel;
import com.gentics.mesh.core.rest.schema.change.impl.SchemaChangeOperation;
import com.gentics.mesh.core.rest.schema.impl.ListFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.SchemaModelImpl;
import com.gentics.mesh.core.rest.schema.impl.StringFieldSchemaImpl;
import com.gentics.mesh.core.schema.change.AbstractChangeTest;
import com.gentics.mesh.error.MeshSchemaException;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=false)
public class FieldTypeChangeTest
extends AbstractChangeTest {
    @Override
    @Test
    public void testFields() throws IOException {
        try (Tx tx = this.tx();){
            CommonTx ctx = (CommonTx)tx.unwrap();
            SchemaModelImpl schemaModel = new SchemaModelImpl("testschema");
            HibSchema schema = ctx.schemaDao().create((SchemaVersionModel)schemaModel, this.user());
            HibSchemaVersion version = (HibSchemaVersion)ctx.schemaDao().createPersistedVersion((HibFieldSchemaElement)schema, v -> {});
            HibFieldTypeChange change = (HibFieldTypeChange)ctx.schemaDao().createPersistedChange((HibFieldSchemaVersionElement)version, SchemaChangeOperation.CHANGEFIELDTYPE);
            change.setFieldName("name");
            Assert.assertEquals((Object)"name", (Object)change.getFieldName());
        }
        catch (MeshSchemaException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Test
    public void testApply() {
        try (Tx tx = this.tx();){
            CommonTx ctx = (CommonTx)tx.unwrap();
            SchemaModelImpl schemaModel = new SchemaModelImpl();
            schemaModel.setName("testschema");
            HibSchema schema = ctx.schemaDao().create((SchemaVersionModel)schemaModel, this.user());
            HibSchemaVersion version = (HibSchemaVersion)ctx.schemaDao().createPersistedVersion((HibFieldSchemaElement)schema, v -> {
                StringFieldSchemaImpl stringField = new StringFieldSchemaImpl();
                stringField.setName("stringField");
                stringField.setRequired(true);
                schemaModel.addField((FieldSchema)stringField);
                v.setSchema((SchemaVersionModel)schemaModel);
            });
            HibFieldTypeChange fieldTypeUpdate = (HibFieldTypeChange)ctx.schemaDao().createPersistedChange((HibFieldSchemaVersionElement)version, SchemaChangeOperation.CHANGEFIELDTYPE);
            fieldTypeUpdate.setFieldName("stringField");
            fieldTypeUpdate.setType("html");
            version.setNextChange((HibSchemaChange)fieldTypeUpdate);
            SchemaModel updatedSchema = (SchemaModel)this.mutator.apply((HibFieldSchemaVersionElement)version);
            Assert.assertNotNull((Object)updatedSchema);
            Assert.assertEquals((Object)"html", (Object)updatedSchema.getField("stringField").getType());
        }
        catch (MeshSchemaException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testChangeFieldTypeToList() {
        try (Tx tx = this.tx();){
            CommonTx ctx = (CommonTx)tx.unwrap();
            SchemaModelImpl schemaModel = new SchemaModelImpl();
            schemaModel.setName("testschema");
            HibSchema schema = ctx.schemaDao().create((SchemaVersionModel)schemaModel, this.user());
            HibSchemaVersion version = (HibSchemaVersion)ctx.schemaDao().createPersistedVersion((HibFieldSchemaElement)schema, v -> {
                StringFieldSchemaImpl stringField = new StringFieldSchemaImpl();
                stringField.setName("stringField");
                stringField.setRequired(true);
                stringField.setLabel("test123");
                schemaModel.addField((FieldSchema)stringField);
                v.setSchema((SchemaVersionModel)schemaModel);
            });
            HibFieldTypeChange fieldTypeUpdate = (HibFieldTypeChange)ctx.schemaDao().createPersistedChange((HibFieldSchemaVersionElement)version, SchemaChangeOperation.CHANGEFIELDTYPE);
            fieldTypeUpdate.setFieldName("stringField");
            fieldTypeUpdate.setType("list");
            fieldTypeUpdate.setListType("html");
            version.setNextChange((HibSchemaChange)fieldTypeUpdate);
            SchemaModel updatedSchema = (SchemaModel)this.mutator.apply((HibFieldSchemaVersionElement)version);
            Assert.assertNotNull((Object)updatedSchema);
            ListFieldSchema fieldSchema = (ListFieldSchema)updatedSchema.getField("stringField", ListFieldSchemaImpl.class);
            Assert.assertEquals((Object)"list", (Object)fieldSchema.getType());
            Assert.assertEquals((Object)"html", (Object)fieldSchema.getListType());
            Assert.assertEquals((Object)"test123", (Object)fieldSchema.getLabel());
        }
        catch (MeshSchemaException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Test
    public void testUpdateFromRest() throws IOException {
        try (Tx tx = this.tx();){
            CommonTx ctx = (CommonTx)tx.unwrap();
            SchemaModelImpl schemaModel = new SchemaModelImpl();
            schemaModel.setName("testschema");
            HibSchema schema = ctx.schemaDao().create((SchemaVersionModel)schemaModel, this.user());
            HibSchemaVersion version = (HibSchemaVersion)ctx.schemaDao().createPersistedVersion((HibFieldSchemaElement)schema, v -> {});
            SchemaChangeModel model = SchemaChangeModel.createChangeFieldTypeChange((String)"testField", (String)"list");
            model.setProperty("listType", (Object)"html");
            HibFieldTypeChange change = (HibFieldTypeChange)ctx.schemaDao().createChange((HibFieldSchemaVersionElement)version, model);
            change.updateFromRest(model);
            Assert.assertEquals((Object)"testField", (Object)change.getFieldName());
            Assert.assertEquals((Object)"list", (Object)change.getType());
            Assert.assertEquals((Object)"html", (Object)change.getListType());
        }
        catch (MeshSchemaException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Test
    public void testTransformToRest() throws IOException {
        try (Tx tx = this.tx();){
            CommonTx ctx = (CommonTx)tx.unwrap();
            SchemaModelImpl schemaModel = new SchemaModelImpl();
            schemaModel.setName("testschema");
            HibSchema schema = ctx.schemaDao().create((SchemaVersionModel)schemaModel, this.user());
            HibSchemaVersion version = (HibSchemaVersion)ctx.schemaDao().createPersistedVersion((HibFieldSchemaElement)schema, v -> {});
            HibFieldTypeChange change = (HibFieldTypeChange)ctx.schemaDao().createPersistedChange((HibFieldSchemaVersionElement)version, SchemaChangeOperation.CHANGEFIELDTYPE);
            change.setFieldName("test");
            change.setListType("html");
            change.setType("list");
            SchemaChangeModel model = change.transformToRest();
            Assert.assertEquals((Object)"html", (Object)model.getProperty("listType"));
            Assert.assertEquals((Object)"list", (Object)model.getProperty("type"));
        }
        catch (MeshSchemaException e) {
            throw new RuntimeException(e);
        }
    }
}

