/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.schema.change;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.data.schema.HibFieldSchemaVersionElement;
import com.gentics.mesh.core.data.schema.HibRemoveFieldChange;
import com.gentics.mesh.core.data.schema.HibSchemaChange;
import com.gentics.mesh.core.data.schema.HibSchemaVersion;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.FieldSchemaContainer;
import com.gentics.mesh.core.rest.schema.FieldSchemaContainerVersion;
import com.gentics.mesh.core.rest.schema.SchemaVersionModel;
import com.gentics.mesh.core.rest.schema.change.impl.SchemaChangeModel;
import com.gentics.mesh.core.rest.schema.change.impl.SchemaChangeOperation;
import com.gentics.mesh.core.rest.schema.impl.SchemaModelImpl;
import com.gentics.mesh.core.schema.change.AbstractChangeTest;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=false)
public class RemoveFieldChangeTest
extends AbstractChangeTest {
    @Override
    @Test
    public void testFields() throws IOException {
        try (Tx tx = this.tx();){
            HibSchemaVersion version = (HibSchemaVersion)this.createVersion(this.schemaDao(tx));
            HibRemoveFieldChange change = (HibRemoveFieldChange)this.createChange(this.schemaDao(tx), version, SchemaChangeOperation.REMOVEFIELD);
            change.setFieldName("someField");
            Assert.assertEquals((Object)"someField", (Object)change.getFieldName());
        }
    }

    @Override
    @Test
    public void testApply() {
        try (Tx tx = this.tx();){
            HibSchemaVersion version = (HibSchemaVersion)this.createVersion(this.schemaDao(tx));
            SchemaModelImpl schema = new SchemaModelImpl();
            schema.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"test"));
            HibRemoveFieldChange change = (HibRemoveFieldChange)this.createChange(this.schemaDao(tx), version, SchemaChangeOperation.REMOVEFIELD);
            change.setFieldName("test");
            version.setNextChange((HibSchemaChange)change);
            version.setSchema((SchemaVersionModel)schema);
            FieldSchemaContainerVersion updatedSchema = this.mutator.apply((HibFieldSchemaVersionElement)version);
            MeshAssertions.assertThat((FieldSchemaContainer)updatedSchema).hasNoField("test");
        }
    }

    @Override
    @Test
    public void testUpdateFromRest() throws IOException {
        try (Tx tx = this.tx();){
            SchemaChangeModel model = new SchemaChangeModel(SchemaChangeOperation.REMOVEFIELD, "someField");
            HibSchemaVersion version = (HibSchemaVersion)this.createVersion(this.schemaDao(tx));
            HibRemoveFieldChange change = (HibRemoveFieldChange)this.schemaDao(tx).createChange((HibFieldSchemaVersionElement)version, model);
            Assert.assertEquals((Object)"someField", (Object)change.getFieldName());
        }
    }

    @Override
    @Test
    public void testTransformToRest() throws IOException {
        try (Tx tx = this.tx();){
            HibSchemaVersion version = (HibSchemaVersion)this.createVersion(this.schemaDao(tx));
            HibRemoveFieldChange change = (HibRemoveFieldChange)this.createChange(this.schemaDao(tx), version, SchemaChangeOperation.REMOVEFIELD);
            Assert.assertEquals((Object)HibRemoveFieldChange.OPERATION, (Object)change.transformToRest().getOperation());
            change.setFieldName("test2");
            SchemaChangeModel model = change.transformToRest();
            Assert.assertEquals((Object)"test2", (Object)model.getProperty("field"));
        }
    }
}

