/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.schema.change;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.core.data.schema.HibFieldSchemaVersionElement;
import com.gentics.mesh.core.data.schema.HibSchemaChange;
import com.gentics.mesh.core.data.schema.HibSchemaVersion;
import com.gentics.mesh.core.data.schema.HibUpdateFieldChange;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.FieldSchemaContainerVersion;
import com.gentics.mesh.core.rest.schema.SchemaVersionModel;
import com.gentics.mesh.core.rest.schema.change.impl.SchemaChangeModel;
import com.gentics.mesh.core.rest.schema.change.impl.SchemaChangeOperation;
import com.gentics.mesh.core.rest.schema.impl.SchemaModelImpl;
import com.gentics.mesh.core.schema.change.AbstractChangeTest;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.PROJECT, startServer=false)
public class UpdateFieldChangeTest
extends AbstractChangeTest {
    @Override
    @Test
    public void testFields() throws IOException {
        try (Tx tx = this.tx();){
            HibSchemaVersion version = (HibSchemaVersion)this.createVersion(this.schemaDao(tx));
            HibUpdateFieldChange change = (HibUpdateFieldChange)this.createChange(this.schemaDao(tx), version, SchemaChangeOperation.UPDATEFIELD);
            change.setLabel("testLabel");
            Assert.assertEquals((Object)"testLabel", (Object)change.getLabel());
        }
    }

    @Override
    @Test
    public void testApply() {
        try (Tx tx = this.tx();){
            HibSchemaVersion version = (HibSchemaVersion)this.createVersion(this.schemaDao(tx));
            version.setName("test");
            SchemaModelImpl schema = new SchemaModelImpl("test");
            schema.setVersion("0.1");
            schema.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"name"));
            version.setSchema((SchemaVersionModel)schema);
            HibUpdateFieldChange change = (HibUpdateFieldChange)this.createChange(this.schemaDao(tx), version, SchemaChangeOperation.UPDATEFIELD);
            change.setFieldName("name");
            change.setLabel("updated");
            version.setNextChange((HibSchemaChange)change);
            FieldSchemaContainerVersion updatedSchema = this.mutator.apply((HibFieldSchemaVersionElement)version);
            Assert.assertEquals((String)"The field label was not updated by the mutator.", (Object)"updated", (Object)updatedSchema.getField("name").getLabel());
        }
    }

    @Override
    @Test
    public void testUpdateFromRest() {
        try (Tx tx = this.tx();){
            HibSchemaVersion version = (HibSchemaVersion)this.createVersion(this.schemaDao(tx));
            SchemaChangeModel model = new SchemaChangeModel(SchemaChangeOperation.UPDATEFIELD, "someField");
            HibUpdateFieldChange change = (HibUpdateFieldChange)this.schemaDao(tx).createChange((HibFieldSchemaVersionElement)version, model);
            Assert.assertEquals((Object)"someField", (Object)change.getFieldName());
        }
    }

    @Override
    @Test
    public void testTransformToRest() throws IOException {
        try (Tx tx = this.tx();){
            HibSchemaVersion version = (HibSchemaVersion)this.createVersion(this.schemaDao(tx));
            HibUpdateFieldChange change = (HibUpdateFieldChange)this.createChange(this.schemaDao(tx), version, SchemaChangeOperation.UPDATEFIELD);
            change.setFieldName("fieldName");
            SchemaChangeModel model = change.transformToRest();
            Assert.assertEquals((Object)"fieldName", (Object)model.getProperty("field"));
            Assert.assertEquals((Object)HibUpdateFieldChange.OPERATION, (Object)model.getOperation());
        }
    }
}

