/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.schema.change;

import com.gentics.mesh.core.data.dao.PersistingMicroschemaDao;
import com.gentics.mesh.core.data.schema.HibFieldSchemaElement;
import com.gentics.mesh.core.data.schema.HibFieldSchemaVersionElement;
import com.gentics.mesh.core.data.schema.HibMicroschema;
import com.gentics.mesh.core.data.schema.HibMicroschemaVersion;
import com.gentics.mesh.core.data.schema.HibSchemaChange;
import com.gentics.mesh.core.data.schema.HibUpdateMicroschemaChange;
import com.gentics.mesh.core.db.CommonTx;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.microschema.MicroschemaVersionModel;
import com.gentics.mesh.core.rest.microschema.impl.MicroschemaModelImpl;
import com.gentics.mesh.core.rest.schema.MicroschemaModel;
import com.gentics.mesh.core.rest.schema.change.impl.SchemaChangeModel;
import com.gentics.mesh.core.rest.schema.change.impl.SchemaChangeOperation;
import com.gentics.mesh.core.schema.change.AbstractChangeTest;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=false)
public class UpdateMicroschemaChangeTest
extends AbstractChangeTest {
    @Override
    @Test
    public void testFields() throws IOException {
        try (Tx tx = this.tx();){
            PersistingMicroschemaDao microschemaDao = ((CommonTx)tx.unwrap()).microschemaDao();
            HibMicroschema microschema = (HibMicroschema)microschemaDao.createPersisted(null);
            HibMicroschemaVersion version = (HibMicroschemaVersion)microschemaDao.createPersistedVersion((HibFieldSchemaElement)microschema, v -> {});
            HibUpdateMicroschemaChange change = (HibUpdateMicroschemaChange)microschemaDao.createPersistedChange((HibFieldSchemaVersionElement)version, SchemaChangeOperation.UPDATEMICROSCHEMA);
            change.setDescription("test");
            Assert.assertEquals((Object)"test", (Object)change.getDescription());
        }
    }

    @Override
    @Test
    public void testApply() {
        try (Tx tx = this.tx();){
            PersistingMicroschemaDao microschemaDao = ((CommonTx)tx.unwrap()).microschemaDao();
            HibMicroschema microschema = (HibMicroschema)microschemaDao.createPersisted(null);
            HibMicroschemaVersion version = (HibMicroschemaVersion)microschemaDao.createPersistedVersion((HibFieldSchemaElement)microschema, v -> {});
            MicroschemaModelImpl schema = new MicroschemaModelImpl();
            HibUpdateMicroschemaChange change = (HibUpdateMicroschemaChange)microschemaDao.createPersistedChange((HibFieldSchemaVersionElement)version, SchemaChangeOperation.UPDATEMICROSCHEMA);
            change.setName("updated");
            change.setIndexOptions(new JsonObject().put("key", (Object)"value"));
            version.setSchema((MicroschemaVersionModel)schema);
            version.setNextChange((HibSchemaChange)change);
            MicroschemaModel updatedSchema = (MicroschemaModel)this.mutator.apply((HibFieldSchemaVersionElement)version);
            Assert.assertEquals((Object)"updated", (Object)updatedSchema.getName());
            Assert.assertEquals((Object)"value", (Object)updatedSchema.getElasticsearch().getString("key"));
            change = (HibUpdateMicroschemaChange)microschemaDao.createPersistedChange((HibFieldSchemaVersionElement)version, SchemaChangeOperation.UPDATEMICROSCHEMA);
            change.setDescription("text");
            version.setNextChange((HibSchemaChange)change);
            updatedSchema = (MicroschemaModel)this.mutator.apply((HibFieldSchemaVersionElement)version);
            Assert.assertEquals((Object)"text", (Object)updatedSchema.getDescription());
        }
    }

    @Override
    @Test
    public void testUpdateFromRest() {
        try (Tx tx = this.tx();){
            PersistingMicroschemaDao microschemaDao = ((CommonTx)tx.unwrap()).microschemaDao();
            HibMicroschema microschema = (HibMicroschema)microschemaDao.createPersisted(null);
            HibMicroschemaVersion version = (HibMicroschemaVersion)microschemaDao.createPersistedVersion((HibFieldSchemaElement)microschema, v -> {});
            SchemaChangeModel model = SchemaChangeModel.createUpdateMicroschemaChange();
            model.setProperty("name", (Object)"someName");
            HibUpdateMicroschemaChange change = (HibUpdateMicroschemaChange)microschemaDao.createChange((HibFieldSchemaVersionElement)version, model);
            change.updateFromRest(model);
            Assert.assertEquals((Object)"someName", (Object)change.getName());
        }
    }

    @Override
    @Test
    public void testTransformToRest() throws IOException {
        try (Tx tx = this.tx();){
            PersistingMicroschemaDao microschemaDao = ((CommonTx)tx.unwrap()).microschemaDao();
            HibMicroschema microschema = (HibMicroschema)microschemaDao.createPersisted(null);
            HibMicroschemaVersion version = (HibMicroschemaVersion)microschemaDao.createPersistedVersion((HibFieldSchemaElement)microschema, v -> {});
            HibUpdateMicroschemaChange change = (HibUpdateMicroschemaChange)microschemaDao.createPersistedChange((HibFieldSchemaVersionElement)version, SchemaChangeOperation.UPDATEMICROSCHEMA);
            change.setName("vcard");
            SchemaChangeModel model = change.transformToRest();
            Assert.assertEquals((Object)"vcard", (Object)model.getProperty("name"));
        }
    }
}

