/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.schema.change;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.core.data.schema.HibFieldSchemaVersionElement;
import com.gentics.mesh.core.data.schema.HibSchemaChange;
import com.gentics.mesh.core.data.schema.HibSchemaVersion;
import com.gentics.mesh.core.data.schema.HibUpdateSchemaChange;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.SchemaModel;
import com.gentics.mesh.core.rest.schema.SchemaVersionModel;
import com.gentics.mesh.core.rest.schema.change.impl.SchemaChangeModel;
import com.gentics.mesh.core.rest.schema.change.impl.SchemaChangeOperation;
import com.gentics.mesh.core.rest.schema.impl.SchemaModelImpl;
import com.gentics.mesh.core.schema.change.AbstractChangeTest;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.util.IndexOptionHelper;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=false)
public class UpdateSchemaChangeTest
extends AbstractChangeTest {
    @Override
    @Test
    public void testFields() throws IOException {
        try (Tx tx = this.tx();){
            HibSchemaVersion version = (HibSchemaVersion)this.createVersion(this.schemaDao(tx));
            HibUpdateSchemaChange change = (HibUpdateSchemaChange)this.createChange(this.schemaDao(tx), version, SchemaChangeOperation.UPDATESCHEMA);
            Assert.assertNull((String)"Initially no container flag value should be set.", (Object)change.getContainerFlag());
            change.setContainerFlag(Boolean.valueOf(true));
            Assert.assertTrue((String)"The container flag should be set to true.", (boolean)change.getContainerFlag());
            change.setDescription("testDescription");
            Assert.assertEquals((Object)"testDescription", (Object)change.getDescription());
            change.setName("someName");
            Assert.assertEquals((Object)"someName", (Object)change.getName());
            change.setDisplayField("fieldName1");
            Assert.assertEquals((Object)"fieldName1", (Object)change.getDisplayField());
            change.setSegmentField("fieldName2");
            Assert.assertEquals((Object)"fieldName2", (Object)change.getSegmentField());
            change.setURLFields(new String[]{"fieldA", "fieldB"});
            Assertions.assertThat((List)change.getURLFields()).containsExactly((Object[])new String[]{"fieldA", "fieldB"});
        }
    }

    @Override
    @Test
    public void testApply() {
        try (Tx tx = this.tx();){
            HibSchemaVersion version = (HibSchemaVersion)this.createVersion(this.schemaDao(tx));
            SchemaModelImpl schema = new SchemaModelImpl();
            HibUpdateSchemaChange change = (HibUpdateSchemaChange)this.createChange(this.schemaDao(tx), version, SchemaChangeOperation.UPDATESCHEMA);
            change.setIndexOptions(new JsonObject().put("key", (Object)"value"));
            change.setName("updated");
            version.setSchema((SchemaVersionModel)schema);
            version.setNextChange((HibSchemaChange)change);
            SchemaModel updatedSchema = (SchemaModel)this.mutator.apply((HibFieldSchemaVersionElement)version);
            Assert.assertEquals((Object)"updated", (Object)updatedSchema.getName());
            Assert.assertEquals((Object)"value", (Object)updatedSchema.getElasticsearch().getString("key"));
            change = (HibUpdateSchemaChange)this.createChange(this.schemaDao(tx), version, SchemaChangeOperation.UPDATESCHEMA);
            change.setDescription("text");
            version.setNextChange((HibSchemaChange)change);
            updatedSchema = (SchemaModel)this.mutator.apply((HibFieldSchemaVersionElement)version);
            Assert.assertEquals((Object)"text", (Object)updatedSchema.getDescription());
        }
    }

    @Test
    public void testFieldOrderChange() {
        try (Tx tx = this.tx();){
            HibSchemaVersion version = (HibSchemaVersion)this.createVersion(this.schemaDao(tx));
            SchemaModelImpl schema = new SchemaModelImpl();
            schema.setSegmentField("someField");
            schema.addField((FieldSchema)FieldUtil.createHtmlFieldSchema((String)"first"));
            schema.addField((FieldSchema)FieldUtil.createHtmlFieldSchema((String)"second"));
            version.setSchema((SchemaVersionModel)schema);
            HibUpdateSchemaChange change = (HibUpdateSchemaChange)this.createChange(this.schemaDao(tx), version, SchemaChangeOperation.UPDATESCHEMA);
            change.setOrder(new String[]{"second", "first"});
            version.setNextChange((HibSchemaChange)change);
            SchemaModel updatedSchema = (SchemaModel)this.mutator.apply((HibFieldSchemaVersionElement)version);
            Assert.assertNotNull((String)"The updated schema was not generated.", (Object)updatedSchema);
            Assert.assertEquals((String)"The segment field value should not have changed", (Object)"someField", (Object)updatedSchema.getSegmentField());
            Assert.assertEquals((String)"The updated schema should contain two fields.", (long)2L, (long)updatedSchema.getFields().size());
            Assert.assertEquals((String)"The first field should now be the field with name \"second\".", (Object)"second", (Object)((FieldSchema)updatedSchema.getFields().get(0)).getName());
            Assert.assertEquals((String)"The second field should now be the field with the name \"first\".", (Object)"first", (Object)((FieldSchema)updatedSchema.getFields().get(1)).getName());
        }
    }

    @Test
    public void testUpdateSchemaSegmentFieldToNull() {
        try (Tx tx = this.tx();){
            HibSchemaVersion version = (HibSchemaVersion)this.createVersion(this.schemaDao(tx));
            SchemaModelImpl schema = new SchemaModelImpl();
            schema.setSegmentField("someField");
            HibUpdateSchemaChange change = (HibUpdateSchemaChange)this.createChange(this.schemaDao(tx), version, SchemaChangeOperation.UPDATESCHEMA);
            change.setSegmentField("");
            version.setSchema((SchemaVersionModel)schema);
            version.setNextChange((HibSchemaChange)change);
            SchemaModel updatedSchema = (SchemaModel)this.mutator.apply((HibFieldSchemaVersionElement)version);
            Assert.assertNull((String)"The segment field name was not set to null", (Object)updatedSchema.getSegmentField());
        }
    }

    @Test
    public void testUpdateSchema() {
        try (Tx tx = this.tx();){
            HibSchemaVersion version = (HibSchemaVersion)this.createVersion(this.schemaDao(tx));
            SchemaModelImpl schema = new SchemaModelImpl();
            HibUpdateSchemaChange change = (HibUpdateSchemaChange)this.createChange(this.schemaDao(tx), version, SchemaChangeOperation.UPDATESCHEMA);
            change.setDisplayField("newDisplayField");
            change.setContainerFlag(Boolean.valueOf(true));
            change.setSegmentField("newSegmentField");
            version.setSchema((SchemaVersionModel)schema);
            version.setNextChange((HibSchemaChange)change);
            SchemaModel updatedSchema = (SchemaModel)this.mutator.apply((HibFieldSchemaVersionElement)version);
            Assert.assertEquals((String)"The display field name was not updated", (Object)"newDisplayField", (Object)updatedSchema.getDisplayField());
            Assert.assertEquals((String)"The segment field name was not updated", (Object)"newSegmentField", (Object)updatedSchema.getSegmentField());
            Assert.assertTrue((String)"The schema container flag was not updated", (boolean)updatedSchema.getContainer());
        }
    }

    @Override
    @Test
    public void testUpdateFromRest() throws IOException {
        try (Tx tx = this.tx();){
            SchemaChangeModel model = new SchemaChangeModel();
            model.setOperation(SchemaChangeOperation.UPDATESCHEMA);
            model.setProperty("required", (Object)true);
            model.setProperty("elasticsearch", (Object)IndexOptionHelper.getRawFieldOption().encode());
            model.setProperty("container", (Object)true);
            model.setProperty("description", (Object)"description");
            model.setProperty("segmentFieldname", (Object)"segmentField");
            model.setProperty("urlFieldsname", (Object)new String[]{"A", "B"});
            model.setProperty("displayFieldname", (Object)"displayField");
            model.setProperty("name", (Object)"newName");
            model.setProperty("order", (Object)new String[]{"A", "B", "C"});
            HibSchemaVersion version = (HibSchemaVersion)this.createVersion(this.schemaDao(tx));
            HibUpdateSchemaChange change = (HibUpdateSchemaChange)this.schemaDao(tx).createChange((HibFieldSchemaVersionElement)version, model);
            change.updateFromRest(model);
            Assert.assertTrue((String)"The required flag should be set to true.", (boolean)((Boolean)change.getRestProperty("required")));
            Assert.assertEquals((Object)"description", (Object)change.getDescription());
            Assert.assertEquals((Object)"segmentField", (Object)change.getSegmentField());
            Assert.assertEquals((Object)"displayField", (Object)change.getDisplayField());
            Assert.assertEquals((Object)"newName", (Object)change.getName());
            Assert.assertEquals((String)"Indexer option has not been set correctly", (Object)IndexOptionHelper.getRawFieldOption().encode(), (Object)change.getRestProperty("elasticsearch"));
            Assert.assertTrue((String)"Container flag should have been set.", (boolean)change.getContainerFlag());
            Assert.assertEquals((Object)HibUpdateSchemaChange.OPERATION, (Object)change.getOperation());
            Assert.assertArrayEquals((Object[])new String[]{"A", "B", "C"}, (Object[])change.getOrder().toArray());
        }
    }

    @Override
    @Test
    public void testTransformToRest() throws IOException {
        try (Tx tx = this.tx();){
            HibSchemaVersion version = (HibSchemaVersion)this.createVersion(this.schemaDao(tx));
            HibUpdateSchemaChange change = (HibUpdateSchemaChange)this.createChange(this.schemaDao(tx), version, SchemaChangeOperation.UPDATESCHEMA);
            SchemaChangeModel model = change.transformToRest();
            Assert.assertNotNull((Object)model);
            Assert.assertEquals((Object)HibUpdateSchemaChange.OPERATION, (Object)model.getOperation());
            Assert.assertEquals((Object)change.getUuid(), (Object)model.getUuid());
            change.setDisplayField("test");
            change.setSegmentField("test2");
            change.setURLFields(new String[]{"fieldA", "fieldB"});
            change.setName("someName");
            change.setDescription("someDescription");
            change.setContainerFlag(Boolean.valueOf(true));
            model = change.transformToRest();
            Assert.assertEquals((Object)"test", (Object)model.getProperty("displayFieldname"));
            Assert.assertEquals((Object)"test2", (Object)model.getProperty("segmentFieldname"));
            Assertions.assertThat((Object[])((String[])model.getProperty("urlFieldsname"))).containsExactly((Object[])new String[]{"fieldA", "fieldB"});
            Assert.assertEquals((Object)"someName", (Object)model.getProperty("name"));
            Assert.assertEquals((Object)"someDescription", (Object)model.getProperty("description"));
            Assert.assertTrue((String)"The container flag should have been set.", (boolean)((Boolean)model.getProperty("container")));
        }
    }
}

