/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.schema.field;

import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.assertj.impl.MicronodeAssert;
import com.gentics.mesh.assertj.impl.NodeAssert;
import com.gentics.mesh.assertj.impl.NodeGraphFieldContainerAssert;
import com.gentics.mesh.context.MicronodeMigrationContext;
import com.gentics.mesh.context.NodeMigrationActionContext;
import com.gentics.mesh.context.impl.MicronodeMigrationContextImpl;
import com.gentics.mesh.context.impl.NodeMigrationActionContextImpl;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.HibFieldContainer;
import com.gentics.mesh.core.data.HibNodeFieldContainer;
import com.gentics.mesh.core.data.branch.HibBranch;
import com.gentics.mesh.core.data.dao.MicroschemaDao;
import com.gentics.mesh.core.data.dao.NodeDao;
import com.gentics.mesh.core.data.dao.PersistingBranchDao;
import com.gentics.mesh.core.data.dao.PersistingMicroschemaDao;
import com.gentics.mesh.core.data.dao.PersistingSchemaDao;
import com.gentics.mesh.core.data.dao.SchemaDao;
import com.gentics.mesh.core.data.job.HibJob;
import com.gentics.mesh.core.data.node.HibMicronode;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.node.field.nesting.HibMicronodeField;
import com.gentics.mesh.core.data.project.HibProject;
import com.gentics.mesh.core.data.schema.HibAddFieldChange;
import com.gentics.mesh.core.data.schema.HibFieldSchemaElement;
import com.gentics.mesh.core.data.schema.HibFieldSchemaVersionElement;
import com.gentics.mesh.core.data.schema.HibFieldTypeChange;
import com.gentics.mesh.core.data.schema.HibMicroschema;
import com.gentics.mesh.core.data.schema.HibMicroschemaVersion;
import com.gentics.mesh.core.data.schema.HibRemoveFieldChange;
import com.gentics.mesh.core.data.schema.HibSchema;
import com.gentics.mesh.core.data.schema.HibSchemaChange;
import com.gentics.mesh.core.data.schema.HibSchemaVersion;
import com.gentics.mesh.core.data.schema.HibUpdateFieldChange;
import com.gentics.mesh.core.data.user.HibUser;
import com.gentics.mesh.core.db.CommonTx;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.endpoint.migration.MigrationStatusHandler;
import com.gentics.mesh.core.field.DataAsserter;
import com.gentics.mesh.core.field.DataProvider;
import com.gentics.mesh.core.field.FieldFetcher;
import com.gentics.mesh.core.field.FieldSchemaCreator;
import com.gentics.mesh.core.field.FieldTestHelper;
import com.gentics.mesh.core.migration.MicronodeMigration;
import com.gentics.mesh.core.migration.NodeMigration;
import com.gentics.mesh.core.rest.microschema.MicroschemaVersionModel;
import com.gentics.mesh.core.rest.microschema.impl.MicroschemaModelImpl;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.ListFieldSchema;
import com.gentics.mesh.core.rest.schema.MicronodeFieldSchema;
import com.gentics.mesh.core.rest.schema.SchemaVersionModel;
import com.gentics.mesh.core.rest.schema.change.impl.SchemaChangeOperation;
import com.gentics.mesh.core.rest.schema.impl.MicronodeFieldSchemaImpl;
import com.gentics.mesh.core.schema.field.DummyMigrationStatus;
import com.gentics.mesh.core.schema.field.FieldMigrationTestcases;
import com.gentics.mesh.event.EventQueueBatch;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.util.CoreTestUtils;
import com.gentics.mesh.util.UUIDUtil;
import com.gentics.mesh.util.VersionNumber;
import io.reactivex.exceptions.CompositeException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import javax.script.ScriptException;
import org.apache.commons.lang.StringUtils;
import org.assertj.core.api.AbstractObjectAssert;
import org.junit.Before;

public abstract class AbstractFieldMigrationTest
extends AbstractMeshTest
implements FieldMigrationTestcases {
    protected static final String NEWFIELD = "New field";
    protected static final String NEWFIELDVALUE = "New field value";
    protected static final String NEWBINARYCHECKSTATUS = "New binary check status";
    protected static final String OLDFIELD = "Old field";
    protected static final String OLDFIELDVALUE = "Old field value";
    protected static final String INVALIDSCRIPT = "this is an invalid script";
    protected static final String KILLERSCRIPT = "function migrate(node, fieldname) {var System = Java.type('java.lang.System'); System.exit(0);}";
    protected NodeMigration nodeMigrationHandler;
    protected MicronodeMigration micronodeMigrationHandler;

    @Before
    public void setupDeps() {
        this.nodeMigrationHandler = this.meshDagger().nodeMigrationHandler();
        this.micronodeMigrationHandler = this.meshDagger().micronodeMigrationHandler();
    }

    protected void removeField(FieldSchemaCreator creator, DataProvider dataProvider, FieldFetcher fetcher) throws InterruptedException, ExecutionException, TimeoutException {
        try (Tx tx = this.tx();){
            if (this.getClass().isAnnotationPresent(MicroschemaTest.class)) {
                this.removeMicroschemaField(tx, creator, dataProvider, fetcher);
            } else {
                this.removeSchemaField(tx, creator, dataProvider, fetcher);
            }
        }
    }

    private void removeSchemaField(Tx tx, FieldSchemaCreator creator, DataProvider dataProvider, FieldFetcher fetcher) throws InterruptedException, ExecutionException, TimeoutException {
        NodeDao nodeDao = tx.nodeDao();
        PersistingSchemaDao schemaDao = (PersistingSchemaDao)tx.schemaDao();
        PersistingBranchDao branchDao = (PersistingBranchDao)tx.branchDao();
        String removedFieldName = "toremove";
        String persistentFieldName = "persistent";
        String schemaName = "migratedSchema";
        HibSchema container = (HibSchema)schemaDao.createPersisted(UUIDUtil.randomUUID());
        container.generateBucketId();
        container.setName(container.getUuid());
        container.setCreated(this.user());
        HibSchemaVersion versionA = this.createSchemaVersion(Tx.get(), container, v -> {
            CoreTestUtils.fillSchemaVersion(v, container, schemaName, "1.0", creator.create(persistentFieldName), creator.create(removedFieldName));
            container.setLatestVersion((HibFieldSchemaVersionElement)v);
        });
        schemaDao.mergeIntoPersisted((HibBaseElement)container);
        HibSchemaVersion versionB = CoreTestUtils.createSchemaVersion(container, schemaName, "2.0", creator.create(persistentFieldName));
        HibRemoveFieldChange change = (HibRemoveFieldChange)schemaDao.createPersistedChange((HibFieldSchemaVersionElement)versionA, SchemaChangeOperation.REMOVEFIELD);
        change.setFieldName(removedFieldName);
        change.setPreviousContainerVersion((HibFieldSchemaVersionElement)versionA);
        change.setNextSchemaContainerVersion((HibFieldSchemaVersionElement)versionB);
        versionA.setNextVersion((HibFieldSchemaVersionElement)versionB);
        versionA.setNextChange((HibSchemaChange)change);
        EventQueueBatch batch = this.createBatch();
        branchDao.assignSchemaVersion(this.project().getLatestBranch(), this.user(), versionA, batch);
        HibUser user = this.user();
        String english = this.english();
        HibNode parentNode = this.folder("2015");
        HibNode node = nodeDao.create(parentNode, user, versionA, this.project());
        Tx.get().commit();
        HibNodeFieldContainer englishContainer = tx.contentDao().createFieldContainer(node, english, node.getProject().getLatestBranch(), user);
        dataProvider.set((HibFieldContainer)englishContainer, persistentFieldName);
        dataProvider.set((HibFieldContainer)englishContainer, removedFieldName);
        branchDao.assignSchemaVersion(this.project().getLatestBranch(), this.user(), versionB, batch);
        CommonTx.get().commit();
        CommonTx.get().data().maybeGetEventQueueBatch().ifPresent(EventQueueBatch::dispatch);
        NodeMigrationActionContextImpl context = new NodeMigrationActionContextImpl();
        context.setProject(this.project());
        context.setBranch(this.project().getLatestBranch());
        context.setFromVersion(versionA);
        context.setToVersion(versionB);
        context.setStatus((MigrationStatusHandler)DummyMigrationStatus.get());
        this.nodeMigrationHandler.migrateNodes((NodeMigrationActionContext)context).blockingAwait();
        ((NodeAssert)MeshAssertions.assertThat((HibNode)node).as("Migrated Node", new Object[0])).isOf(container).hasTranslation("en");
        ((NodeGraphFieldContainerAssert)MeshAssertions.assertThat((HibNodeFieldContainer)tx.contentDao().getFieldContainer(node, "en")).as("Migrated field container", new Object[0])).isOf(versionB);
        ((AbstractObjectAssert)MeshAssertions.assertThat((Object)fetcher.fetch((HibFieldContainer)tx.contentDao().getFieldContainer(node, "en"), persistentFieldName)).as("Field '" + persistentFieldName + "'", new Object[0])).isNotNull();
        ((AbstractObjectAssert)MeshAssertions.assertThat((Object)fetcher.fetch((HibFieldContainer)tx.contentDao().getFieldContainer(node, "en"), removedFieldName)).as("Field '" + removedFieldName + "'", new Object[0])).isNull();
    }

    private void removeMicroschemaField(Tx tx, FieldSchemaCreator creator, DataProvider dataProvider, FieldFetcher fetcher) throws InterruptedException, ExecutionException, TimeoutException {
        NodeDao nodeDao = tx.nodeDao();
        PersistingBranchDao branchDao = (PersistingBranchDao)tx.branchDao();
        PersistingMicroschemaDao microschemaDao = (PersistingMicroschemaDao)tx.microschemaDao();
        String removedFieldName = "toremove";
        String persistentFieldName = "persistent";
        String microschemaName = UUIDUtil.randomUUID();
        String micronodeFieldName = "micronodefield";
        HibMicroschema container = (HibMicroschema)microschemaDao.createPersisted(null);
        container.generateBucketId();
        container.setName(microschemaName);
        container.setCreated(this.user());
        HibMicroschemaVersion versionA = this.createMicroschemaVersion(container, microschemaName, "1.0", creator.create(persistentFieldName), creator.create(removedFieldName));
        HibMicroschemaVersion versionB = this.createMicroschemaVersion(container, microschemaName, "2.0", creator.create(persistentFieldName));
        HibRemoveFieldChange change = (HibRemoveFieldChange)microschemaDao.createPersistedChange((HibFieldSchemaVersionElement)versionA, SchemaChangeOperation.REMOVEFIELD);
        change.setFieldName(removedFieldName);
        change.setPreviousContainerVersion((HibFieldSchemaVersionElement)versionA);
        change.setNextSchemaContainerVersion((HibFieldSchemaVersionElement)versionB);
        versionA.setNextVersion(versionB);
        versionA.setNextChange((HibSchemaChange)change);
        HibNode node = nodeDao.create(this.folder("2015"), this.user(), (HibSchemaVersion)this.schemaContainer("content").getLatestVersion(), this.project());
        Tx.get().commit();
        HibMicronodeField micronodeField = this.createMicronodefield(tx, node, micronodeFieldName, versionA, dataProvider, persistentFieldName, removedFieldName);
        HibNodeFieldContainer oldContainer = tx.contentDao().getFieldContainer(node, "en");
        VersionNumber oldVersion = oldContainer.getVersion();
        branchDao.assignMicroschemaVersion(this.project().getLatestBranch(), this.user(), versionB, this.createBatch());
        CommonTx.get().commit();
        CommonTx.get().data().maybeGetEventQueueBatch().ifPresent(EventQueueBatch::dispatch);
        MicronodeMigrationContextImpl context = new MicronodeMigrationContextImpl();
        context.setBranch(this.project().getLatestBranch());
        context.setFromVersion(versionA);
        context.setToVersion(versionB);
        context.setStatus((MigrationStatusHandler)DummyMigrationStatus.get());
        this.micronodeMigrationHandler.migrateMicronodes((MicronodeMigrationContext)context).blockingAwait(10L, TimeUnit.SECONDS);
        ((NodeGraphFieldContainerAssert)MeshAssertions.assertThat((HibNodeFieldContainer)oldContainer).as("Old container", new Object[0])).hasVersion(oldVersion.toString());
        ((MicronodeAssert)MeshAssertions.assertThat((HibMicronode)micronodeField.getMicronode()).as("Old Micronode", new Object[0])).isOf(versionA);
        HibNodeFieldContainer newContainer = tx.contentDao().getFieldContainer(node, "en");
        ((NodeGraphFieldContainerAssert)MeshAssertions.assertThat((HibNodeFieldContainer)newContainer).as("New container", new Object[0])).hasVersion(oldVersion.nextDraft().toString());
        HibMicronodeField newMicronodeField = newContainer.getMicronode(micronodeFieldName);
        ((MicronodeAssert)MeshAssertions.assertThat((HibMicronode)newMicronodeField.getMicronode()).as("Migrated Micronode", new Object[0])).isOf(versionB);
        ((AbstractObjectAssert)MeshAssertions.assertThat((Object)fetcher.fetch((HibFieldContainer)newMicronodeField.getMicronode(), persistentFieldName)).as("Field '" + persistentFieldName + "'", new Object[0])).isNotNull();
        ((AbstractObjectAssert)MeshAssertions.assertThat((Object)fetcher.fetch((HibFieldContainer)newMicronodeField.getMicronode(), removedFieldName)).as("Field '" + removedFieldName + "'", new Object[0])).isNull();
    }

    protected void renameField(FieldSchemaCreator creator, DataProvider dataProvider, FieldFetcher fetcher, DataAsserter asserter) throws InterruptedException, ExecutionException, TimeoutException {
        try (Tx tx = this.tx();){
            if (this.getClass().isAnnotationPresent(MicroschemaTest.class)) {
                this.renameMicroschemaField(tx, creator, dataProvider, fetcher, asserter);
            } else {
                this.renameSchemaField(tx, creator, dataProvider, fetcher, asserter);
            }
        }
    }

    private void renameSchemaField(Tx tx, FieldSchemaCreator creator, DataProvider dataProvider, FieldFetcher fetcher, DataAsserter asserter) throws InterruptedException, ExecutionException, TimeoutException {
        NodeDao nodeDao = tx.nodeDao();
        PersistingBranchDao branchDao = (PersistingBranchDao)tx.branchDao();
        PersistingSchemaDao schemaDao = (PersistingSchemaDao)tx.schemaDao();
        String oldFieldName = "oldname";
        String newFieldName = "newname";
        String schemaName = "migratedSchema";
        HibSchema container = (HibSchema)schemaDao.createPersisted(UUIDUtil.randomUUID());
        container.generateBucketId();
        container.setName(container.getUuid());
        container.setCreated(this.user());
        schemaDao.mergeIntoPersisted((HibBaseElement)container);
        HibSchemaVersion versionA = this.createSchemaVersion(Tx.get(), container, v -> {
            CoreTestUtils.fillSchemaVersion(v, container, schemaName, "1.0", creator.create(oldFieldName));
            container.setLatestVersion((HibFieldSchemaVersionElement)v);
        });
        FieldSchema newField = creator.create(newFieldName);
        HibSchemaVersion versionB = CoreTestUtils.createSchemaVersion(container, schemaName, "2.0", newField);
        HibAddFieldChange addFieldChange = (HibAddFieldChange)schemaDao.createPersistedChange((HibFieldSchemaVersionElement)versionB, SchemaChangeOperation.ADDFIELD);
        addFieldChange.setFieldName(newFieldName);
        addFieldChange.setType(newField.getType());
        HibRemoveFieldChange removeFieldChange = (HibRemoveFieldChange)schemaDao.createPersistedChange((HibFieldSchemaVersionElement)versionA, SchemaChangeOperation.REMOVEFIELD);
        removeFieldChange.setFieldName(oldFieldName);
        addFieldChange.setPreviousContainerVersion((HibFieldSchemaVersionElement)versionA);
        addFieldChange.setNextChange((HibSchemaChange)removeFieldChange);
        removeFieldChange.setNextSchemaContainerVersion((HibFieldSchemaVersionElement)versionB);
        versionA.setNextVersion((HibFieldSchemaVersionElement)versionB);
        versionB.setNextChange((HibSchemaChange)addFieldChange);
        HibUser user = this.user();
        EventQueueBatch batch = this.createBatch();
        branchDao.assignSchemaVersion(this.project().getLatestBranch(), user, versionA, batch);
        String english = this.english();
        HibNode parentNode = this.folder("2015");
        HibNode node = nodeDao.create(parentNode, user, versionA, this.project());
        HibNodeFieldContainer englishContainer = tx.contentDao().createFieldContainer(node, english, node.getProject().getLatestBranch(), user);
        dataProvider.set((HibFieldContainer)englishContainer, oldFieldName);
        branchDao.assignSchemaVersion(this.project().getLatestBranch(), user, versionB, batch);
        CommonTx.get().commit();
        CommonTx.get().data().maybeGetEventQueueBatch().ifPresent(EventQueueBatch::dispatch);
        NodeMigrationActionContextImpl context = new NodeMigrationActionContextImpl();
        context.setProject(this.project());
        context.setBranch(this.project().getLatestBranch());
        context.setFromVersion(versionA);
        context.setToVersion(versionB);
        context.setStatus((MigrationStatusHandler)DummyMigrationStatus.get());
        this.nodeMigrationHandler.migrateNodes((NodeMigrationActionContext)context).blockingAwait();
        ((NodeAssert)MeshAssertions.assertThat((HibNode)node).as("Migrated Node", new Object[0])).isOf(container).hasTranslation("en");
        ((NodeGraphFieldContainerAssert)MeshAssertions.assertThat((HibNodeFieldContainer)tx.contentDao().getFieldContainer(node, "en")).as("Migrated field container", new Object[0])).isOf(versionB);
        ((AbstractObjectAssert)MeshAssertions.assertThat((Object)fetcher.fetch((HibFieldContainer)tx.contentDao().getFieldContainer(node, "en"), oldFieldName)).as("Field '" + oldFieldName + "'", new Object[0])).isNull();
        asserter.assertThat((HibFieldContainer)tx.contentDao().getFieldContainer(node, "en"), newFieldName);
    }

    private void renameMicroschemaField(Tx tx, FieldSchemaCreator creator, DataProvider dataProvider, FieldFetcher fetcher, DataAsserter asserter) throws InterruptedException, ExecutionException, TimeoutException {
        NodeDao nodeDao = tx.nodeDao();
        PersistingBranchDao branchDao = (PersistingBranchDao)tx.branchDao();
        PersistingMicroschemaDao microschemaDao = (PersistingMicroschemaDao)tx.microschemaDao();
        String oldFieldName = "oldname";
        String newFieldName = "newname";
        String microschemaName = UUIDUtil.randomUUID();
        String micronodeFieldName = "micronodefield";
        HibMicroschema container = (HibMicroschema)microschemaDao.createPersisted(null);
        container.generateBucketId();
        container.setName(microschemaName);
        container.setCreated(this.user());
        HibMicroschemaVersion versionA = this.createMicroschemaVersion(container, microschemaName, "1.0", creator.create(oldFieldName));
        FieldSchema newField = creator.create(newFieldName);
        HibMicroschemaVersion versionB = this.createMicroschemaVersion(container, microschemaName, "2.0", newField);
        HibAddFieldChange addFieldChange = (HibAddFieldChange)microschemaDao.createPersistedChange((HibFieldSchemaVersionElement)versionA, SchemaChangeOperation.ADDFIELD);
        addFieldChange.setFieldName(newFieldName);
        addFieldChange.setType(newField.getType());
        HibRemoveFieldChange removeFieldChange = (HibRemoveFieldChange)microschemaDao.createPersistedChange((HibFieldSchemaVersionElement)versionA, SchemaChangeOperation.REMOVEFIELD);
        removeFieldChange.setFieldName(oldFieldName);
        addFieldChange.setPreviousContainerVersion((HibFieldSchemaVersionElement)versionA);
        addFieldChange.setNextChange((HibSchemaChange)removeFieldChange);
        removeFieldChange.setNextSchemaContainerVersion((HibFieldSchemaVersionElement)versionB);
        versionA.setNextVersion(versionB);
        HibNode node = nodeDao.create(this.folder("2015"), this.user(), (HibSchemaVersion)this.schemaContainer("content").getLatestVersion(), this.project());
        HibMicronodeField micronodeField = this.createMicronodefield(tx, node, micronodeFieldName, versionA, dataProvider, oldFieldName);
        HibNodeFieldContainer oldContainer = tx.contentDao().getFieldContainer(node, "en");
        VersionNumber oldVersion = oldContainer.getVersion();
        HibJob job = branchDao.assignMicroschemaVersion(this.project().getLatestBranch(), this.user(), versionB, this.createBatch());
        CommonTx.get().commit();
        CommonTx.get().data().maybeGetEventQueueBatch().ifPresent(EventQueueBatch::dispatch);
        if (job != null) {
            this.triggerAndWaitForJob(job.getUuid());
        } else {
            MicronodeMigrationContextImpl context = new MicronodeMigrationContextImpl();
            context.setBranch(this.project().getLatestBranch());
            context.setFromVersion(versionA);
            context.setToVersion(versionB);
            context.setStatus((MigrationStatusHandler)DummyMigrationStatus.get());
            this.micronodeMigrationHandler.migrateMicronodes((MicronodeMigrationContext)context).blockingAwait(10L, TimeUnit.SECONDS);
        }
        ((NodeGraphFieldContainerAssert)MeshAssertions.assertThat((HibNodeFieldContainer)oldContainer).as("Old container", new Object[0])).hasVersion(oldVersion.toString());
        ((MicronodeAssert)MeshAssertions.assertThat((HibMicronode)micronodeField.getMicronode()).as("Old Micronode", new Object[0])).isOf(versionA);
        HibNodeFieldContainer newContainer = tx.contentDao().getFieldContainer(node, "en");
        ((NodeGraphFieldContainerAssert)MeshAssertions.assertThat((HibNodeFieldContainer)newContainer).as("New container", new Object[0])).hasVersion(oldVersion.nextDraft().toString());
        HibMicronodeField newMicronodeField = newContainer.getMicronode(micronodeFieldName);
        ((MicronodeAssert)MeshAssertions.assertThat((HibMicronode)newMicronodeField.getMicronode()).as("Migrated Micronode", new Object[0])).isOf(versionB);
        ((AbstractObjectAssert)MeshAssertions.assertThat((Object)fetcher.fetch((HibFieldContainer)newMicronodeField.getMicronode(), oldFieldName)).as("Field '" + oldFieldName + "'", new Object[0])).isNull();
        asserter.assertThat((HibFieldContainer)newMicronodeField.getMicronode(), newFieldName);
    }

    protected void changeType(FieldSchemaCreator oldField, DataProvider dataProvider, FieldFetcher oldFieldFetcher, FieldSchemaCreator newField, DataAsserter asserter) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.getClass().isAnnotationPresent(MicroschemaTest.class)) {
            this.changeMicroschemaType(oldField, dataProvider, oldFieldFetcher, newField, asserter);
        } else {
            this.changeSchemaType(oldField, dataProvider, oldFieldFetcher, newField, asserter);
        }
    }

    private void changeSchemaType(FieldSchemaCreator oldField, DataProvider dataProvider, FieldFetcher oldFieldFetcher, FieldSchemaCreator newField, DataAsserter asserter) throws InterruptedException, ExecutionException, TimeoutException {
        String fieldName = "changedfield";
        String schemaName = "schema_" + System.currentTimeMillis();
        AtomicReference nodeUuid = new AtomicReference();
        AtomicReference schemaUuid = new AtomicReference();
        AtomicReference versionAUuid = new AtomicReference();
        AtomicReference versionBUuid = new AtomicReference();
        AtomicReference oldFieldSchema = new AtomicReference();
        AtomicReference newFieldSchema = new AtomicReference();
        this.tx(tx -> {
            NodeDao nodeDao = tx.nodeDao();
            PersistingBranchDao branchDao = (PersistingBranchDao)tx.branchDao();
            PersistingSchemaDao schemaDao = (PersistingSchemaDao)tx.schemaDao();
            oldFieldSchema.set(oldField.create(fieldName));
            HibSchema container = (HibSchema)schemaDao.createPersisted(UUIDUtil.randomUUID());
            container.generateBucketId();
            container.setName(schemaName);
            container.setCreated(this.user());
            HibSchemaVersion versionA = this.createSchemaVersion(tx, container, v -> {
                CoreTestUtils.fillSchemaVersion(v, container, schemaName, "1.0", (FieldSchema)oldFieldSchema.get());
                container.setLatestVersion((HibFieldSchemaVersionElement)v);
            });
            versionAUuid.set(versionA.getUuid());
            schemaDao.mergeIntoPersisted((HibBaseElement)container);
            schemaUuid.set(container.getUuid());
            newFieldSchema.set(newField.create(fieldName));
            HibSchemaVersion versionB = CoreTestUtils.createSchemaVersion(container, schemaName, "2.0", (FieldSchema)newFieldSchema.get());
            versionBUuid.set(versionB.getUuid());
            HibFieldTypeChange change = (HibFieldTypeChange)schemaDao.createPersistedChange((HibFieldSchemaVersionElement)versionA, SchemaChangeOperation.CHANGEFIELDTYPE);
            change.setFieldName(fieldName);
            change.setType(((FieldSchema)newFieldSchema.get()).getType());
            if (newFieldSchema.get() instanceof ListFieldSchema) {
                change.setListType(((ListFieldSchema)newFieldSchema.get()).getListType());
            }
            change.setPreviousContainerVersion((HibFieldSchemaVersionElement)versionA);
            change.setNextSchemaContainerVersion((HibFieldSchemaVersionElement)versionB);
            versionA.setNextVersion((HibFieldSchemaVersionElement)versionB);
            versionA.setNextChange((HibSchemaChange)change);
            EventQueueBatch batch = this.createBatch();
            branchDao.assignSchemaVersion(this.project().getLatestBranch(), this.user(), versionA, batch);
            HibUser user = this.user();
            String english = this.english();
            HibNode parentNode = this.folder("2015");
            HibNode node = nodeDao.create(parentNode, user, versionA, this.project());
            nodeUuid.set(node.getUuid());
        });
        AtomicReference englishContainer = new AtomicReference();
        this.tx(tx -> {
            HibUser user = this.user();
            String english = this.english();
            HibNode node = tx.nodeDao().findByUuidGlobal((String)nodeUuid.get());
            HibSchema schema = (HibSchema)tx.schemaDao().findByUuid((String)schemaUuid.get());
            HibSchemaVersion versionA = (HibSchemaVersion)tx.schemaDao().findVersionByUuid((HibFieldSchemaElement)schema, (String)versionAUuid.get());
            HibSchemaVersion versionB = (HibSchemaVersion)tx.schemaDao().findVersionByUuid((HibFieldSchemaElement)schema, (String)versionBUuid.get());
            englishContainer.set(tx.contentDao().createFieldContainer(node, english, node.getProject().getLatestBranch(), user));
            dataProvider.set((HibFieldContainer)englishContainer.get(), fieldName);
            MeshAssertions.assertThat((HibNodeFieldContainer)((HibNodeFieldContainer)englishContainer.get())).isOf(versionA).hasVersion("0.1");
            if (dataProvider == FieldTestHelper.NOOP) {
                ((AbstractObjectAssert)MeshAssertions.assertThat((Object)oldFieldFetcher.fetch((HibFieldContainer)englishContainer.get(), fieldName)).as(OLDFIELD, new Object[0])).isNull();
            } else {
                ((AbstractObjectAssert)MeshAssertions.assertThat((Object)oldFieldFetcher.fetch((HibFieldContainer)englishContainer.get(), fieldName)).as(OLDFIELD, new Object[0])).isNotNull();
            }
            EventQueueBatch batch = this.createBatch();
            tx.branchDao().assignSchemaVersion(this.project().getLatestBranch(), this.user(), versionB, batch);
        });
        NodeMigrationActionContextImpl context = new NodeMigrationActionContextImpl();
        context.setProject((HibProject)this.tx(() -> this.project()));
        context.setBranch((HibBranch)this.tx(() -> this.project().getLatestBranch()));
        context.setFromVersion((HibSchemaVersion)this.tx(tx -> {
            SchemaDao schemaDao = tx.schemaDao();
            return (HibSchemaVersion)schemaDao.findVersionByUuid((HibFieldSchemaElement)((HibSchema)schemaDao.findByUuid((String)schemaUuid.get())), (String)versionAUuid.get());
        }));
        context.setToVersion((HibSchemaVersion)this.tx(tx -> {
            SchemaDao schemaDao = tx.schemaDao();
            return (HibSchemaVersion)schemaDao.findVersionByUuid((HibFieldSchemaElement)((HibSchema)schemaDao.findByUuid((String)schemaUuid.get())), (String)versionBUuid.get());
        }));
        context.setStatus((MigrationStatusHandler)DummyMigrationStatus.get());
        this.nodeMigrationHandler.migrateNodes((NodeMigrationActionContext)context).blockingAwait();
        this.tx(tx -> {
            HibNode node = tx.nodeDao().findByUuidGlobal((String)nodeUuid.get());
            HibSchema schema = (HibSchema)tx.schemaDao().findByUuid((String)schemaUuid.get());
            HibSchemaVersion versionA = (HibSchemaVersion)tx.schemaDao().findVersionByUuid((HibFieldSchemaElement)schema, (String)versionAUuid.get());
            HibSchemaVersion versionB = (HibSchemaVersion)tx.schemaDao().findVersionByUuid((HibFieldSchemaElement)schema, (String)versionBUuid.get());
            MeshAssertions.assertThat((HibNodeFieldContainer)((HibNodeFieldContainer)englishContainer.get())).isOf(versionA).hasVersion("0.1");
            HibNodeFieldContainer migratedContainer = tx.contentDao().getFieldContainer(node, "en");
            MeshAssertions.assertThat((HibNodeFieldContainer)migratedContainer).isOf(versionB).hasVersion("0.2");
            ((NodeAssert)MeshAssertions.assertThat((HibNode)node).as("Migrated Node", new Object[0])).isOf(schema).hasTranslation("en");
            if (!StringUtils.equals((String)((FieldSchema)oldFieldSchema.get()).getType(), (String)((FieldSchema)newFieldSchema.get()).getType())) {
                ((AbstractObjectAssert)MeshAssertions.assertThat((Object)oldFieldFetcher.fetch((HibFieldContainer)migratedContainer, fieldName)).as(OLDFIELD, new Object[0])).isNull();
            }
            if (oldFieldSchema.get() instanceof ListFieldSchema && newFieldSchema.get() instanceof ListFieldSchema && !StringUtils.equals((String)((ListFieldSchema)oldFieldSchema.get()).getListType(), (String)((ListFieldSchema)newFieldSchema.get()).getListType())) {
                ((AbstractObjectAssert)MeshAssertions.assertThat((Object)oldFieldFetcher.fetch((HibFieldContainer)migratedContainer, fieldName)).as(OLDFIELD, new Object[0])).isNull();
            }
            asserter.assertThat((HibFieldContainer)migratedContainer, fieldName);
        });
    }

    private void changeMicroschemaType(FieldSchemaCreator oldField, DataProvider dataProvider, FieldFetcher oldFieldFetcher, FieldSchemaCreator newField, DataAsserter asserter) throws InterruptedException, ExecutionException, TimeoutException {
        String fieldName = "changedfield";
        String microschemaName = UUIDUtil.randomUUID();
        String micronodeFieldName = "micronodefield";
        AtomicReference nodeUuid = new AtomicReference();
        AtomicReference microschemaUuid = new AtomicReference();
        AtomicReference versionAUuid = new AtomicReference();
        AtomicReference versionBUuid = new AtomicReference();
        AtomicReference oldFieldSchema = new AtomicReference();
        AtomicReference newFieldSchema = new AtomicReference();
        this.tx(tx -> {
            NodeDao nodeDao = tx.nodeDao();
            PersistingMicroschemaDao microschemaDao = (PersistingMicroschemaDao)tx.microschemaDao();
            oldFieldSchema.set(oldField.create(fieldName));
            HibMicroschema container = (HibMicroschema)microschemaDao.createPersisted(null);
            container.setName(microschemaName);
            container.setCreated(this.user());
            microschemaUuid.set(container.getUuid());
            HibMicroschemaVersion versionA = this.createMicroschemaVersion(container, microschemaName, "1.0", (FieldSchema)oldFieldSchema.get());
            versionAUuid.set(versionA.getUuid());
            newFieldSchema.set(newField.create(fieldName));
            HibMicroschemaVersion versionB = this.createMicroschemaVersion(container, microschemaName, "2.0", (FieldSchema)newFieldSchema.get());
            versionBUuid.set(versionB.getUuid());
            HibFieldTypeChange change = (HibFieldTypeChange)microschemaDao.createPersistedChange((HibFieldSchemaVersionElement)versionA, SchemaChangeOperation.CHANGEFIELDTYPE);
            change.setFieldName(fieldName);
            change.setType(((FieldSchema)newFieldSchema.get()).getType());
            if (newFieldSchema.get() instanceof ListFieldSchema) {
                change.setListType(((ListFieldSchema)newFieldSchema.get()).getListType());
            }
            change.setPreviousContainerVersion((HibFieldSchemaVersionElement)versionA);
            change.setNextSchemaContainerVersion((HibFieldSchemaVersionElement)versionB);
            versionA.setNextVersion(versionB);
            versionA.setNextChange((HibSchemaChange)change);
            microschemaDao.assign(container, this.project(), this.user(), this.createBatch());
            HibNode node = nodeDao.create(this.folder("2015"), this.user(), (HibSchemaVersion)this.schemaContainer("content").getLatestVersion(), this.project());
            nodeUuid.set(node.getUuid());
        });
        AtomicReference oldVersion = new AtomicReference();
        AtomicReference oldContainer = new AtomicReference();
        this.tx(tx -> {
            HibNode node = tx.nodeDao().findByUuidGlobal((String)nodeUuid.get());
            HibMicroschema microschema = (HibMicroschema)tx.microschemaDao().findByUuid((String)microschemaUuid.get());
            HibMicroschemaVersion versionA = (HibMicroschemaVersion)tx.microschemaDao().findVersionByUuid((HibFieldSchemaElement)microschema, (String)versionAUuid.get());
            HibMicronodeField micronodeField = this.createMicronodefield(tx, node, micronodeFieldName, versionA, dataProvider, fieldName);
            oldContainer.set(tx.contentDao().getFieldContainer(node, "en"));
            oldVersion.set(((HibNodeFieldContainer)oldContainer.get()).getVersion());
            if (dataProvider == FieldTestHelper.NOOP) {
                ((AbstractObjectAssert)MeshAssertions.assertThat((Object)oldFieldFetcher.fetch((HibFieldContainer)micronodeField.getMicronode(), fieldName)).as(OLDFIELD, new Object[0])).isNull();
            } else {
                ((AbstractObjectAssert)MeshAssertions.assertThat((Object)oldFieldFetcher.fetch((HibFieldContainer)micronodeField.getMicronode(), fieldName)).as(OLDFIELD, new Object[0])).isNotNull();
            }
        });
        MicronodeMigrationContextImpl context = new MicronodeMigrationContextImpl();
        context.setBranch((HibBranch)this.tx(() -> this.project().getLatestBranch()));
        context.setFromVersion((HibMicroschemaVersion)this.tx(tx -> {
            MicroschemaDao microschemaDao = tx.microschemaDao();
            return (HibMicroschemaVersion)microschemaDao.findVersionByUuid((HibFieldSchemaElement)((HibMicroschema)microschemaDao.findByUuid((String)microschemaUuid.get())), (String)versionAUuid.get());
        }));
        context.setToVersion((HibMicroschemaVersion)this.tx(tx -> {
            MicroschemaDao microschemaDao = tx.microschemaDao();
            return (HibMicroschemaVersion)microschemaDao.findVersionByUuid((HibFieldSchemaElement)((HibMicroschema)microschemaDao.findByUuid((String)microschemaUuid.get())), (String)versionBUuid.get());
        }));
        context.setStatus((MigrationStatusHandler)DummyMigrationStatus.get());
        this.micronodeMigrationHandler.migrateMicronodes((MicronodeMigrationContext)context).blockingAwait(10L, TimeUnit.SECONDS);
        this.tx(tx -> {
            HibNode node = tx.nodeDao().findByUuidGlobal((String)nodeUuid.get());
            HibMicroschema microschema = (HibMicroschema)tx.microschemaDao().findByUuid((String)microschemaUuid.get());
            HibMicroschemaVersion versionA = (HibMicroschemaVersion)tx.microschemaDao().findVersionByUuid((HibFieldSchemaElement)microschema, (String)versionAUuid.get());
            HibMicroschemaVersion versionB = (HibMicroschemaVersion)tx.microschemaDao().findVersionByUuid((HibFieldSchemaElement)microschema, (String)versionBUuid.get());
            HibMicronodeField micronodeField = ((HibNodeFieldContainer)oldContainer.get()).getMicronode(micronodeFieldName);
            ((NodeGraphFieldContainerAssert)MeshAssertions.assertThat((HibNodeFieldContainer)((HibNodeFieldContainer)oldContainer.get())).as("Old container", new Object[0])).hasVersion(((VersionNumber)oldVersion.get()).toString());
            ((MicronodeAssert)MeshAssertions.assertThat((HibMicronode)micronodeField.getMicronode()).as("Old micronode", new Object[0])).isOf(versionA);
            HibNodeFieldContainer newContainer = tx.contentDao().getFieldContainer(node, "en");
            ((NodeGraphFieldContainerAssert)MeshAssertions.assertThat((HibNodeFieldContainer)newContainer).as("New container", new Object[0])).hasVersion(((VersionNumber)oldVersion.get()).nextDraft().toString());
            HibMicronodeField newMicronodeField = newContainer.getMicronode(micronodeFieldName);
            ((MicronodeAssert)MeshAssertions.assertThat((HibMicronode)newMicronodeField.getMicronode()).as("Migrated Micronode", new Object[0])).isOf(versionB);
            if (!StringUtils.equals((String)((FieldSchema)oldFieldSchema.get()).getType(), (String)((FieldSchema)newFieldSchema.get()).getType())) {
                ((AbstractObjectAssert)MeshAssertions.assertThat((Object)oldFieldFetcher.fetch((HibFieldContainer)newMicronodeField.getMicronode(), fieldName)).as(OLDFIELD, new Object[0])).isNull();
            }
            if (oldFieldSchema.get() instanceof ListFieldSchema && newFieldSchema.get() instanceof ListFieldSchema && !StringUtils.equals((String)((ListFieldSchema)oldFieldSchema.get()).getListType(), (String)((ListFieldSchema)newFieldSchema.get()).getListType())) {
                ((AbstractObjectAssert)MeshAssertions.assertThat((Object)oldFieldFetcher.fetch((HibFieldContainer)newMicronodeField.getMicronode(), fieldName)).as(OLDFIELD, new Object[0])).isNull();
            }
            asserter.assertThat((HibFieldContainer)newMicronodeField.getMicronode(), fieldName);
        });
    }

    protected void customMigrationScript(FieldSchemaCreator creator, DataProvider dataProvider, FieldFetcher fetcher, String migrationScript, DataAsserter asserter) throws InterruptedException, ExecutionException, TimeoutException {
        try (Tx tx = this.tx();){
            if (this.getClass().isAnnotationPresent(MicroschemaTest.class)) {
                this.customMicroschemaMigrationScript(tx, creator, dataProvider, fetcher, migrationScript, asserter);
            } else {
                this.customSchemaMigrationScript(tx, creator, dataProvider, fetcher, migrationScript, asserter);
            }
        }
    }

    private void customSchemaMigrationScript(Tx tx, FieldSchemaCreator creator, DataProvider dataProvider, FieldFetcher fetcher, String migrationScript, DataAsserter asserter) throws InterruptedException, ExecutionException, TimeoutException {
        NodeDao nodeDao = tx.nodeDao();
        PersistingBranchDao branchDao = (PersistingBranchDao)tx.branchDao();
        PersistingSchemaDao schemaDao = (PersistingSchemaDao)tx.schemaDao();
        String fieldName = "migratedField";
        String schemaName = "migratedSchema";
        FieldSchema oldField = creator.create(fieldName);
        HibSchema container = (HibSchema)schemaDao.createPersisted(UUIDUtil.randomUUID());
        container.generateBucketId();
        container.setName(UUIDUtil.randomUUID());
        container.setCreated(this.user());
        schemaDao.mergeIntoPersisted((HibBaseElement)container);
        HibSchemaVersion versionA = this.createSchemaVersion(Tx.get(), container, v -> {
            CoreTestUtils.fillSchemaVersion(v, container, schemaName, "1.0", oldField);
            container.setLatestVersion((HibFieldSchemaVersionElement)v);
        });
        FieldSchema newField = creator.create(fieldName);
        HibSchemaVersion versionB = CoreTestUtils.createSchemaVersion(container, schemaName, "2.0", newField);
        HibUpdateFieldChange updateFieldChange = (HibUpdateFieldChange)schemaDao.createPersistedChange((HibFieldSchemaVersionElement)versionA, SchemaChangeOperation.UPDATEFIELD);
        updateFieldChange.setFieldName(fieldName);
        updateFieldChange.setPreviousContainerVersion((HibFieldSchemaVersionElement)versionA);
        updateFieldChange.setNextSchemaContainerVersion((HibFieldSchemaVersionElement)versionB);
        versionA.setNextVersion((HibFieldSchemaVersionElement)versionB);
        EventQueueBatch batch = this.createBatch();
        branchDao.assignSchemaVersion(this.project().getLatestBranch(), this.user(), versionA, batch);
        HibUser user = this.user();
        String english = this.english();
        HibNode parentNode = this.folder("2015");
        HibNode node = nodeDao.create(parentNode, user, versionA, this.project());
        HibNodeFieldContainer englishContainer = tx.contentDao().createFieldContainer(node, english, node.getProject().getLatestBranch(), user);
        dataProvider.set((HibFieldContainer)englishContainer, fieldName);
        branchDao.assignSchemaVersion(this.project().getLatestBranch(), this.user(), versionB, batch);
        CommonTx.get().commit();
        CommonTx.get().data().maybeGetEventQueueBatch().ifPresent(EventQueueBatch::dispatch);
        NodeMigrationActionContextImpl context = new NodeMigrationActionContextImpl();
        context.setProject(this.project());
        context.setBranch(this.project().getLatestBranch());
        context.setFromVersion(versionA);
        context.setToVersion(versionB);
        context.setStatus((MigrationStatusHandler)DummyMigrationStatus.get());
        this.nodeMigrationHandler.migrateNodes((NodeMigrationActionContext)context).blockingAwait();
        ((NodeAssert)MeshAssertions.assertThat((HibNode)node).as("Migrated Node", new Object[0])).isOf(container).hasTranslation("en");
        ((NodeGraphFieldContainerAssert)MeshAssertions.assertThat((HibNodeFieldContainer)tx.contentDao().getFieldContainer(node, "en")).as("Migrated field container", new Object[0])).isOf(versionB);
        asserter.assertThat((HibFieldContainer)tx.contentDao().getFieldContainer(node, "en"), fieldName);
    }

    private void customMicroschemaMigrationScript(Tx tx, FieldSchemaCreator creator, DataProvider dataProvider, FieldFetcher fetcher, String migrationScript, DataAsserter asserter) throws InterruptedException, ExecutionException, TimeoutException {
        PersistingMicroschemaDao microschemaDao = (PersistingMicroschemaDao)tx.microschemaDao();
        PersistingBranchDao branchDao = (PersistingBranchDao)tx.branchDao();
        NodeDao nodeDao = tx.nodeDao();
        String fieldName = "migratedField";
        String microschemaName = UUIDUtil.randomUUID();
        String micronodeFieldName = "micronodefield";
        FieldSchema oldField = creator.create(fieldName);
        HibMicroschema container = (HibMicroschema)microschemaDao.createPersisted(null);
        container.generateBucketId();
        container.setName(microschemaName);
        container.setCreated(this.user());
        HibMicroschemaVersion versionA = this.createMicroschemaVersion(container, microschemaName, "1.0", oldField);
        FieldSchema newField = creator.create(fieldName);
        HibMicroschemaVersion versionB = this.createMicroschemaVersion(container, microschemaName, "2.0", newField);
        HibUpdateFieldChange updateFieldChange = (HibUpdateFieldChange)microschemaDao.createPersistedChange((HibFieldSchemaVersionElement)versionA, SchemaChangeOperation.UPDATEFIELD);
        updateFieldChange.setFieldName(fieldName);
        updateFieldChange.setPreviousContainerVersion((HibFieldSchemaVersionElement)versionA);
        updateFieldChange.setNextSchemaContainerVersion((HibFieldSchemaVersionElement)versionB);
        versionA.setNextVersion(versionB);
        microschemaDao.assign(container, this.project(), this.user(), this.createBatch());
        HibNode node = nodeDao.create(this.folder("2015"), this.user(), (HibSchemaVersion)this.schemaContainer("content").getLatestVersion(), this.project());
        HibMicronodeField micronodeField = this.createMicronodefield(tx, node, micronodeFieldName, versionA, dataProvider, fieldName);
        HibNodeFieldContainer oldContainer = tx.contentDao().getFieldContainer(node, "en");
        VersionNumber oldVersion = oldContainer.getVersion();
        branchDao.assignMicroschemaVersion(this.project().getLatestBranch(), this.user(), versionB, this.createBatch());
        CommonTx.get().commit();
        CommonTx.get().data().maybeGetEventQueueBatch().ifPresent(EventQueueBatch::dispatch);
        MicronodeMigrationContextImpl context = new MicronodeMigrationContextImpl();
        context.setBranch(this.project().getLatestBranch());
        context.setFromVersion(versionA);
        context.setToVersion(versionB);
        context.setStatus((MigrationStatusHandler)DummyMigrationStatus.get());
        this.micronodeMigrationHandler.migrateMicronodes((MicronodeMigrationContext)context).blockingAwait(10L, TimeUnit.SECONDS);
        ((NodeGraphFieldContainerAssert)MeshAssertions.assertThat((HibNodeFieldContainer)oldContainer).as("Old container", new Object[0])).hasVersion(oldVersion.toString());
        ((MicronodeAssert)MeshAssertions.assertThat((HibMicronode)micronodeField.getMicronode()).as("Old Micronode", new Object[0])).isOf(versionA);
        HibNodeFieldContainer newContainer = tx.contentDao().getFieldContainer(node, "en");
        ((NodeGraphFieldContainerAssert)MeshAssertions.assertThat((HibNodeFieldContainer)newContainer).as("New container", new Object[0])).hasVersion(oldVersion.nextDraft().toString());
        HibMicronodeField newMicronodeField = newContainer.getMicronode(micronodeFieldName);
        asserter.assertThat((HibFieldContainer)newMicronodeField.getMicronode(), fieldName);
    }

    protected void invalidMigrationScript(FieldSchemaCreator creator, DataProvider dataProvider, String script) throws Throwable {
        try (Tx tx = this.tx();){
            try {
                if (this.getClass().isAnnotationPresent(MicroschemaTest.class)) {
                    this.invalidMicroschemaMigrationScript(tx, creator, dataProvider, script);
                } else {
                    this.invalidSchemaMigrationScript(tx, creator, dataProvider, script);
                }
            }
            catch (CompositeException e) {
                Throwable firstError = (Throwable)e.getExceptions().get(0);
                if (firstError instanceof ScriptException) {
                    throw firstError;
                }
                Throwable nestedError = firstError.getCause();
                nestedError.printStackTrace();
                throw nestedError;
            }
        }
    }

    private void invalidSchemaMigrationScript(Tx tx, FieldSchemaCreator creator, DataProvider dataProvider, String script) throws InterruptedException, ExecutionException, TimeoutException {
        NodeDao nodeDao = tx.nodeDao();
        PersistingBranchDao branchDao = (PersistingBranchDao)tx.branchDao();
        PersistingSchemaDao schemaDao = (PersistingSchemaDao)tx.schemaDao();
        String fieldName = "migratedField";
        String schemaName = "migratedSchema";
        FieldSchema oldField = creator.create(fieldName);
        HibSchema container = (HibSchema)schemaDao.createPersisted(null);
        container.setName(UUIDUtil.randomUUID());
        container.setCreated(this.user());
        schemaDao.mergeIntoPersisted((HibBaseElement)container);
        HibSchemaVersion versionA = this.createSchemaVersion(Tx.get(), container, v -> {
            CoreTestUtils.fillSchemaVersion(v, container, schemaName, "1.0", oldField);
            container.setLatestVersion((HibFieldSchemaVersionElement)v);
        });
        FieldSchema newField = creator.create(fieldName);
        HibSchemaVersion versionB = CoreTestUtils.createSchemaVersion(container, schemaName, "2.0", newField);
        HibUpdateFieldChange updateFieldChange = (HibUpdateFieldChange)schemaDao.createPersistedChange((HibFieldSchemaVersionElement)versionA, SchemaChangeOperation.UPDATEFIELD);
        updateFieldChange.setFieldName(fieldName);
        updateFieldChange.setPreviousContainerVersion((HibFieldSchemaVersionElement)versionA);
        updateFieldChange.setNextSchemaContainerVersion((HibFieldSchemaVersionElement)versionB);
        versionA.setNextVersion((HibFieldSchemaVersionElement)versionB);
        HibUser user = this.user();
        EventQueueBatch batch = this.createBatch();
        branchDao.assignSchemaVersion(this.project().getLatestBranch(), user, versionA, batch);
        String english = this.english();
        HibNode parentNode = this.folder("2015");
        HibNode node = nodeDao.create(parentNode, user, versionA, this.project());
        HibNodeFieldContainer englishContainer = tx.contentDao().createFieldContainer(node, english, node.getProject().getLatestBranch(), user);
        dataProvider.set((HibFieldContainer)englishContainer, fieldName);
        branchDao.assignSchemaVersion(this.project().getLatestBranch(), user, versionB, batch);
        CommonTx.get().commit();
        CommonTx.get().data().maybeGetEventQueueBatch().ifPresent(EventQueueBatch::dispatch);
        NodeMigrationActionContextImpl context = new NodeMigrationActionContextImpl();
        context.setProject(this.project());
        context.setBranch(this.project().getLatestBranch());
        context.setFromVersion(versionA);
        context.setToVersion(versionB);
        context.setStatus((MigrationStatusHandler)DummyMigrationStatus.get());
        this.nodeMigrationHandler.migrateNodes((NodeMigrationActionContext)context).blockingAwait();
    }

    private void invalidMicroschemaMigrationScript(Tx tx, FieldSchemaCreator creator, DataProvider dataProvider, String script) throws InterruptedException, ExecutionException, TimeoutException {
        String fieldName = "migratedField";
        String microschemaName = UUIDUtil.randomUUID();
        String micronodeFieldName = "micronodefield";
        PersistingBranchDao branchDao = (PersistingBranchDao)tx.branchDao();
        PersistingMicroschemaDao microschemaDao = (PersistingMicroschemaDao)tx.microschemaDao();
        FieldSchema oldField = creator.create(fieldName);
        HibMicroschema container = (HibMicroschema)microschemaDao.createPersisted(null);
        container.setName(microschemaName);
        container.setCreated(this.user());
        HibMicroschemaVersion versionA = this.createMicroschemaVersion(container, microschemaName, "1.0", oldField);
        FieldSchema newField = creator.create(fieldName);
        HibMicroschemaVersion versionB = this.createMicroschemaVersion(container, microschemaName, "2.0", newField);
        HibUpdateFieldChange updateFieldChange = (HibUpdateFieldChange)microschemaDao.createPersistedChange((HibFieldSchemaVersionElement)versionA, SchemaChangeOperation.UPDATEFIELD);
        updateFieldChange.setFieldName(fieldName);
        updateFieldChange.setPreviousContainerVersion((HibFieldSchemaVersionElement)versionA);
        updateFieldChange.setNextSchemaContainerVersion((HibFieldSchemaVersionElement)versionB);
        versionA.setNextVersion(versionB);
        this.createMicronodefield(tx, this.folder("2015"), micronodeFieldName, versionA, dataProvider, fieldName);
        branchDao.assignMicroschemaVersion(this.project().getLatestBranch(), this.user(), versionB, this.createBatch());
        CommonTx.get().commit();
        CommonTx.get().data().maybeGetEventQueueBatch().ifPresent(EventQueueBatch::dispatch);
        MicronodeMigrationContextImpl context = new MicronodeMigrationContextImpl();
        context.setBranch(this.project().getLatestBranch());
        context.setFromVersion(versionA);
        context.setToVersion(versionB);
        context.setStatus((MigrationStatusHandler)DummyMigrationStatus.get());
        this.micronodeMigrationHandler.migrateMicronodes((MicronodeMigrationContext)context).blockingAwait(10L, TimeUnit.SECONDS);
    }

    protected HibMicroschemaVersion createMicroschemaVersion(HibMicroschema container, String name, String version, FieldSchema ... fields) {
        MicroschemaModelImpl schema = new MicroschemaModelImpl();
        schema.setName(name);
        schema.setVersion(version);
        for (FieldSchema field : fields) {
            schema.addField(field);
        }
        HibMicroschemaVersion mversion = (HibMicroschemaVersion)CommonTx.get().microschemaDao().createPersistedVersion((HibFieldSchemaElement)container, arg_0 -> AbstractFieldMigrationTest.lambda$createMicroschemaVersion$18((MicroschemaVersionModel)schema, name, container, arg_0));
        Tx.get().commit();
        return mversion;
    }

    protected HibMicronodeField createMicronodefield(Tx tx, HibNode node, String micronodeFieldName, HibMicroschemaVersion schemaVersion, DataProvider dataProvider, String ... fieldNames) {
        String english = this.english();
        HibSchemaVersion latestVersion = (HibSchemaVersion)node.getSchemaContainer().getLatestVersion();
        SchemaVersionModel schema = latestVersion.getSchema();
        if (schema.getField(micronodeFieldName) == null) {
            schema.addField((FieldSchema)new MicronodeFieldSchemaImpl().setName(micronodeFieldName).setLabel("Micronode Field"));
        }
        ((MicronodeFieldSchema)schema.getField(micronodeFieldName, MicronodeFieldSchema.class)).setAllowedMicroSchemas(new String[]{schemaVersion.getName()});
        latestVersion.setSchema(schema);
        HibNodeFieldContainer englishContainer = tx.contentDao().createFieldContainer(node, english, node.getProject().getLatestBranch(), this.user());
        this.actions().updateSchemaVersion((HibFieldSchemaVersionElement)englishContainer.getSchemaContainerVersion());
        HibMicronodeField micronodeField = englishContainer.createMicronode(micronodeFieldName, schemaVersion);
        for (String fieldName : fieldNames) {
            dataProvider.set((HibFieldContainer)micronodeField.getMicronode(), fieldName);
        }
        return micronodeField;
    }

    private static /* synthetic */ void lambda$createMicroschemaVersion$18(MicroschemaVersionModel schema, String name, HibMicroschema container, HibMicroschemaVersion containerVersion) {
        containerVersion.setSchema(schema);
        containerVersion.setName(name);
        containerVersion.setSchemaContainer(container);
        container.setLatestVersion(containerVersion);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    protected static @interface MicroschemaTest {
    }
}

