/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.schema.field;

import com.gentics.mesh.core.data.binary.Binaries;
import com.gentics.mesh.core.data.binary.HibBinary;
import com.gentics.mesh.core.data.dao.BinaryDao;
import com.gentics.mesh.core.data.node.field.HibBinaryField;
import com.gentics.mesh.core.data.storage.BinaryStorage;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.field.DataProvider;
import com.gentics.mesh.core.field.FieldSchemaCreator;
import com.gentics.mesh.core.field.FieldTestHelper;
import com.gentics.mesh.core.field.binary.BinaryFieldTestHelper;
import com.gentics.mesh.core.rest.node.field.BinaryCheckStatus;
import com.gentics.mesh.core.schema.field.AbstractFieldMigrationTest;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.util.FileUtils;
import com.gentics.mesh.util.RxUtil;
import com.gentics.mesh.util.UUIDUtil;
import io.reactivex.Flowable;
import io.vertx.core.buffer.Buffer;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=false)
public class BinaryFieldMigrationTest
extends AbstractFieldMigrationTest
implements BinaryFieldTestHelper {
    String hash;
    final DataProvider FILL = (container, name) -> {
        Buffer buffer = Buffer.buffer((String)"This is the file contents");
        this.hash = (String)FileUtils.hash((Buffer)buffer).blockingGet();
        Binaries binaries = Tx.get().binaries();
        HibBinary binary = (HibBinary)binaries.findByHash(this.hash).runInExistingTx(Tx.get());
        boolean store = false;
        if (binary == null) {
            binary = (HibBinary)binaries.create(this.hash, 1L).runInExistingTx(Tx.get());
            store = true;
        }
        binary.setCheckStatus(BinaryCheckStatus.ACCEPTED);
        HibBinaryField field = container.createBinary(name, binary);
        field.setFileName("test.txt");
        field.setMimeType("text/plain");
        if (store) {
            BinaryStorage storage = this.meshDagger().binaryStorage();
            String tmpId = UUIDUtil.randomUUID();
            storage.storeInTemp(Flowable.just((Object)buffer), tmpId).blockingAwait();
            storage.moveInPlace(binary.getUuid(), tmpId).blockingAwait();
        }
    };
    final DataProvider FILL_WITH_STATUS_POSTPONED = (container, name) -> {
        this.FILL.set(container, name);
        HibBinary binary = (HibBinary)Tx.get().binaries().findByHash(this.hash).runInExistingTx(Tx.get());
        binary.setCheckStatus(BinaryCheckStatus.POSTPONED);
    };

    @Test
    public void testSetCheckUrl() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBINARY, this.FILL, FETCH, FieldSchemaCreator.CREATEBINARY_WITH_CHECK_URL, (container, name) -> ((AbstractComparableAssert)Assertions.assertThat((Comparable)container.getBinary(name).getBinary().getCheckStatus()).as("New binary check status", new Object[0])).isEqualTo((Object)BinaryCheckStatus.POSTPONED));
    }

    @Test
    public void testUnsetCheckUrl() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBINARY_WITH_CHECK_URL, this.FILL_WITH_STATUS_POSTPONED, FETCH, FieldSchemaCreator.CREATEBINARY, (container, name) -> ((AbstractComparableAssert)Assertions.assertThat((Comparable)container.getBinary(name).getBinary().getCheckStatus()).as("New binary check status", new Object[0])).isEqualTo((Object)BinaryCheckStatus.ACCEPTED));
    }

    @Override
    @Test
    public void testRemove() throws Exception {
        this.removeField(FieldSchemaCreator.CREATEBINARY, this.FILL, FETCH);
    }

    @Override
    @Test
    public void testChangeToBinary() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBINARY, this.FILL, FETCH, FieldSchemaCreator.CREATEBINARY, (container, name) -> {
            BinaryDao binaryDao = Tx.get().binaryDao();
            ((AbstractObjectAssert)Assertions.assertThat((Object)container.getBinary(name)).as("New field", new Object[0])).isNotNull();
            ((AbstractCharSequenceAssert)Assertions.assertThat((String)container.getBinary(name).getFileName()).as("New field value", new Object[0])).isEqualTo((Object)"test.txt");
            ((AbstractCharSequenceAssert)Assertions.assertThat((String)container.getBinary(name).getMimeType()).as("New field value", new Object[0])).isEqualTo((Object)"text/plain");
            ((AbstractCharSequenceAssert)Assertions.assertThat((String)container.getBinary(name).getBinary().getSHA512Sum()).as("New field value", new Object[0])).isEqualTo((Object)this.hash);
            Buffer contents = (Buffer)RxUtil.readEntireData((Flowable)binaryDao.getStream(container.getBinary(name).getBinary())).blockingGet();
            ((AbstractCharSequenceAssert)Assertions.assertThat((String)contents.toString()).as("New field value", new Object[0])).isEqualTo((Object)"This is the file contents");
        });
    }

    @Override
    @Test
    public void testEmptyChangeToBinary() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBINARY, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATEBINARY, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getBinary(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToBoolean() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBINARY, this.FILL, FETCH, FieldSchemaCreator.CREATEBOOLEAN, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getBoolean(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testEmptyChangeToBoolean() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBINARY, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATEBOOLEAN, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getBoolean(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToBooleanList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBINARY, this.FILL, FETCH, FieldSchemaCreator.CREATEBOOLEANLIST, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getBooleanList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testEmptyChangeToBooleanList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBINARY, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATEBOOLEANLIST, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getBooleanList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToDate() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBINARY, this.FILL, FETCH, FieldSchemaCreator.CREATEDATE, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getDate(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testEmptyChangeToDate() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBINARY, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATEDATE, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getDate(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToDateList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBINARY, this.FILL, FETCH, FieldSchemaCreator.CREATEDATELIST, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getDateList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testEmptyChangeToDateList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBINARY, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATEDATELIST, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getDateList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToHtml() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBINARY, this.FILL, FETCH, FieldSchemaCreator.CREATEHTML, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getHtml(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testEmptyChangeToHtml() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBINARY, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATEHTML, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getHtml(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToHtmlList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBINARY, this.FILL, FETCH, FieldSchemaCreator.CREATEHTMLLIST, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getHTMLList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    public void testEmptyChangeToHtmlList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBINARY, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATEHTMLLIST, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getHTMLList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToMicronode() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBINARY, this.FILL, FETCH, FieldSchemaCreator.CREATEMICRONODE, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getMicronode(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testEmptyChangeToMicronode() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBINARY, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATEMICRONODE, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getMicronode(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToMicronodeList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBINARY, this.FILL, FETCH, FieldSchemaCreator.CREATEMICRONODELIST, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getMicronodeList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testEmptyChangeToMicronodeList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBINARY, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATEMICRONODELIST, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getMicronodeList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToNode() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBINARY, this.FILL, FETCH, FieldSchemaCreator.CREATENODE, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getNode(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testEmptyChangeToNode() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBINARY, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATENODE, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getNode(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToNodeList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBINARY, this.FILL, FETCH, FieldSchemaCreator.CREATENODELIST, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getNodeList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testEmptyChangeToNodeList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBINARY, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATENODELIST, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getNodeList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToNumber() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBINARY, this.FILL, FETCH, FieldSchemaCreator.CREATENUMBER, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getNumber(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testEmptyChangeToNumber() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBINARY, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATENUMBER, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getNumber(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToNumberList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBINARY, this.FILL, FETCH, FieldSchemaCreator.CREATENUMBERLIST, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getNumberList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testEmptyChangeToNumberList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBINARY, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATENUMBERLIST, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getNumberList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToString() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBINARY, this.FILL, FETCH, FieldSchemaCreator.CREATESTRING, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getString(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testEmptyChangeToString() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBINARY, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATESTRING, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getString(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToStringList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBINARY, this.FILL, FETCH, FieldSchemaCreator.CREATESTRINGLIST, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getStringList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testEmptyChangeToStringList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBINARY, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATESTRINGLIST, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getStringList(name)).as("New field", new Object[0])).isNull());
    }
}

