/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.schema.field;

import com.gentics.mesh.core.field.FieldSchemaCreator;
import com.gentics.mesh.core.field.FieldTestHelper;
import com.gentics.mesh.core.field.bool.BooleanFieldTestHelper;
import com.gentics.mesh.core.schema.field.AbstractFieldMigrationTest;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import java.math.BigDecimal;
import java.util.List;
import org.assertj.core.api.AbstractBigDecimalAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=false)
public class BooleanFieldMigrationTest
extends AbstractFieldMigrationTest
implements BooleanFieldTestHelper {
    @Override
    @Test
    public void testRemove() throws Exception {
        this.removeField(FieldSchemaCreator.CREATEBOOLEAN, FILLTRUE, FETCH);
    }

    @Override
    @Test
    public void testChangeToBinary() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEAN, FILLTRUE, FETCH, FieldSchemaCreator.CREATEBINARY, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getBinary(name)).as("New field", new Object[0])).isNull());
        this.changeType(FieldSchemaCreator.CREATEBOOLEAN, FILLFALSE, FETCH, FieldSchemaCreator.CREATEBINARY, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getBinary(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testEmptyChangeToBinary() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEAN, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATEBINARY, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getBinary(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToBoolean() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEAN, FILLTRUE, FETCH, FieldSchemaCreator.CREATEBOOLEAN, (container, name) -> {
            ((AbstractObjectAssert)Assertions.assertThat((Object)container.getBoolean(name)).as("New field", new Object[0])).isNotNull();
            ((AbstractBooleanAssert)Assertions.assertThat((Boolean)container.getBoolean(name).getBoolean()).as("New field value", new Object[0])).isEqualTo(true);
        });
        this.changeType(FieldSchemaCreator.CREATEBOOLEAN, FILLFALSE, FETCH, FieldSchemaCreator.CREATEBOOLEAN, (container, name) -> {
            ((AbstractObjectAssert)Assertions.assertThat((Object)container.getBoolean(name)).as("New field", new Object[0])).isNotNull();
            ((AbstractBooleanAssert)Assertions.assertThat((Boolean)container.getBoolean(name).getBoolean()).as("New field value", new Object[0])).isEqualTo(false);
        });
    }

    @Override
    @Test
    public void testEmptyChangeToBoolean() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEAN, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATEBOOLEAN, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getBoolean(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToBooleanList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEAN, FILLTRUE, FETCH, FieldSchemaCreator.CREATEBOOLEANLIST, (container, name) -> {
            ((AbstractObjectAssert)Assertions.assertThat((Object)container.getBooleanList(name)).as("New field", new Object[0])).isNotNull();
            Assertions.assertThat((List)container.getBooleanList(name).getValues()).as("New field", new Object[0]).containsExactly((Object[])new Boolean[]{true});
        });
        this.changeType(FieldSchemaCreator.CREATEBOOLEAN, FILLFALSE, FETCH, FieldSchemaCreator.CREATEBOOLEANLIST, (container, name) -> {
            ((AbstractObjectAssert)Assertions.assertThat((Object)container.getBooleanList(name)).as("New field", new Object[0])).isNotNull();
            Assertions.assertThat((List)container.getBooleanList(name).getValues()).as("New field", new Object[0]).containsExactly((Object[])new Boolean[]{false});
        });
    }

    @Override
    @Test
    public void testEmptyChangeToBooleanList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEAN, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATEBOOLEANLIST, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getBooleanList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToDate() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEAN, FILLTRUE, FETCH, FieldSchemaCreator.CREATEDATE, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getDate(name)).as("New field", new Object[0])).isNull());
        this.changeType(FieldSchemaCreator.CREATEBOOLEAN, FILLFALSE, FETCH, FieldSchemaCreator.CREATEDATE, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getDate(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testEmptyChangeToDate() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEAN, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATEDATE, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getDate(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToDateList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEAN, FILLTRUE, FETCH, FieldSchemaCreator.CREATEDATELIST, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getDateList(name)).as("New field", new Object[0])).isNull());
        this.changeType(FieldSchemaCreator.CREATEBOOLEAN, FILLFALSE, FETCH, FieldSchemaCreator.CREATEDATELIST, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getDateList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testEmptyChangeToDateList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEAN, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATEDATELIST, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getDateList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToHtml() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEAN, FILLTRUE, FETCH, FieldSchemaCreator.CREATEHTML, (container, name) -> {
            ((AbstractObjectAssert)Assertions.assertThat((Object)container.getHtml(name)).as("New field", new Object[0])).isNotNull();
            ((AbstractCharSequenceAssert)Assertions.assertThat((String)container.getHtml(name).getHTML()).as("New field value", new Object[0])).isEqualTo((Object)"true");
        });
        this.changeType(FieldSchemaCreator.CREATEBOOLEAN, FILLFALSE, FETCH, FieldSchemaCreator.CREATEHTML, (container, name) -> {
            ((AbstractObjectAssert)Assertions.assertThat((Object)container.getHtml(name)).as("New field", new Object[0])).isNotNull();
            ((AbstractCharSequenceAssert)Assertions.assertThat((String)container.getHtml(name).getHTML()).as("New field value", new Object[0])).isEqualTo((Object)"false");
        });
    }

    @Override
    @Test
    public void testEmptyChangeToHtml() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEAN, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATEHTML, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getHtml(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToHtmlList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEAN, FILLTRUE, FETCH, FieldSchemaCreator.CREATEHTMLLIST, (container, name) -> {
            ((AbstractObjectAssert)Assertions.assertThat((Object)container.getHTMLList(name)).as("New field", new Object[0])).isNotNull();
            Assertions.assertThat((List)container.getHTMLList(name).getValues()).as("New field value", new Object[0]).containsExactly((Object[])new String[]{"true"});
        });
        this.changeType(FieldSchemaCreator.CREATEBOOLEAN, FILLFALSE, FETCH, FieldSchemaCreator.CREATEHTMLLIST, (container, name) -> {
            ((AbstractObjectAssert)Assertions.assertThat((Object)container.getHTMLList(name)).as("New field", new Object[0])).isNotNull();
            Assertions.assertThat((List)container.getHTMLList(name).getValues()).as("New field value", new Object[0]).containsExactly((Object[])new String[]{"false"});
        });
    }

    @Override
    @Test
    public void testEmptyChangeToHtmlList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEAN, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATEHTMLLIST, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getHTMLList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToMicronode() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEAN, FILLTRUE, FETCH, FieldSchemaCreator.CREATEMICRONODE, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getMicronode(name)).as("New field", new Object[0])).isNull());
        this.changeType(FieldSchemaCreator.CREATEBOOLEAN, FILLFALSE, FETCH, FieldSchemaCreator.CREATEMICRONODE, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getMicronode(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testEmptyChangeToMicronode() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEAN, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATEMICRONODE, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getMicronode(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToMicronodeList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEAN, FILLTRUE, FETCH, FieldSchemaCreator.CREATEMICRONODELIST, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getMicronodeList(name)).as("New field", new Object[0])).isNull());
        this.changeType(FieldSchemaCreator.CREATEBOOLEAN, FILLFALSE, FETCH, FieldSchemaCreator.CREATEMICRONODELIST, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getMicronodeList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testEmptyChangeToMicronodeList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEAN, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATEMICRONODELIST, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getMicronodeList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToNode() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEAN, FILLTRUE, FETCH, FieldSchemaCreator.CREATENODE, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getNode(name)).as("New field", new Object[0])).isNull());
        this.changeType(FieldSchemaCreator.CREATEBOOLEAN, FILLFALSE, FETCH, FieldSchemaCreator.CREATENODE, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getNode(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testEmptyChangeToNode() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEAN, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATENODE, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getNode(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToNodeList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEAN, FILLTRUE, FETCH, FieldSchemaCreator.CREATENODELIST, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getNodeList(name)).as("New field", new Object[0])).isNull());
        this.changeType(FieldSchemaCreator.CREATEBOOLEAN, FILLFALSE, FETCH, FieldSchemaCreator.CREATENODELIST, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getNodeList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testEmptyChangeToNodeList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEAN, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATENODELIST, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getNodeList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToNumber() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEAN, FILLTRUE, FETCH, FieldSchemaCreator.CREATENUMBER, (container, name) -> {
            ((AbstractObjectAssert)Assertions.assertThat((Object)container.getNumber(name)).as("New field", new Object[0])).isNotNull();
            ((AbstractIntegerAssert)Assertions.assertThat((int)container.getNumber(name).getNumber().intValue()).as("New field value", new Object[0])).isEqualTo(1);
        });
        this.changeType(FieldSchemaCreator.CREATEBOOLEAN, FILLFALSE, FETCH, FieldSchemaCreator.CREATENUMBER, (container, name) -> {
            ((AbstractObjectAssert)Assertions.assertThat((Object)container.getNumber(name)).as("New field", new Object[0])).isNotNull();
            ((AbstractIntegerAssert)Assertions.assertThat((int)container.getNumber(name).getNumber().intValue()).as("New field value", new Object[0])).isEqualTo(0);
        });
    }

    @Override
    @Test
    public void testEmptyChangeToNumber() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEAN, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATENUMBER, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getNumber(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToNumberList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEAN, FILLTRUE, FETCH, FieldSchemaCreator.CREATENUMBERLIST, (container, name) -> {
            ((AbstractObjectAssert)Assertions.assertThat((Object)container.getNumberList(name)).as("New field", new Object[0])).isNotNull();
            Assertions.assertThat((List)container.getNumberList(name).getValues()).hasSize(1);
            ((AbstractBigDecimalAssert)Assertions.assertThat((BigDecimal)new BigDecimal(((Number)container.getNumberList(name).getValues().get(0)).intValue())).as("New field value", new Object[0])).isEqualTo((Object)BigDecimal.ONE);
        });
        this.changeType(FieldSchemaCreator.CREATEBOOLEAN, FILLFALSE, FETCH, FieldSchemaCreator.CREATENUMBERLIST, (container, name) -> {
            ((AbstractObjectAssert)Assertions.assertThat((Object)container.getNumberList(name)).as("New field", new Object[0])).isNotNull();
            Assertions.assertThat((List)container.getNumberList(name).getValues()).hasSize(1);
            ((AbstractBigDecimalAssert)Assertions.assertThat((BigDecimal)new BigDecimal(((Number)container.getNumberList(name).getValues().get(0)).intValue())).as("New field value", new Object[0])).isEqualTo((Object)BigDecimal.ZERO);
        });
    }

    @Override
    @Test
    public void testEmptyChangeToNumberList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEAN, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATENUMBERLIST, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getNumberList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToString() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEAN, FILLTRUE, FETCH, FieldSchemaCreator.CREATESTRING, (container, name) -> {
            ((AbstractObjectAssert)Assertions.assertThat((Object)container.getString(name)).as("New field", new Object[0])).isNotNull();
            ((AbstractCharSequenceAssert)Assertions.assertThat((String)container.getString(name).getString()).as("New field value", new Object[0])).isEqualTo((Object)"true");
        });
        this.changeType(FieldSchemaCreator.CREATEBOOLEAN, FILLFALSE, FETCH, FieldSchemaCreator.CREATESTRING, (container, name) -> {
            ((AbstractObjectAssert)Assertions.assertThat((Object)container.getString(name)).as("New field", new Object[0])).isNotNull();
            ((AbstractCharSequenceAssert)Assertions.assertThat((String)container.getString(name).getString()).as("New field value", new Object[0])).isEqualTo((Object)"false");
        });
    }

    @Override
    @Test
    public void testEmptyChangeToString() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEAN, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATESTRING, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getString(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToStringList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEAN, FILLTRUE, FETCH, FieldSchemaCreator.CREATESTRINGLIST, (container, name) -> {
            ((AbstractObjectAssert)Assertions.assertThat((Object)container.getStringList(name)).as("New field", new Object[0])).isNotNull();
            Assertions.assertThat((List)container.getStringList(name).getValues()).as("New field value", new Object[0]).containsExactly((Object[])new String[]{"true"});
        });
        this.changeType(FieldSchemaCreator.CREATEBOOLEAN, FILLFALSE, FETCH, FieldSchemaCreator.CREATESTRINGLIST, (container, name) -> {
            ((AbstractObjectAssert)Assertions.assertThat((Object)container.getStringList(name)).as("New field", new Object[0])).isNotNull();
            Assertions.assertThat((List)container.getStringList(name).getValues()).as("New field value", new Object[0]).containsExactly((Object[])new String[]{"false"});
        });
    }

    @Override
    @Test
    public void testEmptyChangeToStringList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEAN, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATESTRINGLIST, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getStringList(name)).as("New field", new Object[0])).isNull());
    }
}

