/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.schema.field;

import com.gentics.mesh.core.field.FieldSchemaCreator;
import com.gentics.mesh.core.field.FieldTestHelper;
import com.gentics.mesh.core.field.bool.BooleanListFieldHelper;
import com.gentics.mesh.core.schema.field.AbstractFieldMigrationTest;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=false)
public class BooleanListFieldMigrationTest
extends AbstractFieldMigrationTest
implements BooleanListFieldHelper {
    @Override
    @Test
    public void testRemove() throws Exception {
        this.removeField(FieldSchemaCreator.CREATEBOOLEANLIST, FILL, FETCH);
    }

    @Override
    @Test
    public void testChangeToBinary() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEANLIST, FILL, FETCH, FieldSchemaCreator.CREATEBINARY, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getBinary(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testEmptyChangeToBinary() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEANLIST, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATEBINARY, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getBinary(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToBoolean() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEANLIST, FILL, FETCH, FieldSchemaCreator.CREATEBOOLEAN, (container, name) -> {
            ((AbstractObjectAssert)Assertions.assertThat((Object)container.getBoolean(name)).as("New field", new Object[0])).isNotNull();
            ((AbstractBooleanAssert)Assertions.assertThat((Boolean)container.getBoolean(name).getBoolean()).as("New field value", new Object[0])).isEqualTo(true);
        });
    }

    @Override
    @Test
    public void testEmptyChangeToBoolean() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEANLIST, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATEBOOLEAN, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getBoolean(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToBooleanList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEANLIST, FILL, FETCH, FieldSchemaCreator.CREATEBOOLEANLIST, (container, name) -> {
            ((AbstractObjectAssert)Assertions.assertThat((Object)container.getBooleanList(name)).as("New field", new Object[0])).isNotNull();
            Assertions.assertThat((List)container.getBooleanList(name).getValues()).as("New field value", new Object[0]).containsExactly((Object[])new Boolean[]{true, false});
        });
    }

    @Override
    @Test
    public void testEmptyChangeToBooleanList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEANLIST, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATEBOOLEANLIST, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getBooleanList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToDate() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEANLIST, FILL, FETCH, FieldSchemaCreator.CREATEDATE, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getDate(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testEmptyChangeToDate() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEANLIST, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATEDATE, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getDate(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToDateList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEANLIST, FILL, FETCH, FieldSchemaCreator.CREATEDATELIST, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getDateList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testEmptyChangeToDateList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEANLIST, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATEDATELIST, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getDateList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToHtml() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEANLIST, FILL, FETCH, FieldSchemaCreator.CREATEHTML, (container, name) -> {
            ((AbstractObjectAssert)Assertions.assertThat((Object)container.getHtml(name)).as("New field", new Object[0])).isNotNull();
            ((AbstractCharSequenceAssert)Assertions.assertThat((String)container.getHtml(name).getHTML()).as("New field value", new Object[0])).isEqualTo((Object)"true,false");
        });
    }

    @Override
    @Test
    public void testEmptyChangeToHtml() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEANLIST, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATEHTML, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getHtml(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToHtmlList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEANLIST, FILL, FETCH, FieldSchemaCreator.CREATEHTMLLIST, (container, name) -> {
            ((AbstractObjectAssert)Assertions.assertThat((Object)container.getHTMLList(name)).as("New field", new Object[0])).isNotNull();
            Assertions.assertThat((List)container.getHTMLList(name).getValues()).as("New field value", new Object[0]).containsExactly((Object[])new String[]{"true", "false"});
        });
    }

    @Override
    @Test
    public void testEmptyChangeToHtmlList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEANLIST, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATEHTMLLIST, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getHTMLList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToMicronode() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEANLIST, FILL, FETCH, FieldSchemaCreator.CREATEMICRONODE, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getMicronode(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testEmptyChangeToMicronode() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEANLIST, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATEMICRONODE, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getMicronode(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToMicronodeList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEANLIST, FILL, FETCH, FieldSchemaCreator.CREATEMICRONODELIST, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getMicronodeList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testEmptyChangeToMicronodeList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEANLIST, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATEMICRONODELIST, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getMicronodeList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToNode() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEANLIST, FILL, FETCH, FieldSchemaCreator.CREATENODE, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getNode(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testEmptyChangeToNode() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEANLIST, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATENODE, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getNode(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToNodeList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEANLIST, FILL, FETCH, FieldSchemaCreator.CREATENODELIST, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getNodeList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testEmptyChangeToNodeList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEANLIST, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATENODELIST, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getNodeList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToNumber() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEANLIST, FILL, FETCH, FieldSchemaCreator.CREATENUMBER, (container, name) -> {
            ((AbstractObjectAssert)Assertions.assertThat((Object)container.getNumber(name)).as("New field", new Object[0])).isNotNull();
            ((AbstractIntegerAssert)Assertions.assertThat((int)container.getNumber(name).getNumber().intValue()).as("New field value", new Object[0])).isEqualTo(1);
        });
    }

    @Override
    @Test
    public void testEmptyChangeToNumber() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEANLIST, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATENUMBER, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getNumber(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToNumberList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEANLIST, FILL, FETCH, FieldSchemaCreator.CREATENUMBERLIST, (container, name) -> {
            ((AbstractObjectAssert)Assertions.assertThat((Object)container.getNumberList(name)).as("New field", new Object[0])).isNotNull();
            Assertions.assertThat(container.getNumberList(name).getValues().stream().map(Number::longValue).collect(Collectors.toList())).as("New field value", new Object[0]).containsExactly((Object[])new Long[]{1L, 0L});
        });
    }

    @Override
    @Test
    public void testEmptyChangeToNumberList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEANLIST, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATENUMBERLIST, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getNumberList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToString() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEANLIST, FILL, FETCH, FieldSchemaCreator.CREATESTRING, (container, name) -> {
            ((AbstractObjectAssert)Assertions.assertThat((Object)container.getString(name)).as("New field", new Object[0])).isNotNull();
            ((AbstractCharSequenceAssert)Assertions.assertThat((String)container.getString(name).getString()).as("New field value", new Object[0])).isEqualTo((Object)"true,false");
        });
    }

    @Override
    @Test
    public void testEmptyChangeToString() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEANLIST, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATESTRING, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getString(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToStringList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEANLIST, FILL, FETCH, FieldSchemaCreator.CREATESTRINGLIST, (container, name) -> {
            ((AbstractObjectAssert)Assertions.assertThat((Object)container.getStringList(name)).as("New field", new Object[0])).isNotNull();
            Assertions.assertThat((List)container.getStringList(name).getValues()).as("New field value", new Object[0]).containsExactly((Object[])new String[]{"true", "false"});
        });
    }

    @Override
    @Test
    public void testEmptyChangeToStringList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEBOOLEANLIST, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATESTRINGLIST, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getStringList(name)).as("New field", new Object[0])).isNull());
    }
}

