/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.schema.field;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.data.node.field.HibHtmlField;
import com.gentics.mesh.core.field.FieldSchemaCreator;
import com.gentics.mesh.core.field.FieldTestHelper;
import com.gentics.mesh.core.field.html.HtmlFieldTestHelper;
import com.gentics.mesh.core.schema.field.AbstractFieldMigrationTest;
import com.gentics.mesh.search.TrackingSearchProvider;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.util.IndexOptionHelper;
import java.math.BigDecimal;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.AbstractBigDecimalAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.TRACKING, testSize=TestSize.FULL, startServer=false)
public class HtmlFieldMigrationTest
extends AbstractFieldMigrationTest
implements HtmlFieldTestHelper {
    @Override
    @Test
    public void testRemove() throws Exception {
        this.removeField(FieldSchemaCreator.CREATEHTML, FILLTEXT, FETCH);
    }

    @Override
    @Test
    public void testChangeToBinary() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEHTML, FILLTEXT, FETCH, FieldSchemaCreator.CREATEBINARY, (container, name) -> ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getBinary(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testEmptyChangeToBinary() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEHTML, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATEBINARY, (container, name) -> ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getBinary(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToBoolean() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEHTML, FILLTRUE, FETCH, FieldSchemaCreator.CREATEBOOLEAN, (container, name) -> {
            ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getBoolean(name)).as("New field", new Object[0])).isNotNull();
            ((AbstractBooleanAssert)MeshAssertions.assertThat((Boolean)container.getBoolean(name).getBoolean()).as("New field value", new Object[0])).isEqualTo(true);
        });
        this.changeType(FieldSchemaCreator.CREATEHTML, FILLFALSE, FETCH, FieldSchemaCreator.CREATEBOOLEAN, (container, name) -> {
            ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getBoolean(name)).as("New field", new Object[0])).isNotNull();
            ((AbstractBooleanAssert)MeshAssertions.assertThat((Boolean)container.getBoolean(name).getBoolean()).as("New field value", new Object[0])).isEqualTo(false);
        });
        this.changeType(FieldSchemaCreator.CREATEHTML, FILL1, FETCH, FieldSchemaCreator.CREATEBOOLEAN, (container, name) -> {
            ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getBoolean(name)).as("New field", new Object[0])).isNotNull();
            ((AbstractBooleanAssert)MeshAssertions.assertThat((Boolean)container.getBoolean(name).getBoolean()).as("New field value", new Object[0])).isEqualTo(true);
        });
        this.changeType(FieldSchemaCreator.CREATEHTML, FILL0, FETCH, FieldSchemaCreator.CREATEBOOLEAN, (container, name) -> {
            ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getBoolean(name)).as("New field", new Object[0])).isNotNull();
            ((AbstractBooleanAssert)MeshAssertions.assertThat((Boolean)container.getBoolean(name).getBoolean()).as("New field value", new Object[0])).isEqualTo(false);
        });
        this.changeType(FieldSchemaCreator.CREATEHTML, FILLTEXT, FETCH, FieldSchemaCreator.CREATEBOOLEAN, (container, name) -> ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getBoolean(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testEmptyChangeToBoolean() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEHTML, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATEBOOLEAN, (container, name) -> ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getBoolean(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToBooleanList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEHTML, FILLTRUE, FETCH, FieldSchemaCreator.CREATEBOOLEANLIST, (container, name) -> {
            ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getBooleanList(name)).as("New field", new Object[0])).isNotNull();
            MeshAssertions.assertThat((List)container.getBooleanList(name).getValues()).as("New field value", new Object[0]).containsExactly((Object[])new Boolean[]{true});
        });
        this.changeType(FieldSchemaCreator.CREATEHTML, FILLFALSE, FETCH, FieldSchemaCreator.CREATEBOOLEANLIST, (container, name) -> {
            ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getBooleanList(name)).as("New field", new Object[0])).isNotNull();
            MeshAssertions.assertThat((List)container.getBooleanList(name).getValues()).as("New field value", new Object[0]).containsExactly((Object[])new Boolean[]{false});
        });
        this.changeType(FieldSchemaCreator.CREATEHTML, FILL1, FETCH, FieldSchemaCreator.CREATEBOOLEANLIST, (container, name) -> {
            ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getBooleanList(name)).as("New field", new Object[0])).isNotNull();
            MeshAssertions.assertThat((List)container.getBooleanList(name).getValues()).as("New field value", new Object[0]).containsExactly((Object[])new Boolean[]{true});
        });
        this.changeType(FieldSchemaCreator.CREATEHTML, FILL0, FETCH, FieldSchemaCreator.CREATEBOOLEANLIST, (container, name) -> {
            ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getBooleanList(name)).as("New field", new Object[0])).isNotNull();
            MeshAssertions.assertThat((List)container.getBooleanList(name).getValues()).as("New field value", new Object[0]).containsExactly((Object[])new Boolean[]{false});
        });
        this.changeType(FieldSchemaCreator.CREATEHTML, FILLTEXT, FETCH, FieldSchemaCreator.CREATEBOOLEANLIST, (container, name) -> ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getBooleanList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testEmptyChangeToBooleanList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEHTML, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATEBOOLEANLIST, (container, name) -> ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getBooleanList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToDate() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEHTML, FILL0, FETCH, FieldSchemaCreator.CREATEDATE, (container, name) -> {
            ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getDate(name)).as("New field", new Object[0])).isNotNull();
            ((AbstractLongAssert)MeshAssertions.assertThat((Long)container.getDate(name).getDate()).as("New field value", new Object[0])).isEqualTo(0L);
        });
        this.changeType(FieldSchemaCreator.CREATEHTML, FILL1, FETCH, FieldSchemaCreator.CREATEDATE, (container, name) -> {
            ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getDate(name)).as("New field", new Object[0])).isNotNull();
            ((AbstractLongAssert)MeshAssertions.assertThat((Long)container.getDate(name).getDate()).as("New field value", new Object[0])).isEqualTo(1000L);
        });
        this.changeType(FieldSchemaCreator.CREATEHTML, FILLTEXT, FETCH, FieldSchemaCreator.CREATEDATE, (container, name) -> ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getDate(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testEmptyChangeToDate() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEHTML, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATEDATE, (container, name) -> ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getDate(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToDateList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEHTML, FILL0, FETCH, FieldSchemaCreator.CREATEDATELIST, (container, name) -> {
            ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getDateList(name)).as("New field", new Object[0])).isNotNull();
            MeshAssertions.assertThat((List)container.getDateList(name).getValues()).as("New field value", new Object[0]).containsExactly((Object[])new Long[]{0L});
        });
        this.changeType(FieldSchemaCreator.CREATEHTML, FILL1, FETCH, FieldSchemaCreator.CREATEDATELIST, (container, name) -> {
            ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getDateList(name)).as("New field", new Object[0])).isNotNull();
            MeshAssertions.assertThat((List)container.getDateList(name).getValues()).as("New field value", new Object[0]).containsExactly((Object[])new Long[]{1000L});
        });
        this.changeType(FieldSchemaCreator.CREATEHTML, FILLTEXT, FETCH, FieldSchemaCreator.CREATEDATELIST, (container, name) -> ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getDateList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testEmptyChangeToDateList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEHTML, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATEDATELIST, (container, name) -> ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getDateList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToHtml() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEHTML, FILLTEXT, FETCH, FieldSchemaCreator.CREATEHTML, (container, name) -> {
            ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getHtml(name)).as("New field", new Object[0])).isNotNull();
            ((AbstractCharSequenceAssert)MeshAssertions.assertThat((String)container.getHtml(name).getHTML()).as("New field value", new Object[0])).isEqualTo((Object)"<b>HTML</b> content");
        });
    }

    @Override
    @Test
    public void testEmptyChangeToHtml() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEHTML, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATEHTML, (container, name) -> ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getHtml(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToHtmlList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEHTML, FILLTEXT, FETCH, FieldSchemaCreator.CREATEHTMLLIST, (container, name) -> {
            ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getHTMLList(name)).as("New field", new Object[0])).isNotNull();
            MeshAssertions.assertThat((List)container.getHTMLList(name).getValues()).as("New field value", new Object[0]).containsExactly((Object[])new String[]{"<b>HTML</b> content"});
        });
    }

    @Override
    @Test
    public void testEmptyChangeToHtmlList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEHTML, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATEHTMLLIST, (container, name) -> ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getHTMLList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToMicronode() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEHTML, FILLTEXT, FETCH, FieldSchemaCreator.CREATEMICRONODE, (container, name) -> ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getMicronode(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testEmptyChangeToMicronode() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEHTML, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATEMICRONODE, (container, name) -> ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getMicronode(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToMicronodeList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEHTML, FILLTEXT, FETCH, FieldSchemaCreator.CREATEMICRONODELIST, (container, name) -> ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getMicronodeList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testEmptyChangeToMicronodeList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEHTML, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATEMICRONODELIST, (container, name) -> ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getMicronodeList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToNode() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEHTML, FILLTEXT, FETCH, FieldSchemaCreator.CREATENODE, (container, name) -> ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getNode(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testEmptyChangeToNode() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEHTML, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATENODE, (container, name) -> ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getNode(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToNodeList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEHTML, FILLTEXT, FETCH, FieldSchemaCreator.CREATENODELIST, (container, name) -> ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getNodeList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testEmptyChangeToNodeList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEHTML, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATENODELIST, (container, name) -> ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getNodeList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToNumber() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEHTML, FILL0, FETCH, FieldSchemaCreator.CREATENUMBER, (container, name) -> {
            ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getNumber(name)).as("New field", new Object[0])).isNotNull();
            ((AbstractLongAssert)MeshAssertions.assertThat((long)container.getNumber(name).getNumber().longValue()).as("New field value", new Object[0])).isEqualTo(0L);
        });
        this.changeType(FieldSchemaCreator.CREATEHTML, FILL1, FETCH, FieldSchemaCreator.CREATENUMBER, (container, name) -> {
            ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getNumber(name)).as("New field", new Object[0])).isNotNull();
            ((AbstractLongAssert)MeshAssertions.assertThat((long)container.getNumber(name).getNumber().longValue()).as("New field value", new Object[0])).isEqualTo(1L);
        });
        this.changeType(FieldSchemaCreator.CREATEHTML, FILLTEXT, FETCH, FieldSchemaCreator.CREATENUMBER, (container, name) -> ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getNumber(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testEmptyChangeToNumber() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEHTML, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATENUMBER, (container, name) -> ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getNumber(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToNumberList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEHTML, FILL0, FETCH, FieldSchemaCreator.CREATENUMBERLIST, (container, name) -> {
            ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getNumberList(name)).as("New field", new Object[0])).isNotNull();
            MeshAssertions.assertThat((List)container.getNumberList(name).getValues()).hasSize(1);
            ((AbstractBigDecimalAssert)MeshAssertions.assertThat((BigDecimal)new BigDecimal(((Number)container.getNumberList(name).getValues().get(0)).intValue())).as("New field value", new Object[0])).isEqualTo((Object)BigDecimal.ZERO);
        });
        this.changeType(FieldSchemaCreator.CREATEHTML, FILL1, FETCH, FieldSchemaCreator.CREATENUMBERLIST, (container, name) -> {
            ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getNumberList(name)).as("New field", new Object[0])).isNotNull();
            MeshAssertions.assertThat((List)container.getNumberList(name).getValues()).hasSize(1);
            ((AbstractBigDecimalAssert)MeshAssertions.assertThat((BigDecimal)new BigDecimal(((Number)container.getNumberList(name).getValues().get(0)).intValue())).as("New field value", new Object[0])).isEqualTo((Object)BigDecimal.ONE);
        });
        this.changeType(FieldSchemaCreator.CREATEHTML, FILLTEXT, FETCH, FieldSchemaCreator.CREATENUMBERLIST, (container, name) -> ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getNumberList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testEmptyChangeToNumberList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEHTML, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATENUMBERLIST, (container, name) -> ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getNumberList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToString() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEHTML, FILLTEXT, FETCH, FieldSchemaCreator.CREATESTRING, (container, name) -> {
            ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getString(name)).as("New field", new Object[0])).isNotNull();
            ((AbstractCharSequenceAssert)MeshAssertions.assertThat((String)container.getString(name).getString()).as("New field value", new Object[0])).isEqualTo((Object)"<b>HTML</b> content");
        });
    }

    @Override
    @Test
    public void testEmptyChangeToString() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEHTML, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATESTRING, (container, name) -> ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getString(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToStringList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEHTML, FILLTEXT, FETCH, FieldSchemaCreator.CREATESTRINGLIST, (container, name) -> {
            ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getStringList(name)).as("New field", new Object[0])).isNotNull();
            MeshAssertions.assertThat((List)container.getStringList(name).getValues()).as("New field value", new Object[0]).containsExactly((Object[])new String[]{"<b>HTML</b> content"});
        });
    }

    @Override
    @Test
    public void testEmptyChangeToStringList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEHTML, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATESTRINGLIST, (container, name) -> ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getStringList(name)).as("New field", new Object[0])).isNull());
    }

    @Test
    public void testIndexOptionAddRaw() throws InterruptedException, ExecutionException, TimeoutException {
        this.changeType(FieldSchemaCreator.CREATEHTML, FILLLONGTEXT, FETCH, name -> FieldUtil.createHtmlFieldSchema((String)name).setElasticsearch(IndexOptionHelper.getRawFieldOption()), (container, name) -> {
            HibHtmlField htmlField = container.getHtml(name);
            Assert.assertEquals((String)"The html field should not be truncated.", (long)40000L, (long)htmlField.getHTML().length());
            this.waitForSearchIdleEvent();
            MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).recordedStoreEvents(1);
        });
    }
}

