/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.schema.field;

import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.assertj.impl.MicronodeAssert;
import com.gentics.mesh.core.data.node.HibMicronode;
import com.gentics.mesh.core.data.node.field.list.HibMicronodeFieldList;
import com.gentics.mesh.core.field.DataProvider;
import com.gentics.mesh.core.field.FieldFetcher;
import com.gentics.mesh.core.field.FieldSchemaCreator;
import com.gentics.mesh.core.field.FieldTestHelper;
import com.gentics.mesh.core.schema.field.AbstractFieldMigrationTest;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import java.util.List;
import org.assertj.core.api.AbstractObjectAssert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=false)
public class MicronodeListFieldMigrationTest
extends AbstractFieldMigrationTest {
    private final DataProvider FILL = (container, name) -> {
        HibMicronodeFieldList field = container.createMicronodeList(name);
        HibMicronode micronode = field.createMicronode(this.microschemaContainers().get("vcard").getLatestVersion());
        micronode.createString("firstName").setString("Donald");
        micronode.createString("lastName").setString("Duck");
        micronode = field.createMicronode(this.microschemaContainers().get("vcard").getLatestVersion());
        micronode.createString("firstName").setString("Mickey");
        micronode.createString("lastName").setString("Mouse");
    };
    private static final FieldFetcher FETCH = (container, name) -> container.getMicronodeList(name);

    @Override
    @Test
    public void testRemove() throws Exception {
        this.removeField(FieldSchemaCreator.CREATEMICRONODELIST, this.FILL, FETCH);
    }

    @Override
    @Test
    public void testChangeToBinary() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEMICRONODELIST, this.FILL, FETCH, FieldSchemaCreator.CREATEBINARY, (container, name) -> ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getBinary(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testEmptyChangeToBinary() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEMICRONODELIST, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATEBINARY, (container, name) -> ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getBinary(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToBoolean() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEMICRONODELIST, this.FILL, FETCH, FieldSchemaCreator.CREATEBOOLEAN, (container, name) -> ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getBoolean(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testEmptyChangeToBoolean() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEMICRONODELIST, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATEBOOLEAN, (container, name) -> ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getBoolean(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToBooleanList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEMICRONODELIST, this.FILL, FETCH, FieldSchemaCreator.CREATEBOOLEANLIST, (container, name) -> ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getBooleanList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testEmptyChangeToBooleanList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEMICRONODELIST, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATEBOOLEANLIST, (container, name) -> ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getBooleanList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToDate() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEMICRONODELIST, this.FILL, FETCH, FieldSchemaCreator.CREATEDATE, (container, name) -> ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getDate(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testEmptyChangeToDate() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEMICRONODELIST, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATEDATE, (container, name) -> ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getDate(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToDateList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEMICRONODELIST, this.FILL, FETCH, FieldSchemaCreator.CREATEDATELIST, (container, name) -> ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getDateList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testEmptyChangeToDateList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEMICRONODELIST, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATEDATELIST, (container, name) -> ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getDateList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToHtml() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEMICRONODELIST, this.FILL, FETCH, FieldSchemaCreator.CREATEHTML, (container, name) -> ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getHtml(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testEmptyChangeToHtml() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEMICRONODELIST, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATEHTML, (container, name) -> ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getHtml(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToHtmlList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEMICRONODELIST, this.FILL, FETCH, FieldSchemaCreator.CREATEHTMLLIST, (container, name) -> ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getHTMLList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testEmptyChangeToHtmlList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEMICRONODELIST, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATEHTMLLIST, (container, name) -> ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getHTMLList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToMicronode() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEMICRONODELIST, this.FILL, FETCH, FieldSchemaCreator.CREATEMICRONODE, (container, name) -> {
            ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getMicronode(name)).as("New field", new Object[0])).isNotNull();
            ((MicronodeAssert)MeshAssertions.assertThat((HibMicronode)container.getMicronode(name).getMicronode()).as("New field value", new Object[0])).containsStringField("firstName", "Donald").containsStringField("lastName", "Duck");
        });
    }

    @Override
    @Test
    public void testEmptyChangeToMicronode() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEMICRONODELIST, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATEMICRONODE, (container, name) -> ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getMicronode(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToMicronodeList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEMICRONODELIST, this.FILL, FETCH, FieldSchemaCreator.CREATEMICRONODELIST, (container, name) -> {
            ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getMicronodeList(name)).as("New field", new Object[0])).isNotNull();
            MeshAssertions.assertThat((List)container.getMicronodeList(name).getValues()).as("New field value", new Object[0]).hasSize(2);
            ((MicronodeAssert)MeshAssertions.assertThat((HibMicronode)((HibMicronode)container.getMicronodeList(name).getValues().get(0))).as("New field value", new Object[0])).containsStringField("firstName", "Donald").containsStringField("lastName", "Duck");
            ((MicronodeAssert)MeshAssertions.assertThat((HibMicronode)((HibMicronode)container.getMicronodeList(name).getValues().get(1))).as("New field value", new Object[0])).containsStringField("firstName", "Mickey").containsStringField("lastName", "Mouse");
        });
    }

    @Override
    @Test
    public void testEmptyChangeToMicronodeList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEMICRONODELIST, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATEMICRONODELIST, (container, name) -> ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getMicronodeList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToNode() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEMICRONODELIST, this.FILL, FETCH, FieldSchemaCreator.CREATENODE, (container, name) -> ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getNode(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testEmptyChangeToNode() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEMICRONODELIST, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATENODE, (container, name) -> ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getNode(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToNodeList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEMICRONODELIST, this.FILL, FETCH, FieldSchemaCreator.CREATENODELIST, (container, name) -> ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getNodeList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testEmptyChangeToNodeList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEMICRONODELIST, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATENODELIST, (container, name) -> ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getNodeList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToNumber() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEMICRONODELIST, this.FILL, FETCH, FieldSchemaCreator.CREATENUMBER, (container, name) -> ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getNumber(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testEmptyChangeToNumber() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEMICRONODELIST, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATENUMBER, (container, name) -> ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getNumber(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToNumberList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEMICRONODELIST, this.FILL, FETCH, FieldSchemaCreator.CREATENUMBERLIST, (container, name) -> ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getNumberList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testEmptyChangeToNumberList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEMICRONODELIST, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATENUMBERLIST, (container, name) -> ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getNumberList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToString() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEMICRONODELIST, this.FILL, FETCH, FieldSchemaCreator.CREATESTRING, (container, name) -> ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getString(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testEmptyChangeToString() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEMICRONODELIST, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATESTRING, (container, name) -> ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getString(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToStringList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEMICRONODELIST, this.FILL, FETCH, FieldSchemaCreator.CREATESTRINGLIST, (container, name) -> ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getStringList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testEmptyChangeToStringList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATEMICRONODELIST, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATESTRINGLIST, (container, name) -> ((AbstractObjectAssert)MeshAssertions.assertThat((Object)container.getStringList(name)).as("New field", new Object[0])).isNull());
    }
}

