/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.schema.field;

import com.gentics.mesh.core.field.FieldSchemaCreator;
import com.gentics.mesh.core.field.FieldTestHelper;
import com.gentics.mesh.core.field.number.NumberListFieldTestHelper;
import com.gentics.mesh.core.schema.field.AbstractFieldMigrationTest;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=false)
public class NumberListFieldMigrationTest
extends AbstractFieldMigrationTest
implements NumberListFieldTestHelper {
    @Override
    @Test
    public void testRemove() throws Exception {
        this.removeField(FieldSchemaCreator.CREATENUMBERLIST, FILLNUMBERS, FETCH);
    }

    @Override
    @Test
    public void testChangeToBinary() throws Exception {
        this.changeType(FieldSchemaCreator.CREATENUMBERLIST, FILLNUMBERS, FETCH, FieldSchemaCreator.CREATEBINARY, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getBinary(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testEmptyChangeToBinary() throws Exception {
        this.changeType(FieldSchemaCreator.CREATENUMBERLIST, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATEBINARY, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getBinary(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToBoolean() throws Exception {
        this.changeType(FieldSchemaCreator.CREATENUMBERLIST, FILLNUMBERS, FETCH, FieldSchemaCreator.CREATEBOOLEAN, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getBoolean(name)).as("New field", new Object[0])).isNull());
        this.changeType(FieldSchemaCreator.CREATENUMBERLIST, FILLONEZERO, FETCH, FieldSchemaCreator.CREATEBOOLEAN, (container, name) -> {
            ((AbstractObjectAssert)Assertions.assertThat((Object)container.getBoolean(name)).as("New field", new Object[0])).isNotNull();
            ((AbstractBooleanAssert)Assertions.assertThat((Boolean)container.getBoolean(name).getBoolean()).as("New field value", new Object[0])).isEqualTo(true);
        });
    }

    @Override
    @Test
    public void testEmptyChangeToBoolean() throws Exception {
        this.changeType(FieldSchemaCreator.CREATENUMBERLIST, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATEBOOLEAN, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getBoolean(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToBooleanList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATENUMBERLIST, FILLNUMBERS, FETCH, FieldSchemaCreator.CREATEBOOLEANLIST, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getBooleanList(name)).as("New field", new Object[0])).isNull());
        this.changeType(FieldSchemaCreator.CREATENUMBERLIST, FILLONEZERO, FETCH, FieldSchemaCreator.CREATEBOOLEANLIST, (container, name) -> {
            ((AbstractObjectAssert)Assertions.assertThat((Object)container.getBooleanList(name)).as("New field", new Object[0])).isNotNull();
            Assertions.assertThat((List)container.getBooleanList(name).getValues()).as("New field value", new Object[0]).containsExactly((Object[])new Boolean[]{true, false});
        });
    }

    @Override
    @Test
    public void testEmptyChangeToBooleanList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATENUMBERLIST, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATEBOOLEANLIST, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getBooleanList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToDate() throws Exception {
        this.changeType(FieldSchemaCreator.CREATENUMBERLIST, FILLNUMBERS, FETCH, FieldSchemaCreator.CREATEDATE, (container, name) -> {
            ((AbstractObjectAssert)Assertions.assertThat((Object)container.getDate(name)).as("New field", new Object[0])).isNotNull();
            ((AbstractLongAssert)Assertions.assertThat((Long)container.getDate(name).getDate()).as("New field value", new Object[0])).isEqualTo(new BigDecimal(4711000.0).longValue());
        });
    }

    @Override
    @Test
    public void testEmptyChangeToDate() throws Exception {
        this.changeType(FieldSchemaCreator.CREATENUMBERLIST, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATEDATE, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getDate(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToDateList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATENUMBERLIST, FILLNUMBERS, FETCH, FieldSchemaCreator.CREATEDATELIST, (container, name) -> {
            ((AbstractObjectAssert)Assertions.assertThat((Object)container.getDateList(name)).as("New field", new Object[0])).isNotNull();
            Assertions.assertThat((List)container.getDateList(name).getValues()).as("New field value", new Object[0]).containsExactly((Object[])new Long[]{4711000L, 8150000L});
        });
    }

    @Override
    @Test
    public void testEmptyChangeToDateList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATENUMBERLIST, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATEDATELIST, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getDateList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToHtml() throws Exception {
        this.changeType(FieldSchemaCreator.CREATENUMBERLIST, FILLNUMBERS, FETCH, FieldSchemaCreator.CREATEHTML, (container, name) -> {
            ((AbstractObjectAssert)Assertions.assertThat((Object)container.getHtml(name)).as("New field", new Object[0])).isNotNull();
            ((AbstractCharSequenceAssert)Assertions.assertThat((String)container.getHtml(name).getHTML()).as("New field value", new Object[0])).isEqualTo((Object)(Double.toString(4711.0) + "," + Double.toString(8150.0)));
        });
    }

    @Override
    @Test
    public void testEmptyChangeToHtml() throws Exception {
        this.changeType(FieldSchemaCreator.CREATENUMBERLIST, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATEHTML, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getHtml(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToHtmlList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATENUMBERLIST, FILLNUMBERS, FETCH, FieldSchemaCreator.CREATEHTMLLIST, (container, name) -> {
            ((AbstractObjectAssert)Assertions.assertThat((Object)container.getHTMLList(name)).as("New field", new Object[0])).isNotNull();
            Assertions.assertThat((List)container.getHTMLList(name).getValues()).as("New field", new Object[0]).containsExactly((Object[])new String[]{Double.toString(4711.0), Double.toString(8150.0)});
        });
    }

    @Override
    @Test
    public void testEmptyChangeToHtmlList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATENUMBERLIST, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATEHTMLLIST, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getHTMLList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToMicronode() throws Exception {
        this.changeType(FieldSchemaCreator.CREATENUMBERLIST, FILLNUMBERS, FETCH, FieldSchemaCreator.CREATEMICRONODE, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getMicronode(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testEmptyChangeToMicronode() throws Exception {
        this.changeType(FieldSchemaCreator.CREATENUMBERLIST, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATEMICRONODE, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getMicronode(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToMicronodeList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATENUMBERLIST, FILLNUMBERS, FETCH, FieldSchemaCreator.CREATEMICRONODELIST, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getMicronodeList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testEmptyChangeToMicronodeList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATENUMBERLIST, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATEMICRONODELIST, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getMicronodeList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToNode() throws Exception {
        this.changeType(FieldSchemaCreator.CREATENUMBERLIST, FILLNUMBERS, FETCH, FieldSchemaCreator.CREATENODE, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getNode(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testEmptyChangeToNode() throws Exception {
        this.changeType(FieldSchemaCreator.CREATENUMBERLIST, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATENODE, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getNode(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToNodeList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATENUMBERLIST, FILLNUMBERS, FETCH, FieldSchemaCreator.CREATENODELIST, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getNodeList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testEmptyChangeToNodeList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATENUMBERLIST, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATENODELIST, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getNodeList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToNumber() throws Exception {
        this.changeType(FieldSchemaCreator.CREATENUMBERLIST, FILLNUMBERS, FETCH, FieldSchemaCreator.CREATENUMBER, (container, name) -> {
            ((AbstractObjectAssert)Assertions.assertThat((Object)container.getNumber(name)).as("New field", new Object[0])).isNotNull();
            ((AbstractDoubleAssert)Assertions.assertThat((double)container.getNumber(name).getNumber().doubleValue()).as("New field value", new Object[0])).isEqualTo(4711.0);
        });
    }

    @Override
    @Test
    public void testEmptyChangeToNumber() throws Exception {
        this.changeType(FieldSchemaCreator.CREATENUMBERLIST, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATENUMBER, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getNumber(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToNumberList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATENUMBERLIST, FILLNUMBERS, FETCH, FieldSchemaCreator.CREATENUMBERLIST, (container, name) -> {
            ((AbstractObjectAssert)Assertions.assertThat((Object)container.getNumberList(name)).as("New field", new Object[0])).isNotNull();
            Assertions.assertThat(container.getNumberList(name).getValues().stream().map(Number::doubleValue).collect(Collectors.toList())).as("New field value", new Object[0]).containsExactly((Object[])new Double[]{4711.0, 8150.0});
        });
    }

    @Override
    @Test
    public void testEmptyChangeToNumberList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATENUMBERLIST, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATENUMBERLIST, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getNumberList(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToString() throws Exception {
        this.changeType(FieldSchemaCreator.CREATENUMBERLIST, FILLNUMBERS, FETCH, FieldSchemaCreator.CREATESTRING, (container, name) -> {
            ((AbstractObjectAssert)Assertions.assertThat((Object)container.getString(name)).as("New field", new Object[0])).isNotNull();
            ((AbstractCharSequenceAssert)Assertions.assertThat((String)container.getString(name).getString()).as("New field value", new Object[0])).isEqualTo((Object)(Double.toString(4711.0) + "," + Double.toString(8150.0)));
        });
    }

    @Override
    @Test
    public void testEmptyChangeToString() throws Exception {
        this.changeType(FieldSchemaCreator.CREATENUMBERLIST, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATESTRING, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getString(name)).as("New field", new Object[0])).isNull());
    }

    @Override
    @Test
    public void testChangeToStringList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATENUMBERLIST, FILLNUMBERS, FETCH, FieldSchemaCreator.CREATESTRINGLIST, (container, name) -> {
            ((AbstractObjectAssert)Assertions.assertThat((Object)container.getStringList(name)).as("New field", new Object[0])).isNotNull();
            Assertions.assertThat((List)container.getStringList(name).getValues()).as("New field value", new Object[0]).containsExactly((Object[])new String[]{Double.toString(4711.0), Double.toString(8150.0)});
        });
    }

    @Override
    @Test
    public void testEmptyChangeToStringList() throws Exception {
        this.changeType(FieldSchemaCreator.CREATENUMBERLIST, FieldTestHelper.NOOP, FETCH, FieldSchemaCreator.CREATESTRINGLIST, (container, name) -> ((AbstractObjectAssert)Assertions.assertThat((Object)container.getStringList(name)).as("New field", new Object[0])).isNull());
    }
}

