/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.schema.field.binary;

import com.gentics.mesh.core.data.schema.HibSchemaVersion;
import com.gentics.mesh.core.rest.job.JobStatus;
import com.gentics.mesh.core.rest.schema.BinaryExtractOptions;
import com.gentics.mesh.core.rest.schema.BinaryFieldSchema;
import com.gentics.mesh.core.rest.schema.SchemaModel;
import com.gentics.mesh.core.rest.schema.impl.BinaryFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.SchemaResponse;
import com.gentics.mesh.core.rest.schema.impl.SchemaUpdateRequest;
import com.gentics.mesh.json.JsonUtil;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.vertx.core.buffer.Buffer;
import io.vertx.test.core.TestUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.TRACKING, testSize=TestSize.FULL, startServer=true)
public class BinaryFieldEndpointTest
extends AbstractMeshTest {
    @Test
    public void testBinaryFieldExtractOptions() {
        this.grantAdmin();
        String schemaUuid = (String)this.tx(() -> this.schemaContainer("content").getUuid());
        String nodeUuid = (String)this.tx(() -> this.contentUuid());
        SchemaModel schema = (SchemaModel)this.tx(() -> ((HibSchemaVersion)this.schemaContainer("content").getLatestVersion()).getSchema());
        SchemaUpdateRequest request = (SchemaUpdateRequest)JsonUtil.readValue((String)schema.toJson(), SchemaUpdateRequest.class);
        BinaryExtractOptions extractOptions = new BinaryExtractOptions();
        extractOptions.setContent(true);
        extractOptions.setMetadata(true);
        request.addField(new BinaryFieldSchemaImpl().setBinaryExtractOptions(extractOptions).setName("binaryField"));
        this.waitForJobs(() -> ClientHelper.call(() -> this.client().updateSchema(schemaUuid, request, new ParameterProvider[0])), JobStatus.COMPLETED, 1);
        SchemaResponse loadedSchema = (SchemaResponse)ClientHelper.call(() -> this.client().findSchemaByUuid(schemaUuid, new ParameterProvider[0]));
        BinaryFieldSchema loadedField = (BinaryFieldSchema)loadedSchema.getField("binaryField", BinaryFieldSchema.class);
        Assert.assertNotNull((String)"The options should be set", (Object)loadedField.getBinaryExtractOptions());
        Buffer buffer = TestUtils.randomBuffer((int)1000);
        ClientHelper.call(() -> this.client().updateNodeBinaryField(this.projectName(), nodeUuid, "en", "draft", "binaryField", (InputStream)new ByteArrayInputStream(buffer.getBytes()), (long)buffer.length(), "filename.txt", "application/binary", new ParameterProvider[0]));
        request.removeField("binaryField");
        BinaryExtractOptions extractOptions2 = new BinaryExtractOptions();
        extractOptions2.setContent(false);
        extractOptions2.setMetadata(false);
        request.addField(new BinaryFieldSchemaImpl().setBinaryExtractOptions(extractOptions2).setName("binaryField"));
        this.waitForJobs(() -> ClientHelper.call(() -> this.client().updateSchema(schemaUuid, request, new ParameterProvider[0])), JobStatus.COMPLETED, 1);
        SchemaResponse loadedSchema2 = (SchemaResponse)ClientHelper.call(() -> this.client().findSchemaByUuid(schemaUuid, new ParameterProvider[0]));
        BinaryFieldSchema loadedField2 = (BinaryFieldSchema)loadedSchema2.getField("binaryField", BinaryFieldSchema.class);
        BinaryExtractOptions loadedOptions = loadedField2.getBinaryExtractOptions();
        Assert.assertNotNull((String)"The options should be set", (Object)loadedOptions);
        Assert.assertFalse((boolean)loadedOptions.getContent());
        Assert.assertFalse((boolean)loadedOptions.getMetadata());
        request.removeField("binaryField");
        request.addField(new BinaryFieldSchemaImpl().setBinaryExtractOptions(null).setName("binaryField"));
        this.waitForJobs(() -> ClientHelper.call(() -> this.client().updateSchema(schemaUuid, request, new ParameterProvider[0])), JobStatus.COMPLETED, 1);
        loadedSchema = (SchemaResponse)ClientHelper.call(() -> this.client().findSchemaByUuid(schemaUuid, new ParameterProvider[0]));
        loadedField = (BinaryFieldSchema)loadedSchema.getField("binaryField", BinaryFieldSchema.class);
        Assert.assertNull((String)"The options should be set to null", (Object)loadedField.getBinaryExtractOptions());
    }
}

