/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.schema.field.string;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.core.data.schema.HibSchemaVersion;
import com.gentics.mesh.core.rest.job.JobStatus;
import com.gentics.mesh.core.rest.node.NodeUpdateRequest;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.schema.SchemaModel;
import com.gentics.mesh.core.rest.schema.impl.SchemaUpdateRequest;
import com.gentics.mesh.core.rest.schema.impl.StringFieldSchemaImpl;
import com.gentics.mesh.json.JsonUtil;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.netty.handler.codec.http.HttpResponseStatus;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.TRACKING, testSize=TestSize.FULL, startServer=true)
public class StringFieldEndpointTest
extends AbstractMeshTest {
    @Test
    public void testResetAllowField() {
        this.grantAdmin();
        String schemaUuid = (String)this.tx(() -> this.schemaContainer("content").getUuid());
        String nodeUuid = (String)this.tx(() -> this.contentUuid());
        SchemaModel schema = (SchemaModel)this.tx(() -> ((HibSchemaVersion)this.schemaContainer("content").getLatestVersion()).getSchema());
        SchemaUpdateRequest request = (SchemaUpdateRequest)JsonUtil.readValue((String)schema.toJson(), SchemaUpdateRequest.class);
        request.addField(new StringFieldSchemaImpl().setAllowedValues(new String[]{"a", "b", "c"}).setName("extraString"));
        this.waitForJobs(() -> ClientHelper.call(() -> this.client().updateSchema(schemaUuid, request, new ParameterProvider[0])), JobStatus.COMPLETED, 1);
        NodeUpdateRequest nodeUpdateRequest = new NodeUpdateRequest();
        nodeUpdateRequest.setVersion("draft");
        nodeUpdateRequest.setLanguage("en");
        nodeUpdateRequest.getFields().put("extraString", (Field)FieldUtil.createStringField((String)"someValue"));
        ClientHelper.call(() -> this.client().updateNode(this.projectName(), nodeUuid, nodeUpdateRequest, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"node_error_invalid_string_field_value", (String[])new String[]{"extraString", "someValue"});
        request.removeField("extraString");
        request.addField(new StringFieldSchemaImpl().setAllowedValues(new String[0]).setName("extraString"));
        this.waitForJobs(() -> ClientHelper.call(() -> this.client().updateSchema(schemaUuid, request, new ParameterProvider[0])), JobStatus.COMPLETED, 1);
        ClientHelper.call(() -> this.client().updateNode(this.projectName(), nodeUuid, nodeUpdateRequest, new ParameterProvider[0]));
    }
}

