/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.schema.versioning;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.rest.branch.BranchCreateRequest;
import com.gentics.mesh.core.rest.microschema.impl.MicroschemaResponse;
import com.gentics.mesh.core.rest.microschema.impl.MicroschemaUpdateRequest;
import com.gentics.mesh.core.rest.node.NodeUpdateRequest;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.MicronodeField;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.impl.SchemaResponse;
import com.gentics.mesh.core.rest.schema.impl.SchemaUpdateRequest;
import com.gentics.mesh.parameter.ImageManipulationParameters;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.ImageManipulationParametersImpl;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.util.Tuple;
import java.io.IOException;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class SchemaAutoPurgeEndpointTest
extends AbstractMeshTest {
    @Test
    public void testBasicAutoPurge() {
        String nodeUuid = this.contentUuid();
        this.assertVersions(nodeUuid, "en", "PD(1.0)=>I(0.1)");
        this.enableAutoPurgeOnSchema();
        this.assertVersions(nodeUuid, "en", "PD(2.0)=>I(0.1)");
        NodeUpdateRequest nodeUpdateRequest = new NodeUpdateRequest();
        nodeUpdateRequest.setLanguage("en");
        nodeUpdateRequest.setVersion("draft");
        nodeUpdateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)"new name"));
        ClientHelper.call(() -> this.client().updateNode(this.projectName(), nodeUuid, nodeUpdateRequest, new ParameterProvider[0]));
        this.assertVersions(nodeUuid, "en", "D(2.1)=>P(2.0)=>I(0.1)");
        nodeUpdateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)"new name2"));
        ClientHelper.call(() -> this.client().updateNode(this.projectName(), nodeUuid, nodeUpdateRequest, new ParameterProvider[0]));
        this.assertVersions(nodeUuid, "en", "D(2.2)=>P(2.0)=>I(0.1)");
        nodeUpdateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)"new name3"));
        ClientHelper.call(() -> this.client().updateNode(this.projectName(), nodeUuid, nodeUpdateRequest, new ParameterProvider[0]));
        this.assertVersions(nodeUuid, "en", "D(2.3)=>P(2.0)=>I(0.1)");
        ClientHelper.call(() -> this.client().publishNode(this.projectName(), nodeUuid, new ParameterProvider[0]));
        this.assertVersions(nodeUuid, "en", "PD(3.0)=>I(0.1)");
        ClientHelper.call(() -> this.client().takeNodeOffline(this.projectName(), nodeUuid, new ParameterProvider[0]));
        this.assertVersions(nodeUuid, "en", "D(3.0)=>I(0.1)");
        ClientHelper.call(() -> this.client().publishNode(this.projectName(), nodeUuid, new ParameterProvider[0]));
        this.assertVersions(nodeUuid, "en", "PD(4.0)=>I(0.1)");
        ClientHelper.call(() -> this.client().publishNode(this.projectName(), nodeUuid, new ParameterProvider[0]));
        this.assertVersions(nodeUuid, "en", "PD(4.0)=>I(0.1)");
        nodeUpdateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)"new name4"));
        ClientHelper.call(() -> this.client().updateNode(this.projectName(), nodeUuid, nodeUpdateRequest, new ParameterProvider[0]));
        this.assertVersions(nodeUuid, "en", "D(4.1)=>P(4.0)=>I(0.1)");
        ClientHelper.call(() -> this.client().takeNodeOffline(this.projectName(), nodeUuid, new ParameterProvider[0]));
        this.assertVersions(nodeUuid, "en", "D(4.1)=>I(0.1)");
        ClientHelper.call(() -> this.client().publishNode(this.projectName(), nodeUuid, new ParameterProvider[0]));
        this.assertVersions(nodeUuid, "en", "PD(5.0)=>I(0.1)");
        this.waitForJob(() -> {
            BranchCreateRequest branchCreateRequest = new BranchCreateRequest();
            branchCreateRequest.setName("branch1");
            branchCreateRequest.setLatest(false);
            ClientHelper.call(() -> this.client().createBranch(this.projectName(), branchCreateRequest, new ParameterProvider[0]));
        });
        this.assertVersions(nodeUuid, "en", "PDI(5.0)=>I(0.1)");
        nodeUpdateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)"new name5"));
        ClientHelper.call(() -> this.client().updateNode(this.projectName(), nodeUuid, nodeUpdateRequest, new ParameterProvider[0]));
        this.assertVersions(nodeUuid, "en", "D(5.1)=>PI(5.0)=>I(0.1)");
        ClientHelper.call(() -> this.client().publishNode(this.projectName(), nodeUuid, new ParameterProvider[0]));
        this.assertVersions(nodeUuid, "en", "PD(6.0)=>I(5.0)=>I(0.1)");
    }

    @Test
    public void testAutoPurgeWithUpload() {
        this.enableAutoPurgeOnSchema();
        HibNode node = this.content();
        String nodeUuid = (String)this.tx(() -> node.getUuid());
        this.tx(tx -> {
            this.prepareSchema(this.content(), "", "binary");
            tx.commit();
        });
        this.assertVersions(nodeUuid, "en", "PD(2.0)=>I(0.1)");
        ClientHelper.call(() -> this.uploadRandomData(node, "en", "binary", 1000, "application/pdf", "somefile.PDF"));
        this.assertVersions(nodeUuid, "en", "D(2.1)=>P(2.0)=>I(0.1)");
        ClientHelper.call(() -> this.uploadRandomData(node, "en", "binary", 1000, "application/pdf", "somefile.PDF"));
        this.assertVersions(nodeUuid, "en", "D(2.2)=>P(2.0)=>I(0.1)");
    }

    @Test
    public void testAutoPurgeWithBinaryTransform() throws IOException {
        HibNode node = this.content();
        String nodeUuid = (String)this.tx(() -> node.getUuid());
        this.assertVersions(nodeUuid, "en", "PD(1.0)=>I(0.1)");
        this.enableAutoPurgeOnSchema();
        this.assertVersions(nodeUuid, "en", "PD(2.0)=>I(0.1)");
        String version = this.uploadImage(node, "en", "image").getVersion();
        this.assertVersions(nodeUuid, "en", "D(2.1)=>P(2.0)=>I(0.1)");
        ImageManipulationParameters params = new ImageManipulationParametersImpl().setWidth(Integer.valueOf(100));
        ClientHelper.call(() -> this.client().transformNodeBinaryField("dummy", nodeUuid, "en", version, "image", params));
        this.assertVersions(nodeUuid, "en", "D(2.2)=>P(2.0)=>I(0.1)");
    }

    @Test
    public void testAutoPurgeForSchemaMigration() {
        this.grantAdmin();
        this.enableAutoPurgeOnSchema();
        String contentSchemaUuid = (String)this.tx(() -> this.schemaContainer("content").getUuid());
        String nodeUuid = this.contentUuid();
        this.assertVersions(nodeUuid, "en", "PD(2.0)=>I(0.1)");
        SchemaUpdateRequest request = ((SchemaResponse)ClientHelper.call(() -> this.client().findSchemaByUuid(contentSchemaUuid, new ParameterProvider[0]))).toUpdateRequest();
        request.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"1"));
        this.waitForJob(() -> ClientHelper.call(() -> this.client().updateSchema(contentSchemaUuid, request, new ParameterProvider[0])));
        this.assertVersions(nodeUuid, "en", "PD(3.0)=>I(0.1)");
        request.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"2"));
        this.waitForJob(() -> ClientHelper.call(() -> this.client().updateSchema(contentSchemaUuid, request, new ParameterProvider[0])));
        this.assertVersions(nodeUuid, "en", "PD(4.0)=>I(0.1)");
        NodeUpdateRequest nodeUpdateRequest = new NodeUpdateRequest();
        nodeUpdateRequest.setLanguage("en");
        nodeUpdateRequest.setVersion("draft");
        nodeUpdateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)"new name"));
        ClientHelper.call(() -> this.client().updateNode(this.projectName(), nodeUuid, nodeUpdateRequest, new ParameterProvider[0]));
        this.assertVersions(nodeUuid, "en", "D(4.1)=>P(4.0)=>I(0.1)");
        request.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"3"));
        this.waitForJob(() -> ClientHelper.call(() -> this.client().updateSchema(contentSchemaUuid, request, new ParameterProvider[0])));
        this.assertVersions(nodeUuid, "en", "D(5.1)=>P(5.0)=>I(0.1)");
    }

    @Test
    public void testAutoPurgeForMicroschemaMigration() {
        this.grantAdmin();
        String microschemaUuid = (String)this.tx(() -> this.microschemaContainer("vcard").getUuid());
        String contentSchemaUuid = (String)this.tx(() -> this.schemaContainer("content").getUuid());
        String nodeUuid = this.contentUuid();
        this.assertVersions(nodeUuid, "en", "PD(1.0)=>I(0.1)");
        SchemaUpdateRequest schemaRequest = ((SchemaResponse)ClientHelper.call(() -> this.client().findSchemaByUuid(contentSchemaUuid, new ParameterProvider[0]))).toUpdateRequest();
        schemaRequest.addField((FieldSchema)FieldUtil.createMicronodeFieldSchema((String)"card").setAllowedMicroSchemas(new String[]{"vcard"}));
        this.waitForJob(() -> ClientHelper.call(() -> this.client().updateSchema(contentSchemaUuid, schemaRequest, new ParameterProvider[0])));
        this.assertVersions(nodeUuid, "en", "PD(2.0)=>I(0.1)");
        NodeUpdateRequest nodeUpdateRequest = new NodeUpdateRequest();
        nodeUpdateRequest.setLanguage("en");
        nodeUpdateRequest.setVersion("draft");
        Tuple firstNameField = Tuple.tuple((Object)"firstName", (Object)FieldUtil.createStringField((String)"joe"));
        Tuple lastNameField = Tuple.tuple((Object)"lastName", (Object)FieldUtil.createStringField((String)"doe"));
        MicronodeField micronode = FieldUtil.createMicronodeField((String)"card", (Tuple[])new Tuple[]{firstNameField, lastNameField});
        micronode.getMicroschema().setName("vcard");
        nodeUpdateRequest.getFields().put("card", (Field)micronode);
        ClientHelper.call(() -> this.client().updateNode(this.projectName(), nodeUuid, nodeUpdateRequest, new ParameterProvider[0]));
        this.assertVersions(nodeUuid, "en", "D(2.1)=>P(2.0)=>I(0.1)");
        MicroschemaUpdateRequest microschemaRequest = ((MicroschemaResponse)ClientHelper.call(() -> this.client().findMicroschemaByUuid(microschemaUuid, new ParameterProvider[0]))).toRequest();
        microschemaRequest.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"extra"));
        this.waitForJob(() -> ClientHelper.call(() -> this.client().updateMicroschema(microschemaUuid, microschemaRequest, new ParameterProvider[0])));
        this.assertVersions(nodeUuid, "en", "D(3.1)=>P(3.0)=>I(0.1)");
    }

    private void enableAutoPurgeOnSchema() {
        this.grantAdmin();
        String contentSchemaUuid = (String)this.tx(() -> this.schemaContainer("content").getUuid());
        MeshAssertions.assertThat((SchemaResponse)((SchemaResponse)ClientHelper.call(() -> this.client().findSchemaByUuid(contentSchemaUuid, new ParameterProvider[0])))).autoPurgeIsNotSet();
        this.waitForJob(() -> {
            SchemaResponse schema = (SchemaResponse)ClientHelper.call(() -> this.client().findSchemaByUuid(contentSchemaUuid, new ParameterProvider[0]));
            SchemaUpdateRequest updateRequest = schema.toUpdateRequest();
            updateRequest.setAutoPurge(Boolean.valueOf(true));
            ClientHelper.call(() -> this.client().updateSchema(contentSchemaUuid, updateRequest, new ParameterProvider[0]));
        });
        MeshAssertions.assertThat((SchemaResponse)((SchemaResponse)ClientHelper.call(() -> this.client().findSchemaByUuid(contentSchemaUuid, new ParameterProvider[0])))).autoPurgeIsEnabled();
    }
}

