/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.ssl;

import com.gentics.mesh.rest.client.MeshRestClientConfig;
import com.gentics.mesh.rest.client.impl.OkHttpClientUtil;
import com.gentics.mesh.test.context.MeshTestHelper;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.io.IOException;
import java.net.URISyntaxException;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class SSLTestClient {
    private static final Logger log = LoggerFactory.getLogger(SSLTestClient.class);
    public static final String CERT_PATH = "/client-ssl/";
    public static final String FMT_TEST_URL = "https://localhost:%s/api/v1";

    public static void call(int httpsPort, boolean trustAll, ClientCert clientCertName) throws IOException, URISyntaxException {
        OkHttpClient client = SSLTestClient.client(clientCertName, trustAll);
        Request request = new Request.Builder().url(String.format(FMT_TEST_URL, httpsPort)).build();
        log.info((Object)("Performing request: " + request));
        Response response = client.newCall(request).execute();
        log.info((Object)("Received response: " + response));
    }

    public static OkHttpClient client(ClientCert clientCertName, boolean trustAll) throws URISyntaxException {
        MeshRestClientConfig.Builder builder = new MeshRestClientConfig.Builder();
        builder.setHost("localhost");
        if (clientCertName != null) {
            builder.setClientKey(MeshTestHelper.getResourcePath(CERT_PATH + clientCertName.name().toLowerCase() + ".key"));
            builder.setClientCert(MeshTestHelper.getResourcePath(CERT_PATH + clientCertName.name().toLowerCase() + ".pem"));
        }
        if (!trustAll) {
            builder.addTrustedCA(MeshTestHelper.getResourcePath("/client-ssl/server.pem"));
        }
        return OkHttpClientUtil.createClient((MeshRestClientConfig)builder.build());
    }

    public static enum ClientCert {
        BOB,
        ALICE;

    }
}

