/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.ssl;

import com.gentics.mesh.core.ssl.SSLTestClient;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.SSLTestMode;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true, ssl=SSLTestMode.CLIENT_CERT_REQUIRED)
public class SSLUserCertRequireServerTest
extends AbstractMeshTest {
    @Test
    public void testReadByUUID() throws Exception {
        String uuid = this.userUuid();
        ClientHelper.call(() -> this.sslClient().findUserByUuid(uuid, new ParameterProvider[0]));
        ClientHelper.call(() -> this.client().findUserByUuid(uuid, new ParameterProvider[0]));
        SSLTestClient.call(this.httpsPort(), false, SSLTestClient.ClientCert.ALICE);
        try {
            SSLTestClient.call(this.httpsPort(), false, null);
            Assert.fail((String)"The request should fail since no valid client was passed along.");
        }
        catch (SSLHandshakeException e) {
            Assert.assertEquals((Object)"Received fatal alert: bad_certificate", (Object)e.getMessage());
        }
        catch (SSLException e) {
            Assert.assertEquals((Object)"readHandshakeRecord", (Object)e.getMessage());
        }
        try {
            SSLTestClient.call(this.httpsPort(), false, SSLTestClient.ClientCert.BOB);
            Assert.fail((String)"The request should fail since bob's cert is invalid.");
        }
        catch (SSLHandshakeException e) {
            Assert.assertEquals((Object)"Received fatal alert: bad_certificate", (Object)e.getMessage());
        }
        catch (SSLException e) {
            Assert.assertEquals((Object)"readHandshakeRecord", (Object)e.getMessage());
        }
    }
}

